/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.springframework.config;

import com.sas.framework.commons.util.SystemProperty;
import org.springframework.util.ClassUtils;

public class ApplicationServerIdentifier {
    private static String containerSystemProperty = SystemProperty.SAS_CONTAINER_IDENTIFIER.get();
    private static final boolean IS_PRESENT_WEBLOGIC = ClassUtils.isPresent((String)"weblogic.security.Security", (ClassLoader)ApplicationServerIdentifier.class.getClassLoader());
    private static final boolean IS_PRESENT_WEBSPHERE = ClassUtils.isPresent((String)"com.ibm.websphere.security.auth.WSSubject", (ClassLoader)ApplicationServerIdentifier.class.getClassLoader());
    private static final boolean IS_PRESENT_JBOSS = ClassUtils.isPresent((String)"org.jboss.security.SecurityAssociation", (ClassLoader)ApplicationServerIdentifier.class.getClassLoader());
    private static final boolean IS_PRESENT_VFABRICTCSVR = ClassUtils.isPresent((String)"com.springsource.tcruntime.instance.TcRuntimeInstance", (ClassLoader)ApplicationServerIdentifier.class.getClassLoader());

    public boolean isJBoss() {
        return this.getBoolean("jboss", IS_PRESENT_JBOSS);
    }

    public boolean isVfabricTCSvr() {
        return this.getBoolean("vfabrictcsvr", IS_PRESENT_VFABRICTCSVR);
    }

    public boolean isWebLogic() {
        return this.getBoolean("weblogic", IS_PRESENT_WEBLOGIC);
    }

    public boolean isWebSphere() {
        return this.getBoolean("websphere", IS_PRESENT_WEBSPHERE);
    }

    private boolean getBoolean(String propertyValue, boolean present) {
        if (null != containerSystemProperty) {
            return containerSystemProperty.equals(propertyValue);
        }
        return present;
    }
}

