/*
 * Decompiled with CFR 0.152.
 */
package com.sas.testcontainer;

import com.sas.editor.LogMemoryStorageConfigData;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SetMemoryLogSizeParms
extends JDialog {
    private LogMemoryStorageConfigData mStorageParams;
    private boolean mDataOkay = false;
    protected JTextField MaxLinesField = new JTextField();
    protected JTextField ChunkSizeField = new JTextField();
    protected JLabel MaxLinesStatic = new JLabel();
    protected JLabel ChunkSizeStatic = new JLabel();
    protected JButton OKButton = new JButton();
    protected JButton CancelButton = new JButton();

    public SetMemoryLogSizeParms(JFrame logFrame, LogMemoryStorageConfigData storageData) {
        this.mStorageParams = storageData;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.MaxLinesStatic.setText("Max number of lines:");
        this.ChunkSizeStatic.setText("Number of lines lost on overflow:");
        this.OKButton.setText("OK");
        this.CancelButton.setText("Cancel");
        this.MaxLinesStatic.setLabelFor(this.MaxLinesField);
        this.ChunkSizeStatic.setLabelFor(this.ChunkSizeField);
        AutoSizingGridLayout windowLayout = new AutoSizingGridLayout(3, 2);
        windowLayout.setRemainderColumn(2);
        windowLayout.setFillCell(true);
        windowLayout.setUseColumnRemainder(true);
        this.getContentPane().setLayout((LayoutManager)windowLayout);
        this.setResizable(false);
        this.getContentPane().add(this.MaxLinesStatic);
        this.getContentPane().add(this.MaxLinesField);
        this.getContentPane().add(this.ChunkSizeStatic);
        this.getContentPane().add(this.ChunkSizeField);
        this.getContentPane().add(this.OKButton);
        this.getContentPane().add(this.CancelButton);
        this.MaxLinesField.setText(Integer.toString(this.mStorageParams.getMaxLineCount()));
        this.ChunkSizeField.setText(Integer.toString(this.mStorageParams.getDropOffLines()));
        this.setModal(true);
        this.setSize(350, 100);
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetMemoryLogSizeParms.this.setData();
            }
        });
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetMemoryLogSizeParms.this.OnClose();
            }
        });
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                SetMemoryLogSizeParms.this.OnClose();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
    }

    public void OnClose() {
        this.mDataOkay = false;
        this.dispose();
    }

    private void setData() {
        this.mDataOkay = true;
        this.mStorageParams.setMaxLineCount(Integer.parseInt(this.MaxLinesField.getText()));
        this.mStorageParams.setDropOffLines(Integer.parseInt(this.ChunkSizeField.getText()));
        this.dispose();
    }

    public boolean isOkay() {
        return this.mDataOkay;
    }
}

