/*
 * Decompiled with CFR 0.152.
 */
package com.sas.testcontainer;

import com.sas.editor.LogAutoRollingFileStorageConfigData;
import com.sas.editor.LogSuppliedRollingFileStorageConfigData;
import com.sas.editor.LogTemporaryRollingFileStorageConfigData;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SetDiskLogSizeParms
extends JDialog {
    private LogSuppliedRollingFileStorageConfigData mStorage;
    private boolean mDataOkay = false;
    protected JTextField FileCountField = new JTextField();
    protected JTextField LinesPerFileField = new JTextField();
    protected JLabel FileCountStatic = new JLabel();
    protected JLabel LinesPerFileStatic = new JLabel();
    protected JButton OKButton = new JButton();
    protected JButton CancelButton = new JButton();

    public SetDiskLogSizeParms(JFrame logFrame, LogSuppliedRollingFileStorageConfigData storageData) {
        super(logFrame);
        this.mStorage = storageData;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.FileCountStatic.setText("Number of files:");
        this.LinesPerFileStatic.setText("Lines per file:");
        this.OKButton.setText("OK");
        this.CancelButton.setText("Cancel");
        this.FileCountStatic.setLabelFor(this.FileCountField);
        this.LinesPerFileStatic.setLabelFor(this.LinesPerFileField);
        AutoSizingGridLayout windowLayout = new AutoSizingGridLayout(3, 2);
        windowLayout.setRemainderColumn(2);
        windowLayout.setFillCell(true);
        windowLayout.setUseColumnRemainder(true);
        this.getContentPane().setLayout((LayoutManager)windowLayout);
        this.setResizable(false);
        this.getContentPane().add(this.FileCountStatic);
        this.getContentPane().add(this.FileCountField);
        this.getContentPane().add(this.LinesPerFileStatic);
        this.getContentPane().add(this.LinesPerFileField);
        this.getContentPane().add(this.OKButton);
        this.getContentPane().add(this.CancelButton);
        this.FileCountField.setText(Integer.toString(this.mStorage.getDataFiles().length));
        this.LinesPerFileField.setText(Integer.toString(this.mStorage.getLinesPerFile()));
        this.setModal(true);
        this.setSize(350, 100);
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetDiskLogSizeParms.this.setData();
            }
        });
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetDiskLogSizeParms.this.OnClose();
            }
        });
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                SetDiskLogSizeParms.this.OnClose();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
    }

    public void OnClose() {
        this.mDataOkay = false;
        this.dispose();
    }

    public LogSuppliedRollingFileStorageConfigData getConfigData() {
        return this.mStorage;
    }

    private void setData() {
        this.mDataOkay = true;
        int linesPerFile = Integer.parseInt(this.LinesPerFileField.getText());
        int maxFiles = Integer.parseInt(this.FileCountField.getText());
        LogAutoRollingFileStorageConfigData newConfig = null;
        if (this.mStorage instanceof LogAutoRollingFileStorageConfigData) {
            newConfig = new LogAutoRollingFileStorageConfigData(new File("C:\\temp"), "Auto", ".log", maxFiles, linesPerFile, this.mStorage.isDeleteOnClose());
        } else if (this.mStorage instanceof LogTemporaryRollingFileStorageConfigData) {
            File[] dataFiles = this.mStorage.getDataFiles();
            File[] indexFiles = this.mStorage.getIndexFiles();
            File[] newDataFiles = new File[maxFiles];
            File[] fileArray = new File[maxFiles];
        }
        this.mStorage = newConfig;
        this.dispose();
    }

    public boolean isOkay() {
        return this.mDataOkay;
    }
}

