/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.editor.CodeBlock;
import com.sas.editor.CodeEditorDocument;
import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorView;
import com.sas.editor.ColorChangeListener;
import com.sas.editor.ICodeDocument;
import java.util.Vector;
import javax.swing.event.DocumentEvent;

public class ViewFoldInfo
implements ColorChangeListener {
    private ICodeDocument mDoc;
    public static final int FOLD_SIGNATURE_LINE = 1;
    public static final int FOLD_EXPANDED_LINE = 2;
    public static final int FOLD_BLOCK_MEMBER = 4;
    public static final int FOLD_START_LINE = 8;
    public static final int FOLD_END_LINE = 16;
    protected int m_Counter = 65536;
    protected Vector m_LineFoldFlags = null;
    protected CodeEditorView m_View = null;
    protected boolean m_IgnoreFolding = false;

    public ViewFoldInfo(ICodeDocument doc) {
        this.m_LineFoldFlags = new Vector(10, 10);
        this.m_LineFoldFlags.add(0, new Integer(2));
        this.mDoc = doc;
    }

    public ViewFoldInfo(CodeEditorView view) {
        this.m_View = view;
        this.m_LineFoldFlags = new Vector(10, 10);
        this.m_LineFoldFlags.add(0, new Integer(2));
        CodeEditorDocument doc = (CodeEditorDocument)view.getDocument();
        doc.addColorChangeListener(this);
        this.mDoc = doc;
    }

    public void cleanup() {
        if (this.m_View != null) {
            this.unhookListeners();
            this.m_IgnoreFolding = true;
        }
    }

    public void setFoldingStatus(boolean reportFolding) {
        if (!this.m_IgnoreFolding != reportFolding) {
            boolean bl = this.m_IgnoreFolding = !reportFolding;
            if (!this.m_IgnoreFolding) {
                int lineCount = this.mDoc.getLineCount();
                this.m_LineFoldFlags = new Vector(lineCount, 0);
                this.insertLines(0, lineCount);
            } else {
                this.m_LineFoldFlags = null;
            }
        }
    }

    public void insertUpdate(DocumentEvent changes) {
    }

    public void removeUpdate(DocumentEvent changes) {
    }

    @Override
    public void colorChangeUpdate(DocumentEvent changes) {
        if (this.m_View != null) {
            int offset = changes.getOffset();
            CodeEditorDocument doc = (CodeEditorDocument)this.m_View.getDocument();
            doc.getLanguageParser().updateFoldInfo(this, offset, offset + changes.getLength());
            CodeEditorPane host = (CodeEditorPane)this.m_View.getContainer();
            if (host != null) {
                host.repaintBorder();
            }
        }
    }

    @Override
    public void insertLines(int startLine, int count) {
        if (this.m_IgnoreFolding) {
            return;
        }
        this.m_Counter += 65536;
        int defaultValue = this.m_Counter | 2;
        for (int i = 0; i < count; ++i) {
            this.m_LineFoldFlags.add(startLine, new Integer(defaultValue));
        }
    }

    @Override
    public void removeLines(int startLine, int count) {
        if (this.m_IgnoreFolding) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            if (this.m_LineFoldFlags.isEmpty() || startLine < 0 || startLine >= this.m_LineFoldFlags.size()) continue;
            this.m_LineFoldFlags.remove(startLine);
        }
    }

    protected ICodeDocument getDocument() {
        return this.mDoc;
    }

    public void clearBlockInfo(int startLine, int endLine) {
        if (this.m_IgnoreFolding) {
            return;
        }
        for (int i = startLine; i <= endLine; ++i) {
            this.setFlags(i, 2);
        }
    }

    public boolean getBlockInfo(int line, CodeBlock outBlock) {
        int i;
        if (this.m_IgnoreFolding) {
            return false;
        }
        if (line > this.m_LineFoldFlags.size() || line < 0) {
            return false;
        }
        outBlock.setStart(-1);
        outBlock.setEnd(-1);
        outBlock.setSigLine(-1);
        int flags = this.getFlags(line);
        if ((flags & 4) == 0) {
            return false;
        }
        if ((flags & 1) != 0 && (flags & 8) != 0 && (flags & 0x10) != 0) {
            outBlock.setStart(line);
            outBlock.setEnd(line);
            outBlock.setSigLine(line);
            return true;
        }
        for (i = line; i >= 0; --i) {
            flags = this.getFlags(i);
            if ((flags & 1) != 0) {
                outBlock.setSigLine(i);
            }
            if ((flags & 0x10) != 0 && i != line) {
                return false;
            }
            if ((flags & 8) == 0) continue;
            outBlock.setStart(i);
            break;
        }
        if (outBlock.start() < 0) {
            return false;
        }
        for (i = line; i < this.m_LineFoldFlags.size(); ++i) {
            flags = this.getFlags(i);
            if ((flags & 1) != 0) {
                outBlock.setSigLine(i);
            }
            if ((flags & 8) != 0 && i != line) {
                return false;
            }
            if ((flags & 0x10) == 0) continue;
            outBlock.setEnd(i);
            break;
        }
        return outBlock.end() >= 0;
    }

    public boolean setFoldingBlock(CodeBlock newBlock) {
        if (this.m_IgnoreFolding) {
            return false;
        }
        if (newBlock.start() > newBlock.end() || newBlock.sigLine() < newBlock.start() || newBlock.sigLine() > newBlock.end() || newBlock.start() < 0) {
            System.out.println("setFoldingBlock:  Bad folding block");
            return false;
        }
        if (newBlock.end() > this.m_LineFoldFlags.size()) {
            return false;
        }
        this.addFlags(newBlock.sigLine(), 1);
        this.addFlags(newBlock.start(), 8);
        this.addFlags(newBlock.end(), 16);
        this.internalExpand(newBlock.start(), newBlock.end());
        return true;
    }

    public void unhookListeners() {
        if (this.m_View != null) {
            CodeEditorDocument doc = (CodeEditorDocument)this.m_View.getDocument();
            doc.removeColorChangeListener(this);
        }
    }

    protected int getFlags(int line) {
        if (this.m_IgnoreFolding) {
            return -1;
        }
        return (Integer)this.m_LineFoldFlags.get(line);
    }

    protected void setFlags(int line, int newFlags) {
        if (this.m_IgnoreFolding) {
            return;
        }
        this.m_LineFoldFlags.set(line, new Integer(newFlags));
    }

    protected void addFlags(int line, int addFlags) {
        if (this.m_IgnoreFolding) {
            return;
        }
        int oldFlags = this.getFlags(line);
        this.setFlags(line, oldFlags | addFlags);
    }

    protected void updateFlags(int line, int subtractFlags, int addFlags) {
        if (this.m_IgnoreFolding) {
            return;
        }
        int oldFlags = this.getFlags(line);
        int newFlags = oldFlags & ~subtractFlags;
        this.setFlags(line, newFlags |= addFlags);
    }

    public boolean isTopLevelLine(int line) {
        int flags;
        if (this.m_IgnoreFolding) {
            return true;
        }
        return line < this.m_LineFoldFlags.size() && line >= 0 && (((flags = this.getFlags(line)) & 1) != 0 || (flags & 2) != 0);
    }

    public boolean isLineCollapsed(int line) {
        if (this.m_IgnoreFolding) {
            return false;
        }
        int flags = this.getFlags(line);
        return (flags & 2) == 0;
    }

    public boolean isStartLine(int line) {
        if (this.m_IgnoreFolding) {
            return false;
        }
        int flags = this.getFlags(line);
        return (flags & 8) != 0;
    }

    public boolean isEndLine(int line) {
        if (this.m_IgnoreFolding) {
            return false;
        }
        int flags = this.getFlags(line);
        return (flags & 0x10) != 0;
    }

    public boolean isBlockLine(int line) {
        if (this.m_IgnoreFolding) {
            return false;
        }
        int flags = this.getFlags(line);
        return (flags & 4) != 0;
    }

    public boolean isSignatureLine(int line) {
        if (this.m_IgnoreFolding) {
            return false;
        }
        int flags = this.getFlags(line);
        return (flags & 1) != 0;
    }

    public boolean getLineStatus(int line, LineStatus status) {
        if (this.m_IgnoreFolding || line >= this.m_LineFoldFlags.size()) {
            status.isSignature = false;
            status.isExpanded = false;
            status.isBlockStart = false;
            status.isBlockEnd = false;
            status.isExpanded = false;
            status.isTopLevel = true;
            return false;
        }
        int flags = this.getFlags(line);
        status.isSignature = (flags & 1) != 0;
        status.isExpanded = (flags & 2) != 0;
        status.isBlockStart = (flags & 8) != 0;
        status.isBlockEnd = (flags & 0x10) != 0;
        status.isExpanded = (flags & 2) != 0;
        status.isTopLevel = status.isSignature || status.isExpanded;
        return true;
    }

    public int getNextSignatureLine(int line) {
        if (this.m_IgnoreFolding) {
            return -1;
        }
        if (line >= this.m_LineFoldFlags.size() || line < 0) {
            return -1;
        }
        for (int i = line + 1; i < this.m_LineFoldFlags.size(); ++i) {
            int flags = this.getFlags(i);
            if ((flags & 1) == 0) continue;
            return i;
        }
        return -1;
    }

    public int getPreviousSignatureLine(int line) {
        if (this.m_IgnoreFolding) {
            return -1;
        }
        if (line >= this.m_LineFoldFlags.size() || line < 0) {
            return -1;
        }
        for (int i = line - 1; i >= 0; --i) {
            int flags = this.getFlags(i);
            if ((flags & 1) == 0) continue;
            return i;
        }
        return -1;
    }

    public int getFirstTopLevelLine() {
        if (this.m_IgnoreFolding) {
            return 0;
        }
        for (int i = 0; i < this.m_LineFoldFlags.size(); ++i) {
            int flags = this.getFlags(i);
            if ((flags & 1) == 0 && (flags & 2) == 0) continue;
            return i;
        }
        return 0;
    }

    public int getLastTopLevelLine() {
        if (this.m_IgnoreFolding) {
            return this.getDocument().getLineCount() - 1;
        }
        for (int i = this.m_LineFoldFlags.size() - 1; i >= 0; --i) {
            int flags = this.getFlags(i);
            if ((flags & 1) == 0 && (flags & 2) == 0) continue;
            return i;
        }
        return this.getDocument().getLineCount() - 1;
    }

    public int getNextTopLevelLine(int startLine, int jumps) {
        if (this.m_IgnoreFolding) {
            int lineCount = this.getDocument().getLineCount();
            int resultLine = startLine;
            if (startLine < 0 || startLine >= lineCount) {
                resultLine = lineCount - 1;
                return resultLine;
            }
            if (jumps <= 0) {
                return resultLine;
            }
            if (startLine + jumps >= lineCount) {
                resultLine = lineCount - 1;
                return resultLine;
            }
            resultLine = startLine + jumps;
            return resultLine;
        }
        int resultLine = this.isTopLevelLine(startLine) ? startLine : this.getLastTopLevelLine();
        if (startLine >= this.m_LineFoldFlags.size() || startLine < 0) {
            return resultLine;
        }
        if (jumps <= 0) {
            return resultLine;
        }
        int foundCount = 0;
        for (int i = startLine + 1; i < this.m_LineFoldFlags.size(); ++i) {
            int flags = this.getFlags(i);
            if ((flags & 1) == 0 && (flags & 2) == 0) continue;
            resultLine = i;
            if (++foundCount < jumps) continue;
            return resultLine;
        }
        return resultLine;
    }

    public int getPreviousTopLevelLine(int startLine, int jumps) {
        if (this.m_IgnoreFolding) {
            int lineCount = this.getDocument().getLineCount();
            int resultLine = startLine;
            if (startLine < 0 || startLine >= lineCount) {
                resultLine = 0;
                return resultLine;
            }
            if (jumps <= 0) {
                return resultLine;
            }
            if (startLine - jumps < 0) {
                resultLine = 0;
                return resultLine;
            }
            resultLine = startLine - jumps;
            return resultLine;
        }
        int resultLine = this.isTopLevelLine(startLine) ? startLine : this.getFirstTopLevelLine();
        if (startLine >= this.m_LineFoldFlags.size() || startLine < 0) {
            return resultLine;
        }
        if (jumps <= 0) {
            return resultLine;
        }
        int foundCount = 0;
        for (int i = startLine - 1; i >= 0; --i) {
            int flags = this.getFlags(i);
            if ((flags & 1) == 0 && (flags & 2) == 0) continue;
            resultLine = i;
            if (++foundCount < jumps) continue;
            return resultLine;
        }
        return resultLine;
    }

    public int[] sizedArray(int[] sourceArray, int arraySize) {
        if (sourceArray.length == arraySize) {
            return sourceArray;
        }
        int[] tempResults = new int[arraySize];
        for (int k = 0; k < arraySize; ++k) {
            tempResults[k] = sourceArray[k];
        }
        return tempResults;
    }

    public int[] getTopLevelLines(int startLine, int count) {
        int[] resultLines = new int[count];
        if (count <= 0) {
            return resultLines;
        }
        int arrayIndex = 0;
        if (this.m_IgnoreFolding) {
            int lineCount = this.getDocument().getLineCount();
            if (startLine < 0 || startLine >= lineCount || count < 0) {
                return null;
            }
            for (int i = 0; i < count; ++i) {
                if (startLine + i >= lineCount) {
                    return this.sizedArray(resultLines, arrayIndex);
                }
                resultLines[arrayIndex++] = startLine + i;
            }
            return this.sizedArray(resultLines, arrayIndex);
        }
        if (startLine < 0 || startLine >= this.m_LineFoldFlags.size()) {
            return null;
        }
        if (!this.isTopLevelLine(startLine)) {
            return null;
        }
        if (count < 0) {
            return null;
        }
        resultLines[arrayIndex++] = startLine;
        if (count == 1) {
            return this.sizedArray(resultLines, arrayIndex);
        }
        int foundCount = 1;
        for (int i = startLine + 1; i < this.m_LineFoldFlags.size(); ++i) {
            int flags = this.getFlags(i);
            if ((flags & 1) == 0 && (flags & 2) == 0) continue;
            resultLines[arrayIndex++] = i;
            if (++foundCount < count) continue;
            return this.sizedArray(resultLines, arrayIndex);
        }
        return this.sizedArray(resultLines, arrayIndex);
    }

    public int getTopLevelLineCount() {
        if (this.m_IgnoreFolding) {
            return this.getDocument().getLineCount();
        }
        int count = 0;
        for (int i = 0; i < this.m_LineFoldFlags.size(); ++i) {
            int flags = this.getFlags(i);
            if ((flags & 1) == 0 && (flags & 2) == 0) continue;
            ++count;
        }
        return count;
    }

    public int getTopLevelLinesToLine(int line) {
        if (this.m_IgnoreFolding) {
            int lineCount = this.getDocument().getLineCount();
            if (line >= lineCount) {
                return lineCount - 1;
            }
            if (line < 0) {
                return -1;
            }
            return line;
        }
        if (!this.isTopLevelLine(line)) {
            return -1;
        }
        int count = 0;
        if (line >= this.m_LineFoldFlags.size()) {
            line = this.m_LineFoldFlags.size() - 1;
        }
        for (int i = 0; i < line; ++i) {
            int flags = this.getFlags(i);
            if ((flags & 1) == 0 && (flags & 2) == 0) continue;
            ++count;
        }
        return count;
    }

    public int getNthTopLevelLine(int count) {
        if (this.m_IgnoreFolding) {
            if (count <= 0) {
                return 0;
            }
            if (count > this.getDocument().getLineCount()) {
                return this.getDocument().getLineCount();
            }
            return count - 1;
        }
        int firstTopLevel = this.getFirstTopLevelLine();
        if (count <= 1) {
            return firstTopLevel;
        }
        return this.getNextTopLevelLine(firstTopLevel, count - 1);
    }

    public int subtractTopLevelLines(int firstLine, int secondLine) {
        if (this.m_IgnoreFolding) {
            int lineCount = this.getDocument().getLineCount();
            if (firstLine < 0 || secondLine < 0 || firstLine >= lineCount || secondLine >= lineCount) {
                return 0;
            }
            return secondLine - firstLine;
        }
        int first = Math.min(firstLine, secondLine);
        int second = Math.max(firstLine, secondLine);
        int increment = 1;
        if (first == secondLine) {
            increment = -1;
        }
        if (!this.isTopLevelLine(first) || !this.isTopLevelLine(second)) {
            return 0;
        }
        if (first < 0 || second >= this.m_LineFoldFlags.size()) {
            return 0;
        }
        if (firstLine == secondLine) {
            return 0;
        }
        int difference = increment;
        for (int i = first + 1; i < second; ++i) {
            int flags = this.getFlags(i);
            if ((flags & 1) == 0 && (flags & 2) == 0) continue;
            difference += increment;
        }
        return difference;
    }

    protected void internalExpand(int blockStart, int blockEnd) {
        int blockFlags = 6;
        for (int i = blockStart; i <= blockEnd; ++i) {
            this.addFlags(i, blockFlags);
        }
    }

    protected void internalCollapse(int blockStart, int blockEnd) {
        for (int i = blockStart; i <= blockEnd; ++i) {
            this.updateFlags(i, 2, 4);
        }
    }

    public boolean expand(int line) {
        if (this.m_IgnoreFolding) {
            return false;
        }
        if (line >= this.m_LineFoldFlags.size() || line < 0) {
            return false;
        }
        CodeBlock cb = new CodeBlock();
        boolean okay = this.getBlockInfo(line, cb);
        if (!okay) {
            return false;
        }
        int flags = this.getFlags(line);
        if ((flags & 2) != 0) {
            return false;
        }
        this.internalExpand(cb.start(), cb.end());
        if (this.m_View != null) {
            CodeEditorPane host = (CodeEditorPane)this.m_View.getContainer();
            host.revalidate();
            host.repaint();
            host.repaintBorder();
            this.positionCaret(host);
        }
        return true;
    }

    public boolean collapse(int line) {
        if (this.m_IgnoreFolding) {
            return false;
        }
        if (line >= this.m_LineFoldFlags.size() || line < 0) {
            return false;
        }
        CodeBlock cb = new CodeBlock();
        boolean okay = this.getBlockInfo(line, cb);
        if (!okay) {
            return false;
        }
        int flags = this.getFlags(line);
        if ((flags & 2) == 0) {
            return false;
        }
        this.internalCollapse(cb.start(), cb.end());
        if (this.m_View != null) {
            CodeEditorPane host = (CodeEditorPane)this.m_View.getContainer();
            host.revalidate();
            host.repaint();
            host.repaintBorder();
            this.positionCaret(host);
        }
        return true;
    }

    public void collapseAll() {
        if (this.m_IgnoreFolding) {
            return;
        }
        boolean inBlock = false;
        for (int i = 0; i < this.m_LineFoldFlags.size(); ++i) {
            int flags = this.getFlags(i);
            if ((flags & 8) != 0) {
                inBlock = true;
            }
            if (inBlock) {
                this.updateFlags(i, 2, 0);
            }
            if ((flags & 0x10) == 0) continue;
            inBlock = false;
        }
        if (this.m_View != null) {
            CodeEditorPane host = (CodeEditorPane)this.m_View.getContainer();
            host.revalidate();
            host.repaint();
            host.repaintBorder();
            this.positionCaret(host);
        }
    }

    public void expandAll() {
        if (this.m_IgnoreFolding) {
            return;
        }
        boolean inBlock = false;
        for (int i = 0; i < this.m_LineFoldFlags.size(); ++i) {
            int flags = this.getFlags(i);
            if ((flags & 8) != 0) {
                inBlock = true;
            }
            if (inBlock) {
                this.addFlags(i, 2);
            }
            if ((flags & 0x10) == 0) continue;
            inBlock = false;
        }
        if (this.m_View != null) {
            CodeEditorPane host = (CodeEditorPane)this.m_View.getContainer();
            host.revalidate();
            host.repaint();
            host.repaintBorder();
            this.positionCaret(host);
        }
    }

    private void positionCaret(CodeEditorPane pane) {
        int caretLine = pane.getCaretLine() - 1;
        int caretPos = pane.getCaretPosition();
        boolean hidden = !this.isTopLevelLine(caretLine);
        CodeBlock cb = new CodeBlock();
        boolean okay = this.getBlockInfo(caretLine, cb);
        if (!okay) {
            return;
        }
        if (hidden) {
            caretLine = cb.m_Sig;
            caretPos = pane.getCodeEditorDocument().getStartOffsetForLine(caretLine);
            pane.setCaretPosition(caretPos);
        }
        pane.getCaret().setVisible(false);
        pane.getCaret().setVisible(true);
    }

    public class LineStatus {
        public boolean isSignature;
        public boolean isExpanded;
        public boolean isBlockStart;
        public boolean isBlockMember;
        public boolean isBlockEnd;
        public boolean isTopLevel;
    }
}

