/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.editor.AttributeMap;
import com.sas.editor.CodeBlock;
import com.sas.editor.CodeEditorAttributeManager;
import com.sas.editor.CodeEditorDocLine;
import com.sas.editor.CodeEditorSchemeManager;
import com.sas.editor.ICodeDocument;
import com.sas.editor.LineTokenInfo;
import com.sas.editor.SasColor;
import com.sas.editor.TokenInfo;
import com.sas.editor.TokenMap;
import com.sas.editor.TokenMapInterface;
import com.sas.editor.language.DefaultLanguageParser;
import com.sas.editor.language.SasKeywordInfo;
import com.sas.editor.language.SasKeywordManager;
import com.sas.editor.language.SasKeywordMgrSnapshot;
import com.sas.editor.language.SasLineTokenInfo;
import com.sas.editor.language.SasToken;
import com.sas.editor.language.SasTokenInfo;
import com.sas.editor.language.SasTokenizer;
import com.sas.editor.language.ViewFoldInfo;
import java.awt.Font;
import java.util.Vector;
import javax.swing.text.Element;
import javax.swing.text.Segment;

public class SasLanguageParser
extends DefaultLanguageParser {
    private static Segment segLineText = new Segment();
    protected static int[] m_aParenLevels = new int[25];
    protected SasKeywordManager m_KeywordMgr = null;
    protected boolean m_bSOS;
    protected boolean m_bNoEditScan = false;
    protected static SasTokenizer mTokenizer = new SasTokenizer();
    protected CodeEditorAttributeManager attrManager = new CodeEditorAttributeManager(this.m_Doc.getDefaults());
    protected Vector m_CodeBlocks = null;
    protected boolean m_SimpleBlocks = true;
    protected TokenMap mNewTokenMap = null;
    protected String mDefaultProcContext;

    public SasLanguageParser(ICodeDocument doc) {
        super(doc);
        this.m_KeywordMgr = new SasKeywordManager(this.m_Doc.getDefaults());
        this.m_CodeBlocks = new Vector(10, 10);
        this.updateElementAttributeMap();
        this.m_bSOS = false;
        this.mDefaultProcContext = "";
    }

    @Override
    public void cleanup() {
        this.m_Doc = null;
        if (this.mNewTokenMap != null) {
            this.mNewTokenMap.cleanup();
        }
        SasLanguageParser.mTokenizer.m_Doc = null;
        super.cleanup();
    }

    @Override
    public void color() {
        if (this.m_Doc.getLength() == 0) {
            this.m_Doc.getTokenMap().clear();
            return;
        }
        int colorEnd = this.m_Doc.getLength();
        int rc = this.EditScan(0, colorEnd, null);
        if (rc == -1) {
            this.EnableDocumentColoring(false);
            return;
        }
        this.m_Doc.getTokenMap().patchRanges(this.mNewTokenMap);
        this.mNewTokenMap = null;
        this.m_Doc.syntaxColorUpdate(0, colorEnd);
    }

    @Override
    public void color(int offset, int length) {
        int endOffset;
        if (this.mDefaultProcContext.length() > 0) {
            this.color();
            return;
        }
        SasKeywordMgrSnapshot snapshot = null;
        int snapshotOffset = this.m_Doc.getPrevLineEndOffset(offset);
        if (snapshotOffset > 0) {
            snapshot = this.getSnapshotAtOffset(snapshotOffset);
        }
        if ((endOffset = this.EditScan(offset, offset + length - 1, snapshot)) == -1) {
            this.EnableDocumentColoring(false);
            return;
        }
        this.m_Doc.getTokenMap().patchRanges(this.mNewTokenMap);
        this.mNewTokenMap = null;
        this.m_Doc.syntaxColorUpdate(offset, endOffset);
    }

    public void interactiveReplace(int changeStartOffset, int deleteLength, int insertLength) {
        if (insertLength == 0) {
            this.interactiveDelete(changeStartOffset, deleteLength);
            return;
        }
        if (this.m_Doc.isEmpty()) {
            this.m_Doc.getTokenMap().clear();
            return;
        }
        if (this.m_Doc.getTokenMap().getRangeCount() == 0) {
            this.color();
            return;
        }
        if (deleteLength > 0) {
            this.m_Doc.getTokenMap().shiftPositionsForDelete(changeStartOffset, changeStartOffset + deleteLength);
        }
        this.interactiveInsert(changeStartOffset, insertLength);
    }

    @Override
    public void interactiveInsert(int changeStartOffset, int changeLength) {
        if (this.m_Doc.isEmpty()) {
            this.m_Doc.getTokenMap().clear();
            return;
        }
        if (this.m_Doc.getTokenMap().getRangeCount() == 0) {
            this.color();
            return;
        }
        this.m_Doc.getTokenMap().shiftPositionsForInsert(changeStartOffset, changeLength);
        int changeEndOffset = changeStartOffset + changeLength;
        int colorStartOffset = this.findColorStart(changeStartOffset);
        CodeEditorDocLine changeEndLine = new CodeEditorDocLine(this.m_Doc, changeEndOffset);
        CodeEditorDocLine colorEndLine = changeEndLine.next();
        int colorEndOffset = colorEndLine != null ? colorEndLine.start() : changeEndLine.end();
        colorEndOffset = Math.min(colorEndOffset, this.m_Doc.getLength());
        this.color(colorStartOffset, colorEndOffset - colorStartOffset);
        int nextSigLine = this.getNextSigLine(this.m_Doc.getLineNumberFromOffset(changeStartOffset + changeLength));
        if (nextSigLine >= 0) {
            this.updateSectionStart(nextSigLine, 0);
        }
    }

    @Override
    public void interactiveDelete(int changeStartOffset, int changeLength) {
        if (this.m_Doc.isEmpty()) {
            this.m_Doc.getTokenMap().clear();
            return;
        }
        if (this.m_Doc.getTokenMap().getRangeCount() == 0) {
            this.color();
            return;
        }
        this.m_Doc.getTokenMap().shiftPositionsForDelete(changeStartOffset, changeStartOffset + changeLength);
        int colorStartOffset = this.findColorStart(changeStartOffset);
        CodeEditorDocLine changeEndLine = new CodeEditorDocLine(this.m_Doc, changeStartOffset);
        CodeEditorDocLine colorEndLine = changeEndLine.next();
        int colorEndOffset = colorEndLine != null ? colorEndLine.start() : changeEndLine.end();
        this.color(colorStartOffset, colorEndOffset - colorStartOffset + 1);
        int nextSigLine = this.getNextSigLine(this.m_Doc.getLineNumberFromOffset(changeStartOffset));
        if (nextSigLine >= 0) {
            this.updateSectionStart(nextSigLine, 0);
        }
    }

    @Override
    public void updateElementAttributeMap() {
        this.m_AttrMap = this.attrManager.getAttributeMap(2);
        if (this.m_AttrMap == null) {
            this.initAttributes();
            this.attrManager.setAttributeMap(this.m_AttrMap, 2, true);
        }
    }

    @Override
    public void updateKeywords() {
        if (this.m_KeywordMgr.UpdateKeywords()) {
            this.color();
        }
    }

    public void initAttributes() {
        int nElements = 23;
        this.m_AttrMap = new AttributeMap(nElements);
        this.m_AttrMap.addElementAttributes((short)4, SasColor.darkGreen, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)15, SasColor.black, SasColor.lightYellow, false, false);
        this.m_AttrMap.addElementAttributes((short)12, SasColor.teal, SasColor.white, true, false);
        this.m_AttrMap.addElementAttributes((short)10, SasColor.black, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)11, SasColor.black, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)13, SasColor.teal, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)8, SasColor.purple, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)3, SasColor.blue, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)17, SasColor.black, SasColor.white, true, true);
        this.m_AttrMap.addElementAttributes((short)6, SasColor.blue, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)18, SasColor.black, SasColor.white, true, true);
        this.m_AttrMap.addElementAttributes((short)20, SasColor.navy, SasColor.white, true, false);
        this.m_AttrMap.addElementAttributes((short)21, SasColor.black, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)1, SasColor.black, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)7, SasColor.teal, SasColor.white, true, false);
        this.m_AttrMap.addElementAttributes((short)16, SasColor.navy, SasColor.offWhite, true, false);
        this.m_AttrMap.addElementAttributes((short)9, SasColor.navy, SasColor.white, true, false);
        this.m_AttrMap.addElementAttributes((short)2, SasColor.green, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)22, SasColor.green, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)5, SasColor.purple, SasColor.white, false, true);
        this.m_AttrMap.addElementAttributes((short)19, SasColor.red, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)14, SasColor.red, SasColor.white, false, true);
        this.m_AttrMap.addElementAttributes((short)23, SasColor.blue, SasColor.white, false, false);
        Font f = this.attrManager.getFont(2);
        if (f == null) {
            f = CodeEditorSchemeManager.PREDEFINED_FONT;
        }
        this.m_AttrMap.addFontAttributes(f);
    }

    public int findColorStart(int deltaOffset) {
        if (this.m_Doc.getCurrentLineStartOffset(deltaOffset) == 0) {
            return 0;
        }
        if (!this.m_Doc.IsDocumentColoringEnabled()) {
            return 0;
        }
        int prevLineOffset = this.m_Doc.getPrevLineStartOffset(deltaOffset);
        CodeEditorDocLine currLine = new CodeEditorDocLine(this.m_Doc, prevLineOffset);
        while (currLine.start() > 0) {
            if (currLine.length() > 0 && this.m_Doc.lineTokenInfoExists(currLine.start())) {
                SasLineTokenInfo slti = (SasLineTokenInfo)this.m_Doc.getLineTokenInfo(currLine.start(), false);
                short edisptype = this.getTokenTypeForOffset(currLine.lastCharOffset());
                if (edisptype == 4 || edisptype == 5 || edisptype == 14) {
                    currLine = currLine.previous();
                    continue;
                }
                int lineFlags = slti.getLineFlags();
                if ((lineFlags & 0x100) == 256) break;
                if ((lineFlags & 0x4000000) == 0x4000000) {
                    edisptype = this.getTokenTypeForOffset(currLine.start());
                    if (edisptype != 4 && edisptype != 5 && edisptype != 19) break;
                    currLine = currLine.previous();
                    continue;
                }
                currLine = currLine.previous();
                continue;
            }
            currLine = currLine.previous();
        }
        return currLine.start();
    }

    protected short getTokenTypeForOffset(int offset) {
        if (offset < 0 || offset > this.m_Doc.getLength()) {
            return 0;
        }
        TokenInfo tok = this.m_Doc.getTokenMap().getTokenInfo(offset);
        if (tok == null) {
            return 0;
        }
        return tok.getTokenType();
    }

    @Override
    public boolean isCommentType(int offset) {
        short type = this.getTokenTypeForOffset(offset);
        return type == 4;
    }

    @Override
    public boolean isCodeType(int offset) {
        short type = this.getTokenTypeForOffset(offset);
        return type == 3;
    }

    @Override
    public boolean IsDocumentColoringEnabled() {
        return !this.m_bNoEditScan;
    }

    @Override
    public void EnableDocumentColoring(boolean b) {
        if (this.m_bNoEditScan != b) {
            return;
        }
        this.m_bNoEditScan = !b;
        boolean isMyLock = this.m_Doc.RequestLock();
        if (this.m_bNoEditScan) {
            TokenMapInterface tokenMap = this.m_Doc.getTokenMap();
            tokenMap.clear();
            SasTokenInfo tokenInfo = new SasTokenInfo(0, this.m_Doc.getLength(), 1, null);
            tokenMap.append(tokenInfo, false);
        } else {
            this.color();
        }
        if (isMyLock) {
            this.m_Doc.ReleaseLock();
        }
    }

    protected final int determineTokenLine(int tokenOffset, int contextLine) {
        int startOffset = tokenOffset;
        return this.m_Doc.getLineForOffset(startOffset);
    }

    public int EditScan(int startOffset, int endOffset, SasKeywordMgrSnapshot inSnapshot) {
        SasKeywordMgrSnapshot snapshot;
        this.mNewTokenMap = new TokenMap(this.m_Doc);
        SasKeywordInfo keywordInfo = new SasKeywordInfo();
        short edisptype = 1;
        mTokenizer.Initialize(this.m_Doc);
        boolean bResetLineFlags = false;
        boolean bEndInStarComment = false;
        boolean bChanges = true;
        boolean bLabel = false;
        int nInMacroDefinition = 0;
        int nInMacroQuotingFunction = 0;
        int nParenNestingDepth = 0;
        int nStatementID = 0;
        int fLineFlags = 0;
        int nPctTokenOffset = -1;
        boolean bNextTokenStartsLine = true;
        boolean bTokenStartsLine = false;
        boolean reachedEndOfLineAfterRequiredParseDistance = false;
        if (this.m_bNoEditScan) {
            return startOffset;
        }
        boolean isMyLock = this.m_Doc.RequestLock();
        this.m_KeywordMgr.Reset(inSnapshot);
        if (this.mDefaultProcContext.length() > 0) {
            SasKeywordInfo outEntry = new SasKeywordInfo();
            this.m_KeywordMgr.KeywordLookup("proc", "", outEntry, true);
            this.m_KeywordMgr.KeywordLookup(this.mDefaultProcContext, "", outEntry, false);
            inSnapshot = this.m_KeywordMgr.TakeSnapshot(true, nInMacroDefinition);
        }
        if (inSnapshot != null) {
            this.m_bSOS = inSnapshot.m_bSOS;
            nInMacroDefinition = inSnapshot.m_nInMacroDefinition;
        } else {
            this.m_bSOS = true;
            nInMacroDefinition = 0;
        }
        mTokenizer.SetPosition(startOffset);
        SasToken token = mTokenizer.NextToken();
        SasLineTokenInfo tok_slti = null;
        int tokenStartLine = -1;
        int tokenEndLine = -1;
        int lastTokenStartOffset = -1;
        while (true) {
            if (token.GetType() == -1) break;
            if (lastTokenStartOffset == token.GetStartOffset()) {
                return -1;
            }
            lastTokenStartOffset = token.GetStartOffset();
            tokenStartLine = this.determineTokenLine(token.GetStartOffset(), tokenEndLine);
            tokenEndLine = this.determineTokenLine(token.GetEndOffset() - 1, tokenStartLine);
            tok_slti = (SasLineTokenInfo)this.m_Doc.getLineTokenInfoForLine(tokenStartLine, false);
            edisptype = 1;
            boolean bPostKeywordSOS = false;
            if (bNextTokenStartsLine && token.GetType() != 0) {
                bTokenStartsLine = true;
                bNextTokenStartsLine = false;
            } else {
                bTokenStartsLine = false;
            }
            boolean bTokenEndsLine = false;
            SasToken lookAheadToken = this.PeekNextToken(mTokenizer);
            if (lookAheadToken != null) {
                if (lookAheadToken.GetType() == 0) {
                    if (!this.m_Doc.onSameLine(lookAheadToken.GetStartOffset(), lookAheadToken.GetEndOffset())) {
                        bNextTokenStartsLine = true;
                        bTokenEndsLine = true;
                    }
                } else if (!this.m_Doc.onSameLine(lookAheadToken.GetStartOffset(), token.GetEndOffset())) {
                    bNextTokenStartsLine = true;
                    bTokenEndsLine = true;
                }
                if (!bTokenEndsLine) {
                    bNextTokenStartsLine = tokenStartLine != tokenEndLine;
                    bTokenEndsLine = bNextTokenStartsLine;
                }
            } else {
                bNextTokenStartsLine = true;
                bTokenEndsLine = true;
            }
            if (bTokenStartsLine) {
                tok_slti.setLineFlags(0);
                tok_slti.setLineDisplayFlags(0);
                fLineFlags &= 0xFFFFFEFF;
            }
            if (token.GetType() == 21 && token.GetSubType() != 2 && !mTokenizer.GetInStarComment()) {
                edisptype = 4;
                fLineFlags |= 1;
            } else {
                if (token.GetType() != 0 && !mTokenizer.GetInStarComment()) {
                    fLineFlags |= 0x400;
                }
                if (token.GetType() == 2) {
                    boolean bKeywordFound;
                    boolean bNoLookUp = mTokenizer.GetInStarComment();
                    SasToken nextToken = mTokenizer.PeekNextNonWhitespaceToken();
                    if (this.m_bSOS) {
                        if (mTokenizer.tokenEqualsString(nextToken, "+") || mTokenizer.tokenEqualsString(nextToken, "{") || mTokenizer.tokenEqualsString(nextToken, "[") || mTokenizer.tokenEqualsString(nextToken, ":")) {
                            bNoLookUp = true;
                        }
                        if (mTokenizer.tokenEqualsString(nextToken, ":")) {
                            bLabel = true;
                        }
                    }
                    if (!bNoLookUp) {
                        bKeywordFound = this.m_KeywordMgr.KeywordLookup(token.GetValue(), nextToken.GetValue(), keywordInfo, this.m_bSOS);
                        bPostKeywordSOS = keywordInfo.m_bPostKeywordSOS;
                        if (keywordInfo.m_eDisptype != -1) {
                            edisptype = keywordInfo.m_eDisptype;
                        }
                    } else {
                        bKeywordFound = false;
                    }
                    if (!bNoLookUp && !bKeywordFound && mTokenizer.tokenEqualsString(nextToken, "=")) {
                        edisptype = 1;
                    }
                    if (this.m_bSOS && bKeywordFound && mTokenizer.tokenEqualsString(nextToken, "=") && (keywordInfo.m_fFlags & 0x200) == 0) {
                        bKeywordFound = false;
                        edisptype = 1;
                    }
                    if (!bNoLookUp && !bKeywordFound && edisptype != 18 && mTokenizer.tokenEqualsString(nextToken, "(")) {
                        edisptype = 1;
                    }
                    if (bKeywordFound) {
                        if (this.m_bSOS || nInMacroDefinition != 0) {
                            nStatementID = keywordInfo.m_nInState;
                            if (this.m_bSOS && nInMacroDefinition == 0) {
                                fLineFlags = 256;
                                fLineFlags = (keywordInfo.m_fFlags & 8) != 0 ? (fLineFlags |= 0x2000) : (fLineFlags |= 0x1000);
                            }
                            if (nStatementID == 101 || nStatementID == 103 || nStatementID == 10015) {
                                if (nStatementID == 10015) {
                                    tok_slti.setLineFlags(tok_slti.getLineFlags() | 0x40 | fLineFlags);
                                }
                                if ((tok_slti.getLineDisplayFlags() & 0x2000) != 0) {
                                    tok_slti.setLineDisplayFlags(tok_slti.getLineDisplayFlags() | 0xFFFFDFFF);
                                }
                                this.m_KeywordMgr.SetInInteractiveProc(false);
                                int line = tokenStartLine;
                                int lineStartOffset = this.m_Doc.getStartOffsetForLine(line);
                                this.updateSectionStart(line, token.GetEndOffset() - lineStartOffset);
                            }
                            if (nStatementID == 104 && this.m_KeywordMgr.InInteractiveProc()) {
                                fLineFlags |= 8;
                                this.m_KeywordMgr.SetInInteractiveProc(false);
                            }
                            if (nStatementID == 10016) {
                                tok_slti.setLineFlags(tok_slti.getLineFlags() | 0x8000000 | fLineFlags);
                            }
                        }
                        if ((keywordInfo.m_fFlags & 0x80) != 0) {
                            if (nInMacroQuotingFunction == 0) {
                                nParenNestingDepth = 0;
                                SasLanguageParser.m_aParenLevels[0] = 0;
                            }
                            ++nInMacroQuotingFunction;
                            mTokenizer.SetInMacroQuotingFunction(true);
                            token = mTokenizer.CurrentToken();
                        }
                        if (nStatementID == 10015) {
                            ++nInMacroDefinition;
                            this.m_KeywordMgr.SetInMacroDefinition(true);
                            this.m_KeywordMgr.SetMacroNameDefinition(true);
                        }
                    }
                    this.m_bSOS = bPostKeywordSOS;
                    if (this.m_KeywordMgr.InMacroScope()) {
                        this.m_KeywordMgr.EndMacroScope();
                    }
                    if (nInMacroDefinition != 0) {
                        if (nStatementID == 10016) {
                            this.m_KeywordMgr.SetInMacroDefinition(--nInMacroDefinition > 0);
                            fLineFlags &= 0xFBFFFFFF;
                            fLineFlags |= 0x80;
                            tok_slti.setLineFlags(tok_slti.getLineFlags() & 0xFBFFFFFF);
                        }
                        fLineFlags &= 0xFBFFCFFF;
                        if (nStatementID != 10015) {
                            fLineFlags = nStatementID == 10016 ? (fLineFlags |= 0x1000) : (fLineFlags |= 0x4000000);
                            tok_slti.setLineDisplayFlags(tok_slti.getLineDisplayFlags() & 0xFFFFCFF3);
                        } else {
                            fLineFlags |= 0x2000;
                        }
                    }
                } else if (token.GetType() == 3) {
                    edisptype = 5;
                    fLineFlags |= 2;
                } else if (token.GetType() == 4 || token.GetType() == 5 || token.GetType() == 11) {
                    edisptype = 7;
                } else if (token.GetType() == 8 || token.GetType() == 9 || token.GetType() == 10) {
                    edisptype = 12;
                    fLineFlags |= 2;
                } else if (token.GetType() == 12) {
                    edisptype = 5;
                    fLineFlags |= 2;
                } else if (token.GetType() == 7) {
                    edisptype = 13;
                } else if (mTokenizer.tokenEqualsString(token, "%")) {
                    this.m_KeywordMgr.StartMacroScope();
                    nPctTokenOffset = token.GetStartOffset();
                } else if (this.m_KeywordMgr.InMacroScope()) {
                    this.m_KeywordMgr.EndMacroScope();
                }
                if (this.m_KeywordMgr.InMacroCollectMode() && edisptype != 6) {
                    edisptype = 21;
                }
                if (this.m_bSOS && (mTokenizer.tokenEqualsString(token, "*") || mTokenizer.tokenEqualsString(token, "**") || mTokenizer.tokenEqualsString(token, "*/"))) {
                    mTokenizer.SetInStarComment(true);
                    token = mTokenizer.CurrentToken();
                    fLineFlags |= 1;
                    fLineFlags &= 0xFFFFFBFF;
                }
                if (!this.m_KeywordMgr.InMacroScope() && token.GetType() != 0 && !bPostKeywordSOS) {
                    this.m_bSOS = false;
                }
                if (token.GetType() == 30) {
                    boolean bCardsScanned = false;
                    if (mTokenizer.GetInStarComment()) {
                        edisptype = 4;
                        bEndInStarComment = true;
                    }
                    if (nStatementID == 26 || nStatementID == 27) {
                        int nNextLineOffset;
                        int nCurrLineOffset = this.m_Doc.getCurrentLineStartOffset(token.GetEndOffset()) - 1;
                        int nDocLength = this.m_Doc.getLength();
                        int nextLineIndex = tokenEndLine + 1;
                        if (nextLineIndex > this.m_Doc.getLineCount() - 1) {
                            nextLineIndex = this.m_Doc.getLineCount() - 1;
                        }
                        if ((nNextLineOffset = this.m_Doc.getNextLineStartOffsetFromLine(tokenEndLine)) > nDocLength) {
                            nNextLineOffset = nDocLength;
                        }
                        snapshot = this.m_KeywordMgr.TakeSnapshot(this.m_bSOS, nInMacroDefinition);
                        this.ColorToken(endOffset, token.GetStartOffset(), nNextLineOffset, tokenStartLine, tokenEndLine, (short)1, fLineFlags, snapshot, nPctTokenOffset < 0);
                        ++nextLineIndex;
                        nCurrLineOffset = nNextLineOffset;
                        while (nCurrLineOffset < nDocLength) {
                            nNextLineOffset = this.m_Doc.getNextLineStartOffsetFromLine(nextLineIndex - 1);
                            if (nNextLineOffset > nDocLength) {
                                nNextLineOffset = nDocLength;
                            }
                            try {
                                this.m_Doc.getText(nCurrLineOffset, nNextLineOffset - 1 - nCurrLineOffset, segLineText);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            if (nStatementID == 26 ? this.hasSemiColon(segLineText) : nStatementID == 27 && SasLanguageParser.segLineText.count == 4 && this.hasAllSemiColons(segLineText)) break;
                            SasLineTokenInfo currline_slti = (SasLineTokenInfo)this.m_Doc.getLineTokenInfoForLine(nextLineIndex - 1, false);
                            currline_slti.setLineFlags(0);
                            if (nCurrLineOffset > nDocLength) {
                                nCurrLineOffset = nDocLength;
                            }
                            snapshot = this.m_KeywordMgr.TakeSnapshot(this.m_bSOS, nInMacroDefinition);
                            this.ColorToken(endOffset, nCurrLineOffset, nNextLineOffset, nextLineIndex - 1, nextLineIndex - 1, (short)15, 0x101000, snapshot, nPctTokenOffset < 0);
                            nCurrLineOffset = nNextLineOffset;
                            ++nextLineIndex;
                        }
                        fLineFlags |= 0x1000;
                        mTokenizer.SetPosition(nCurrLineOffset);
                        token = mTokenizer.NextToken();
                        bCardsScanned = true;
                    }
                    if (nStatementID > 10000) {
                        this.m_KeywordMgr.EndMacroScope();
                    }
                    nStatementID = 0;
                    this.m_bSOS = true;
                    bResetLineFlags = true;
                    bLabel = false;
                    if (bCardsScanned) continue;
                }
                if (bLabel && mTokenizer.tokenEqualsString(token, ":")) {
                    nStatementID = 0;
                    this.m_bSOS = true;
                    bLabel = false;
                }
                if (nInMacroQuotingFunction != 0 && token.GetType() != 0 && (mTokenizer.tokenEqualsString(token, "(") || mTokenizer.tokenEqualsString(token, ")"))) {
                    if (mTokenizer.tokenEqualsString(token, "(")) {
                        if (nInMacroQuotingFunction > nParenNestingDepth) {
                            SasLanguageParser.m_aParenLevels[Math.min((int)24, (int)(++nParenNestingDepth))] = 0;
                        }
                        int n = Math.min(24, nInMacroQuotingFunction);
                        m_aParenLevels[n] = m_aParenLevels[n] + 1;
                    } else if (mTokenizer.tokenEqualsString(token, ")")) {
                        int n = Math.min(24, nInMacroQuotingFunction);
                        m_aParenLevels[n] = m_aParenLevels[n] - 1;
                    }
                    if (m_aParenLevels[Math.min(24, nInMacroQuotingFunction)] == 0 && --nInMacroQuotingFunction == 0) {
                        mTokenizer.SetInMacroQuotingFunction(false);
                        token = mTokenizer.CurrentToken();
                    }
                }
            }
            if (edisptype == 6 || edisptype == 20) {
                this.mNewTokenMap.removeLast();
                token.m_nStartOffset = nPctTokenOffset;
                nPctTokenOffset = -1;
            }
            if (mTokenizer.GetInStarComment()) {
                edisptype = 4;
            }
            if (nInMacroDefinition != 0 && nStatementID != 10015 && edisptype == 1) {
                edisptype = 21;
            }
            if (edisptype == 10 && !this.m_KeywordMgr.InInteractiveProc()) {
                fLineFlags |= 0x80;
            }
            snapshot = this.m_KeywordMgr.TakeSnapshot(this.m_bSOS, nInMacroDefinition);
            bChanges = this.ColorToken(endOffset, token.GetStartOffset(), token.GetEndOffset(), tokenStartLine, tokenEndLine, edisptype, fLineFlags, snapshot, nPctTokenOffset < 0);
            if (bEndInStarComment) {
                bEndInStarComment = false;
                mTokenizer.SetInStarComment(false);
                token = mTokenizer.CurrentToken();
                fLineFlags &= 0xFFFFFFFE;
                edisptype = 1;
            }
            int position = mTokenizer.GetPosition();
            if (bTokenEndsLine && position >= endOffset) {
                reachedEndOfLineAfterRequiredParseDistance = true;
            }
            if (!bChanges && mTokenizer.GetPosition() >= endOffset && edisptype != 5 && edisptype != 4 && reachedEndOfLineAfterRequiredParseDistance) {
                if (isMyLock) {
                    this.m_Doc.ReleaseLock();
                }
                return mTokenizer.GetPosition();
            }
            if (bResetLineFlags) {
                fLineFlags = 0;
            }
            bResetLineFlags = false;
            token = mTokenizer.NextToken();
        }
        if (token.GetType() == 21 || mTokenizer.GetInStarComment()) {
            edisptype = 4;
        }
        snapshot = this.m_KeywordMgr.TakeSnapshot(this.m_bSOS, nInMacroDefinition);
        tokenStartLine = this.determineTokenLine(token.GetStartOffset(), tokenEndLine);
        tokenEndLine = this.determineTokenLine(token.GetEndOffset() - 1, tokenStartLine);
        this.ColorToken(endOffset, token.GetStartOffset(), token.GetEndOffset(), tokenStartLine, tokenEndLine, edisptype, fLineFlags, snapshot, nPctTokenOffset < 0);
        if (isMyLock) {
            this.m_Doc.ReleaseLock();
        }
        return mTokenizer.GetPosition();
    }

    protected boolean ColorToken(int colorStopOffset, int startOffset, int endOffset, int startLine, int endLine, short edisptype, int fLineFlags, SasKeywordMgrSnapshot snapshot, boolean coaslesceTags) {
        if (startOffset == endOffset) {
            return false;
        }
        if (startOffset > endOffset) {
            return false;
        }
        short tokenType = edisptype;
        if (tokenType == 10) {
            tokenType = 9;
        }
        int endLineIndex = endLine;
        int docLength = this.m_Doc.getLineCount();
        for (int currentLine = startLine; currentLine < docLength && currentLine <= endLineIndex; ++currentLine) {
            SasLineTokenInfo slti = (SasLineTokenInfo)this.m_Doc.getLineTokenInfoForLine(currentLine, false);
            int newLineFlags = slti.getLineFlags() | fLineFlags;
            if ((edisptype == 5 || edisptype == 4) && currentLine > startLine) {
                newLineFlags = fLineFlags;
                newLineFlags &= 0xFFFFFEFF;
                slti.setLineDisplayFlags(0);
            }
            if ((newLineFlags & 0x88) != 0) {
                slti.setLineDisplayFlags(slti.getLineDisplayFlags() | 0x2000);
            }
            if ((newLineFlags & 4) == 0 || currentLine > startLine) {
                if (!this.isBlankLine(currentLine)) {
                    newLineFlags &= 0xFFFFFDFF;
                } else {
                    newLineFlags |= 0x200;
                    newLineFlags &= 0xFFFFCA27;
                    int lineNumber = currentLine;
                    int uDisplayFlags = this.getLineDisplayFlags(lineNumber);
                    this.setLineDisplayFlags(lineNumber, uDisplayFlags &= 0xFFFFDFF3);
                }
                newLineFlags |= 4;
            }
            slti.setLineFlags(newLineFlags);
        }
        TokenInfo tokenInfo = new SasTokenInfo(startOffset, endOffset, tokenType, snapshot);
        this.mNewTokenMap.append(tokenInfo, coaslesceTags);
        this.mNewTokenMap.seekEnd();
        tokenInfo = this.mNewTokenMap.getCurrent();
        return endOffset < colorStopOffset || !this.m_Doc.getTokenMap().containsRange(tokenInfo);
    }

    protected SasToken PeekNextToken(SasTokenizer tokenizer) {
        SasToken nextToken = tokenizer.PeekNextToken();
        if (nextToken.GetType() == -1) {
            return null;
        }
        return nextToken;
    }

    public SasKeywordMgrSnapshot getSnapshotAtOffset(int offset) {
        TokenInfo tokenInfo = this.m_Doc.getTokenMap().getTokenInfo(offset);
        if (tokenInfo != null) {
            return (SasKeywordMgrSnapshot)tokenInfo.getUserData();
        }
        return null;
    }

    private boolean hasSemiColon(Segment txt) {
        for (int i = txt.getBeginIndex(); i <= txt.getEndIndex(); ++i) {
            if (txt.setIndex(i) != ';') continue;
            return true;
        }
        return false;
    }

    private boolean hasAllSemiColons(Segment txt) {
        for (int i = txt.getBeginIndex(); i < txt.getEndIndex(); ++i) {
            if (txt.setIndex(i) == ';') continue;
            return false;
        }
        return true;
    }

    @Override
    public LineTokenInfo createLineTokenInfoObject(Element elem) {
        return new SasLineTokenInfo(elem);
    }

    public void makeBlockList() {
        int currLine = 0;
        int start = 0;
        int end = 0;
        int sig = 0;
        this.freeBlockList();
        sig = this.getNextSigLine(currLine);
        while (sig >= 0) {
            start = this.updateSectionStart(sig, 0);
            end = this.findSectionEnd(sig);
            if (end < sig) {
                end = sig;
            }
            this.addCodeBlock(start, end, sig);
            currLine = end + 1;
            sig = this.getNextSigLine(currLine);
        }
        this.extendLastBlock();
    }

    protected boolean extendLastBlock() {
        int lastDocLine;
        int nUpperBound = this.m_CodeBlocks.size() - 1;
        if (nUpperBound == -1) {
            return false;
        }
        CodeBlock lastBlock = (CodeBlock)this.m_CodeBlocks.get(nUpperBound);
        int lastBlockLine = lastBlock.end();
        if (lastBlockLine == (lastDocLine = this.m_Doc.getLineCount() - 1)) {
            return false;
        }
        ++lastBlockLine;
        while (lastBlockLine <= lastDocLine) {
            if ((this.getLineFlags(lastBlockLine) & 0x200) == 0) {
                return false;
            }
            ++lastBlockLine;
        }
        lastBlock.setEnd(lastDocLine);
        return true;
    }

    public Vector getBlockList() {
        return this.m_CodeBlocks;
    }

    protected void freeBlockList() {
        this.m_CodeBlocks.removeAllElements();
    }

    protected void addCodeBlock(int start, int end, int sig) {
        this.m_CodeBlocks.add(new CodeBlock(start, end, sig));
    }

    protected boolean getBlockInfo(int line, CodeBlock cb) {
        if (this.m_CodeBlocks.isEmpty()) {
            return false;
        }
        CodeBlock curr = null;
        for (int i = 0; i < this.m_CodeBlocks.size(); ++i) {
            curr = (CodeBlock)this.m_CodeBlocks.get(i);
            if (line < curr.m_Start || line > curr.m_End) continue;
            cb.m_Start = curr.m_Start;
            cb.m_End = curr.m_End;
            cb.m_Sig = curr.m_Sig;
            return true;
        }
        return false;
    }

    protected int getNextSigLine(int startLine) {
        int maxLines = this.m_Doc.getLineCount();
        for (int currLine = startLine; currLine < maxLines; ++currLine) {
            int displayFlags = this.getLineDisplayFlags(currLine);
            int lineFlags = this.getLineFlags(currLine);
            if ((displayFlags & 0xC) != 0) {
                return currLine;
            }
            if ((lineFlags & 0x40) == 0) continue;
            return currLine;
        }
        return -1;
    }

    protected int updateSectionStart(int startLine, int startColumn) {
        int sectionLine = startLine;
        if (this.m_SimpleBlocks) {
            if (startLine == 0) {
                sectionLine = 0;
            } else {
                for (int currLine = startLine - 1; currLine >= 0; --currLine) {
                    int lineFlags = this.getLineFlags(currLine);
                    if ((lineFlags & 0x200) != 0) {
                        sectionLine = currLine;
                        continue;
                    }
                    if ((lineFlags & 1) != 0 && (lineFlags & 0x400) == 0) {
                        sectionLine = currLine;
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (int currLine = startLine; currLine >= 0; --currLine) {
                int lineFlags = this.getLineFlags(currLine);
                if ((lineFlags & 0x1040) == 0) {
                    if (currLine == 0) {
                        if ((lineFlags & 0x200) != 0) break;
                        sectionLine = 0;
                        break;
                    }
                    if ((lineFlags & 0x200) != 0) continue;
                    sectionLine = currLine;
                    continue;
                }
                if ((lineFlags & 0x3040) == 0) {
                    if ((lineFlags & 0x200) != 0) continue;
                    sectionLine = currLine;
                    continue;
                }
                if (currLine != startLine) break;
                if (currLine == 0) {
                    if ((lineFlags & 0x200) != 0) break;
                    sectionLine = 0;
                    break;
                }
                sectionLine = currLine;
            }
        }
        this.setLineDisplayFlags(sectionLine, this.getLineDisplayFlags(sectionLine) | 0x1000);
        this.setLineFlags(startLine, this.getLineFlags(startLine) | 0x10 | (this.m_bSOS && startColumn == 0 ? 256 : 0));
        if (this.m_bSOS && (this.getLineDisplayFlags(startLine) & 0xC) == 0) {
            this.setLineDisplayFlags(startLine, this.getLineDisplayFlags(startLine) | 8);
        }
        return sectionLine;
    }

    protected int findSectionEnd(int sigLine) {
        int lineFlags;
        int lastLine = this.m_Doc.getLineCount() - 1;
        int endOfSection = 0;
        if (sigLine == lastLine) {
            return sigLine;
        }
        if ((this.getLineDisplayFlags(sigLine) & 0x2000) != 0) {
            return sigLine;
        }
        if ((this.getLineFlags(sigLine) & 0x40) != 0) {
            int nestedMacro = 0;
            for (int currLine = sigLine; currLine <= lastLine; ++currLine) {
                int lineFlags2 = this.getLineFlags(currLine);
                if ((lineFlags2 & 0x40) != 0) {
                    ++nestedMacro;
                }
                if ((lineFlags2 & 0x88) == 0 || (lineFlags2 & 0x8000000) == 0 || --nestedMacro != 0) continue;
                return currLine;
            }
            return lastLine;
        }
        boolean foundSection = false;
        for (int currLine = sigLine + 1; currLine <= lastLine; ++currLine) {
            int displayFlags = this.getLineDisplayFlags(currLine);
            lineFlags = this.getLineFlags(currLine);
            if ((displayFlags & 0xC) != 0 && (lineFlags & 0x40) == 0) {
                endOfSection = this.findEndOfPriorSection(Math.max(currLine - 1, 0));
                foundSection = true;
                break;
            }
            if ((lineFlags & 0x88) == 0 || (lineFlags & 0x8000000) != 0) continue;
            if (currLine == lastLine) {
                return currLine;
            }
            int endFlagToMatch = (lineFlags & 0x80) != 0 ? 128 : 8;
            for (int endSectionLine = currLine + 1; endSectionLine <= lastLine; ++endSectionLine) {
                displayFlags = this.getLineDisplayFlags(endSectionLine);
                lineFlags = this.getLineFlags(endSectionLine);
                if ((displayFlags & 0xC) != 0) {
                    currLine = endSectionLine - 1;
                    break;
                }
                if ((lineFlags & endFlagToMatch) != 0) continue;
                currLine = endSectionLine - 1;
                break;
            }
            return currLine;
        }
        if (!foundSection) {
            endOfSection = this.findEndOfPriorSection(lastLine);
        }
        if ((this.getLineFlags(endOfSection) & 0x8000000) != 0) {
            int nestedMacro = 0;
            for (int scanLine = endOfSection; scanLine > sigLine; --scanLine) {
                lineFlags = this.getLineFlags(scanLine);
                if ((lineFlags & 0x8000000) != 0) {
                    --nestedMacro;
                }
                if ((lineFlags & 0x40) == 0 || ++nestedMacro != 0) continue;
                endOfSection = this.findEndOfPriorSection(scanLine - 1);
                break;
            }
        }
        return endOfSection;
    }

    protected int findEndOfPriorSection(int startLine) {
        for (int currLine = startLine; currLine >= 0; --currLine) {
            int lineFlags = this.getLineFlags(currLine);
            if ((lineFlags & 1) != 0 && (lineFlags & 0x400) == 0 || (lineFlags & 0x200) != 0 || (lineFlags & 0x2000) != 0) continue;
            return currLine;
        }
        return 0;
    }

    @Override
    public void updateFoldInfo(ViewFoldInfo foldInfo, int startOffset, int endOffset) {
        int startLine = this.m_Doc.getLineNumberFromOffset(startOffset);
        int endLine = this.m_Doc.getLineNumberFromOffset(endOffset);
        boolean foldingChange = false;
        ClearPoint topClearPoint = new ClearPoint();
        topClearPoint.setNewFold(startLine);
        ClearPoint bottomClearPoint = new ClearPoint();
        bottomClearPoint.setNewFold(endLine);
        this.makeBlockList();
        int stopLine = 0;
        int updateRangeLine = startLine;
        while (updateRangeLine <= endLine) {
            if (this.findTopClearPoint(foldInfo, updateRangeLine, stopLine, topClearPoint)) {
                foldingChange = true;
                break;
            }
            stopLine = updateRangeLine++;
        }
        stopLine = this.m_Doc.getLineCount() - 1;
        updateRangeLine = endLine;
        while (updateRangeLine >= startLine) {
            if (this.findBottomClearPoint(foldInfo, updateRangeLine, stopLine, bottomClearPoint)) {
                foldingChange = true;
                break;
            }
            stopLine = updateRangeLine--;
        }
        if (foldingChange) {
            foldInfo.clearBlockInfo(topClearPoint.clearPoint(), bottomClearPoint.clearPoint());
            this.addFoldBlocks(foldInfo, topClearPoint.newFold(), bottomClearPoint.newFold());
        }
        this.freeBlockList();
    }

    protected boolean findTopClearPoint(ViewFoldInfo foldInfo, int startLine, int stopLine, ClearPoint cp) {
        CodeBlock oldBlock = new CodeBlock();
        CodeBlock newBlock = new CodeBlock();
        CodeBlock rcBlock = new CodeBlock();
        int scanLine = startLine;
        boolean inNewBlock = this.getBlockInfo(scanLine, newBlock);
        cp.setClearPoint(inNewBlock ? newBlock.start() : startLine);
        boolean foundDifference = false;
        while (scanLine >= stopLine) {
            inNewBlock = this.getBlockInfo(scanLine, newBlock);
            boolean inOldBlock = foldInfo.getBlockInfo(scanLine, oldBlock);
            if (inNewBlock && inOldBlock && newBlock.start() == oldBlock.start() && newBlock.end() == oldBlock.end() && newBlock.sigLine() == oldBlock.sigLine()) break;
            if (inOldBlock) {
                scanLine = oldBlock.start();
            }
            cp.setClearPoint(inOldBlock ? oldBlock.start() : scanLine);
            this.getBlockInfo(cp.clearPoint(), rcBlock);
            cp.setNewFold(rcBlock.start());
            if (inNewBlock || inOldBlock) {
                foundDifference = true;
            }
            --scanLine;
        }
        return foundDifference;
    }

    protected boolean findBottomClearPoint(ViewFoldInfo foldInfo, int startLine, int stopLine, ClearPoint cp) {
        CodeBlock oldBlock = new CodeBlock();
        CodeBlock newBlock = new CodeBlock();
        CodeBlock rcBlock = new CodeBlock();
        int scanLine = startLine;
        boolean inNewBlock = this.getBlockInfo(scanLine, newBlock);
        cp.setClearPoint(inNewBlock ? newBlock.end() : scanLine);
        boolean foundDifference = false;
        while (scanLine <= stopLine) {
            inNewBlock = this.getBlockInfo(scanLine, newBlock);
            boolean inOldBlock = foldInfo.getBlockInfo(scanLine, oldBlock);
            if (inNewBlock && inOldBlock && newBlock.start() == oldBlock.start() && newBlock.end() == oldBlock.end() && newBlock.sigLine() == oldBlock.sigLine()) break;
            if (inOldBlock) {
                scanLine = oldBlock.end();
            }
            cp.setClearPoint(inOldBlock ? oldBlock.end() : scanLine);
            if (this.getBlockInfo(cp.clearPoint(), rcBlock)) {
                cp.setNewFold(rcBlock.end());
            } else {
                cp.setNewFold(cp.clearPoint());
            }
            if (inNewBlock || inOldBlock) {
                foundDifference = true;
            }
            ++scanLine;
        }
        return foundDifference;
    }

    protected void addFoldBlocks(ViewFoldInfo foldInfo, int startNewFold, int endNewFold) {
        CodeBlock addBlock = new CodeBlock();
        int currLine = startNewFold;
        while (currLine <= endNewFold) {
            boolean lineInNewBlock = this.getBlockInfo(currLine, addBlock);
            if (!lineInNewBlock) {
                ++currLine;
                continue;
            }
            foldInfo.setFoldingBlock(addBlock);
            currLine = addBlock.end() + 1;
        }
    }

    protected boolean isBlankLine(CodeEditorDocLine line) {
        int charsToCheck = line.end() - line.start();
        boolean rc = true;
        Segment s = new Segment();
        try {
            this.m_Doc.getText(line.start(), charsToCheck, s);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        char currChar = s.first();
        for (int i = 0; i < charsToCheck; ++i) {
            if (currChar != ' ' && currChar != '\t' && currChar != '\n' && currChar != '\r') {
                rc = false;
                break;
            }
            currChar = s.next();
        }
        return rc;
    }

    protected boolean isBlankLine(int line) {
        int startOffset = this.m_Doc.getStartOffsetForLine(line);
        int charsToCheck = this.m_Doc.getLineLength(line);
        boolean rc = true;
        Segment s = new Segment();
        try {
            this.m_Doc.getText(startOffset, charsToCheck, s);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        char currChar = s.first();
        for (int i = 0; i < charsToCheck; ++i) {
            if (currChar != ' ' && currChar != '\t' && currChar != '\n' && currChar != '\r') {
                rc = false;
                break;
            }
            currChar = s.next();
        }
        return rc;
    }

    public void setDefaultProcContext(String procName) {
        this.mDefaultProcContext = procName;
        if (this.mDefaultProcContext == null) {
            this.mDefaultProcContext = "";
        }
        this.mDefaultProcContext = this.mDefaultProcContext.toLowerCase();
    }

    protected int getLineFlags(int line) {
        int flags = 0;
        SasLineTokenInfo slti = (SasLineTokenInfo)this.m_Doc.getLineTokenInfoForLine(line, false);
        if (slti != null) {
            flags = slti.getLineFlags();
        }
        return flags;
    }

    protected void setLineFlags(int line, int newFlags) {
        SasLineTokenInfo slti = (SasLineTokenInfo)this.m_Doc.getLineTokenInfoForLine(line, false);
        if (slti != null) {
            slti.setLineFlags(newFlags);
        }
    }

    protected int getLineDisplayFlags(int line) {
        int flags = 0;
        SasLineTokenInfo slti = (SasLineTokenInfo)this.m_Doc.getLineTokenInfoForLine(line, false);
        if (slti != null) {
            flags = slti.getLineDisplayFlags();
        }
        return flags;
    }

    protected void setLineDisplayFlags(int line, int newFlags) {
        SasLineTokenInfo slti = (SasLineTokenInfo)this.m_Doc.getLineTokenInfoForLine(line, false);
        if (slti != null) {
            slti.setLineDisplayFlags(newFlags);
        }
    }

    public class ClearPoint {
        protected int m_ClearPoint = -1;
        protected int m_NewFold = -1;

        public int clearPoint() {
            return this.m_ClearPoint;
        }

        public int newFold() {
            return this.m_NewFold;
        }

        public void setClearPoint(int cp) {
            this.m_ClearPoint = cp;
        }

        public void setNewFold(int nf) {
            this.m_NewFold = nf;
        }
    }
}

