/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.language.Sas;
import com.sas.editor.language.SasElements;
import com.sas.editor.language.SasKeywordInfo;
import com.sas.editor.language.SasKeywordMap;
import com.sas.editor.language.SasKeywordMgrSnapshot;
import com.sas.editor.language.StaticKeywords;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SasKeywordManager {
    protected static SasKeywordMap s_UserKeywordMap = null;
    protected static SasKeywordMap s_MacroKeywordMap = null;
    protected static SasKeywordMap s_SloughKeywordMap = null;
    protected static SasKeywordMap s_GlobalKeywordMap = null;
    private static boolean s_bKeywordsInitialized = false;
    private static int s_nInitKeywordRefCount = 0;
    protected static final String GroupName_Tag = "GroupName:";
    protected SasKeywordMap m_LookupContext;
    protected SasKeywordMap m_BaseContext;
    protected SasKeywordMap m_ProcContext;
    protected boolean m_bUseBaseContext;
    protected boolean m_bInUnknownProc;
    protected boolean m_bInMacroDefinition;
    protected boolean m_bInInteractiveProc;
    protected boolean m_bInMacroScope;
    protected boolean m_bAtEndOfSection;
    protected boolean m_bMacroCollectMode;
    protected boolean m_bForceSOS;
    protected boolean m_bJustSawPROCKeyword;
    protected boolean m_bMacroNameDefinition;
    protected short m_nStatementID;
    protected short m_fStatementFlags;
    protected SasKeywordMap m_SavedLookupContext;
    protected boolean m_bSavedUseBaseContext;
    protected SasKeywordMap m_LookupMap = null;
    protected CodeEditorDefaults defaults;
    NumericSuffix NumericSuffixString = new NumericSuffix();

    public SasKeywordManager(CodeEditorDefaults defs) {
        this.defaults = defs;
        if (!s_bKeywordsInitialized) {
            this.initKeywordMaps();
            s_bKeywordsInitialized = true;
        }
        this.UpdateKeywords();
    }

    public void SetBaseContext(SasKeywordMap Map2) {
        this.m_BaseContext = Map2;
    }

    public SasKeywordMap GetBaseContext() {
        return this.m_BaseContext;
    }

    public void SetLookupContext(SasKeywordMap Map2) {
        this.m_LookupContext = Map2;
    }

    public SasKeywordMap GetLookupContext() {
        return this.m_LookupContext;
    }

    public void SetProcContext(SasKeywordMap Map2) {
        this.m_ProcContext = Map2;
    }

    public SasKeywordMap GetProcContext() {
        return this.m_ProcContext;
    }

    public static int FindNearestPrime(int nSearchNumber) {
        return SasKeywordMap.findNearestPrime(nSearchNumber);
    }

    public void SectionEnding() {
        this.m_bAtEndOfSection = true;
    }

    public void SetInMacroDefinition(boolean bNewValue) {
        this.m_bInMacroDefinition = bNewValue;
    }

    public boolean InMacroDefinition() {
        return this.m_bInMacroDefinition;
    }

    public void SetInInteractiveProc(boolean bNewValue) {
        this.m_bInInteractiveProc = bNewValue;
    }

    public boolean InInteractiveProc() {
        return this.m_bInInteractiveProc;
    }

    public void SetMacroNameDefinition(boolean bNewValue) {
        this.m_bMacroNameDefinition = bNewValue;
    }

    public boolean MacroNameDefinition() {
        return this.m_bMacroNameDefinition;
    }

    public void SetInMacroScope(boolean bNewValue) {
        this.m_bInMacroScope = bNewValue;
    }

    public boolean InMacroScope() {
        return this.m_bInMacroScope;
    }

    public void SetMacroCollectMode(boolean bNewValue) {
        this.m_bMacroCollectMode = bNewValue;
    }

    public boolean InMacroCollectMode() {
        return this.m_bMacroCollectMode;
    }

    public String GetNumericSuffixString(String s) {
        this.HasNumericSuffix(s);
        return this.NumericSuffixString.Text;
    }

    public int GetNumericSuffixInt(String s) {
        this.HasNumericSuffix(s);
        return this.NumericSuffixString.Suffix;
    }

    protected void HasNumericSuffix(String strTokenValue) {
        int nMultiplier = 1;
        int nNumericSuffix = 0;
        boolean bNumericSuffix = false;
        for (int i = strTokenValue.length() - 1; i >= 0; --i) {
            char ch = strTokenValue.charAt(i);
            if (Character.isDigit(ch)) {
                nNumericSuffix += Character.digit(ch, 10) * nMultiplier;
                nMultiplier *= 10;
            } else {
                if (!bNumericSuffix) break;
                this.NumericSuffixString.Text = strTokenValue.substring(0, i + 1);
                this.NumericSuffixString.Suffix = nNumericSuffix;
                return;
            }
            bNumericSuffix = true;
        }
        this.NumericSuffixString.Text = "";
        this.NumericSuffixString.Suffix = -1;
    }

    public void StartMacroScope() {
        if (!this.InMacroScope()) {
            this.m_SavedLookupContext = this.m_LookupContext;
            this.SetLookupContext(s_MacroKeywordMap);
            this.m_bSavedUseBaseContext = this.m_bUseBaseContext;
            this.m_bUseBaseContext = false;
            this.SetInMacroScope(true);
        }
    }

    public void EndMacroScope() {
        if (this.InMacroScope()) {
            this.SetLookupContext(this.m_SavedLookupContext);
            this.m_bUseBaseContext = this.m_bSavedUseBaseContext;
            this.m_SavedLookupContext = null;
            this.SetInMacroScope(false);
        }
    }

    public SasKeywordMgrSnapshot TakeSnapshot(boolean bSOS, int nInMacroDefinition) {
        SasKeywordMgrSnapshot snapshot = new SasKeywordMgrSnapshot();
        snapshot.m_bSOS = bSOS;
        snapshot.m_nInMacroDefinition = nInMacroDefinition;
        snapshot.m_bInInteractiveProc = this.InInteractiveProc();
        snapshot.m_BaseContext = this.GetBaseContext();
        snapshot.m_ProcContext = this.GetProcContext();
        snapshot.m_LookupContext = !this.InMacroScope() ? this.GetLookupContext() : this.m_SavedLookupContext;
        return snapshot;
    }

    public void Reset() {
        this.Reset(null);
    }

    public void Reset(SasKeywordMgrSnapshot Snapshot) {
        this.m_bInMacroScope = false;
        this.m_bAtEndOfSection = false;
        this.m_bMacroCollectMode = false;
        this.m_bForceSOS = false;
        this.m_bJustSawPROCKeyword = false;
        this.m_bMacroNameDefinition = false;
        this.m_nStatementID = 0;
        this.m_fStatementFlags = 0;
        this.m_bInUnknownProc = false;
        this.m_bSavedUseBaseContext = false;
        this.m_SavedLookupContext = null;
        if (Snapshot == null) {
            this.SetLookupContext(s_GlobalKeywordMap);
            this.SetBaseContext(s_GlobalKeywordMap);
            this.SetProcContext(s_GlobalKeywordMap);
            this.SetInMacroDefinition(false);
            this.SetInInteractiveProc(false);
        } else {
            this.SetLookupContext(Snapshot.m_LookupContext);
            this.SetBaseContext(Snapshot.m_BaseContext);
            this.SetProcContext(Snapshot.m_ProcContext);
            this.SetInMacroDefinition(Snapshot.InMacroDefinition());
            this.SetInInteractiveProc(Snapshot.InInteractiveProc());
        }
    }

    public void DeleteKeywords(SasKeywordMap Map2) {
        if (Map2.isEmpty()) {
            return;
        }
        Map2.clear();
    }

    public SasKeywordInfo FindKeyword(String strKeyword) {
        SasKeywordInfo KeywordFound = null;
        SasKeywordMap KeywordMap = this.GetLookupContext();
        if (KeywordMap != null) {
            KeywordFound = KeywordMap.lookup(strKeyword);
        }
        if (KeywordFound == null && this.m_bUseBaseContext && (KeywordMap = this.GetBaseContext()) != null) {
            KeywordFound = KeywordMap.lookup(strKeyword);
        }
        if (KeywordFound == null) {
            KeywordFound = s_UserKeywordMap.lookup(strKeyword);
        }
        return KeywordFound;
    }

    public boolean KeywordLookup(String strKeywordLower, String strNextToken, SasKeywordInfo OutEntry, boolean bInOutSOS) {
        boolean bDoLookup;
        boolean bKeywordFound = false;
        boolean bTmpInMacroDefinition = false;
        boolean bSOS = bInOutSOS;
        SasKeywordInfo Entry2 = null;
        if (bSOS) {
            this.SetMacroCollectMode(false);
            this.m_nStatementID = 0;
            this.m_fStatementFlags = 0;
            this.m_bJustSawPROCKeyword = false;
            if (!this.InMacroScope()) {
                this.SetLookupContext(this.GetProcContext());
                this.SetBaseContext(s_GlobalKeywordMap);
                this.m_bUseBaseContext = true;
            }
        } else {
            this.m_bUseBaseContext = false;
        }
        OutEntry.m_eDisptype = 1;
        String strKeyword = strKeywordLower.toUpperCase(Locale.getDefault());
        if (bSOS && !this.InMacroScope() && strKeyword.compareTo("DATA") == 0) {
            this.SetLookupContext(s_GlobalKeywordMap);
        }
        boolean bl = bDoLookup = !this.InMacroDefinition() || this.InMacroScope();
        if (bDoLookup) {
            Entry2 = this.FindKeyword(strKeyword);
            boolean bl2 = bKeywordFound = Entry2 != null;
        }
        if (bDoLookup && !bKeywordFound && bSOS) {
            int nNumericSuffix = this.GetNumericSuffixInt(strKeyword);
            String strPrefixValue = this.GetNumericSuffixString(strKeyword);
            boolean bKeywordFoundWithoutSuffix = false;
            if (nNumericSuffix > -1) {
                Entry2 = this.FindKeyword(strPrefixValue);
                bKeywordFound = Entry2 != null;
                bKeywordFoundWithoutSuffix = bKeywordFound;
                if (bKeywordFoundWithoutSuffix && (Entry2.m_fFlags & 0x10) != 0) {
                    bKeywordFound = true;
                    if (Entry2.m_nInState == 105 || Entry2.m_nInState == 102) {
                        if (nNumericSuffix < 1 || nNumericSuffix > 10) {
                            bKeywordFound = false;
                        }
                    } else if (nNumericSuffix < 1 || nNumericSuffix > 255) {
                        bKeywordFound = false;
                    }
                }
                if (!bKeywordFound) {
                    OutEntry.m_eDisptype = (short)19;
                }
            }
        }
        if (bKeywordFound && bSOS && Entry2.m_nInState == 0 && bDoLookup) {
            SasKeywordMap CurrentContext = this.GetLookupContext();
            this.SetLookupContext(s_GlobalKeywordMap);
            Entry2 = this.FindKeyword(strKeyword);
            bKeywordFound = Entry2 != null;
            this.SetLookupContext(CurrentContext);
        }
        if (bKeywordFound) {
            if (bSOS && Entry2.m_nInState == 0) {
                bKeywordFound = false;
            } else if (!bSOS && Entry2.m_nInState == 9999) {
                bKeywordFound = false;
            }
        } else if (bSOS && !this.InMacroDefinition() && !this.m_bInUnknownProc) {
            OutEntry.m_eDisptype = (short)19;
        }
        if (bKeywordFound && (Entry2.m_fFlags & 0x200) != 0 && strNextToken.compareTo("=") != 0) {
            bKeywordFound = false;
        }
        if (bKeywordFound) {
            boolean bForceColor;
            OutEntry.Copy(Entry2);
            if (Entry2.m_subMap != null && !Entry2.m_subMap.isEmpty()) {
                this.SetBaseContext(this.GetLookupContext());
                this.SetLookupContext(Entry2.m_subMap);
            }
            short fFlags = Entry2.m_fFlags;
            if (bSOS || this.InMacroDefinition()) {
                this.m_nStatementID = Entry2.m_nInState;
                this.m_fStatementFlags = Entry2.m_fFlags;
            }
            boolean bl3 = bForceColor = (fFlags & 4) == 4;
            if ((this.m_fStatementFlags & 0x100) != 0) {
                this.m_bMacroCollectMode = true;
            }
            if (Entry2.m_panOutStateTable != null) {
                short[] panOutStateTable = Entry2.m_panOutStateTable;
                for (int si = 1; si <= panOutStateTable[0]; ++si) {
                    if (this.m_nStatementID != panOutStateTable[si]) continue;
                    bForceColor = true;
                }
            }
            if (this.m_bJustSawPROCKeyword) {
                OutEntry.m_eDisptype = (short)16;
                this.m_bJustSawPROCKeyword = false;
                this.SetBaseContext(s_GlobalKeywordMap);
                this.SetProcContext(Entry2.m_subMap);
                this.SetInInteractiveProc((Entry2.m_fFlags & 0x400) == 1024);
                this.m_bInUnknownProc = false;
            }
            if (!this.m_bJustSawPROCKeyword && bSOS && this.m_nStatementID == 103) {
                this.m_bJustSawPROCKeyword = true;
            }
            if (Entry2.m_nInState == 101 && bSOS) {
                this.SetBaseContext(s_GlobalKeywordMap);
                this.SetProcContext(Entry2.m_subMap);
                this.m_bInUnknownProc = false;
            }
            if (Entry2.m_nInState == 104) {
                this.SetLookupContext(s_GlobalKeywordMap);
                this.SetProcContext(s_GlobalKeywordMap);
                this.SetBaseContext(s_GlobalKeywordMap);
            }
            if (this.m_nStatementID == 10015) {
                bTmpInMacroDefinition = true;
            }
            if (bSOS || bForceColor || this.m_bForceSOS) {
                if (OutEntry.m_eDisptype == 1) {
                    OutEntry.m_eDisptype = Entry2.m_eDisptype;
                }
                if ((fFlags & 1) != 0) {
                    bSOS = true;
                    this.m_bForceSOS = true;
                } else {
                    bSOS = false;
                    this.m_bForceSOS = false;
                }
            }
            this.EndMacroScope();
        } else {
            bSOS = false;
            if (this.m_bJustSawPROCKeyword) {
                OutEntry.m_eDisptype = (short)16;
                this.m_bJustSawPROCKeyword = false;
                this.SetLookupContext(s_SloughKeywordMap);
                this.SetProcContext(s_SloughKeywordMap);
                this.SetBaseContext(s_GlobalKeywordMap);
                this.m_bInUnknownProc = true;
            }
            if (this.InMacroScope()) {
                OutEntry.m_eDisptype = (short)18;
                this.EndMacroScope();
            }
        }
        if ((bTmpInMacroDefinition || this.InMacroDefinition()) && OutEntry.m_eDisptype == 1) {
            OutEntry.m_eDisptype = this.m_bMacroNameDefinition ? (short)17 : (short)21;
            this.m_bMacroNameDefinition = false;
        }
        OutEntry.m_bPostKeywordSOS = bSOS;
        return bKeywordFound;
    }

    public String[] getKeywordsFromDefaults() {
        int numberOfUserKeywords = this.defaults.getPropertyInt("SasKeywordManager.numberOfUserDefinedKeywords.txt", 0);
        String[] userKeywords = new String[numberOfUserKeywords];
        for (int i = 0; i < numberOfUserKeywords; ++i) {
            userKeywords[i] = this.defaults.getPropertyString("SasKeywordManager.UserDefinedKeyword." + i + ".txt");
        }
        return userKeywords;
    }

    protected SasKeywordMap createUserKeywordMap(String[] userKeywords) {
        SasKeywordMap userMap = new SasKeywordMap(userKeywords.length);
        for (int i = 0; i < userKeywords.length; ++i) {
            String strKeyword = userKeywords[i].toUpperCase();
            SasKeywordInfo entry = new SasKeywordInfo(strKeyword, null, 23, 1000, null, 4, 0);
            userMap.add(entry);
        }
        return userMap;
    }

    public boolean UpdateKeywords() {
        String[] newUserKeywords = this.getKeywordsFromDefaults();
        SasKeywordMap newMap = this.createUserKeywordMap(newUserKeywords);
        if (newMap.isEqual(s_UserKeywordMap)) {
            return false;
        }
        this.DeleteKeywords(s_UserKeywordMap);
        s_UserKeywordMap = newMap;
        return true;
    }

    public void DeleteKeywordMaps() {
        if (s_nInitKeywordRefCount > 0 && --s_nInitKeywordRefCount == 0) {
            this.DeleteKeywords(s_SloughKeywordMap);
            this.DeleteKeywords(s_MacroKeywordMap);
            this.DeleteKeywords(s_GlobalKeywordMap);
            this.DeleteKeywords(s_UserKeywordMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initKeywordMaps() {
        HashMap<String, Group> groupMap = new HashMap<String, Group>();
        InputStream is = this.getClass().getResourceAsStream("SASKeywords.txt");
        BufferedReader reader = null;
        try {
            String line;
            InputStreamReader isr = new InputStreamReader(is, "UTF-8");
            reader = new BufferedReader(isr);
            Group currentGroup = null;
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0) continue;
                if (line.startsWith(GroupName_Tag)) {
                    String name = line.substring(10).trim();
                    currentGroup = new Group(name);
                    groupMap.put(name, currentGroup);
                    continue;
                }
                String[] lineItems = line.split(",");
                if (lineItems.length < 7) continue;
                String keyword = lineItems[0].trim();
                String subItemName = lineItems[1].trim();
                String dispType = lineItems[2].trim();
                String state = lineItems[3].trim();
                String outStateTable = lineItems[4].trim();
                String flags = lineItems[5].trim();
                String indentFlags = lineItems[6].trim();
                GroupItem item = new GroupItem(keyword);
                item.setSubItemName(subItemName);
                item.setDispType(dispType);
                item.setState(state);
                item.setOutputStateTable(outStateTable);
                item.setFlags(flags);
                item.setIndentFlags(indentFlags);
                currentGroup.mItems.add(item);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        SasKeywordMap keywordMap = null;
        Group topGroup = (Group)groupMap.get("global_kw");
        if (topGroup != null) {
            keywordMap = new SasKeywordMap(topGroup.mItems.size());
            this.fillInKeywordMap(topGroup, groupMap, keywordMap);
        }
        s_SloughKeywordMap = new SasKeywordMap(StaticKeywords.slough_kw);
        s_GlobalKeywordMap = keywordMap;
        s_MacroKeywordMap = new SasKeywordMap(StaticKeywords.macro_kw);
        String[] userKeywords = this.getKeywordsFromDefaults();
        s_UserKeywordMap = this.createUserKeywordMap(userKeywords);
    }

    private void fillInKeywordMap(Group group, Map groupMap, SasKeywordMap keywordMap) {
        for (GroupItem groupItem : group.mItems) {
            SasKeywordInfo keywordInfo = new SasKeywordInfo(groupItem.getKeyword(), null, groupItem.getDispType(), groupItem.getState(), groupItem.getOutputStateTable(), groupItem.getFlags(), groupItem.getIndentFlags());
            if (groupItem.getSubItemName() != null) {
                Group subGroup = (Group)groupMap.get(groupItem.getSubItemName());
                if (subGroup != null) {
                    SasKeywordMap subKeywordMap = new SasKeywordMap(subGroup.mItems.size());
                    this.fillInKeywordMap(subGroup, groupMap, subKeywordMap);
                    keywordInfo.setSubItemMap(subKeywordMap);
                } else {
                    System.out.println("Error - missing keyword group: " + groupItem.getSubItemName());
                }
            }
            keywordMap.add(keywordInfo);
        }
    }

    public boolean lookup(String strKeyword, String strNextKeyword, SasKeywordInfo o_kw, boolean bInSOS) {
        SasKeywordInfo kwFound = null;
        boolean bReturn = false;
        String strKeywordUpper = strKeyword.toUpperCase(Locale.getDefault());
        kwFound = s_GlobalKeywordMap.lookup(strKeywordUpper);
        if (kwFound != null) {
            bReturn = true;
            this.m_LookupMap = kwFound.m_subMap;
        }
        return bReturn;
    }

    private class NumericSuffix {
        String Text = new String();
        int Suffix = 0;
    }

    private static class Group {
        private String mName;
        private List mItems;

        public Group(String name) {
            this.mName = name;
            this.mItems = new ArrayList();
        }
    }

    private static class GroupItem {
        private String mKeyword;
        private String mSubItemName;
        private int mDispType;
        private int mState;
        private short[] mOutputStateTable;
        private int mFlags;
        private int mIndentFlags;

        public GroupItem(String keyword) {
            this.mKeyword = keyword;
            this.mDispType = -1;
            this.mSubItemName = null;
            this.mState = 0;
            this.mOutputStateTable = null;
            this.mFlags = 0;
            this.mIndentFlags = 0;
        }

        public String getKeyword() {
            return this.mKeyword;
        }

        public int getDispType() {
            return this.mDispType;
        }

        public void setDispType(String dispType) {
            Short code = (Short)SasElements.mDispMap.get(dispType);
            if (code != null) {
                this.mDispType = code.shortValue();
            } else {
                System.out.println("Error-unknown DISP type: " + dispType);
            }
        }

        public int getFlags() {
            return this.mFlags;
        }

        public void setFlags(String flagString) {
            this.mFlags = 0;
            if (flagString.equals("0")) {
                return;
            }
            String[] flags = flagString.split(" ");
            for (int i = 0; i < flags.length; ++i) {
                String flag = flags[i];
                Short code = (Short)Sas.mKeywordCodeMap.get(flag);
                if (code != null) {
                    this.mFlags |= code.shortValue();
                    continue;
                }
                System.out.println("Error - unknown code: " + flag);
            }
        }

        public int getIndentFlags() {
            return this.mIndentFlags;
        }

        public void setIndentFlags(String indentFlagsString) {
            if (indentFlagsString.equals("0")) {
                this.mIndentFlags = 0;
            } else {
                try {
                    this.mIndentFlags = Integer.parseInt(indentFlagsString);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }

        public short[] getOutputStateTable() {
            return this.mOutputStateTable;
        }

        public void setOutputStateTable(String outputStateTable) {
            if (outputStateTable.equals("null")) {
                outputStateTable = null;
            }
        }

        public int getState() {
            return this.mState;
        }

        public void setState(String stateFlags) {
            Short codeValue = (Short)Sas.mKeywordCodeMap.get(stateFlags);
            if (codeValue != null) {
                this.mState = codeValue.shortValue();
            } else if (stateFlags.equals("0")) {
                this.mState = 0;
            } else {
                System.out.println("Error - unknown state flag: " + stateFlags);
            }
        }

        public String getSubItemName() {
            return this.mSubItemName;
        }

        public void setSubItemName(String subItemName) {
            this.mSubItemName = subItemName.equals("null") ? null : subItemName;
        }
    }
}

