/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.editor.language.SasKeywordMap;
import java.util.Arrays;

public class SasKeywordInfo {
    protected String m_strKeyword;
    protected short m_eDisptype;
    protected short m_nInState;
    protected short[] m_panOutStateTable;
    protected short m_fFlags;
    protected int m_nIndentFlags;
    protected boolean m_bPostKeywordSOS;
    protected SasKeywordMap m_subMap = null;

    public SasKeywordInfo(String strKeyword, SasKeywordInfo[] subArray, int eDisptype, int nInState, short[] panOutStateTable, int fFlags, int nIndentFlags) {
        this.m_strKeyword = strKeyword;
        this.m_eDisptype = (short)eDisptype;
        this.m_nInState = (short)nInState;
        this.m_panOutStateTable = panOutStateTable;
        this.m_fFlags = (short)fFlags;
        this.m_subMap = null;
        this.m_nIndentFlags = nIndentFlags;
        this.m_bPostKeywordSOS = false;
        if (subArray != null && subArray.length > 0) {
            this.m_subMap = new SasKeywordMap(subArray);
        }
    }

    public void setSubItemMap(SasKeywordMap keywordMap) {
        this.m_subMap = keywordMap;
    }

    public SasKeywordMap getSubItemMap() {
        return this.m_subMap;
    }

    public short getFlags() {
        return this.m_fFlags;
    }

    public SasKeywordInfo() {
        this.m_strKeyword = null;
        this.m_eDisptype = (short)-1;
        this.m_nInState = 0;
        this.m_panOutStateTable = null;
        this.m_fFlags = 0;
        this.m_nIndentFlags = 0;
        this.m_bPostKeywordSOS = false;
    }

    public void Copy(SasKeywordInfo ski) {
        this.m_bPostKeywordSOS = ski.m_bPostKeywordSOS;
        this.m_eDisptype = ski.m_eDisptype;
        this.m_fFlags = ski.m_fFlags;
        this.m_nIndentFlags = ski.m_nIndentFlags;
        this.m_nInState = ski.m_nInState;
        this.m_panOutStateTable = ski.m_panOutStateTable;
        this.m_strKeyword = ski.m_strKeyword;
        this.m_subMap = ski.m_subMap;
    }

    public Object getKey() {
        return this.m_strKeyword;
    }

    public boolean isEqual(SasKeywordInfo otherInfo) {
        if (this.m_bPostKeywordSOS != otherInfo.m_bPostKeywordSOS) {
            return false;
        }
        if (this.m_eDisptype != otherInfo.m_eDisptype) {
            return false;
        }
        if (this.m_fFlags != otherInfo.m_fFlags) {
            return false;
        }
        if (this.m_nIndentFlags != otherInfo.m_nIndentFlags) {
            return false;
        }
        if (this.m_nInState != otherInfo.m_nInState) {
            return false;
        }
        if (this.m_panOutStateTable == null && otherInfo.m_panOutStateTable != null || this.m_panOutStateTable != null && otherInfo.m_panOutStateTable == null) {
            return false;
        }
        if (this.m_panOutStateTable != null && !Arrays.equals(this.m_panOutStateTable, otherInfo.m_panOutStateTable)) {
            return false;
        }
        if (!this.m_strKeyword.equals(otherInfo.m_strKeyword)) {
            return false;
        }
        if (this.m_subMap == null && otherInfo.m_subMap != null || this.m_subMap != null && otherInfo.m_subMap == null) {
            return false;
        }
        return this.m_subMap == null || this.m_subMap.isEqual(otherInfo.m_subMap);
    }
}

