/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.editor.LogListDocument;
import com.sas.editor.LogMemoryStorageConfigData;
import com.sas.editor.LogRollingFileStorageConfigDataInterface;
import com.sas.editor.LogStorageConfigDataInterface;
import com.sas.editor.language.LogMemoryRepository;
import com.sas.editor.language.LogRollingFileRepository;
import com.sas.editor.language.RepositoryChangedListener;
import com.sas.editor.language.RepositoryIndexInterface;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;

public final class LogRepository {
    private Map mListeners = new WeakHashMap();
    private RepositoryIndexInterface mDocumentIndex;
    private boolean mAlive = false;

    public LogRepository(LogStorageConfigDataInterface storageInfo) throws IOException {
        if (storageInfo instanceof LogRollingFileStorageConfigDataInterface) {
            this.mDocumentIndex = new LogRollingFileRepository((LogRollingFileStorageConfigDataInterface)storageInfo, this.mListeners);
        } else if (storageInfo instanceof LogMemoryStorageConfigData) {
            this.mDocumentIndex = new LogMemoryRepository((LogMemoryStorageConfigData)storageInfo, this.mListeners);
        }
        this.mAlive = true;
    }

    public void delete() throws IOException {
        if (this.mAlive) {
            this.mDocumentIndex.delete();
            this.mAlive = false;
        }
    }

    public LogStorageConfigDataInterface getStorageParameters() {
        return this.mDocumentIndex.getStorageInfo();
    }

    public void addListener(RepositoryChangedListener listener) {
        this.mListeners.put(listener, null);
    }

    public void removeListener(RepositoryChangedListener listener) {
        this.mListeners.remove(listener);
    }

    public long getLogCharacterCount() {
        if (!this.mAlive) {
            return 0L;
        }
        return this.mDocumentIndex.getCharLength();
    }

    protected String getText(RepositoryIndexInterface documentIndex, int lineNumber, int offsetOnLine, int length) {
        if (!this.mAlive) {
            return "";
        }
        return documentIndex.getText(lineNumber, offsetOnLine, length);
    }

    public static String generateFilePath(String directory, String prefix, String suffix, int index) {
        File logFile = new File(directory, prefix + "_" + Integer.toString(index) + "_" + suffix);
        try {
            return logFile.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public int append(String line, int lineAttrs) throws IOException {
        if (!this.mAlive) {
            return 0;
        }
        int returnIndex = line.indexOf(10);
        if (returnIndex >= 0) {
            line = line.substring(0, returnIndex);
        }
        return this.mDocumentIndex.append(line, lineAttrs);
    }

    private void updateListenersForRepositoryShift() {
        for (LogListDocument listener : this.mListeners.keySet()) {
            listener.repositoryChanged();
        }
    }

    public int getLineCount() {
        if (!this.mAlive) {
            return 0;
        }
        return this.mDocumentIndex.getSize();
    }

    public int getLineLength(int lineNumber) {
        if (!this.mAlive) {
            return 0;
        }
        long nextLineStart = 0L;
        if (this.isLastLine(lineNumber)) {
            return 0;
        }
        if (lineNumber + 1 >= this.getLineCount() - 1) {
            nextLineStart = this.mDocumentIndex.getCharLength();
        } else {
            this.mDocumentIndex.seek(lineNumber + 1);
            nextLineStart = this.mDocumentIndex.getCurrentDocOffset();
        }
        this.mDocumentIndex.seek(lineNumber);
        long length = nextLineStart - (long)this.mDocumentIndex.getCurrentDocOffset();
        if (length < 0L) {
            return 0;
        }
        return (int)length;
    }

    public short getLineType(int lineNumber) {
        if (!this.mAlive) {
            return 0;
        }
        if (this.isLastLine(lineNumber)) {
            return 0;
        }
        this.mDocumentIndex.seek(lineNumber);
        return this.mDocumentIndex.getCurrentLineType();
    }

    protected boolean isLastLine(int lineNumber) {
        return lineNumber >= this.mDocumentIndex.getSize() - 1;
    }

    public int getLineStart(int lineNumber) {
        if (!this.mAlive) {
            return 0;
        }
        if (this.isLastLine(lineNumber)) {
            return this.mDocumentIndex.getCharLength();
        }
        this.mDocumentIndex.seek(lineNumber);
        return this.mDocumentIndex.getCurrentDocOffset();
    }

    public int getLineForOffset(int offset) {
        if (!this.mAlive) {
            return 0;
        }
        if (this.mDocumentIndex.getSize() == 0) {
            return 0;
        }
        if (offset < 0) {
            return 0;
        }
        int quickCheckResult = this.mDocumentIndex.quickFindLineForOffset(offset);
        if (quickCheckResult >= 0) {
            return quickCheckResult;
        }
        int low = 0;
        int high = this.mDocumentIndex.getSize() - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            this.mDocumentIndex.seek(middle);
            int lineStartOffset = this.mDocumentIndex.getCurrentDocOffset();
            if (middle == this.mDocumentIndex.getSize() - 1 && offset >= lineStartOffset) {
                return middle;
            }
            if (lineStartOffset <= offset && lineStartOffset + this.getLineLength(middle) > offset) {
                return middle;
            }
            if (lineStartOffset > offset) {
                high = middle - 1;
                continue;
            }
            low = middle + 1;
        }
        return 0;
    }

    public int getCharLength() {
        if (!this.mAlive) {
            return 0;
        }
        return this.mDocumentIndex.getCharLength();
    }

    public String getText(int startOffset, int length) {
        if (!this.mAlive) {
            return "";
        }
        int lineNumber = this.getLineForOffset(startOffset);
        if (this.isLastLine(lineNumber)) {
            return "";
        }
        this.mDocumentIndex.seek(lineNumber);
        return this.getText(this.mDocumentIndex, lineNumber, startOffset - this.mDocumentIndex.getCurrentDocOffset(), length);
    }

    public void clear() throws IOException {
        if (!this.mAlive) {
            return;
        }
        this.mDocumentIndex.clear();
        this.updateListenersForRepositoryShift();
    }

    public void flush() throws IOException {
        if (!this.mAlive) {
            return;
        }
        this.mDocumentIndex.flush();
    }

    public void close() throws IOException {
        if (!this.mAlive) {
            return;
        }
        this.mDocumentIndex.close();
    }
}

