/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.editor.LogMemoryStorageConfigData;
import com.sas.editor.LogStorageConfigDataInterface;
import com.sas.editor.language.MyArrayList;
import com.sas.editor.language.RepositoryChangedListener;
import com.sas.editor.language.RepositoryIndexInterface;
import java.io.IOException;
import java.util.Map;

public class LogMemoryRepository
implements RepositoryIndexInterface {
    private MyArrayList mDataLines;
    private int[] mDocStartOffsets;
    private short[] mLineTypes;
    private int mUsedIndices;
    private float mGrowthFactor;
    private int mCurrentIndex;
    private int mMaxLines;
    private int mCharLength;
    private int mChunkSize;
    private Map mListeners;

    public LogMemoryRepository(LogMemoryStorageConfigData storageInfo, Map listeners) {
        this.mListeners = listeners;
        this.mGrowthFactor = 1.3f;
        this.mMaxLines = Math.max(storageInfo.getMaxLineCount(), 1);
        this.mChunkSize = Math.min(Math.max(storageInfo.getDropOffLines(), 1), this.mMaxLines);
        this.mUsedIndices = 0;
        this.allocateArrays(this.mMaxLines);
        this.mCurrentIndex = -1;
        this.mCharLength = 0;
        this.mDataLines = new MyArrayList();
    }

    @Override
    public LogStorageConfigDataInterface getStorageInfo() {
        LogMemoryStorageConfigData data = new LogMemoryStorageConfigData(this.mMaxLines, this.mChunkSize);
        return data;
    }

    private void allocateArrays(int newSize) {
        int fixedNewSize = Math.min(newSize, this.mMaxLines);
        this.mDocStartOffsets = new int[fixedNewSize];
        this.mLineTypes = new short[fixedNewSize];
    }

    @Override
    public void clear() throws IOException {
        this.mCharLength = 0;
        this.mDataLines.clear();
        this.mUsedIndices = 0;
        this.seek(this.mUsedIndices);
    }

    public void truncate(int firstLineToRemove) {
        this.mUsedIndices = firstLineToRemove;
    }

    private void removeLines(int leadingLinesToRemove) {
        if ((leadingLinesToRemove = Math.min(leadingLinesToRemove, this.mUsedIndices)) > 0) {
            System.arraycopy(this.mDocStartOffsets, leadingLinesToRemove, this.mDocStartOffsets, 0, this.mUsedIndices - leadingLinesToRemove);
            System.arraycopy(this.mLineTypes, leadingLinesToRemove, this.mLineTypes, 0, this.mUsedIndices - leadingLinesToRemove);
            this.mUsedIndices -= leadingLinesToRemove;
            this.seek(this.mCurrentIndex - leadingLinesToRemove);
        }
    }

    @Override
    public void seek(int index) {
        this.mCurrentIndex = index < 0 ? 0 : (index >= this.mUsedIndices ? this.mUsedIndices - 1 : index);
    }

    @Override
    public int getCurrentDocOffset() {
        if (this.mCurrentIndex < 0) {
            return 0;
        }
        return this.mDocStartOffsets[this.mCurrentIndex];
    }

    @Override
    public short getCurrentLineType() {
        if (this.mCurrentIndex < 0) {
            return 0;
        }
        return this.mLineTypes[this.mCurrentIndex];
    }

    @Override
    public int getSize() {
        return this.mUsedIndices + 1;
    }

    private void shiftToZero() {
        if (this.mUsedIndices == 0) {
            return;
        }
        if (this.mChunkSize > this.mUsedIndices) {
            this.mUsedIndices = 0;
            return;
        }
        int docOffsetShiftAmount = this.mDocStartOffsets[this.mChunkSize];
        if (docOffsetShiftAmount == 0) {
            return;
        }
        this.removeLines(this.mChunkSize);
        this.mCharLength -= docOffsetShiftAmount;
        for (int i = 0; i < this.mUsedIndices; ++i) {
            int docOffset = this.mDocStartOffsets[i];
            this.mDocStartOffsets[i] = docOffset -= docOffsetShiftAmount;
        }
    }

    @Override
    public int getMaxSize() {
        return this.mMaxLines;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public int getCharLength() {
        return this.mCharLength;
    }

    @Override
    public void dump() {
    }

    @Override
    public int append(String line, int lineAttrs) throws IOException {
        boolean shifted = false;
        if (this.getSize() >= this.getMaxSize()) {
            this.mDataLines.removeRange(0, this.mChunkSize);
            this.shiftToZero();
            shifted = true;
        }
        this.mDataLines.add(line);
        int oldSize = this.mLineTypes.length;
        if (this.mUsedIndices >= oldSize) {
            int newSize = (int)((float)this.mLineTypes.length * this.mGrowthFactor);
            int[] oldDocStartOffsets = this.mDocStartOffsets;
            short[] oldLineTypes = this.mLineTypes;
            this.allocateArrays(newSize);
            System.arraycopy(oldDocStartOffsets, 0, this.mDocStartOffsets, 0, oldSize);
            System.arraycopy(oldLineTypes, 0, this.mLineTypes, 0, oldSize);
        }
        this.mDocStartOffsets[this.mUsedIndices] = this.getCharLength();
        this.mLineTypes[this.mUsedIndices] = (short)lineAttrs;
        ++this.mUsedIndices;
        this.mCharLength += line.length() + 1;
        if (shifted) {
            this.updateListenersForRepositoryShift();
        }
        return line.length() + 1;
    }

    @Override
    public String getText(int lineNumber, int offsetOnLine, int length) {
        StringBuffer buffer = new StringBuffer();
        String data = "";
        if (lineNumber < this.mDataLines.size()) {
            data = (String)this.mDataLines.get(lineNumber);
        }
        int index = offsetOnLine;
        int lineIndex = lineNumber;
        int accumulatedChars = 0;
        while (accumulatedChars < length) {
            if (index < data.length()) {
                buffer.append(data.charAt(index));
                ++accumulatedChars;
                ++index;
                continue;
            }
            buffer.append('\n');
            ++accumulatedChars;
            if (++lineIndex >= this.mDataLines.size()) break;
            data = (String)this.mDataLines.get(lineIndex);
            index = 0;
        }
        return buffer.toString();
    }

    private void updateListenersForRepositoryShift() {
        for (RepositoryChangedListener listener : this.mListeners.keySet()) {
            listener.repositoryChanged();
        }
    }

    @Override
    public int quickFindLineForOffset(int offset) {
        return -1;
    }

    public void setParameters(int maxLines, int chunkSize) {
        this.mMaxLines = Math.max(maxLines, 10);
        this.mUsedIndices = 0;
        this.mCurrentIndex = -1;
        this.mCharLength = 0;
        this.mChunkSize = Math.max(chunkSize, 1);
        if (this.mDocStartOffsets.length > this.mMaxLines) {
            this.allocateArrays(this.mMaxLines);
        }
    }

    @Override
    public void delete() throws IOException {
        this.clear();
    }
}

