/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.editor.AttributeMap;
import com.sas.editor.CodeEditorAttributeManager;
import com.sas.editor.CodeEditorDocument;
import com.sas.editor.CodeEditorSchemeManager;
import com.sas.editor.LineTokenInfo;
import com.sas.editor.LogListDocument;
import com.sas.editor.SasColor;
import com.sas.editor.language.DefaultLanguageParser;
import com.sas.editor.language.SasLineTokenInfo;
import java.awt.Font;
import javax.swing.text.Element;

public class LogListLanguageParser
extends DefaultLanguageParser {
    private boolean mColoringEnabled;
    CodeEditorAttributeManager attrManager;

    public LogListLanguageParser(CodeEditorDocument doc) {
        super(doc);
        this.attrManager = new CodeEditorAttributeManager(doc.getDefaults());
        this.updateElementAttributeMap();
        this.mColoringEnabled = true;
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    protected AttributeMap getColorAttributeMap() {
        int nElements = 6;
        AttributeMap attrMap = new AttributeMap(nElements);
        attrMap.addElementAttributes((short)9, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)8, SasColor.darkGreen, SasColor.white, false, false);
        attrMap.addElementAttributes((short)7, SasColor.red, SasColor.white, false, false);
        attrMap.addElementAttributes((short)6, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)10, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)5, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)1, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)2, SasColor.blue, SasColor.white, false, false);
        attrMap.addElementAttributes((short)3, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)4, SasColor.teal, SasColor.white, false, false);
        Font f = this.attrManager.getFont(5);
        if (f == null) {
            f = CodeEditorSchemeManager.PREDEFINED_FONT;
        }
        attrMap.addFontAttributes(f);
        return attrMap;
    }

    @Override
    public void updateElementAttributeMap() {
        int langID = this.m_Doc.getLanguage().getID();
        if (!((LogListDocument)this.m_Doc).isLogListColoringEnabled()) {
            return;
        }
        this.m_AttrMap = this.attrManager.getAttributeMap(langID);
        if (this.m_AttrMap == null) {
            this.m_AttrMap = this.getColorAttributeMap();
            this.attrManager.setAttributeMap(this.m_AttrMap, langID, true);
        }
    }

    @Override
    public void color() {
    }

    @Override
    public void interactiveDelete(int nStartOffset, int nLength) {
    }

    @Override
    public LineTokenInfo createLineTokenInfoObject(Element elem) {
        return new SasLineTokenInfo(elem);
    }

    @Override
    public boolean IsDocumentColoringEnabled() {
        return this.mColoringEnabled;
    }

    @Override
    public void EnableDocumentColoring(boolean b) {
        if (b == this.mColoringEnabled) {
            return;
        }
        this.mColoringEnabled = b;
        if (!b) {
            this.setElementAttributeMap(this.getNoColorAttributeMap());
        } else {
            this.updateElementAttributeMap();
            this.setElementAttributeMap(this.m_AttrMap);
        }
    }

    protected AttributeMap getNoColorAttributeMap() {
        int nElements = 6;
        AttributeMap attrMap = new AttributeMap(nElements);
        attrMap.addElementAttributes((short)9, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)8, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)7, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)6, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)10, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)5, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)1, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)2, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)3, SasColor.black, SasColor.white, false, false);
        attrMap.addElementAttributes((short)4, SasColor.black, SasColor.white, false, false);
        Font f = this.attrManager.getFont(5);
        if (f == null) {
            f = CodeEditorSchemeManager.PREDEFINED_FONT;
        }
        attrMap.addFontAttributes(f);
        return attrMap;
    }
}

