/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.editor.AttributeMap;
import com.sas.editor.CodeEditorAttributeManager;
import com.sas.editor.CodeEditorDocument;
import com.sas.editor.CodeEditorSchemeManager;
import com.sas.editor.CodeEditorTextPosition;
import com.sas.editor.LineTokenInfo;
import com.sas.editor.SasColor;
import com.sas.editor.TokenInfo;
import com.sas.editor.TokenMap;
import com.sas.editor.TokenMapInterface;
import com.sas.editor.language.DefaultLanguageParser;
import com.sas.editor.language.HtmlLineTokenInfo;
import java.awt.Font;
import javax.swing.text.Element;
import javax.swing.text.Segment;

public class HtmlLanguageParser
extends DefaultLanguageParser {
    protected boolean m_bNoEditScan;
    protected boolean m_XMLSpecific;
    protected CodeEditorAttributeManager attrManager = new CodeEditorAttributeManager(this.m_Doc.getDefaults());
    protected boolean m_htmlComment;
    protected TokenMapInterface mNewTokenMap = null;
    public static final short HTML_COMMENT = 25;
    public static final short HTML_STRING_LITERAL = 26;
    public static final short HTML_TAG_NAME = 27;
    public static final short HTML_PARAMETER_NAME = 28;
    public static final short HTML_MISCELLANEOUS = 29;
    public static final short HTML_TAG_BOUNDARY = 30;
    public static final short HTML_META_TAG = 31;
    public static final short HTML_PARAMETER_VALUE = 32;

    public HtmlLanguageParser(CodeEditorDocument doc, boolean doXML) {
        super(doc);
        this.m_XMLSpecific = doXML;
        this.m_htmlComment = false;
        this.updateElementAttributeMap();
    }

    public HtmlLanguageParser(CodeEditorDocument doc) {
        this(doc, true);
    }

    @Override
    public void cleanup() {
        if (this.mNewTokenMap != null) {
            this.mNewTokenMap.cleanup();
        }
        super.cleanup();
    }

    @Override
    public void updateElementAttributeMap() {
        this.m_AttrMap = this.attrManager.getAttributeMap(3);
        if (this.m_AttrMap == null) {
            this.initAttributes();
            this.attrManager.setAttributeMap(this.m_AttrMap, 3, true);
        }
    }

    public void initAttributes() {
        int nElements = 8;
        this.m_AttrMap = new AttributeMap(nElements);
        this.m_AttrMap.addElementAttributes((short)25, SasColor.green, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)26, SasColor.red, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)27, SasColor.blue, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)28, SasColor.purple, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)29, SasColor.black, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)30, SasColor.black, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)31, SasColor.purple, SasColor.white, false, false);
        this.m_AttrMap.addElementAttributes((short)32, SasColor.cyan, SasColor.white, false, false);
        Font f = this.attrManager.getFont(3);
        if (f == null) {
            f = CodeEditorSchemeManager.PREDEFINED_FONT;
        }
        this.m_AttrMap.addFontAttributes(f);
    }

    @Override
    public void interactiveInsert(int changeStartOffset, int changeLength) {
        if (this.m_Doc.isEmpty()) {
            this.m_Doc.getTokenMap().clear();
            return;
        }
        if (this.m_Doc.getTokenMap().getRangeCount() == 0) {
            this.color();
            return;
        }
        try {
            this.m_Doc.getTokenMap().shiftPositionsForInsert(changeStartOffset, changeLength);
            int colorStart = this.findPreviousSpotOutsideTag(changeStartOffset);
            int colorEnd = this.m_Doc.getNextLineStartOffset(changeStartOffset + changeLength);
            this.color(colorStart, colorEnd - colorStart);
        }
        catch (Exception e) {
            this.color();
        }
    }

    @Override
    public void interactiveDelete(int changeStartOffset, int changeLength) {
        if (this.m_Doc.isEmpty()) {
            this.m_Doc.getTokenMap().clear();
            return;
        }
        if (this.m_Doc.getTokenMap().getRangeCount() == 0) {
            this.color();
            return;
        }
        try {
            this.m_Doc.getTokenMap().shiftPositionsForDelete(changeStartOffset, changeStartOffset + changeLength);
            int colorStart = this.findPreviousSpotOutsideTag(changeStartOffset);
            int colorEnd = this.m_Doc.getNextLineStartOffset(changeStartOffset);
            this.color(colorStart, colorEnd - colorStart);
        }
        catch (Exception e) {
            this.color();
        }
    }

    @Override
    public void color() {
        int colorEnd = this.m_Doc.getLength();
        this.EditScan(0, colorEnd);
        this.m_Doc.getTokenMap().patchRanges(this.mNewTokenMap);
        this.mNewTokenMap = null;
        this.m_Doc.syntaxColorUpdate(0, colorEnd);
    }

    @Override
    public void color(int offset, int length) {
        TokenInfo info = this.m_Doc.getTokenMap().getTokenInfo(offset);
        int colorStart = 0;
        colorStart = info == null ? this.m_Doc.getLength() : info.getStartOffset();
        info = this.m_Doc.getTokenMap().getTokenInfo(offset + length);
        int colorEnd = 0;
        colorEnd = info == null ? this.m_Doc.getLength() : info.getEndOffset();
        colorEnd = this.EditScan(colorStart, colorEnd);
        this.m_Doc.getTokenMap().patchRanges(this.mNewTokenMap);
        this.mNewTokenMap = null;
        this.m_Doc.syntaxColorUpdate(colorStart, colorEnd);
    }

    @Override
    public boolean IsDocumentColoringEnabled() {
        return !this.m_bNoEditScan;
    }

    @Override
    public void EnableDocumentColoring(boolean b) {
        if (this.m_bNoEditScan != b) {
            return;
        }
        this.m_bNoEditScan = !b;
        boolean isMyLock = this.m_Doc.RequestLock();
        if (this.m_bNoEditScan) {
            TokenMapInterface tokenMap = this.m_Doc.getTokenMap();
            tokenMap.clear();
            TokenInfo tokenInfo = new TokenInfo(0, this.m_Doc.getLength(), 29, null);
            tokenMap.append(tokenInfo, false);
        } else {
            this.color();
        }
        if (isMyLock) {
            this.m_Doc.ReleaseLock();
        }
    }

    public int lineOf(int offset) {
        return this.m_Doc.getLineNumberFromOffset(offset);
    }

    @Override
    public boolean isCharacterLiteralType(int offset) {
        short type = this.getTokenTypeForOffset(offset);
        return type == 26;
    }

    @Override
    public boolean isCommentType(int offset) {
        short type = this.getTokenTypeForOffset(offset);
        return type == 25;
    }

    @Override
    public boolean isCodeType(int offset) {
        short type = this.getTokenTypeForOffset(offset);
        return type == 27 || type == 29 || type == 30 || type == 28 || type == 32 || type == 31;
    }

    protected short getTokenTypeForOffset(int offset) {
        if (offset < 0 || offset > this.m_Doc.getLength()) {
            return 0;
        }
        TokenInfo tok = this.m_Doc.getTokenMap().getTokenInfo(offset);
        if (tok == null) {
            return 0;
        }
        return tok.getTokenType();
    }

    @Override
    public boolean isReservedWordType(int offset) {
        return false;
    }

    @Override
    public boolean isLineCommentType(int offset) {
        return false;
    }

    public int EditScan(int startOffset, int endOffset) {
        this.mNewTokenMap = new TokenMap(this.m_Doc);
        CodeEditorTextPosition currentPos = new CodeEditorTextPosition();
        CodeEditorTextPosition prevPos = new CodeEditorTextPosition();
        int documentEnd = this.m_Doc.getLength();
        int searchEndBoundary = endOffset;
        boolean insideTag = false;
        boolean okayToQuit = false;
        boolean atStartOfTag = false;
        boolean equalsSeen = false;
        CodeEditorTextPosition foundPos = new CodeEditorTextPosition();
        CodeEditorTextPosition tempPos = new CodeEditorTextPosition();
        char cc = ' ';
        Segment textSeg = new Segment();
        int lineLength = 0;
        if (this.m_bNoEditScan) {
            return startOffset;
        }
        currentPos.mLine = this.lineOf(startOffset) + 1;
        Element rootElement = this.m_Doc.getDefaultRootElement();
        Element lineElement = rootElement.getElement(currentPos.mLine - 1);
        currentPos.mColumn = startOffset - lineElement.getStartOffset() + 1;
        prevPos.copyFrom(currentPos);
        while (!(currentPos.mLine > this.m_Doc.getLineCount() || this.m_Doc.getOffset(currentPos) >= searchEndBoundary && okayToQuit || this.m_Doc.getOffset(currentPos) >= documentEnd)) {
            lineElement = rootElement.getElement(currentPos.mLine - 1);
            lineLength = lineElement.getEndOffset() - lineElement.getStartOffset() - 1;
            try {
                this.m_Doc.getText(lineElement.getStartOffset(), lineLength, textSeg);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            while (!(okayToQuit && this.m_Doc.getOffset(currentPos) >= searchEndBoundary || currentPos.mColumn > lineLength)) {
                boolean crossesLineBoundary;
                cc = textSeg.array[textSeg.getBeginIndex() + currentPos.mColumn - 1];
                if (insideTag && (cc == '\"' || cc == '\'')) {
                    if (prevPos.lessThan(currentPos)) {
                        okayToQuit = this.ColorToken(searchEndBoundary, this.m_Doc.getOffset(prevPos), this.m_Doc.getOffset(currentPos), (short)29);
                    }
                    equalsSeen = false;
                    CodeEditorTextPosition stringEndPos = new CodeEditorTextPosition();
                    int savedCurrentPos = this.m_Doc.getOffset(currentPos);
                    ++currentPos.mColumn;
                    this.findEndOfString(cc, currentPos, stringEndPos);
                    okayToQuit = this.ColorToken(searchEndBoundary, savedCurrentPos, this.m_Doc.getOffset(stringEndPos), (short)26);
                    crossesLineBoundary = currentPos.mLine != stringEndPos.mLine;
                    currentPos.copyFrom(stringEndPos);
                    prevPos.copyFrom(stringEndPos);
                    if (!crossesLineBoundary) continue;
                    lineElement = rootElement.getElement(currentPos.mLine - 1);
                    lineLength = lineElement.getEndOffset() - lineElement.getStartOffset() - 1;
                    try {
                        this.m_Doc.getText(lineElement.getStartOffset(), lineLength, textSeg);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (this.m_Doc.getOffset(currentPos) <= searchEndBoundary || !okayToQuit) continue;
                    break;
                }
                if (cc == '<') {
                    if (prevPos.lessThan(currentPos)) {
                        okayToQuit = this.ColorToken(searchEndBoundary, this.m_Doc.getOffset(prevPos), this.m_Doc.getOffset(currentPos), (short)29);
                        prevPos.copyFrom(currentPos);
                    }
                    if (currentPos.mColumn + 3 <= lineLength && textSeg.array[textSeg.getBeginIndex() + currentPos.mColumn] == '!' && textSeg.array[textSeg.getBeginIndex() + currentPos.mColumn + 1] == '-' && textSeg.array[textSeg.getBeginIndex() + currentPos.mColumn + 2] == '-') {
                        tempPos.copyFrom(currentPos);
                        tempPos.mColumn += 4;
                        this.findXMLCommentEnd(tempPos, foundPos);
                        okayToQuit = this.ColorToken(searchEndBoundary, this.m_Doc.getOffset(currentPos), this.m_Doc.getOffset(foundPos), (short)25);
                        boolean crossesLineBoundary2 = currentPos.mLine != foundPos.mLine;
                        currentPos.copyFrom(foundPos);
                        prevPos.copyFrom(foundPos);
                        if (!crossesLineBoundary2) continue;
                        lineElement = rootElement.getElement(currentPos.mLine - 1);
                        lineLength = lineElement.getEndOffset() - lineElement.getStartOffset() - 1;
                        try {
                            this.m_Doc.getText(lineElement.getStartOffset(), lineLength, textSeg);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (this.m_Doc.getOffset(currentPos) <= searchEndBoundary || !okayToQuit) continue;
                        break;
                    }
                    if (currentPos.mColumn + 1 < lineLength && (textSeg.array[textSeg.getBeginIndex() + currentPos.mColumn] == '!' || this.m_XMLSpecific && textSeg.array[textSeg.getBeginIndex() + currentPos.mColumn] == '?')) {
                        tempPos.copyFrom(currentPos);
                        tempPos.mColumn += 2;
                        boolean htmlComment = false;
                        this.findMetaTagEnd(tempPos, foundPos);
                        htmlComment = this.m_htmlComment;
                        short rangeType = 31;
                        if (htmlComment) {
                            rangeType = 25;
                        }
                        okayToQuit = this.ColorToken(searchEndBoundary, this.m_Doc.getOffset(currentPos), this.m_Doc.getOffset(foundPos), rangeType);
                        crossesLineBoundary = currentPos.mLine != foundPos.mLine;
                        currentPos.copyFrom(foundPos);
                        prevPos.copyFrom(foundPos);
                        if (!crossesLineBoundary) continue;
                        lineElement = rootElement.getElement(currentPos.mLine - 1);
                        lineLength = lineElement.getEndOffset() - lineElement.getStartOffset() - 1;
                        try {
                            this.m_Doc.getText(lineElement.getStartOffset(), lineLength, textSeg);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (this.m_Doc.getOffset(currentPos) <= searchEndBoundary || !okayToQuit) continue;
                        break;
                    }
                    tempPos.copyFrom(currentPos);
                    insideTag = true;
                    atStartOfTag = true;
                    equalsSeen = false;
                    ++currentPos.mColumn;
                    if (currentPos.mColumn < lineLength && textSeg.array[textSeg.getBeginIndex() + currentPos.mColumn - 1] == '/') {
                        ++currentPos.mColumn;
                    }
                    okayToQuit = this.ColorToken(searchEndBoundary, this.m_Doc.getOffset(tempPos), this.m_Doc.getOffset(currentPos), (short)30);
                    prevPos.copyFrom(currentPos);
                    continue;
                }
                if (cc == '>') {
                    if (prevPos.lessThan(currentPos)) {
                        okayToQuit = this.ColorToken(searchEndBoundary, this.m_Doc.getOffset(prevPos), this.m_Doc.getOffset(currentPos), (short)29);
                    }
                    tempPos.copyFrom(currentPos);
                    ++currentPos.mColumn;
                    okayToQuit = this.ColorToken(searchEndBoundary, this.m_Doc.getOffset(tempPos), this.m_Doc.getOffset(currentPos), (short)30);
                    prevPos.copyFrom(currentPos);
                    insideTag = false;
                    equalsSeen = false;
                    continue;
                }
                if (this.m_XMLSpecific && (cc == '/' || cc == '%') && currentPos.mColumn < lineLength && textSeg.array[textSeg.getBeginIndex() + currentPos.mColumn] == '>') {
                    if (prevPos.lessThan(currentPos)) {
                        okayToQuit = this.ColorToken(searchEndBoundary, this.m_Doc.getOffset(prevPos), this.m_Doc.getOffset(currentPos), (short)29);
                    }
                    tempPos.copyFrom(currentPos);
                    insideTag = false;
                    equalsSeen = false;
                    currentPos.mColumn += 2;
                    okayToQuit = this.ColorToken(searchEndBoundary, this.m_Doc.getOffset(tempPos), this.m_Doc.getOffset(currentPos), (short)30);
                    prevPos.copyFrom(currentPos);
                    continue;
                }
                if (cc == '=' && insideTag) {
                    equalsSeen = true;
                    ++currentPos.mColumn;
                    if (currentPos.mColumn <= lineLength) continue;
                    break;
                }
                if (cc == '!' && insideTag) {
                    ++currentPos.mColumn;
                    if (currentPos.mColumn <= lineLength) continue;
                    break;
                }
                if (insideTag && this.isIdentifierChar(cc)) {
                    if (prevPos.lessThan(currentPos)) {
                        okayToQuit = this.ColorToken(searchEndBoundary, this.m_Doc.getOffset(prevPos), this.m_Doc.getOffset(currentPos), (short)29);
                    }
                    char currentChar = textSeg.array[textSeg.getBeginIndex() + currentPos.mColumn - 1];
                    int column = currentPos.mColumn;
                    while (this.isIdentifierChar(currentChar) && ++column <= lineLength) {
                        currentChar = textSeg.array[textSeg.getBeginIndex() + column - 1];
                    }
                    short rangeType = 0;
                    if (atStartOfTag) {
                        rangeType = 27;
                        atStartOfTag = false;
                    } else if (!equalsSeen) {
                        rangeType = 28;
                    } else {
                        equalsSeen = false;
                        rangeType = 32;
                    }
                    tempPos.mLine = currentPos.mLine;
                    tempPos.mColumn = column;
                    okayToQuit = this.ColorToken(searchEndBoundary, this.m_Doc.getOffset(currentPos), this.m_Doc.getOffset(tempPos), rangeType);
                    prevPos.copyFrom(tempPos);
                    currentPos.copyFrom(tempPos);
                    continue;
                }
                ++currentPos.mColumn;
            }
            if (this.m_Doc.getOffset(currentPos) >= searchEndBoundary && okayToQuit) break;
            ++currentPos.mLine;
            currentPos.mColumn = 1;
        }
        if (currentPos.mLine > this.m_Doc.getLineCount() || this.m_Doc.getOffset(currentPos) > this.m_Doc.getLength()) {
            this.m_Doc.getDocumentEnd(currentPos);
        }
        if (prevPos.lessThan(currentPos)) {
            okayToQuit = this.ColorToken(searchEndBoundary, this.m_Doc.getOffset(prevPos), this.m_Doc.getOffset(currentPos), (short)29);
        }
        return this.m_Doc.getOffset(currentPos);
    }

    protected boolean ColorToken(int colorStopOffset, int startOffset, int endOffset, short tokenType) {
        TokenInfo newToken = new TokenInfo(startOffset, endOffset, tokenType, null);
        if (endOffset >= colorStopOffset && this.m_Doc.getTokenMap().containsRange(newToken)) {
            return true;
        }
        this.mNewTokenMap.append(newToken, false);
        return false;
    }

    protected boolean isIdentifierChar(char character) {
        return Character.isLetterOrDigit(character) || character == '-' || character == '\'' || character == '.' || character == '_';
    }

    protected boolean findEndOfString(char stringChar, CodeEditorTextPosition startPos, CodeEditorTextPosition foundPos) {
        Segment textSeg = new Segment();
        Element rootElement = this.m_Doc.getDefaultRootElement();
        int maxLine = this.m_Doc.getLineCount();
        int column = startPos.mColumn;
        int lineLength = 0;
        for (int line = startPos.mLine; line <= maxLine; ++line) {
            try {
                Element currentElement = rootElement.getElement(line - 1);
                lineLength = currentElement.getEndOffset() - currentElement.getStartOffset() - 1;
                this.m_Doc.getText(currentElement.getStartOffset(), lineLength, textSeg);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
            while (column <= lineLength) {
                if (textSeg.array[textSeg.getBeginIndex() + column - 1] == stringChar) {
                    foundPos.mLine = line;
                    foundPos.mColumn = column + 1;
                    return true;
                }
                if (textSeg.array[textSeg.getBeginIndex() + column - 1] == '>' && !this.m_XMLSpecific) {
                    foundPos.mLine = line;
                    foundPos.mColumn = column;
                    return true;
                }
                ++column;
            }
            column = 1;
        }
        this.m_Doc.getDocumentEnd(foundPos);
        return false;
    }

    protected boolean findXMLCommentEnd(CodeEditorTextPosition pos, CodeEditorTextPosition foundPos) {
        Segment textSeg = new Segment();
        Element rootElement = this.m_Doc.getDefaultRootElement();
        int maxLine = this.m_Doc.getLineCount();
        int column = pos.mColumn;
        int lineLength = 0;
        for (int line = pos.mLine; line <= maxLine; ++line) {
            try {
                Element currentElement = rootElement.getElement(line - 1);
                lineLength = currentElement.getEndOffset() - currentElement.getStartOffset() - 1;
                this.m_Doc.getText(currentElement.getStartOffset(), lineLength, textSeg);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.m_Doc.getDocumentEnd(foundPos);
                return false;
            }
            while (column + 1 < lineLength) {
                if (textSeg.array[textSeg.getBeginIndex() + column - 1] == '-' && textSeg.array[textSeg.getBeginIndex() + column] == '-' && textSeg.array[textSeg.getBeginIndex() + column + 1] == '>') {
                    foundPos.mLine = line;
                    foundPos.mColumn = column + 3;
                    return true;
                }
                ++column;
            }
            column = 1;
        }
        this.m_Doc.getDocumentEnd(foundPos);
        return false;
    }

    public boolean findMetaTagEnd(CodeEditorTextPosition pos, CodeEditorTextPosition foundPos) {
        this.m_htmlComment = false;
        Segment textSeg = new Segment();
        Element rootElement = this.m_Doc.getDefaultRootElement();
        int maxLine = this.m_Doc.getLineCount();
        int column = pos.mColumn;
        int lineLength = 0;
        for (int line = pos.mLine; line <= maxLine; ++line) {
            try {
                Element currentElement = rootElement.getElement(line - 1);
                lineLength = currentElement.getEndOffset() - currentElement.getStartOffset() - 1;
                this.m_Doc.getText(currentElement.getStartOffset(), lineLength, textSeg);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
            while (column <= lineLength) {
                if (textSeg.array[textSeg.getBeginIndex() + column - 1] == '>') {
                    foundPos.mLine = line;
                    foundPos.mColumn = column + 1;
                    return true;
                }
                if (!this.m_htmlComment && textSeg.array[textSeg.getBeginIndex() + column - 1] == '-' && textSeg.array[textSeg.getBeginIndex() + column] == '-') {
                    this.m_htmlComment = true;
                }
                ++column;
            }
            column = 1;
        }
        this.m_Doc.getDocumentEnd(foundPos);
        return false;
    }

    protected int findPreviousSpotOutsideTag(int startOffset) {
        boolean atStart;
        int newOffset;
        String docText = "";
        try {
            docText = this.m_Doc.getText(0, startOffset);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int firstTagStart = docText.lastIndexOf(60);
        int firstTagClose = docText.lastIndexOf(62);
        if (firstTagStart > firstTagClose) {
            newOffset = firstTagStart;
            atStart = true;
        } else {
            newOffset = firstTagClose;
            atStart = false;
        }
        if (newOffset < 0) {
            newOffset = 0;
        }
        if (this.areWeSittingOnTag(newOffset)) {
            if (atStart) {
                return newOffset;
            }
            return newOffset + 1;
        }
        if (newOffset == 0) {
            return 0;
        }
        return this.findPreviousSpotOutsideTag(newOffset - 1);
    }

    protected boolean areWeSittingOnTag(int offset) {
        TokenInfo ti = this.m_Doc.getTokenInfo(offset);
        if (ti == null) {
            return false;
        }
        short type = ti.getTokenType();
        return type == 31 || type == 30;
    }

    @Override
    public LineTokenInfo createLineTokenInfoObject(Element elem) {
        return new HtmlLineTokenInfo(elem);
    }
}

