/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import com.sas.editor.AttributeMap;
import com.sas.editor.ICodeDocument;
import com.sas.editor.LineTokenInfo;
import com.sas.editor.language.ILanguageParser;
import com.sas.editor.language.SpecialStringReader;
import com.sas.editor.language.ViewFoldInfo;
import java.awt.Color;
import java.io.StreamTokenizer;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class DefaultLanguageParser
implements ILanguageParser {
    protected AttributeMap m_AttrMap = null;
    protected ICodeDocument m_Doc;

    public DefaultLanguageParser(ICodeDocument doc) {
        this.m_Doc = doc;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void color() {
        Color[] c = new Color[]{Color.red, Color.green, Color.blue};
        int colorIndex = -1;
        int tokType = -4;
        SpecialStringReader sr = null;
        try {
            sr = new SpecialStringReader(this.m_Doc.getText(0, this.m_Doc.getLength()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        StreamTokenizer tokenizer = new StreamTokenizer(sr);
        tokenizer.slashSlashComments(true);
        while (tokType != -1) {
            int tokOffset = sr.getCurrentOffset();
            try {
                tokType = tokenizer.nextToken();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            int tokLength = sr.getCurrentOffset() - tokOffset;
            colorIndex = tokLength % 3;
            SimpleAttributeSet attributes = new SimpleAttributeSet();
            StyleConstants.setForeground(attributes, c[colorIndex]);
        }
    }

    @Override
    public void color(int nStartOffset, int nLength) {
        this.color();
    }

    @Override
    public void interactiveInsert(int nStartOffset, int nLength) {
        this.color();
    }

    @Override
    public void interactiveDelete(int nStartOffset, int nLength) {
        this.color();
    }

    @Override
    public boolean isCommentType(Element e) {
        return false;
    }

    @Override
    public boolean isCommentType(int offset) {
        return false;
    }

    @Override
    public boolean isCharacterLiteralType(Element e) {
        return false;
    }

    @Override
    public boolean isCharacterLiteralType(int offset) {
        return false;
    }

    @Override
    public boolean isCodeType(Element e) {
        return true;
    }

    @Override
    public boolean isCodeType(int offset) {
        return true;
    }

    @Override
    public boolean isReservedWordType(Element e) {
        return false;
    }

    @Override
    public boolean isReservedWordType(int offset) {
        return false;
    }

    @Override
    public boolean isLineCommentType(Element e) {
        return false;
    }

    @Override
    public boolean isLineCommentType(int offset) {
        return false;
    }

    @Override
    public boolean intersectsComment(int nStartOffset, int nLength) {
        return false;
    }

    @Override
    public boolean intersectsCharacterLiteral(int nStartOffset, int nLength) {
        return false;
    }

    @Override
    public boolean intersectsCode(int nStartOffset, int nLength) {
        return false;
    }

    @Override
    public void updateKeywords() {
    }

    @Override
    public void EnableDocumentColoring(boolean b) {
    }

    @Override
    public boolean IsDocumentColoringEnabled() {
        return true;
    }

    @Override
    public LineTokenInfo createLineTokenInfoObject(Element elem) {
        return new LineTokenInfo(elem, -1);
    }

    @Override
    public AttributeMap getElementAttributeMap() {
        return this.m_AttrMap;
    }

    @Override
    public void setElementAttributeMap(AttributeMap map) {
        this.m_AttrMap = map;
    }

    @Override
    public void updateElementAttributeMap() {
    }

    @Override
    public void updateFoldInfo(ViewFoldInfo foldInfo, int startOffset, int endOffset) {
    }
}

