/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.language;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    private byte[] mBuffer;
    private int mBytesInBuffer;
    protected long mDeferredSeekPos;

    public BufferedRandomAccessFile(String name, String mode, int bufferSize) throws FileNotFoundException {
        super(name, mode);
        this.init(bufferSize);
    }

    public BufferedRandomAccessFile(File file, String mode, int bufferSize) throws FileNotFoundException {
        super(file, mode);
        this.init(bufferSize);
    }

    private void init(int bufferSize) {
        bufferSize = Math.max(bufferSize, 2);
        this.mBuffer = new byte[bufferSize];
        this.mBytesInBuffer = 0;
        this.mDeferredSeekPos = -1L;
    }

    private void flush() throws IOException {
        if (this.mBytesInBuffer > 0) {
            super.write(this.mBuffer, 0, this.mBytesInBuffer);
            this.mBytesInBuffer = 0;
        }
        if (this.mDeferredSeekPos >= 0L) {
            super.seek(this.mDeferredSeekPos);
            this.mDeferredSeekPos = -1L;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    @Override
    public long getFilePointer() throws IOException {
        if (this.mDeferredSeekPos >= 0L) {
            return this.mDeferredSeekPos;
        }
        long filePointer = super.getFilePointer();
        return filePointer + (long)this.mBytesInBuffer;
    }

    @Override
    public long length() throws IOException {
        return Math.max(super.length(), super.getFilePointer() + (long)this.mBytesInBuffer);
    }

    @Override
    public int read() throws IOException {
        this.flush();
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.flush();
        return super.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.flush();
        return super.read(b);
    }

    @Override
    public void seek(long pos) throws IOException {
        this.mDeferredSeekPos = pos;
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.flush();
        super.setLength(newLength);
        if (this.mDeferredSeekPos > newLength) {
            this.mDeferredSeekPos = newLength;
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.flush();
        return super.skipBytes(n);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.mDeferredSeekPos != super.getFilePointer() + (long)this.mBytesInBuffer) {
            this.flush();
        }
        if (len > this.mBuffer.length) {
            this.flush();
            super.write(b, off, len);
        } else if (len + this.mBytesInBuffer > this.mBuffer.length) {
            this.flush();
            super.write(b, off, len);
        } else {
            System.arraycopy(b, off, this.mBuffer, this.mBytesInBuffer, len);
            this.mBytesInBuffer += len;
            if (this.mDeferredSeekPos >= 0L) {
                this.mDeferredSeekPos += (long)len;
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.mDeferredSeekPos != super.getFilePointer() + (long)this.mBytesInBuffer) {
            this.flush();
        }
        if (this.mBytesInBuffer + 1 > this.mBuffer.length) {
            this.flush();
        }
        this.mBuffer[this.mBytesInBuffer] = (byte)b;
        ++this.mBytesInBuffer;
        if (this.mDeferredSeekPos >= 0L) {
            ++this.mDeferredSeekPos;
        }
    }
}

