/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.border;

import com.sas.editor.border.BorderManager;
import com.sas.editor.border.CodeEditorLineBasedBorderPane;
import com.sas.editor.language.ViewFoldInfo;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class FoldingPane
extends CodeEditorLineBasedBorderPane {
    protected int m_FontHeight;
    protected ViewFoldInfo m_FoldInfo;

    public FoldingPane(BorderManager mgr, int width, Color bg) {
        super(mgr, width, bg);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        this.m_FoldInfo = this.m_Mgr.getEditorPane().getViewFoldInfo();
        this.m_FontHeight = this.m_Mgr.getEditorFontMetrics().getHeight();
        this.clearBackground(g);
        int[] visibleLines = this.getVisibleLines();
        if (visibleLines == null) {
            return;
        }
        int[] lineRange = new int[2];
        Rectangle clipRect = g.getClipBounds();
        this.getScreenLinesAffected(clipRect, lineRange);
        Rectangle clientRect = this.m_Mgr.getScrollPane().getRowHeader().getViewRect();
        g.translate(clientRect.x, clientRect.y);
        for (int screenLine = lineRange[0]; screenLine <= lineRange[1]; ++screenLine) {
            if (screenLine >= visibleLines.length) {
                return;
            }
            int lineNumber = visibleLines[screenLine];
            boolean start = this.m_FoldInfo.isStartLine(lineNumber);
            boolean end = this.m_FoldInfo.isEndLine(lineNumber);
            boolean block = this.m_FoldInfo.isBlockLine(lineNumber);
            boolean sig = this.m_FoldInfo.isSignatureLine(lineNumber);
            boolean collapsed = this.m_FoldInfo.isLineCollapsed(lineNumber);
            this.getRectForRangeOfScreenLines(screenLine, screenLine, clipRect);
            if (!collapsed && (start || end || block)) {
                this.drawStartEndLine(g, start, end, clipRect);
            }
            if (!sig) continue;
            this.drawSignatureBox(g, collapsed, clipRect);
        }
        g.setColor(oldColor);
    }

    @Override
    public void drawLine(int x, Rectangle y, Graphics g) {
    }

    protected int getBaseLine(int line) {
        Rectangle viewRect = this.m_Mgr.getScrollPane().getViewport().getViewRect();
        FontMetrics metrics = this.m_Mgr.getEditorFontMetrics();
        int fontHeight = metrics.getHeight();
        int ascent = metrics.getAscent();
        int linesAbove = Math.max(0, viewRect.y / fontHeight);
        int firstLineNumber = linesAbove + 1;
        int baseline = linesAbove * fontHeight + ascent - viewRect.y;
        for (int i = firstLineNumber; i < line; ++i) {
            baseline += fontHeight;
        }
        return baseline;
    }

    protected void drawSignatureBox(Graphics g, boolean collapsed, Rectangle clipRect) {
        if (!this.m_Mgr.getEditorPane().getCodeFolding()) {
            return;
        }
        Color origColor = g.getColor();
        Rectangle markerRect = new Rectangle();
        this.getMarkerRectOfClipArea(clipRect, markerRect);
        g.setColor(Color.white);
        g.fillRect(markerRect.x, markerRect.y, markerRect.width, markerRect.height);
        g.setColor(Color.gray);
        g.drawRect(markerRect.x, markerRect.y, markerRect.width, markerRect.height);
        g.setColor(Color.black);
        int INSET = 2;
        int centerY = markerRect.y + markerRect.height / 2;
        g.drawLine(markerRect.x + INSET, centerY, markerRect.x + markerRect.width - INSET, centerY);
        if (collapsed) {
            int centerX = markerRect.x + markerRect.width / 2;
            g.drawLine(centerX, markerRect.y + INSET, centerX, markerRect.y + markerRect.height - INSET);
        }
        g.setColor(origColor);
    }

    protected void drawStartEndLine(Graphics g, boolean isStart, boolean isEnd, Rectangle clipRect) {
        if (!this.m_Mgr.getEditorPane().getCodeFolding() || !this.m_Mgr.getEditorPane().getShowSectionBrackets()) {
            return;
        }
        Rectangle markerRect = new Rectangle();
        this.getMarkerRectOfClipArea(clipRect, markerRect);
        int centerX = markerRect.x + markerRect.width / 2;
        int CONTAINLINE_INSET = 2;
        int lineTop = clipRect.y;
        int lineBottom = clipRect.y + this.m_FontHeight;
        if (isStart) {
            lineTop += CONTAINLINE_INSET;
        }
        if (isEnd) {
            lineBottom -= CONTAINLINE_INSET;
        }
        g.setColor(Color.gray);
        g.drawLine(centerX, lineTop, centerX, lineBottom);
        if (isStart) {
            g.drawLine(centerX, lineTop, clipRect.x + clipRect.width, lineTop);
        }
        if (isEnd) {
            g.drawLine(centerX, lineBottom, clipRect.x + clipRect.width, lineBottom);
        }
    }

    protected void drawBlockLine(Graphics g, Rectangle clipRect) {
        if (!this.m_Mgr.getEditorPane().getCodeFolding() || !this.m_Mgr.getEditorPane().getShowSectionBrackets()) {
            return;
        }
        Rectangle markerRect = new Rectangle();
        this.getMarkerRectOfClipArea(clipRect, markerRect);
        int centerX = markerRect.x + markerRect.width / 2;
        g.setColor(Color.gray);
        g.drawLine(centerX, clipRect.y, centerX, clipRect.y + clipRect.height);
    }

    public boolean checkSignatureBlock(Point p) {
        int index;
        int offset = this.m_Mgr.getBorderWidth() - this.getWidth();
        int line = this.m_Mgr.getLineForMousePos(p);
        ViewFoldInfo vfi = this.m_Mgr.getEditorPane().getViewFoldInfo();
        int count = vfi.getTopLevelLineCount();
        int firstVisibleLine = vfi.getFirstTopLevelLine();
        int[] topLevelLines = vfi.getTopLevelLines(firstVisibleLine, count);
        for (index = 0; index < topLevelLines.length && topLevelLines[index] != line; ++index) {
        }
        int fontHeight = this.m_Mgr.getEditorFontMetrics().getHeight();
        int baseline = this.getBaseLine(index + 1);
        int boxHeight = baseline - fontHeight / 2;
        p.x -= offset;
        Rectangle rect = new Rectangle(-1, boxHeight + 1, 12, 12);
        boolean b = rect.contains(p);
        return b;
    }

    public void doCollapseExpand(int line) {
        ViewFoldInfo vfi = this.m_Mgr.getEditorPane().getViewFoldInfo();
        if (vfi.isLineCollapsed(line)) {
            vfi.expand(line);
        } else {
            vfi.collapse(line);
        }
        this.repaint();
    }

    void getMarkerRectOfClipArea(Rectangle clipRect, Rectangle markerRect) {
        int size = this.m_FontHeight < this.getWidth() ? this.m_FontHeight : clipRect.width;
        if ((size = size * 2 / 3) % 2 == 1) {
            --size;
        }
        int startX = clipRect.x + (this.getWidth() - size) / 2;
        int startY = clipRect.y + (this.m_FontHeight - size) / 2;
        markerRect.x = startX;
        markerRect.y = startY;
        markerRect.width = size;
        markerRect.height = size;
    }
}

