/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor.border;

import com.sas.editor.CodeEditorPane;
import com.sas.editor.border.CodeBorderPanel;
import com.sas.editor.border.CodeEditorBorderPane;
import com.sas.editor.border.FlatMarginPane;
import com.sas.editor.border.FoldingPane;
import com.sas.editor.border.LineNumberPane;
import com.sas.editor.language.ViewFoldInfo;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BorderManager
implements MouseMotionListener,
MouseListener,
DocumentListener,
CaretListener {
    public static final int BORDER_LINENUMBERS = 1;
    public static final int BORDER_DECORATION = 2;
    public static final int BORDER_CODEFOLDING = 3;
    private static final int LINENUMBER_MIN_DIGITS = 3;
    private static final int LINENUMBER_MARGIN = 3;
    private static final int DECORATION_PANE_WIDTH = 10;
    private static final int CODEFOLDING_PANE_WIDTH = 15;
    private static final int EDITOR_RIGHT_MARGIN = 3;
    private CodeEditorPane m_EditPane;
    private JScrollPane m_ScrollPane;
    private Color m_BorderColor;
    private Color m_MarginColor;
    private boolean m_LineNumbers;
    private boolean m_LogListLineNumbers = true;
    private int m_LineNumberDigits;
    private int m_LineNumberMargin;
    private int m_CodeFoldingWidth;
    private boolean m_CodeFolding;
    private int m_MarginWidth;
    private int m_DecorationWidth;
    private LineNumberPane m_LineNumberBorder;
    private FoldingPane m_CodeFoldingBorder;
    private FlatMarginPane m_MarginBorder;
    private boolean m_LineSelectionInProcess = false;
    private CodeBorderPanel mLeftBorderContainer;
    private CodeEditorBorderPane m_DecorationBorder;
    private Timer mTimer;
    private TimerTask mTimerTask;

    public BorderManager(CodeEditorPane editPane, JScrollPane scrollPane) {
        this.m_EditPane = editPane;
        this.m_ScrollPane = scrollPane;
        this.m_BorderColor = SystemColor.control;
        this.m_MarginColor = SystemColor.window;
        this.m_LineNumbers = false;
        this.m_CodeFolding = false;
        this.m_MarginWidth = 3;
        this.m_DecorationWidth = 10;
        this.m_LineNumberDigits = 0;
        this.m_LineNumberMargin = 3;
        this.m_ScrollPane.addMouseListener(this);
        this.m_ScrollPane.addMouseMotionListener(this);
        this.m_EditPane.getDocument().addDocumentListener(this);
        this.m_EditPane.addCaretListener(this);
        this.mTimer = null;
        this.mTimerTask = null;
    }

    public void cleanup() {
        if (this.mLeftBorderContainer != null) {
            this.mLeftBorderContainer.cleanup();
        }
        if (this.m_EditPane != null) {
            this.m_EditPane.getDocument().removeDocumentListener(this);
            this.m_EditPane.removeCaretListener(this);
        }
        if (this.m_ScrollPane != null) {
            this.m_ScrollPane.removeMouseListener(this);
            this.m_ScrollPane.removeMouseMotionListener(this);
        }
    }

    public void createBorder() {
        this.mLeftBorderContainer = new CodeBorderPanel(this.m_ScrollPane);
        FlowLayout fl = new FlowLayout();
        fl.setHgap(0);
        fl.setVgap(0);
        this.mLeftBorderContainer.setLayout(fl);
        this.m_DecorationWidth = !(this.m_LineNumbers && this.m_LogListLineNumbers || this.m_CodeFolding) ? (int)(10.0 * 1.5) : 10;
        this.mLeftBorderContainer.setBackground(this.m_BorderColor);
        if (this.m_LineNumbers && this.m_LogListLineNumbers) {
            int width = this.computeLineNumbersWidth();
            this.m_LineNumberBorder = new LineNumberPane(this, this.m_LineNumberDigits, width + this.m_LineNumberMargin, Color.black, this.m_BorderColor);
            this.m_LineNumberBorder.setLeftMargin(this.m_LineNumberMargin);
            this.mLeftBorderContainer.add(this.m_LineNumberBorder);
            this.mLeftBorderContainer.addComponentListener(this.m_LineNumberBorder);
            this.m_LineNumberBorder.setSize(this.m_LineNumberBorder.getWidth(), this.mLeftBorderContainer.getHeight());
        }
        this.m_DecorationBorder = new CodeEditorBorderPane(this, this.m_DecorationWidth, this.m_BorderColor);
        this.mLeftBorderContainer.add(this.m_DecorationBorder);
        if (this.m_CodeFolding) {
            this.m_CodeFoldingWidth = 15;
            this.m_CodeFoldingBorder = new FoldingPane(this, this.m_CodeFoldingWidth, this.m_BorderColor);
            this.mLeftBorderContainer.add(this.m_CodeFoldingBorder);
            this.mLeftBorderContainer.addComponentListener(this.m_CodeFoldingBorder);
            this.m_CodeFoldingBorder.setSize(this.m_CodeFoldingBorder.getWidth(), this.mLeftBorderContainer.getHeight());
        }
        this.m_MarginBorder = new FlatMarginPane(this, this.m_MarginWidth, this.m_MarginColor);
        this.mLeftBorderContainer.add(this.m_MarginBorder);
        this.mLeftBorderContainer.addComponentListener(this.m_MarginBorder);
        this.m_MarginBorder.setSize(this.m_MarginBorder.getWidth(), this.mLeftBorderContainer.getHeight());
        this.m_ScrollPane.setRowHeaderView(this.mLeftBorderContainer);
        this.m_EditPane.revalidate();
        this.repaintBorder();
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.m_BorderColor = backgroundColor;
        if (this.m_CodeFoldingBorder != null) {
            this.m_CodeFoldingBorder.setBackground(backgroundColor);
        }
        if (this.m_LineNumberBorder != null) {
            this.m_LineNumberBorder.setBackground(backgroundColor);
        }
        if (this.m_DecorationBorder != null) {
            this.m_DecorationBorder.setBackground(backgroundColor);
        }
        this.createBorder();
    }

    public void setLineNumbers(boolean bOnOff) {
        this.updateLineNumberBorder(bOnOff);
    }

    public void setLogListLineNumbers(boolean bOnOff) {
        this.m_LogListLineNumbers = bOnOff;
        this.createBorder();
    }

    public void setCodeFolding(boolean bOnOff) {
        if (this.m_CodeFolding == bOnOff) {
            return;
        }
        this.m_CodeFolding = bOnOff;
        this.createBorder();
    }

    public boolean isLineNumbers() {
        return this.m_LineNumbers;
    }

    public boolean usePreviousCaretLine() {
        return this.m_EditPane.checkLineSelect();
    }

    public FontMetrics getEditorFontMetrics() {
        return this.m_EditPane.getFontMetrics(this.m_EditPane.getFont());
    }

    public JScrollPane getScrollPane() {
        return this.m_ScrollPane;
    }

    public CodeEditorPane getEditorPane() {
        return this.m_EditPane;
    }

    public int getLineBorderWidth() {
        return this.m_LineNumberBorder.getWidth();
    }

    public int getBorderWidth() {
        int width = this.mLeftBorderContainer.getWidth();
        return width;
    }

    protected synchronized void updateLineNumberBorder(boolean bOnOff) {
        if (!bOnOff) {
            if (this.m_LineNumbers) {
                this.m_LineNumbers = false;
                this.createBorder();
            }
            return;
        }
        boolean bChange = bOnOff != this.m_LineNumbers;
        int newDigits = this.computeLineNumberBorderDigits();
        if (!bChange) {
            boolean bl = bChange = newDigits != this.m_LineNumberDigits;
        }
        if (bChange) {
            this.m_LineNumbers = bOnOff;
            this.m_LineNumberDigits = newDigits;
            this.createBorder();
        }
    }

    protected int computeLineNumberBorderDigits() {
        try {
            int docLines = this.m_EditPane.getLineCount();
            int nDigits = 0;
            while (docLines > 0) {
                docLines /= 10;
                ++nDigits;
            }
            if (nDigits <= 3) {
                nDigits = 3;
            }
            return nDigits;
        }
        catch (NullPointerException e) {
            return 3;
        }
    }

    protected int computeLineNumbersWidth() {
        if (this.m_LineNumberDigits <= 0) {
            return 0;
        }
        char[] str = new char[this.m_LineNumberDigits];
        for (int i = 0; i < this.m_LineNumberDigits; ++i) {
            str[i] = 57;
        }
        FontMetrics metrics = this.getEditorFontMetrics();
        return metrics.charsWidth(str, 0, this.m_LineNumberDigits);
    }

    public void repaintBorder() {
        try {
            this.m_ScrollPane.repaint(this.mLeftBorderContainer.getX(), this.mLeftBorderContainer.getY(), this.mLeftBorderContainer.getWidth(), this.mLeftBorderContainer.getHeight());
        }
        catch (Exception e) {
            this.m_ScrollPane.repaint();
        }
    }

    protected int getCaretLine() {
        return this.m_EditPane.getCaretLine() + 1;
    }

    protected int getLineForMousePos(Point p) {
        Rectangle viewRect = this.getViewportRect();
        int docY = viewRect.y + (int)p.getY();
        Point adjP = new Point((int)p.getX(), docY);
        int offset = this.getEditorPane().getUI().viewToModel(this.getEditorPane(), adjP);
        int line = this.getEditorPane().getCodeEditorDocument().getLineForOffset(offset);
        return line;
    }

    protected Rectangle getViewportRect() {
        return this.getScrollPane().getViewport().getViewRect();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int docLine;
        if ((e.getModifiers() & 0x10) == 0) {
            return;
        }
        int x = e.getX();
        if (x > this.getBorderWidth()) {
            return;
        }
        ViewFoldInfo vfi = this.getEditorPane().getViewFoldInfo();
        if (vfi.isSignatureLine(docLine = this.getLineForMousePos(e.getPoint())) && this.m_CodeFoldingBorder.checkSignatureBlock(e.getPoint())) {
            this.m_CodeFoldingBorder.doCollapseExpand(docLine);
            return;
        }
        this.m_LineSelectionInProcess = true;
        docLine = this.getLineForMousePos(e.getPoint());
        this.m_EditPane.borderSelectLine(e, docLine);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.m_LineSelectionInProcess) {
            this.m_LineSelectionInProcess = false;
            this.m_EditPane.borderMouseReleased(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.m_LineSelectionInProcess) {
            return;
        }
        Rectangle viewRect = this.getViewportRect();
        int x = e.getX();
        int paneY = e.getY() + viewRect.y;
        if (x <= this.getBorderWidth()) {
            int paneX = 0;
            MouseEvent eAdj = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), paneX, paneY, e.getClickCount(), e.isPopupTrigger());
            int docLine = this.getLineForMousePos(e.getPoint());
            this.m_EditPane.extendLineSelection(eAdj, docLine);
        } else if ((double)x <= (double)this.getBorderWidth() + viewRect.getWidth()) {
            int paneX = e.getX() - this.getBorderWidth();
            MouseEvent eAdj = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), paneX, paneY, e.getClickCount(), e.isPopupTrigger());
            this.m_EditPane.extendSelection(eAdj);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateLineNumberPaneWidth();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateLineNumberPaneWidth();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void updateLineNumberPaneWidth() {
        if (this.m_LineNumbers) {
            if (this.mTimer == null) {
                this.mTimer = new Timer();
            }
            if (this.mTimerTask != null) {
                this.mTimerTask.cancel();
            }
            this.mTimerTask = new TimerTask(){

                @Override
                public void run() {
                    BorderManager.this.updateLineNumberBorder(BorderManager.this.m_LineNumbers);
                }
            };
            this.mTimer.schedule(this.mTimerTask, 250L);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.m_LineNumberBorder != null) {
            this.m_LineNumberBorder.cachePaintInfo();
            int xPos = this.m_LineNumberBorder.getX();
            int yPos = Math.abs(this.mLeftBorderContainer.getY());
            this.m_LineNumberBorder.repaint(0L, xPos, yPos, 1, 1);
        }
    }
}

