/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.LogListDocument;
import com.sas.editor.TokenInfo;
import com.sas.editor.TokenMapInterface;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import javax.swing.text.Element;

class VirtualLogListTokenMap
implements TokenMapInterface {
    private LogListDocument mDoc;
    private int mCurrentLine;

    public VirtualLogListTokenMap(LogListDocument doc) {
        this.mDoc = doc;
        this.mCurrentLine = 0;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void clear() {
    }

    @Override
    public void removeLast() {
    }

    @Override
    public int getRangeCount() {
        return this.mDoc.getLineCount();
    }

    @Override
    public void patchRanges(TokenMapInterface newRanges) {
    }

    @Override
    public TokenInfo getCurrent() {
        return this.getTokenInfoForLine(this.mCurrentLine);
    }

    private TokenInfo getTokenInfoForLine(int line) {
        Element element = this.mDoc.getElement(line);
        if (element == null) {
            return null;
        }
        LineType lt = LineType.from_int(this.mDoc.getLineType(line));
        int dispType = 0;
        dispType = lt == LineType.LineTypeByline ? 3 : (lt == LineType.LineTypeFootnote ? 4 : (lt == LineType.LineTypeHilighted ? 2 : (lt == LineType.LineTypeNormal ? 1 : (lt == LineType.LineTypeSource ? 6 : (lt == LineType.LineTypeTitle ? 5 : (lt == LineType.LineTypeError ? 7 : (lt == LineType.LineTypeWarning ? 8 : (lt == LineType.LineTypeNote ? 9 : (lt == LineType.LineTypeMessage ? 10 : 6)))))))));
        TokenInfo tokenInfo = new TokenInfo(element.getStartOffset(), element.getEndOffset(), (short)dispType, null);
        return tokenInfo;
    }

    @Override
    public TokenInfo seekEnd() {
        this.mCurrentLine = this.getRangeCount() - 1;
        return this.getTokenInfoForLine(this.mCurrentLine);
    }

    @Override
    public TokenInfo seekStart() {
        this.mCurrentLine = 0;
        return this.getTokenInfoForLine(this.mCurrentLine);
    }

    @Override
    public TokenInfo seek(int offset) {
        int line;
        this.mCurrentLine = line = this.mDoc.getLineForOffset(offset);
        return this.getTokenInfoForLine(this.mCurrentLine);
    }

    @Override
    public TokenInfo next() {
        ++this.mCurrentLine;
        return this.getTokenInfoForLine(this.mCurrentLine);
    }

    @Override
    public TokenInfo previous() {
        --this.mCurrentLine;
        return this.getTokenInfoForLine(this.mCurrentLine);
    }

    @Override
    public TokenInfo getTokenInfo(int offset) {
        int line = this.mDoc.getLineForOffset(offset);
        return this.getTokenInfoForLine(line);
    }

    @Override
    public void append(TokenInfo info, boolean mergeIfPossible) {
    }

    @Override
    public boolean containsRange(TokenInfo testToken) {
        return false;
    }

    @Override
    public boolean validate(boolean completenessCheck) {
        return true;
    }

    @Override
    public void shiftPositionsForInsert(int insertStart, int insertLength) {
    }

    @Override
    public void shiftPositionsForDelete(int deleteStart, int deleteEnd) {
    }

    @Override
    public void dump() {
    }

    @Override
    public boolean isCurrentValid() {
        return this.mCurrentLine >= 0 && this.mCurrentLine < this.mDoc.getLineCount();
    }
}

