/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;

class VirtualLogElement
implements Element {
    private int mStartOffset;
    private int mEndOffset;
    private Document mDocument;
    private int mLineIndex;
    private String mLineData;
    private int mCachedLineWidth;

    public VirtualLogElement(Document doc, int lineIndex, int startOffset, int endOffset) {
        this.mStartOffset = startOffset;
        this.mEndOffset = endOffset;
        this.mDocument = doc;
        this.mLineIndex = lineIndex;
        this.mLineData = null;
        this.mCachedLineWidth = -1;
    }

    @Override
    public int getElementCount() {
        return 0;
    }

    @Override
    public int getEndOffset() {
        return this.mEndOffset;
    }

    @Override
    public int getStartOffset() {
        return this.mStartOffset;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public int getElementIndex(int arg0) {
        return 0;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public AttributeSet getAttributes() {
        return null;
    }

    @Override
    public Document getDocument() {
        return this.mDocument;
    }

    @Override
    public Element getParentElement() {
        return null;
    }

    @Override
    public Element getElement(int arg0) {
        return null;
    }

    public int getLineIndex() {
        return this.mLineIndex;
    }

    void setLineIndex(int lineIndex) {
        if (this.mStartOffset < 0 && this.mEndOffset < 0) {
            this.mLineIndex = lineIndex;
        }
    }

    public String getLineData() {
        return this.mLineData;
    }

    public void setLineData(String lineData) {
        this.mLineData = lineData;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.mLineIndex);
        buffer.append(": ");
        buffer.append(this.mStartOffset);
        buffer.append('-');
        buffer.append(this.mEndOffset);
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualLogElement) {
            return this.getLineIndex() == ((VirtualLogElement)obj).getLineIndex();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getLineIndex();
    }

    int getLineWidth() {
        return this.mCachedLineWidth;
    }

    void setLineWidth(int cachedLineWidth) {
        this.mCachedLineWidth = cachedLineWidth;
    }

    void setEndOffset(int endOffset) {
        this.mEndOffset = endOffset;
    }

    void setStartOffset(int startOffset) {
        this.mStartOffset = startOffset;
    }
}

