/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

public class TokenInfo {
    protected int m_StartOffset;
    protected short m_TokenType;
    protected Object m_UserData;
    protected int m_EndOffset;

    public TokenInfo(int startOffset, int endOffset, short type, Object userData) {
        this.setStartOffset(startOffset);
        this.setEndOffset(endOffset);
        this.setTokenType(type);
        this.setUserData(userData);
    }

    public boolean canMerge(TokenInfo mergeCandidate) {
        return this.m_TokenType == mergeCandidate.m_TokenType;
    }

    public boolean equals(TokenInfo otherToken) {
        return otherToken.m_EndOffset == this.m_EndOffset && otherToken.m_StartOffset == this.m_StartOffset && otherToken.m_TokenType == this.m_TokenType;
    }

    public final void setInfo(int startOffset, int endOffset, short tokenType, Object userData) {
        this.setStartOffset(startOffset);
        this.setEndOffset(endOffset);
        this.setTokenType(tokenType);
        this.setUserData(userData);
    }

    public final void setEqualTo(TokenInfo source) {
        this.setStartOffset(source.getStartOffset());
        this.setEndOffset(source.getEndOffset());
        this.setTokenType(source.getTokenType());
        this.setUserData(source.getUserData());
    }

    public final void setStartOffset(int newOffset) {
        this.m_StartOffset = newOffset;
    }

    public final int getStartOffset() {
        return this.m_StartOffset;
    }

    public final void setEndOffset(int newOffset) {
        this.m_EndOffset = newOffset;
    }

    public final int getEndOffset() {
        return this.m_EndOffset;
    }

    public final void setTokenType(short newType) {
        this.m_TokenType = newType;
    }

    public final short getTokenType() {
        return this.m_TokenType;
    }

    public final void setUserData(Object newUserData) {
        this.m_UserData = newUserData;
    }

    public final Object getUserData() {
        return this.m_UserData;
    }

    public final Object clone() {
        return new TokenInfo(this.m_StartOffset, this.m_EndOffset, this.m_TokenType, this.m_UserData);
    }
}

