/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.MRUListNode;

public class MRUList {
    private MRUListNode mHead = null;
    private MRUListNode mTail = null;
    private int mElementCount = 0;

    public MRUListNode prepend(Object userData) {
        MRUListNode firstNode = new MRUListNode(userData);
        firstNode.setPrev(this.mHead);
        if (this.mHead != null) {
            this.mHead.setNext(firstNode);
        }
        this.mHead = firstNode;
        if (this.mTail == null) {
            this.mTail = firstNode;
        }
        ++this.mElementCount;
        return firstNode;
    }

    public MRUListNode removeLast() {
        if (this.mTail != null) {
            MRUListNode lastNode = this.mTail;
            this.mTail = this.mTail.getNext();
            this.mTail.setPrev(null);
            lastNode.setNext(null);
            --this.mElementCount;
            return lastNode;
        }
        return null;
    }

    public int size() {
        return this.mElementCount;
    }

    public void clear() {
        this.mElementCount = 0;
        this.mHead = null;
        this.mTail = null;
    }

    public void dump() {
        for (MRUListNode node = this.mHead; node != null; node = node.getPrev()) {
            node.dump();
        }
    }
}

