/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditor;
import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorDocument;
import com.sas.editor.CodeLanguage;
import com.sas.editor.LogListDocument;
import com.sas.editor.LogListHolder;
import com.sas.editor.LogListPreview;
import java.awt.Frame;
import javax.swing.text.Document;

public class LogListViewer
extends CodeEditor {
    public static final int LOG = 1;
    public static final int LST = 2;

    public LogListViewer(Frame frame, int logOrLst, LogListHolder logData) {
        this(logOrLst, logData, new CodeEditorDefaults());
    }

    public LogListViewer(Frame frame, int logOrLst, LogListHolder logData, CodeEditorDefaults defs) {
        this(logOrLst, logData, defs);
    }

    public LogListViewer(int logOrLst, LogListHolder logData, CodeEditorDefaults defaults) {
        super(defaults);
        this.initialize(logOrLst, logData);
    }

    private void initialize(int logOrLst, LogListHolder logData) {
        CodeLanguage lang = logOrLst == 5 || logOrLst == 1 ? CodeLanguage.LOG : CodeLanguage.LIST;
        LogListDocument doc = new LogListDocument(lang, this.m_Defaults);
        CodeEditorDocument oldoc = this.getEditorPane().getCodeEditorDocument();
        this.getEditorPane().setDocument(doc);
        if (!(this instanceof LogListPreview)) {
            oldoc.cleanup();
        }
        oldoc = null;
        if (logData != null) {
            doc.setContents(logData.getLineArray(), logData.getCarriageControl(), logData.getLineTypes());
        }
        this.getEditorPane().setReadOnly(true);
        this.getEditorPane().getBorderManager().insertUpdate(null);
        this.getEditorPane().moveCaretToEndOfDocument();
    }

    public void append(LogListHolder logData) {
        LogListDocument doc = (LogListDocument)this.getEditorPane().getDocument();
        int currentLine = this.getEditorPane().getCaretLine();
        boolean onLastLine = currentLine == doc.getLineCount() - 1;
        int currentLength = doc.getLength();
        int currentOffset = this.getEditorPane().getCaretPosition();
        try {
            int charsAdded = doc.insertTextAttributeBased(0, logData.getLineArray(), logData.getCarriageControl(), logData.getLineTypes());
            if (onLastLine) {
                this.getEditorPane().moveCaretToEndOfDocument();
            } else {
                int charsDeleted = currentLength + charsAdded - doc.getLength();
                if (charsDeleted != 0) {
                    this.getEditorPane().setCaretPosition(Math.max(0, currentOffset - charsDeleted));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setReadOnly(boolean bReadOnly) {
    }

    public void EnableLogListColoring(boolean b) {
        Document doc = this.getEditorPane().getDocument();
        if (doc instanceof LogListDocument) {
            ((LogListDocument)doc).EnableLogListColoring(b);
        }
    }

    public void setLogListLineNumbers(boolean b) {
        this.getEditorPane().setLogListLineNumbers(b);
    }

    @Override
    public void setLanguage(CodeLanguage language) {
        if (language == CodeLanguage.LOG || language == CodeLanguage.LIST) {
            this.m_EditPane.setLanguage(language);
        }
    }
}

