/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorView;
import com.sas.editor.LogListDocument;
import com.sas.editor.LongLineListener;
import com.sas.editor.VirtualLogElement;
import java.awt.Font;
import java.awt.Shape;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Element;
import javax.swing.text.ViewFactory;

public class LogListView
extends CodeEditorView
implements LongLineListener {
    private Timer mLongLineTimer;
    private TimerTask mUpdateScrollbarTask;

    public LogListView(Element elem) {
        super(elem);
        ((LogListDocument)this.getDocument()).addLongLineListener(this);
        this.mLongLineTimer = new Timer();
        this.mUpdateScrollbarTask = null;
    }

    private synchronized void updateHorizontalScrollbar() {
        if (this.mUpdateScrollbarTask != null) {
            this.mUpdateScrollbarTask.cancel();
        }
        this.mUpdateScrollbarTask = new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Element oldLongestLine = LogListView.this.longLine;
                        LogListView.this.calculateLongestLine();
                        if (oldLongestLine.getStartOffset() != LogListView.this.longLine.getStartOffset()) {
                            LogListView.this.preferenceChanged(null, true, false);
                            LogListView.this.getContainer().repaint();
                        }
                    }
                });
            }
        };
        this.mLongLineTimer.schedule(this.mUpdateScrollbarTask, 400L);
    }

    @Override
    protected Element getElement(int index) {
        LogListDocument doc = (LogListDocument)this.getDocument();
        return doc.getElement(index);
    }

    @Override
    protected void calculateLongestLine() {
        LogListDocument doc = (LogListDocument)this.getDocument();
        this.longLine = doc.getLongestLineInCache(this);
        if (this.longLine == null) {
            this.longLine = doc.getElement(0);
        }
    }

    @Override
    protected int getLineWidth(Element line) {
        VirtualLogElement element;
        int width;
        if (line instanceof VirtualLogElement && (width = (element = (VirtualLogElement)line).getLineWidth()) >= 0) {
            return width;
        }
        return super.getLineWidth(line);
    }

    @Override
    protected void updateMetrics() {
        Font f = this.baseFont;
        int cachedTabSize = this.tabSize;
        super.updateMetrics();
        if (this.baseFont != f || this.tabSize != cachedTabSize) {
            LogListDocument doc = (LogListDocument)this.getDocument();
            doc.removeLineWidthCaching();
        }
    }

    @Override
    protected void updateDamage(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateMetrics();
        ((CodeEditorPane)this.getContainer()).getBorderManager().insertUpdate(null);
        this.preferenceChanged(this, true, true);
        ((CodeEditorPane)this.getContainer()).getScrollPane().getRowHeader().invalidate();
        this.getContainer().invalidate();
        this.getContainer().repaint();
    }

    @Override
    public void lineAdded(int lineNumber) {
        this.updateHorizontalScrollbar();
    }

    @Override
    public void linesRemoved() {
        this.longLine = ((LogListDocument)this.getDocument()).getElement(0);
        this.updateHorizontalScrollbar();
    }
}

