/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorResource;
import com.sas.editor.language.ViewFoldInfo;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class GoToLineDialog
extends JDialog
implements KeyEventDispatcher {
    protected JTextField LineField = new JTextField();
    protected JLabel GoToLineStatic = new JLabel();
    protected JButton OKButton = new JButton();
    protected JButton CancelButton = new JButton();
    protected CodeEditorPane m_EditorPane;
    protected CodeEditorResource resource;
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public static GoToLineDialog CreateDialog(CodeEditorPane sourcePane) {
        Component parent = sourcePane.getParentFrameOrDialog();
        if (parent instanceof Frame) {
            return new GoToLineDialog((Frame)parent, sourcePane);
        }
        if (parent instanceof Dialog) {
            return new GoToLineDialog((Dialog)parent, sourcePane);
        }
        return null;
    }

    private GoToLineDialog(Frame f, CodeEditorPane pane) {
        super(f);
        this.initialize(pane);
    }

    private GoToLineDialog(Dialog dlg, CodeEditorPane pane) {
        super(dlg);
        this.initialize(pane);
    }

    private void initialize(CodeEditorPane pane) {
        this.resource = new CodeEditorResource(GoToLineDialog.class);
        this.m_EditorPane = pane;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String item = this.resource.getString("GoToLineDialog.GetLineNumberLabel.txt");
        String text = Util.getLabelWithoutMnemonic((String)item);
        this.GoToLineStatic.setText(text);
        int index = Util.getDisplayedMnemonicIndex((String)item);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)item);
            this.GoToLineStatic.setDisplayedMnemonic(mnemonic);
            this.GoToLineStatic.setDisplayedMnemonicIndex(index);
        }
        this.GoToLineStatic.setLabelFor(this.LineField);
        this.OKButton.setText(this.resource.getString("Common.OK.txt"));
        this.CancelButton.setText(this.resource.getString("Common.Cancel.txt"));
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.setResizable(false);
        this.getContentPane().add((Component)this.LineField, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 10, 9, 9), 200, 0));
        this.getContentPane().add((Component)this.OKButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 15, 1, new Insets(10, 10, 2, 10), 30, 0));
        this.getContentPane().add((Component)this.CancelButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(2, 10, 8, 10), 30, 0));
        this.getContentPane().add((Component)this.GoToLineStatic, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 1, new Insets(10, 10, 1, 31), 200, 0));
        this.setTitle(this.resource.getString("GoToLineDialog.Title.txt"));
        this.setModal(true);
        this.setSize(350, 100);
        this.setLocationRelativeTo(this.m_EditorPane);
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GoToLineDialog.this.OnGoToLine();
            }
        });
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GoToLineDialog.this.OnClose();
            }
        });
        this.LineField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GoToLineDialog.this.OnGoToLine();
            }
        });
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
                GoToLineDialog.this.onActivate();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                GoToLineDialog.this.OnClose();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getID() != 402) {
            return false;
        }
        if (e.getKeyCode() == 27 && this.isActive()) {
            this.OnClose();
            return true;
        }
        return false;
    }

    public void OnClose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.dispose();
    }

    public void onActivate() {
        this.LineField.selectAll();
    }

    public void setText(int i) {
        this.LineField.setText(String.valueOf(i + 1));
    }

    public void OnGoToLine() {
        String line = this.LineField.getText();
        int lineNumber = 1;
        int offset = 1;
        try {
            NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
            Number n = nf.parse(line);
            lineNumber = n.intValue();
        }
        catch (Exception ex) {
            String msg = this.resource.getString("GoToLineDialog.GetIntegerError.txt");
            Object[] options = new Object[]{this.resource.getString("Common.OK.txt")};
            JOptionPane.showOptionDialog(null, msg, this.resource.getString("Common.CodeEditor.txt"), -1, 2, null, options, options[0]);
            this.LineField.selectAll();
            return;
        }
        if (--lineNumber >= 0 && lineNumber <= this.m_EditorPane.getCodeEditorDocument().getLineCount() && (offset = this.m_EditorPane.getCodeEditorDocument().getStartOffsetForLine(lineNumber)) >= 0) {
            ViewFoldInfo vfi = this.m_EditorPane.getViewFoldInfo();
            if (!vfi.isTopLevelLine(lineNumber)) {
                vfi.expand(lineNumber);
            }
            this.m_EditorPane.setCaretPosition(offset);
        }
        this.OnClose();
    }
}

