/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import java.io.Serializable;
import java.util.AbstractList;

public class GapList
extends AbstractList
implements Cloneable,
Serializable {
    static final long serialVersionUID = 836832229016709409L;
    private Object[] data;
    private int count;
    private int gapPosition;
    private int increment;
    private static final Object EMPTY_VALUE = null;

    private void fillData(int start, int end, Object o) {
        for (int i = start; i < end; ++i) {
            this.data[i] = o;
        }
    }

    private Object internalGet(int i) {
        if (i >= this.gapPosition) {
            return this.data[i + this.gapSize()];
        }
        return this.data[i];
    }

    private final void internalSet(int i, Object o) {
        if (i >= this.gapPosition) {
            this.data[i + this.gapSize()] = o;
        } else {
            this.data[i] = o;
        }
    }

    private final int gapSize() {
        return this.data.length - this.size();
    }

    private int computeNewCapacity() {
        int newSize = this.increment == 0 ? this.data.length * 2 : this.data.length + this.increment;
        return newSize;
    }

    private final void moveGap(int newGapPosition) {
        if (newGapPosition == this.gapPosition) {
            return;
        }
        int gapSize = this.gapSize();
        if (gapSize > 0) {
            if (newGapPosition < this.gapPosition) {
                int to = this.gapPosition + gapSize - 1;
                int from = this.gapPosition - 1;
                for (int nItems = this.gapPosition - newGapPosition; nItems > 0; --nItems) {
                    this.data[to] = this.data[from];
                    this.data[from] = EMPTY_VALUE;
                    --to;
                    --from;
                }
            } else {
                int to = this.gapPosition;
                int from = this.gapPosition + gapSize;
                for (int nItems = newGapPosition - this.gapPosition; nItems > 0; --nItems) {
                    this.data[to] = this.data[from];
                    this.data[from] = EMPTY_VALUE;
                    ++to;
                    ++from;
                }
            }
        }
        this.gapPosition = newGapPosition;
    }

    private final void moveGapEnsureCapacity(int newGapPosition, int capacity) {
        if (this.gapPosition == newGapPosition && this.data.length >= capacity) {
            return;
        }
        if (this.data.length >= capacity) {
            this.moveGap(newGapPosition);
        } else {
            if (newGapPosition < 0) {
                throw new IndexOutOfBoundsException(newGapPosition + "<" + 0);
            }
            int newSize = this.computeNewCapacity();
            if (newSize < capacity) {
                newSize = capacity;
            }
            Object[] newData = new Object[newSize];
            int newGapSize = newSize - this.count;
            if (this.gapPosition == newGapPosition && this.gapPosition == this.count) {
                System.arraycopy(this.data, 0, newData, 0, this.count);
                this.data = newData;
                this.fillData(this.count, newSize, EMPTY_VALUE);
            } else {
                int from = 0;
                int to = 0;
                while (from < newGapPosition) {
                    newData[to] = this.internalGet(from);
                    ++from;
                    ++to;
                }
                to += newGapSize;
                while (from < this.count) {
                    newData[to] = this.internalGet(from);
                    ++to;
                    ++from;
                }
                this.data = newData;
                this.gapPosition = newGapPosition;
                this.fillData(this.gapPosition, this.gapPosition + this.gapSize(), EMPTY_VALUE);
            }
        }
    }

    private void insertElementAt(Object o, int index) {
        int c = this.size();
        if (index > c) {
            throw new IndexOutOfBoundsException(index + ">" + c);
        }
        this.moveGapEnsureCapacity(index, c + 1);
        ++this.gapPosition;
        this.internalSet(index, o);
        ++this.count;
    }

    public GapList() {
        this(8, 0);
    }

    public GapList(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public GapList(int initialSize, int capacityIncrement) {
        this.data = new Object[initialSize];
        this.increment = capacityIncrement;
    }

    @Override
    public Object get(int index) {
        return this.internalGet(index);
    }

    @Override
    public Object set(int index, Object value) {
        Object previous = this.internalGet(index);
        this.internalSet(index, value);
        return previous;
    }

    @Override
    public void add(int index, Object element) {
        try {
            this.insertElementAt(element, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public Object remove(int index) {
        Object previous = this.internalGet(index);
        this.moveGap(index + 1);
        this.internalSet(index, EMPTY_VALUE);
        --this.count;
        --this.gapPosition;
        return previous;
    }

    @Override
    public int size() {
        return this.count;
    }

    public boolean equals(GapList list) {
        if (list == null || list.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            Object b;
            Object a = this.internalGet(i);
            if (a == (b = list.internalGet(i))) continue;
            if (a == null || b == null) {
                return false;
            }
            if (a.equals(b)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object.getClass() == GapList.class && this.equals((GapList)object);
    }

    public Object clone() throws CloneNotSupportedException {
        GapList clone = (GapList)super.clone();
        clone.data = new Object[this.data.length];
        System.arraycopy(this.data, 0, clone.data, 0, this.data.length);
        return clone;
    }
}

