/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorResource;
import com.sas.editor.language.ViewFoldInfo;
import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.text.Collator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class FindDialog
extends JDialog
implements KeyEventDispatcher,
WindowFocusListener {
    private JLabel FindLabel = new JLabel();
    private JLabel ReplaceLabel = new JLabel();
    private JComboBox FindTextCombo = new WideComboBox();
    private JComboBox ReplaceTextCombo = new WideComboBox();
    private JButton FindNextButton = new JButton();
    private JButton ReplaceNextButton = new JButton();
    private JButton ReplaceAllButton = new JButton();
    private JButton ReplaceInSelectionButton = new JButton();
    private JButton CloseButton = new JButton();
    private JCheckBox MatchCaseCheckbox = new JCheckBox();
    private JCheckBox MatchWholeWordCheckbox = new JCheckBox();
    private ButtonGroup SearchGroup = new ButtonGroup();
    private JRadioButton SearchUpRadio = new JRadioButton();
    private JRadioButton SearchDownRadio = new JRadioButton();
    private JLabel SearchZoneLabel = new JLabel();
    private JComboBox SearchZoneCombo = new WideComboBox();
    private CodeEditorPane m_EditorPane;
    private boolean m_bWasClosed = true;
    private static boolean mMatchAnyCase = true;
    private static boolean mMatchWholeWord = false;
    private static boolean mSearchDirectionDown = true;
    private static int mSearchZoneComboSetting = 0;
    private static String mCurrentFindString = "";
    private static String mCurrentReplaceString = "";
    private boolean mCurrentlyShowingWarningDialog;
    protected CodeEditorResource resource;
    protected Collator coll = Collator.getInstance(Locale.getDefault());

    public static FindDialog CreateDialog(CodeEditorPane sourcePane) {
        Component parent = sourcePane.getParentFrameOrDialog();
        if (parent instanceof Frame) {
            return new FindDialog((Frame)parent, sourcePane);
        }
        if (parent instanceof Dialog) {
            return new FindDialog((Dialog)parent, sourcePane);
        }
        return null;
    }

    private FindDialog(Frame f, CodeEditorPane pane) {
        super(f);
        this.initialize(pane);
    }

    private FindDialog(Dialog dlg, CodeEditorPane pane) {
        super(dlg);
        this.initialize(pane);
    }

    public void initialize(CodeEditorPane pane) {
        this.m_EditorPane = pane;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.resource = new CodeEditorResource(FindDialog.class);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addWindowFocusListener(this);
    }

    private void jbInit() throws Exception {
        int i;
        this.setupMnemonics(this.FindLabel, "FindDialog.FindTextLabel.txt");
        this.setupMnemonics(this.ReplaceLabel, "FindDialog.ReplaceWithLabel.txt");
        this.setupMnemonics(this.FindNextButton, "FindDialog.FindNextLabel.txt");
        this.setupMnemonics(this.ReplaceNextButton, "FindDialog.ReplaceNextLabel.txt");
        this.setupMnemonics(this.ReplaceAllButton, "FindDialog.ReplaceAllLabel.txt");
        this.setupMnemonics(this.ReplaceInSelectionButton, "FindDialog.ReplaceInSelectionLabel.txt");
        this.setupMnemonics(this.CloseButton, "Common.Close.txt");
        String groupBoxLabelText = this.resource.getString("FindDialog.DirectionBoxLabel.txt");
        this.setupMnemonics(this.SearchUpRadio, "FindDialog.SearchUpLabel.txt");
        this.setupMnemonics(this.SearchDownRadio, "FindDialog.SearchDownLabel.txt");
        this.setupMnemonics(this.MatchCaseCheckbox, "FindDialog.MatchCaseLabel.txt");
        this.setupMnemonics(this.MatchWholeWordCheckbox, "FindDialog.MatchWholeWordLabel.txt");
        this.setupMnemonics(this.SearchZoneLabel, "FindDialog.CodeCommentLabel.txt");
        AutoSizingGridLayout windowLayout = new AutoSizingGridLayout(1, 1, 0, 0, true, true, true);
        this.getContentPane().setLayout((LayoutManager)windowLayout);
        JPanel wholePane = new JPanel();
        EmptyBorder spaceBorder = new EmptyBorder(10, 10, 10, 10);
        wholePane.setBorder(spaceBorder);
        this.getContentPane().add(wholePane);
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(1, 2, 15, 0, true, true, true);
        mainLayout.setRemainderColumn(1);
        wholePane.setLayout((LayoutManager)mainLayout);
        JPanel findControlPanel = new JPanel();
        AutoSizingGridLayout findControlLayout = new AutoSizingGridLayout(3, 1, 0, 15, true, false, true);
        findControlPanel.setLayout((LayoutManager)findControlLayout);
        wholePane.add(findControlPanel);
        JPanel searchComboPanel = new JPanel();
        AutoSizingGridLayout textComboLayout = new AutoSizingGridLayout(2, 2, 5, 5, true, false, true);
        textComboLayout.setRemainderColumn(2);
        searchComboPanel.setLayout((LayoutManager)textComboLayout);
        findControlPanel.add(searchComboPanel);
        JPanel smallOptionPanel = new JPanel();
        AutoSizingGridLayout smallOptionLayout = new AutoSizingGridLayout(1, 2, 30, 0, true, false, false);
        smallOptionPanel.setLayout((LayoutManager)smallOptionLayout);
        findControlPanel.add(smallOptionPanel);
        JPanel matchPanel = new JPanel();
        AutoSizingGridLayout matchLayout = new AutoSizingGridLayout(2, 1, 0, 0, true, false, false);
        matchPanel.setLayout((LayoutManager)matchLayout);
        smallOptionPanel.add(matchPanel);
        JPanel directionPanel = new JPanel();
        AutoSizingGridLayout directionLayout = new AutoSizingGridLayout(2, 1, 0, 0, true, false, false);
        directionPanel.setLayout((LayoutManager)directionLayout);
        smallOptionPanel.add(directionPanel);
        JPanel commentFilterPanel = new JPanel();
        AutoSizingGridLayout commentFilterLayout = new AutoSizingGridLayout(1, 2, 5, 0, true, false, true);
        commentFilterLayout.setRemainderColumn(2);
        commentFilterPanel.setLayout((LayoutManager)commentFilterLayout);
        findControlPanel.add(commentFilterPanel);
        JPanel actionPanel = new JPanel();
        AutoSizingGridLayout actionButtonLayout = new AutoSizingGridLayout(5, 1, 0, 5, true, false, false);
        actionPanel.setLayout((LayoutManager)actionButtonLayout);
        wholePane.add(actionPanel);
        searchComboPanel.add(this.FindLabel);
        searchComboPanel.add(this.FindTextCombo);
        searchComboPanel.add(this.ReplaceLabel);
        searchComboPanel.add(this.ReplaceTextCombo);
        matchPanel.add(this.MatchCaseCheckbox);
        matchPanel.add(this.MatchWholeWordCheckbox);
        this.SearchGroup.add(this.SearchUpRadio);
        this.SearchGroup.add(this.SearchDownRadio);
        TitledBorder groupBorder = new TitledBorder(groupBoxLabelText);
        directionPanel.setBorder(groupBorder);
        directionPanel.add(this.SearchUpRadio);
        directionPanel.add(this.SearchDownRadio);
        commentFilterPanel.add(this.SearchZoneLabel);
        commentFilterPanel.add(this.SearchZoneCombo);
        actionPanel.add(this.FindNextButton);
        actionPanel.add(this.ReplaceNextButton);
        actionPanel.add(this.ReplaceAllButton);
        actionPanel.add(this.ReplaceInSelectionButton);
        actionPanel.add(this.CloseButton);
        this.FindTextCombo.setEditable(true);
        this.ReplaceTextCombo.setEditable(true);
        Component[] comps = this.FindTextCombo.getComponents();
        if (comps.length > 0) {
            this.FindLabel.setLabelFor(comps[comps.length - 1]);
        }
        if ((comps = this.ReplaceTextCombo.getComponents()).length > 0) {
            this.ReplaceLabel.setLabelFor(comps[comps.length - 1]);
        }
        this.SearchZoneLabel.setLabelFor(this.SearchZoneCombo);
        this.setTitle(this.resource.getString("FindDialog.Title.txt"));
        this.setLocationRelativeTo(this.m_EditorPane);
        this.setResizable(true);
        this.SearchZoneCombo.addItem(this.resource.getString("FindDialog.CodeAndCommentsItem.txt"));
        this.SearchZoneCombo.addItem(this.resource.getString("FindDialog.CodeOnlyItem.txt"));
        this.SearchZoneCombo.addItem(this.resource.getString("FindDialog.CommentsOnlyItem.txt"));
        String[] historyStrings = this.m_EditorPane.getFindHistoryStrings();
        for (i = 0; i < historyStrings.length; ++i) {
            this.FindTextCombo.addItem(historyStrings[i]);
        }
        historyStrings = this.m_EditorPane.getReplaceHistoryStrings();
        for (i = 0; i < historyStrings.length; ++i) {
            this.ReplaceTextCombo.addItem(historyStrings[i]);
        }
        this.SearchZoneCombo.setSelectedIndex(mSearchZoneComboSetting);
        this.MatchCaseCheckbox.setSelected(!mMatchAnyCase);
        this.MatchWholeWordCheckbox.setSelected(mMatchWholeWord);
        this.SearchDownRadio.setSelected(mSearchDirectionDown);
        this.SearchUpRadio.setSelected(!mSearchDirectionDown);
        this.setText(this.FindTextCombo, mCurrentFindString);
        this.setText(this.ReplaceTextCombo, mCurrentReplaceString);
        this.SearchZoneCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                mSearchZoneComboSetting = FindDialog.this.SearchZoneCombo.getSelectedIndex();
            }
        });
        this.MatchCaseCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                mMatchAnyCase = !FindDialog.this.MatchCaseCheckbox.isSelected();
            }
        });
        this.MatchWholeWordCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                mMatchWholeWord = FindDialog.this.MatchWholeWordCheckbox.isSelected();
            }
        });
        this.SearchDownRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                mSearchDirectionDown = FindDialog.this.SearchDownRadio.isSelected();
            }
        });
        this.SearchUpRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                mSearchDirectionDown = !FindDialog.this.SearchUpRadio.isSelected();
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
                FindDialog.this.m_EditorPane.setFindDialogPosition(FindDialog.this.getLocationOnScreen());
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                FindDialog.this.m_EditorPane.setFindDialogSize(FindDialog.this.getSize());
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }
        });
        this.FindTextCombo.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.OnFindNext(e);
            }
        });
        this.ReplaceTextCombo.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.OnReplaceNext(e);
            }
        });
        this.CloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.OnClose();
            }
        });
        this.FindNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.OnFindNext(e);
            }
        });
        this.ReplaceNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.OnReplaceNext(e);
            }
        });
        this.ReplaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.OnReplaceAll(e);
            }
        });
        this.ReplaceInSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.OnReplaceInSelection(e);
            }
        });
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
                FindDialog.this.onActivate();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                FindDialog.this.OnClose();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.updateButtons();
        this.pack();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getID() != 402) {
            return false;
        }
        if (e.getKeyCode() == 27 && this.isActive()) {
            this.OnClose();
            return true;
        }
        if (e.getKeyCode() == 38 && this.isActive() && this.SearchDownRadio.hasFocus()) {
            this.SearchUpRadio.requestFocus();
            if ((e.getModifiers() & 2) == 0) {
                this.SearchUpRadio.setSelected(true);
            }
        }
        if (e.getKeyCode() == 40 && this.isActive() && this.SearchUpRadio.hasFocus()) {
            this.SearchDownRadio.requestFocus();
            if ((e.getModifiers() & 2) == 0) {
                this.SearchDownRadio.setSelected(true);
            }
        }
        return false;
    }

    public void OnClose() {
        mCurrentFindString = (String)this.FindTextCombo.getEditor().getItem();
        mCurrentReplaceString = (String)this.ReplaceTextCombo.getEditor().getItem();
        CodeEditorPane.clearFrameFindDialog();
        this.m_bWasClosed = true;
        if (this.m_EditorPane != null) {
            this.m_EditorPane.getCodeEditorDocument().ResetFoundPosition();
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.dispose();
    }

    public void onActivate() {
        if (this.m_bWasClosed) {
            this.FindTextCombo.getEditor().selectAll();
            this.m_bWasClosed = false;
        }
    }

    public void setText(String text) {
        this.setText(this.FindTextCombo, text);
    }

    public void setText(JComboBox jcb, String text) {
        if (text == null) {
            return;
        }
        jcb.configureEditor(jcb.getEditor(), text);
        jcb.getEditor().selectAll();
    }

    @Override
    public void setVisible(boolean b) {
        if (!this.m_EditorPane.isReadOnly()) {
            this.ReplaceInSelectionButton.setEnabled(this.m_EditorPane.getSelectedText() != null);
        }
        super.setVisible(b);
        this.FindTextCombo.getEditor().selectAll();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeEditorPane.markFindDialogOpened();
            }
        });
    }

    protected void updateButtons() {
        if (this.m_EditorPane == null) {
            this.ReplaceAllButton.setEnabled(false);
            this.ReplaceInSelectionButton.setEnabled(false);
            this.ReplaceNextButton.setEnabled(false);
            this.ReplaceLabel.setEnabled(false);
            this.ReplaceTextCombo.setEnabled(false);
            this.FindNextButton.setEnabled(false);
            return;
        }
        this.SearchZoneCombo.setEnabled(true);
        this.ReplaceAllButton.setEnabled(true);
        this.ReplaceInSelectionButton.setEnabled(true);
        this.ReplaceNextButton.setEnabled(true);
        this.ReplaceLabel.setEnabled(true);
        this.ReplaceTextCombo.setEnabled(true);
        this.FindNextButton.setEnabled(true);
        if (!this.m_EditorPane.getCodeEditorDocument().IsDocumentColoringEnabled()) {
            this.SearchZoneLabel.setEnabled(false);
            this.SearchZoneCombo.setEnabled(false);
        }
        if (this.m_EditorPane.isReadOnly()) {
            this.ReplaceAllButton.setEnabled(false);
            this.ReplaceInSelectionButton.setEnabled(false);
            this.ReplaceNextButton.setEnabled(false);
            this.ReplaceLabel.setEnabled(false);
            this.ReplaceTextCombo.setEnabled(false);
        }
    }

    protected void OnFindNext(ActionEvent e) {
        boolean SearchComments;
        String TextToFind = (String)this.FindTextCombo.getEditor().getItem();
        boolean SearchDown = this.SearchDownRadio.isSelected();
        boolean MatchCase = this.MatchCaseCheckbox.isSelected();
        boolean MatchWord = this.MatchWholeWordCheckbox.isSelected();
        boolean SearchCode = this.SearchZoneCombo.getSelectedItem() != this.resource.getString("FindDialog.CommentsOnlyItem.txt");
        boolean bl = SearchComments = this.SearchZoneCombo.getSelectedItem() != this.resource.getString("FindDialog.CodeOnlyItem.txt");
        if (this.coll.compare(TextToFind, "") == 0) {
            return;
        }
        int Offset = SearchDown ? this.m_EditorPane.getCaretPosition() : this.m_EditorPane.getSelectionStart() - 1;
        this.UpdateComboBoxList(this.FindTextCombo, TextToFind);
        this.saveComboBoxListItems();
        int index = this.m_EditorPane.getCodeEditorDocument().Find(TextToFind, Offset, SearchDown, MatchCase, MatchWord, SearchCode, SearchComments);
        this.m_EditorPane.getCodeEditorDocument();
        if (index == -2) {
            Toolkit.getDefaultToolkit().beep();
            String msg = this.resource.getMessageString("FindDialog.FinishedSearching.fmt.txt", TextToFind);
            Object[] options = new Object[]{this.resource.getString("Common.OK.txt")};
            this.mCurrentlyShowingWarningDialog = true;
            JOptionPane.showOptionDialog(this, msg, this.resource.getString("FindDialog.Title.txt"), -1, 2, null, options, options[0]);
            this.mCurrentlyShowingWarningDialog = false;
            this.FindTextCombo.getEditor().selectAll();
            return;
        }
        if (index >= 0) {
            int line;
            ViewFoldInfo vfi = this.m_EditorPane.getViewFoldInfo();
            if (!vfi.isTopLevelLine(line = this.m_EditorPane.getCodeEditorDocument().getLineForOffset(index))) {
                vfi.expand(line);
            }
            this.m_EditorPane.setSelectionStart(index);
            this.m_EditorPane.setSelectionEnd(index + TextToFind.length());
        } else {
            Toolkit.getDefaultToolkit().beep();
            String msg = this.resource.getMessageString("FindDialog.CouldNotFind.fmt.txt", TextToFind);
            Object[] options = new Object[]{this.resource.getString("Common.OK.txt")};
            this.mCurrentlyShowingWarningDialog = true;
            JOptionPane.showOptionDialog(this, msg, this.resource.getString("FindDialog.Title.txt"), -1, 2, null, options, options[0]);
            this.mCurrentlyShowingWarningDialog = false;
        }
    }

    protected void OnReplaceNext(ActionEvent e) {
        boolean SearchComments;
        String TextToFind = (String)this.FindTextCombo.getEditor().getItem();
        String TextToReplace = (String)this.ReplaceTextCombo.getEditor().getItem();
        int Offset = this.m_EditorPane.getCaretPosition();
        boolean SearchDown = this.SearchDownRadio.isSelected();
        boolean MatchCase = this.MatchCaseCheckbox.isSelected();
        boolean MatchWord = this.MatchWholeWordCheckbox.isSelected();
        boolean SearchCode = this.SearchZoneCombo.getSelectedItem() != this.resource.getString("FindDialog.CommentsOnlyItem.txt");
        boolean bl = SearchComments = this.SearchZoneCombo.getSelectedItem() != this.resource.getString("FindDialog.CodeOnlyItem.txt");
        if (this.coll.compare(TextToFind, "") == 0) {
            return;
        }
        if (TextToReplace == null) {
            TextToReplace = "";
        }
        this.UpdateComboBoxList(this.FindTextCombo, TextToFind);
        this.UpdateComboBoxList(this.ReplaceTextCombo, TextToReplace);
        this.saveComboBoxListItems();
        int index = this.m_EditorPane.getCodeEditorDocument().ReplaceText(TextToFind, TextToReplace, Offset, SearchDown, MatchCase, MatchWord, SearchCode, SearchComments);
        if (index >= 0) {
            int line;
            ViewFoldInfo vfi = this.m_EditorPane.getViewFoldInfo();
            if (!vfi.isTopLevelLine(line = this.m_EditorPane.getCodeEditorDocument().getLineForOffset(index))) {
                vfi.expand(line);
            }
            this.m_EditorPane.setSelectionStart(index);
            this.m_EditorPane.setSelectionEnd(index + TextToReplace.length());
        } else {
            String msg = this.resource.getMessageString("FindDialog.CouldNotFind.fmt.txt", TextToFind);
            Object[] options = new Object[]{this.resource.getString("Common.OK.txt")};
            this.mCurrentlyShowingWarningDialog = true;
            JOptionPane.showOptionDialog(this, msg, this.resource.getString("Common.CodeEditor.txt"), -1, 2, null, options, options[0]);
            this.mCurrentlyShowingWarningDialog = false;
        }
    }

    public void OnReplaceAll(ActionEvent e) {
        String TextToFind = (String)this.FindTextCombo.getEditor().getItem();
        String TextToReplace = (String)this.ReplaceTextCombo.getEditor().getItem();
        boolean MatchCase = this.MatchCaseCheckbox.isSelected();
        boolean MatchWord = this.MatchWholeWordCheckbox.isSelected();
        boolean SearchCode = this.SearchZoneCombo.getSelectedItem() != this.resource.getString("FindDialog.CommentsOnlyItem.txt");
        boolean SearchComments = this.SearchZoneCombo.getSelectedItem() != this.resource.getString("FindDialog.CodeOnlyItem.txt");
        boolean displayDialogOnFail = true;
        int searchIndex = 0;
        if (this.coll.compare(TextToFind, "") == 0) {
            return;
        }
        this.UpdateComboBoxList(this.FindTextCombo, TextToFind);
        this.UpdateComboBoxList(this.ReplaceTextCombo, TextToReplace);
        this.saveComboBoxListItems();
        this.m_EditorPane.getCodeEditorDocument().setMassReplaceCode(System.currentTimeMillis());
        do {
            int foundIndex;
            if ((foundIndex = this.m_EditorPane.getCodeEditorDocument().FindText(TextToFind, searchIndex, true, MatchCase, MatchWord, SearchCode, SearchComments)) >= 0) {
                foundIndex = this.m_EditorPane.getCodeEditorDocument().ReplaceText(TextToFind, TextToReplace, foundIndex, true, MatchCase, MatchWord, SearchCode, SearchComments);
            }
            searchIndex = foundIndex < 0 ? foundIndex : foundIndex + TextToReplace.length();
            if (foundIndex >= 0) {
                displayDialogOnFail = false;
                continue;
            }
            if (!displayDialogOnFail) continue;
            String msg = this.resource.getMessageString("FindDialog.CouldNotFind.fmt.txt", TextToFind);
            Object[] options = new Object[]{this.resource.getString("Common.OK.txt")};
            this.mCurrentlyShowingWarningDialog = true;
            JOptionPane.showOptionDialog(this, msg, this.resource.getString("Common.CodeEditor.txt"), -1, 2, null, options, options[0]);
            this.mCurrentlyShowingWarningDialog = false;
        } while (searchIndex >= 0);
        this.m_EditorPane.getCodeEditorDocument().setMassReplaceCode(0L);
        this.m_EditorPane.getCodeEditorDocument().ResetFoundPosition();
    }

    public void OnReplaceInSelection(ActionEvent e) {
        String TextToFind = (String)this.FindTextCombo.getEditor().getItem();
        String TextToReplace = (String)this.ReplaceTextCombo.getEditor().getItem();
        boolean MatchCase = this.MatchCaseCheckbox.isSelected();
        boolean MatchWord = this.MatchWholeWordCheckbox.isSelected();
        boolean SearchCode = this.SearchZoneCombo.getSelectedItem() != this.resource.getString("FindDialog.CommentsOnlyItem.txt");
        boolean SearchComments = this.SearchZoneCombo.getSelectedItem() != this.resource.getString("FindDialog.CodeOnlyItem.txt");
        int startPos = this.m_EditorPane.getSelectionStart();
        int endPos = this.m_EditorPane.getSelectionEnd();
        if (this.coll.compare(TextToFind, "") == 0) {
            return;
        }
        this.UpdateComboBoxList(this.FindTextCombo, TextToFind);
        this.UpdateComboBoxList(this.ReplaceTextCombo, TextToReplace);
        this.saveComboBoxListItems();
        this.m_EditorPane.getCodeEditorDocument().setMassReplaceCode(System.currentTimeMillis());
        int index = this.m_EditorPane.getCodeEditorDocument().ReplaceInSelection(TextToFind, TextToReplace, startPos, endPos, MatchCase, MatchWord, SearchCode, SearchComments);
        this.m_EditorPane.getCodeEditorDocument().setMassReplaceCode(0L);
        if (index < 0) {
            String msg = this.resource.getMessageString("FindDialog.CouldNotFind.fmt.txt", TextToFind);
            Object[] options = new Object[]{this.resource.getString("Common.OK.txt")};
            this.mCurrentlyShowingWarningDialog = true;
            JOptionPane.showOptionDialog(this, msg, this.resource.getString("Common.CodeEditor.txt"), -1, 2, null, options, options[0]);
            this.mCurrentlyShowingWarningDialog = false;
        } else {
            this.m_EditorPane.setSelectionStart(startPos);
            this.m_EditorPane.setSelectionEnd(index);
        }
    }

    protected void saveComboBoxListItems() {
        ArrayList findList = new ArrayList();
        for (int i = 0; i < this.FindTextCombo.getItemCount(); ++i) {
            findList.add(this.FindTextCombo.getItemAt(i));
        }
        this.m_EditorPane.setFindHistoryStrings(findList.toArray(new String[0]));
        ArrayList replaceList = new ArrayList();
        for (int i = 0; i < this.ReplaceTextCombo.getItemCount(); ++i) {
            replaceList.add(this.ReplaceTextCombo.getItemAt(i));
        }
        this.m_EditorPane.setReplaceHistoryStrings(replaceList.toArray(new String[0]));
    }

    protected void UpdateComboBoxList(JComboBox jcb, String text) {
        if (text == null || this.coll.compare(text, "") == 0) {
            return;
        }
        for (int i = 0; i < jcb.getItemCount(); ++i) {
            if (this.coll.compare((String)jcb.getItemAt(i), text) != 0) continue;
            jcb.removeItemAt(i);
            break;
        }
        jcb.insertItemAt(text, 0);
        while (jcb.getItemCount() > this.m_EditorPane.getFindHistorySize()) {
            jcb.removeItemAt(this.m_EditorPane.getFindHistorySize());
        }
        this.setText(jcb, text);
    }

    public int getWidthOfString(String s) {
        Font f = this.getContentPane().getFont();
        FontMetrics fm = this.getContentPane().getFontMetrics(f);
        StringCharacterIterator sci = new StringCharacterIterator(s);
        int size = 0;
        for (int i = sci.getBeginIndex(); i <= sci.getEndIndex(); ++i) {
            size += fm.charWidth(sci.setIndex(i));
        }
        return size;
    }

    public void setEditor(CodeEditorPane pane) {
        if (this.m_EditorPane != null && this.m_EditorPane != pane) {
            this.m_EditorPane.getCodeEditorDocument().ResetFoundPosition();
        }
        if (this.m_EditorPane != pane) {
            pane.getCodeEditorDocument().ResetFoundPosition();
        }
        this.m_EditorPane = pane;
        this.updateButtons();
    }

    @Override
    public void windowGainedFocus(WindowEvent arg0) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (this.m_EditorPane != null) {
            Window focusGainer = e.getOppositeWindow();
            if (focusGainer == null) {
                this.m_EditorPane.autoCloseFindDialog();
            } else {
                Window dialogParent = SwingUtilities.windowForComponent(this);
                if (focusGainer != dialogParent && !this.mCurrentlyShowingWarningDialog) {
                    this.m_EditorPane.autoCloseFindDialog();
                }
            }
        }
    }

    protected void setupMnemonics(JLabel lbl, String key) {
        String lblItem = this.resource.getString(key);
        String lblText = Util.getLabelWithoutMnemonic((String)lblItem);
        lbl.setText(lblText);
        int index = Util.getDisplayedMnemonicIndex((String)lblItem);
        if (index > -1) {
            lbl.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)lblItem));
            lbl.setDisplayedMnemonicIndex(index);
        }
    }

    protected void setupMnemonics(JRadioButton rbn, String key) {
        String lblItem = this.resource.getString(key);
        String lblText = Util.getLabelWithoutMnemonic((String)lblItem);
        rbn.setText(lblText);
        int index = Util.getDisplayedMnemonicIndex((String)lblItem);
        if (index > -1) {
            rbn.setMnemonic(Util.getDisplayedMnemonic((String)lblItem));
            rbn.setDisplayedMnemonicIndex(index);
        }
    }

    protected void setupMnemonics(JCheckBox cbx, String key) {
        String lblItem = this.resource.getString(key);
        String lblText = Util.getLabelWithoutMnemonic((String)lblItem);
        cbx.setText(lblText);
        int index = Util.getDisplayedMnemonicIndex((String)lblItem);
        if (index > -1) {
            cbx.setMnemonic(Util.getDisplayedMnemonic((String)lblItem));
            cbx.setDisplayedMnemonicIndex(index);
        }
    }

    protected void setupMnemonics(JButton btn, String key) {
        String buttonItem = this.resource.getString(key);
        String buttonText = Util.getLabelWithoutMnemonic((String)buttonItem);
        btn.setText(buttonText);
        int index = Util.getDisplayedMnemonicIndex((String)buttonItem);
        if (index > -1) {
            btn.setMnemonic(Util.getDisplayedMnemonic((String)buttonItem));
            btn.setDisplayedMnemonicIndex(index);
        }
    }
}

