/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.LogListHolder;
import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class EditorSubmit {
    private ILanguageService m_pSASLanguage;
    private Document m_doc;

    public EditorSubmit(IWorkspace ws, Document doc) {
        this.m_pSASLanguage = ws.LanguageService();
        this.m_doc = doc;
    }

    public void Submit() {
        String strText = "";
        int nLen = 0;
        try {
            nLen = this.m_doc.getLength();
            strText = this.m_doc.getText(0, nLen);
            this.m_pSASLanguage.Submit(strText);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        catch (GenericError ex) {
            ex.printStackTrace();
        }
    }

    public String[] GetLogText() {
        CarriageControlSeqHolder logCarriageControlHldr = new CarriageControlSeqHolder();
        LineTypeSeqHolder logLineTypeHldr = new LineTypeSeqHolder();
        StringSeqHolder logHldr = new StringSeqHolder();
        try {
            this.m_pSASLanguage.FlushLogLines(Integer.MAX_VALUE, logCarriageControlHldr, logLineTypeHldr, logHldr);
        }
        catch (GenericError ex) {
            ex.printStackTrace();
        }
        String[] logLines = logHldr.value;
        return logLines;
    }

    public String[] GetListText() {
        CarriageControlSeqHolder listCarriageControlHldr = new CarriageControlSeqHolder();
        LineTypeSeqHolder listLineTypeHldr = new LineTypeSeqHolder();
        StringSeqHolder listHldr = new StringSeqHolder();
        try {
            this.m_pSASLanguage.FlushListLines(Integer.MAX_VALUE, listCarriageControlHldr, listLineTypeHldr, listHldr);
        }
        catch (GenericError ex) {
            ex.printStackTrace();
        }
        String[] listLines = listHldr.value;
        return listLines;
    }

    public LogListHolder GetLog() {
        CarriageControlSeqHolder logCarriageControlHldr = new CarriageControlSeqHolder();
        LineTypeSeqHolder logLineTypeHldr = new LineTypeSeqHolder();
        StringSeqHolder logHldr = new StringSeqHolder();
        try {
            this.m_pSASLanguage.FlushLogLines(Integer.MAX_VALUE, logCarriageControlHldr, logLineTypeHldr, logHldr);
        }
        catch (GenericError ex) {
            ex.printStackTrace();
        }
        return new LogListHolder(logHldr, logCarriageControlHldr, logLineTypeHldr);
    }

    public LogListHolder GetList() {
        CarriageControlSeqHolder listCarriageControlHldr = new CarriageControlSeqHolder();
        LineTypeSeqHolder listLineTypeHldr = new LineTypeSeqHolder();
        StringSeqHolder listHldr = new StringSeqHolder();
        try {
            this.m_pSASLanguage.FlushListLines(Integer.MAX_VALUE, listCarriageControlHldr, listLineTypeHldr, listHldr);
        }
        catch (GenericError ex) {
            ex.printStackTrace();
        }
        return new LogListHolder(listHldr, listCarriageControlHldr, listLineTypeHldr);
    }
}

