/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.AttributeMap;
import com.sas.editor.CodeEditorDocument;
import com.sas.editor.CodeEditorLinePrintData;
import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorResource;
import com.sas.editor.TokenInfo;
import com.sas.editor.TokenMap;
import com.sas.editor.TokenMapInterface;
import com.sas.editor.TokenMapIterator;
import com.sas.editor.language.ViewFoldInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.util.List;
import java.util.Locale;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public class CodeEditorView
extends PlainView {
    AttributeMap m_AttrMap;
    TokenMapIterator m_TMI = new TokenMapIterator();
    ViewFoldInfo m_FoldInfo = new ViewFoldInfo(this);
    int tabSize;
    int tabBase;
    int sel0;
    int sel1;
    protected FontMetrics mMetrics;
    Font baseFont;
    Element longLine;

    public CodeEditorView(Element elem) {
        super(elem);
    }

    public void cleanup() {
        if (this.m_FoldInfo != null) {
            this.m_FoldInfo.cleanup();
        }
    }

    public ViewFoldInfo getViewFoldInfo() {
        return this.m_FoldInfo;
    }

    @Override
    protected int getTabSize() {
        int size = 8;
        Document doc = this.getDocument();
        if (doc instanceof CodeEditorDocument) {
            size = ((CodeEditorDocument)this.getDocument()).getTabSize();
        }
        return size;
    }

    @Override
    public void insertUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        Element root = this.getElement();
        int changeLine = root.getElementIndex(changes.getOffset());
        this.m_FoldInfo.expand(changeLine);
        this.updateDamage(changes, a, f);
    }

    @Override
    public void removeUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        Element root = this.getElement();
        int changeLine = root.getElementIndex(changes.getOffset());
        this.m_FoldInfo.expand(changeLine);
        this.updateDamage(changes, a, f);
    }

    @Override
    public void changedUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    @Override
    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        Element line = this.getElement(lineIndex);
        int oldY = y;
        g.translate(0, y);
        y = 0;
        try {
            if (line.isLeaf()) {
                this.drawElement(line, g, x, y);
            } else {
                int count = line.getElementCount();
                for (int i = 0; i < count; ++i) {
                    Element elem = line.getElement(i);
                    x = this.drawElement(elem, g, x, y);
                }
            }
        }
        catch (BadLocationException e) {
            CodeEditorResource res = new CodeEditorResource(CodeEditorView.class);
            String s = res.getString("CodeEditorView.UnableToRenderLineExceptionMessage.txt");
            throw new Error(s + "  " + lineIndex);
        }
        finally {
            g.translate(0, -oldY);
        }
    }

    protected int drawElement(Element elem, Graphics g, int x, int y) throws BadLocationException {
        int p0 = elem.getStartOffset();
        int p1 = elem.getEndOffset();
        p1 = Math.min(this.getDocument().getLength(), p1);
        if (this.sel0 == this.sel1) {
            x = this.drawUnselectedText(g, x, y, p0, p1);
        } else if (p0 >= this.sel0 && p0 <= this.sel1 && p1 >= this.sel0 && p1 <= this.sel1) {
            x = this.drawSelectedText(g, x, y, p0, p1);
        } else if (this.sel0 >= p0 && this.sel0 <= p1) {
            if (this.sel1 >= p0 && this.sel1 <= p1) {
                x = this.drawUnselectedText(g, x, y, p0, this.sel0);
                x = this.drawSelectedText(g, x, y, this.sel0, this.sel1);
                x = this.drawUnselectedText(g, x, y, this.sel1, p1);
            } else {
                x = this.drawUnselectedText(g, x, y, p0, this.sel0);
                x = this.drawSelectedText(g, x, y, this.sel0, p1);
            }
        } else if (this.sel1 >= p0 && this.sel1 <= p1) {
            x = this.drawSelectedText(g, x, y, p0, this.sel1);
            x = this.drawUnselectedText(g, x, y, this.sel1, p1);
        } else {
            x = this.drawUnselectedText(g, x, y, p0, p1);
        }
        return x;
    }

    @Override
    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        Document doc = this.getDocument();
        doc.getText(p0, p1 - p0, this.getLineBuffer());
        return this.drawTabbedText(this.getLineBuffer(), x, y, g, this, p0, false);
    }

    @Override
    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        Document doc = this.getDocument();
        doc.getText(p0, p1 - p0, this.getLineBuffer());
        return this.drawTabbedText(this.getLineBuffer(), x, y, g, this, p0, true);
    }

    public int drawTabbedText(Segment s, int x, int y, Graphics g, TabExpander e, int startOffset, boolean bSelected) {
        FontMetrics currentFontMetrics = g.getFontMetrics();
        int nextX = x;
        char[] txt = s.array;
        int txtOffset = s.offset;
        int flushLen = 0;
        int flushIndex = s.offset;
        int n = s.offset + s.count;
        for (int i = txtOffset; i < n; ++i) {
            if (txt[i] == '\t') {
                if (flushLen > 0) {
                    nextX = this.drawChars(g, txt, flushIndex, flushLen, x, y, startOffset + flushIndex - txtOffset, bSelected);
                    flushLen = 0;
                }
                flushIndex = i + 1;
                nextX = e != null ? (int)e.nextTabStop(nextX, startOffset + i - txtOffset) : (nextX += currentFontMetrics.charWidth(' '));
                x = nextX;
                continue;
            }
            if (txt[i] == '\n' || txt[i] == '\r') {
                if (flushLen > 0) {
                    nextX = this.drawChars(g, txt, flushIndex, flushLen, x, y, startOffset + flushIndex - txtOffset, bSelected);
                    flushLen = 0;
                }
                flushIndex = i + 1;
                x = nextX;
                continue;
            }
            ++flushLen;
            nextX += currentFontMetrics.charWidth(txt[i]);
        }
        if (flushLen > 0) {
            nextX = this.drawChars(g, txt, flushIndex, flushLen, x, y, startOffset + flushIndex - txtOffset, bSelected);
        }
        if (this.getDocument() instanceof CodeEditorDocument && ((CodeEditorDocument)this.getDocument()).getEditableRegion() != null && ((CodeEditorDocument)this.getDocument()).isInReadonlyRegion(startOffset)) {
            int width = Math.max((int)g.getClipBounds().getWidth(), this.getClientRect().width);
            this.paintCharBackground(g, nextX, y - currentFontMetrics.getAscent(), width, currentFontMetrics.getHeight(), ((CodeEditorDocument)this.getDocument()).getReadonlyBgColor());
        }
        return nextX;
    }

    void drawToPrinter(Graphics g, int startOffset, int endOffset, int printerX, int printerY) {
        try {
            this.drawUnselectedText(g, printerX, printerY, startOffset, endOffset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    void cachePrintInfo(Graphics g, boolean folding, int width, List lineInfos) {
        TokenMapInterface tokenMap = ((CodeEditorDocument)this.getDocument()).getTokenMap();
        TokenMapIterator tokenIterator = new TokenMapIterator();
        tokenIterator.setTokenMap(tokenMap, 0);
        int lineCount = this.getDocument().getDefaultRootElement().getElementCount();
        FontMetrics defaultFontMetrics = g.getFontMetrics(this.getContainer().getFont());
        int tabPixels = this.getTabSize() * defaultFontMetrics.charWidth('m');
        CodeEditorLinePrintData lastPrintData = null;
        block2: for (int i = 0; i < lineCount; ++i) {
            Element lineElement = this.getDocument().getDefaultRootElement().getElement(i);
            int elementStart = lineElement.getStartOffset();
            int elementEnd = lineElement.getEndOffset();
            if (folding && !this.m_FoldInfo.isTopLevelLine(i)) continue;
            tokenIterator.seek(elementStart);
            TokenInfo tokenInfo = tokenIterator.getTokenInfo();
            if (tokenInfo == null) break;
            int start = Math.max(elementStart, tokenInfo.getStartOffset());
            int end = Math.min(elementEnd, tokenInfo.getEndOffset());
            lastPrintData = new CodeEditorLinePrintData();
            lastPrintData.mStartOffset = start;
            lastPrintData.mEndOffset = elementEnd;
            lastPrintData.mLineNumber = i + 1;
            lineInfos.add(lastPrintData);
            int accumulatedExtent = 0;
            while (start < elementEnd) {
                this.setGraphicsForCurrentToken(g, tokenIterator, false, start);
                FontMetrics fontSpec = g.getFontMetrics();
                String segmentText = "";
                try {
                    segmentText = this.getDocument().getText(start, end - start);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                int extent = this.getPrintExtent(fontSpec, tabPixels, segmentText);
                if (accumulatedExtent + extent > width) {
                    int splitIndex = this.findSplitIndex(fontSpec, tabPixels, segmentText, width - accumulatedExtent, false);
                    lastPrintData.mEndOffset = start + splitIndex;
                    lastPrintData = new CodeEditorLinePrintData();
                    lastPrintData.mStartOffset = start + splitIndex;
                    lastPrintData.mEndOffset = elementEnd;
                    lineInfos.add(lastPrintData);
                    start += splitIndex;
                    accumulatedExtent = 0;
                    continue;
                }
                accumulatedExtent += extent;
                tokenInfo = tokenIterator.nextToken();
                if (tokenInfo == null) continue block2;
                start = tokenInfo.getStartOffset();
                end = Math.min(tokenInfo.getEndOffset(), elementEnd);
            }
        }
    }

    private int getPrintExtent(FontMetrics fontSpec, int tabPixels, String segmentText) {
        StringBuffer buffer = new StringBuffer();
        int totalExtent = 0;
        for (int i = 0; i < segmentText.length(); ++i) {
            char c = segmentText.charAt(i);
            if (c == '\t') {
                int extent = fontSpec.stringWidth(buffer.toString());
                buffer.delete(0, buffer.length());
                int pixelsToNextTabStop = (totalExtent += extent) % tabPixels;
                if (pixelsToNextTabStop > 0) {
                    totalExtent += pixelsToNextTabStop;
                    continue;
                }
                totalExtent += tabPixels;
                continue;
            }
            buffer.append(c);
        }
        if (buffer.length() > 0) {
            int extent = fontSpec.stringWidth(buffer.toString());
            totalExtent += extent;
        }
        return totalExtent;
    }

    private int findSplitIndex(FontMetrics fontSpec, int tabPixels, String segmentText, int width, boolean forceProgress) {
        int charIndex;
        StringBuffer buffer = new StringBuffer("");
        for (charIndex = 0; charIndex < segmentText.length(); ++charIndex) {
            buffer.append(segmentText.charAt(charIndex));
            int testWidth = this.getPrintExtent(fontSpec, tabPixels, buffer.toString());
            if (testWidth > width) break;
        }
        if (forceProgress && charIndex == 0) {
            charIndex = 1;
        }
        return charIndex;
    }

    public void bidiDrawChars(Graphics g, char[] txt, int offset, int length, int x, int y) {
        int i;
        int extent = 0;
        int TwoBlanksFlag = 0;
        boolean AnyHebrewFlag = false;
        boolean FD_Flag = false;
        FontMetrics m = g.getFontMetrics();
        for (i = offset; i < offset + length - 1; ++i) {
            if ('\u05d0' <= txt[i] && txt[i] <= '\u05ea') {
                AnyHebrewFlag = true;
            }
            if (txt[i] != '\u200e') continue;
            FD_Flag = true;
        }
        if (!AnyHebrewFlag) {
            g.drawChars(txt, offset, length, x, y);
            return;
        }
        int CurrLength = length;
        for (i = offset; i < offset + length - 1; i += CurrLength + 1 - TwoBlanksFlag) {
            int j;
            for (j = i; j <= offset + length - 1 && txt[j] != '\u200e'; ++j) {
                if (j > offset && TwoBlanksFlag == 0 && AnyHebrewFlag && !FD_Flag && txt[j - 1] == ' ' && txt[j] == ' ') {
                    TwoBlanksFlag = 1;
                    break;
                }
                if (txt[j] == ' ') continue;
                TwoBlanksFlag = 0;
            }
            CurrLength = j - i;
            for (int blanks = i; blanks < i + CurrLength && txt[blanks] == ' '; ++blanks) {
                --CurrLength;
                ++i;
                g.drawChars(txt, blanks, 1, x, y);
                extent = m.charsWidth(txt, blanks, 1);
                x += extent;
            }
            g.drawChars(txt, i, CurrLength, x, y);
            extent = m.charsWidth(txt, i, CurrLength);
            x += extent;
        }
    }

    protected int drawChars(Graphics g, char[] txt, int offset, int length, int x, int y, int startOffset, boolean bSelected) {
        int nextX;
        Locale l = Locale.getDefault();
        this.m_TMI.seek(startOffset);
        if (!this.m_TMI.currentValid()) {
            nextX = x;
            Color bg = this.setGraphicsForCurrentToken(g, null, bSelected, startOffset);
            FontMetrics m = g.getFontMetrics();
            int extent = m.charsWidth(txt, offset, length);
            this.paintCharBackground(g, x, y - m.getAscent(), extent, m.getHeight(), bg);
            if (l.getLanguage().equals(new Locale("iw", "", "").getLanguage())) {
                this.bidiDrawChars(g, txt, offset, length, x, y);
            } else {
                g.drawChars(txt, offset, length, x, y);
            }
            nextX += extent;
        } else {
            int adj = offset - startOffset;
            int maxDrawOffset = startOffset + length;
            nextX = x;
            int previousEndOffset = startOffset;
            int drawnChars = 0;
            while (drawnChars < length) {
                int drawStartOffset = 0;
                int drawEndOffset = 0;
                if (this.m_TMI.currentValid()) {
                    TokenInfo currentTokenInfo = this.m_TMI.getTokenInfo();
                    drawStartOffset = Math.max(currentTokenInfo.getStartOffset(), startOffset);
                    drawEndOffset = Math.min(currentTokenInfo.getEndOffset(), maxDrawOffset);
                    if (previousEndOffset != drawStartOffset) {
                        drawStartOffset = previousEndOffset;
                    }
                } else {
                    drawStartOffset = previousEndOffset;
                    drawEndOffset = drawStartOffset + (length - drawnChars);
                }
                int drawLength = drawEndOffset - drawStartOffset;
                if (drawLength <= 0) {
                    this.m_TMI.nextToken();
                    continue;
                }
                Color bg = this.setGraphicsForCurrentToken(g, this.m_TMI, bSelected, startOffset);
                FontMetrics m = g.getFontMetrics();
                int extent = m.charsWidth(txt, drawStartOffset + adj, drawLength);
                this.paintCharBackground(g, nextX, y - m.getAscent(), extent, m.getHeight(), bg);
                if (l.getLanguage().equals(new Locale("iw", "", "").getLanguage())) {
                    this.bidiDrawChars(g, txt, drawStartOffset + adj, drawLength, nextX, y);
                } else {
                    g.drawChars(txt, drawStartOffset + adj, drawLength, nextX, y);
                }
                nextX += extent;
                this.m_TMI.nextToken();
                drawnChars += drawLength;
                previousEndOffset = drawEndOffset;
            }
        }
        return nextX;
    }

    protected Color setGraphicsForCurrentToken(Graphics g, TokenMapIterator tmi, boolean bSelected) {
        Color bg;
        Color fg;
        AttributeSet attrs = null;
        TokenInfo ti = null;
        if (tmi != null && (ti = tmi.getTokenInfo()) != null) {
            attrs = this.m_AttrMap.getElementAttributes(ti.getTokenType());
        }
        if (attrs != null) {
            fg = StyleConstants.getForeground(attrs);
            bg = StyleConstants.getBackground(attrs);
            boolean bold = StyleConstants.isBold(attrs);
            boolean italic = StyleConstants.isItalic(attrs);
        } else {
            fg = SystemColor.windowText;
            bg = SystemColor.window;
            boolean bold = false;
            boolean italic = false;
        }
        Font f = null;
        f = attrs != null ? (Font)attrs.getAttribute("Font") : ((CodeEditorPane)this.getContainer()).getFont();
        g.setFont(f);
        if (fg != null) {
            Color useFg;
            if (bSelected) {
                useFg = new Color(255 - fg.getRed(), 255 - fg.getGreen(), 255 - fg.getBlue());
                bg = ((CodeEditorPane)this.getContainer()).getSelectionColor();
            } else {
                useFg = fg;
            }
            g.setColor(useFg);
        }
        return bg;
    }

    protected void paintCharBackground(Graphics g, int x, int y, int width, int height, Color bgColor) {
        if (bgColor != null && bgColor != Color.white) {
            Color saveFg = g.getColor();
            g.setColor(bgColor);
            g.fillRect(x, y, width, height);
            g.setColor(saveFg);
        }
    }

    @Override
    public void paint(Graphics g, Shape a) {
        if (this.m_FoldInfo == null || this.m_TMI == null) {
            return;
        }
        Shape originalA = a;
        Rectangle alloc = (Rectangle)a;
        this.tabBase = alloc.x;
        CodeEditorPane host = (CodeEditorPane)this.getContainer();
        this.m_AttrMap = host.getElementAttributeMap();
        g.setFont(host.getFont());
        this.sel0 = host.getSelectionStart();
        this.sel1 = host.getSelectionEnd();
        this.updateMetrics();
        Rectangle clientRect = this.getClientRect();
        int lineHeight = this.getDeviceLineHeight();
        int fontHeight = this.mMetrics.getHeight();
        int fontDescender = this.mMetrics.getDescent();
        int firstVisibleLine = this.getFirstVisibleLineNumber();
        Rectangle clip = g.getClipBounds();
        int firstScreenLineAffected = (clip.y - clientRect.y) / lineHeight;
        firstScreenLineAffected = Math.max(firstScreenLineAffected, 0);
        int lastScreenLineAffected = (clip.y - clientRect.y + clip.height) / lineHeight;
        if ((clip.y - clientRect.y + clip.height) % lineHeight == 0) {
            --lastScreenLineAffected;
        }
        lastScreenLineAffected = Math.min(lastScreenLineAffected, this.getPartiallyVisibleLineCount() - 1);
        lastScreenLineAffected = Math.max(lastScreenLineAffected, 0);
        firstScreenLineAffected = Math.min(firstScreenLineAffected, this.getPartiallyVisibleLineCount() - 1);
        int[] topLevelLines = this.m_FoldInfo.getTopLevelLines(firstVisibleLine, lastScreenLineAffected + 1);
        if (topLevelLines == null || topLevelLines.length == 0 || firstScreenLineAffected >= topLevelLines.length) {
            return;
        }
        int x = 0;
        int y = this.getYCoordForTopOfDeviceLine(firstScreenLineAffected) + clientRect.y;
        y += this.mMetrics.getAscent();
        boolean drawFoldLines = host.getCodeFolding() && host.getShowSectionLines();
        Highlighter h = host.getHighlighter();
        LayeredHighlighter dh = h instanceof LayeredHighlighter ? (LayeredHighlighter)h : null;
        for (int index = firstScreenLineAffected; index <= lastScreenLineAffected && index < topLevelLines.length; ++index) {
            int currLine = topLevelLines[index];
            Element lineElement = this.getElement(currLine);
            if (lineElement != null) {
                if (dh != null) {
                    if (currLine == ((CodeEditorDocument)this.getDocument()).getLineCount() - 1) {
                        dh.paintLayeredHighlights(g, lineElement.getStartOffset(), lineElement.getEndOffset(), originalA, host, this);
                    } else {
                        dh.paintLayeredHighlights(g, lineElement.getStartOffset(), lineElement.getEndOffset() - 1, originalA, host, this);
                    }
                }
                this.m_TMI.setTokenMap(((CodeEditorDocument)this.getDocument()).getTokenMap(), lineElement.getStartOffset());
                this.drawLine(currLine, g, x, y);
                if (drawFoldLines) {
                    boolean drawStartLine = false;
                    boolean drawEndLine = false;
                    boolean collapsed = this.m_FoldInfo.isLineCollapsed(currLine);
                    boolean isEndLine = this.m_FoldInfo.isEndLine(currLine);
                    boolean isSigLine = this.m_FoldInfo.isSignatureLine(currLine);
                    boolean isStartLine = this.m_FoldInfo.isStartLine(currLine);
                    if (isStartLine || isSigLine && collapsed) {
                        drawStartLine = true;
                    }
                    if (isEndLine || isSigLine && collapsed) {
                        drawEndLine = true;
                    }
                    if (drawStartLine || drawEndLine) {
                        int endLineY = y + Math.max(fontDescender - 1, 0);
                        int startLineY = y - this.mMetrics.getAscent() - this.mMetrics.getLeading();
                        Color origColor = g.getColor();
                        g.setColor(Color.gray);
                        if (drawStartLine) {
                            g.drawLine(0, startLineY, alloc.width, startLineY);
                        }
                        if (drawEndLine) {
                            g.drawLine(0, endLineY, alloc.width, endLineY);
                        }
                        g.setColor(origColor);
                    }
                }
            }
            y += fontHeight;
        }
    }

    public void printLine(Graphics g, int currLine, int x, int y) {
        Element map = this.getElement();
        this.m_TMI.setTokenMap(((CodeEditorDocument)this.getDocument()).getTokenMap(), map.getElement(currLine).getStartOffset());
        this.drawLine(currLine, g, x, y);
    }

    @Override
    protected void updateMetrics() {
        Container host = this.getContainer();
        Font f = host.getFont();
        if (this.baseFont != f) {
            this.baseFont = f;
            this.mMetrics = host.getFontMetrics(this.baseFont);
            this.calculateLongestLine();
        }
        this.tabSize = this.getTabSize() * this.mMetrics.charWidth('m');
    }

    public Font getDocumentFont() {
        Container host = this.getContainer();
        Font f = host.getFont();
        return f;
    }

    @Override
    protected Rectangle lineToRect(Shape a, int line) {
        Rectangle r = null;
        this.updateMetrics();
        if (this.mMetrics != null) {
            int height;
            int lineTopLevel;
            boolean isTopLevel = this.m_FoldInfo.isTopLevelLine(line);
            if (isTopLevel) {
                lineTopLevel = this.m_FoldInfo.getTopLevelLinesToLine(line);
                height = this.mMetrics.getHeight();
            } else {
                int prevTopLevel = this.m_FoldInfo.getPreviousTopLevelLine(line, 1);
                lineTopLevel = this.m_FoldInfo.getTopLevelLinesToLine(prevTopLevel) + 1;
                height = 0;
            }
            Rectangle alloc = a.getBounds();
            alloc.y += lineTopLevel * height;
            alloc.height = height;
            r = alloc;
        }
        return r;
    }

    protected void calculateLongestLine() {
        Element lines = this.getElement();
        int n = lines.getElementCount();
        int maxWidth = -1;
        for (int i = 0; i < n; ++i) {
            Element line = lines.getElement(i);
            int w = this.getLineWidth(line);
            if (w <= maxWidth) continue;
            maxWidth = w;
            this.longLine = line;
        }
    }

    protected int getLineWidth(Element line) {
        if (this.mMetrics == null) {
            return 0;
        }
        int p0 = line.getStartOffset();
        int p1 = line.getEndOffset();
        int w = 0;
        try {
            Document doc = line.getDocument();
            doc.getText(p0, p1 - p0, this.getLineBuffer());
            TokenMapInterface tm = null;
            if (doc instanceof CodeEditorDocument) {
                tm = ((CodeEditorDocument)doc).getTokenMap();
            }
            if (tm != null) {
                w = TokenMap.getTabbedTextWidth(this.getLineBuffer(), this.mMetrics, this.tabBase, p0, this, tm);
            }
            if (tm == null || w == -1) {
                w = Utilities.getTabbedTextWidth(this.getLineBuffer(), this.mMetrics, this.tabBase, (TabExpander)this, p0);
            }
        }
        catch (BadLocationException ble) {
            w = 0;
        }
        return w;
    }

    @Override
    public float nextTabStop(float x, int tabOffset) {
        if (this.tabSize == 0) {
            return x;
        }
        int ntabs = ((int)x - this.tabBase) / this.tabSize;
        return this.tabBase + (ntabs + 1) * this.tabSize;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Document doc = this.getDocument();
        int lineIndex = ((CodeEditorDocument)this.getDocument()).getLineForOffset(pos);
        Rectangle lineArea = this.lineToRect(a, lineIndex);
        boolean isTopLevel = this.m_FoldInfo.isTopLevelLine(lineIndex);
        this.tabBase = lineArea.x;
        Element line = this.getElement(lineIndex);
        int p0 = line.getStartOffset();
        doc.getText(p0, pos - p0, this.getLineBuffer());
        int xOffs = 0;
        TokenMapInterface tm = ((CodeEditorDocument)doc).getTokenMap();
        if (tm != null) {
            xOffs = TokenMap.getTabbedTextWidth(this.getLineBuffer(), this.mMetrics, this.tabBase, p0, this, tm);
        }
        if (tm == null || xOffs < 1) {
            xOffs = Utilities.getTabbedTextWidth(this.getLineBuffer(), this.mMetrics, this.tabBase, (TabExpander)this, p0);
        }
        lineArea.x += xOffs;
        lineArea.width = 1;
        lineArea.height = isTopLevel ? this.mMetrics.getHeight() : 0;
        return lineArea;
    }

    protected Element getElement(int index) {
        return this.getDocument().getDefaultRootElement().getElement(index);
    }

    @Override
    public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
        int topLevelLineCount;
        bias[0] = Position.Bias.Forward;
        Rectangle alloc = a.getBounds();
        Document doc = this.getDocument();
        int x = (int)fx;
        int y = (int)fy;
        if (y < alloc.y) {
            int firstTopLevel = this.m_FoldInfo.getFirstTopLevelLine();
            Element line = this.getElement(firstTopLevel);
            return line.getStartOffset();
        }
        if (y > alloc.y + alloc.height) {
            int lastTopLevel = this.m_FoldInfo.getLastTopLevelLine();
            Element line = this.getElement(lastTopLevel);
            return line.getEndOffset() - 1;
        }
        int topLevelLineIndex = Math.abs((y - alloc.y) / this.mMetrics.getHeight());
        if (topLevelLineIndex >= (topLevelLineCount = this.m_FoldInfo.getTopLevelLineCount())) {
            int lineIndex = this.m_FoldInfo.getLastTopLevelLine();
            Element line = this.getElement(lineIndex);
            return line.getEndOffset() - 1;
        }
        int lineIndex = this.m_FoldInfo.getNthTopLevelLine(topLevelLineIndex + 1);
        Element line = this.getElement(lineIndex);
        if (x < alloc.x) {
            return line.getStartOffset();
        }
        if (x > alloc.x + alloc.width) {
            return line.getEndOffset() - 1;
        }
        try {
            int p0 = line.getStartOffset();
            int p1 = line.getEndOffset() - 1;
            doc.getText(p0, p1 - p0, this.getLineBuffer());
            this.tabBase = alloc.x;
            int offs = p0 + Utilities.getTabbedTextOffset(this.getLineBuffer(), this.mMetrics, this.tabBase, x, this, p0);
            return offs;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        switch (axis) {
            case 0: {
                return this.getLineWidth(this.longLine) + 5;
            }
            case 1: {
                int lineHeight = this.mMetrics.getHeight();
                int totalLines = this.m_FoldInfo.getTopLevelLineCount();
                int span = totalLines * lineHeight;
                JViewport vp = null;
                CodeEditorPane host = (CodeEditorPane)this.getContainer();
                Container c = host.getParent();
                if (c instanceof JViewport) {
                    vp = (JViewport)c;
                    Rectangle r = vp.getViewRect();
                    span = (int)((double)span + Math.max(0.0, r.getHeight() - (double)lineHeight));
                }
                return span;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    @Override
    public int getNextVisualPositionFrom(int offset1, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        CodeEditorPane host = (CodeEditorPane)this.getContainer();
        CodeEditorDocument doc = host.getCodeEditorDocument();
        ViewFoldInfo vfi = host.getViewFoldInfo();
        int line1 = doc.getLineForOffset(offset1);
        switch (direction) {
            case 1: 
            case 5: {
                int offset2 = offset1;
                if (direction == 5 && vfi.getLastTopLevelLine() == line1) {
                    return offset1;
                }
                if (direction == 1 && vfi.getFirstTopLevelLine() == line1) {
                    return offset1;
                }
                while (!vfi.isTopLevelLine(doc.getLineForOffset(offset2 = super.getNextVisualPositionFrom(offset2, b, a, direction, biasRet))) && offset2 >= 0) {
                }
                if (offset2 == -1) {
                    int lineLength;
                    int line2 = doc.getLineForOffset(offset1);
                    int gotoVisibleLine = direction == 1 ? vfi.getPreviousTopLevelLine(line2, 1) : vfi.getNextTopLevelLine(line2, 1);
                    int lineOffset = offset1 - doc.getCurrentLineStartOffset(offset1);
                    if (lineOffset > (lineLength = doc.getLineLength(gotoVisibleLine) - 1)) {
                        lineOffset = lineLength;
                    }
                    offset2 = doc.getStartOffsetForLine(gotoVisibleLine) + lineOffset;
                }
                return offset2;
            }
            case 3: {
                int offset2 = offset1 + 1;
                int line2 = doc.getLineForOffset(offset2);
                if (line1 == line2 || !vfi.isLineCollapsed(line2)) break;
                int lastVisLine = vfi.getLastTopLevelLine();
                if (line1 == lastVisLine) {
                    return offset1;
                }
                line2 = vfi.getNextTopLevelLine(line1, 1);
                offset2 = doc.getStartOffsetForLine(line2);
                return offset2;
            }
            case 7: {
                int offset2 = offset1 - 1;
                int line2 = doc.getLineForOffset(offset2);
                if (line1 == line2 || !vfi.isLineCollapsed(line2)) break;
                int firstVisLine = vfi.getFirstTopLevelLine();
                if (line1 == firstVisLine) {
                    return offset1;
                }
                line2 = vfi.getPreviousTopLevelLine(line1, 1);
                offset2 = doc.getStartOffsetForLine(line2);
                return offset2 += doc.getLineLength(line2) - 1;
            }
        }
        return super.getNextVisualPositionFrom(offset1, b, a, direction, biasRet);
    }

    @Override
    protected void updateDamage(DocumentEvent changes, Shape a, ViewFactory f) {
        Element[] removed;
        Container host = this.getContainer();
        this.updateMetrics();
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec = changes.getChange(elem);
        Element[] added = ec != null ? ec.getChildrenAdded() : null;
        Element[] elementArray = removed = ec != null ? ec.getChildrenRemoved() : null;
        if (added != null && added.length > 0 || removed != null && removed.length > 0) {
            if (added != null) {
                int currWide = this.getLineWidth(this.longLine);
                for (int i = 0; i < added.length; ++i) {
                    int w = this.getLineWidth(added[i]);
                    if (w <= currWide) continue;
                    currWide = w;
                    this.longLine = added[i];
                }
            }
            if (removed != null) {
                for (int i = 0; i < removed.length; ++i) {
                    if (removed[i] != this.longLine) continue;
                    this.calculateLongestLine();
                    break;
                }
            }
            this.preferenceChanged(null, true, true);
            JScrollPane scrollPane = ((CodeEditorPane)this.getContainer()).getScrollPane();
            if (scrollPane != null) {
                scrollPane.getRowHeader().invalidate();
            }
            host.repaint();
        } else {
            Element map = this.getElement();
            int startLine = map.getElementIndex(changes.getOffset());
            int endLine = map.getElementIndex(changes.getOffset() + changes.getLength());
            this.damageLineRange(startLine, endLine, a, host);
            if (changes.getType() == DocumentEvent.EventType.INSERT) {
                int w = this.getLineWidth(this.longLine);
                Element e = this.getElement(startLine);
                if (e == this.longLine) {
                    this.preferenceChanged(null, true, false);
                } else if (this.getLineWidth(e) > w) {
                    this.longLine = e;
                    this.preferenceChanged(null, true, false);
                }
            } else if (changes.getType() == DocumentEvent.EventType.REMOVE && this.getElement(startLine) == this.longLine) {
                this.calculateLongestLine();
                this.preferenceChanged(null, true, false);
            }
        }
    }

    @Override
    protected void damageLineRange(int line0, int line1, Shape a, Component host) {
        if (a != null) {
            Rectangle area0 = this.lineToRect(a, line0);
            Rectangle area1 = this.lineToRect(a, line1);
            if (area0 != null && area1 != null) {
                Rectangle damage = area0.union(area1);
                host.repaint(damage.x, damage.y, damage.width, damage.height);
            } else {
                host.repaint();
            }
        }
    }

    public Rectangle getVisibleEditorRect() {
        CodeEditorPane editor = (CodeEditorPane)this.getContainer();
        Rectangle alloc = editor.getBounds();
        if (alloc.width > 0 && alloc.height > 0) {
            alloc.y = 0;
            alloc.x = 0;
            Insets insets = editor.getInsets();
            alloc.x += insets.left;
            alloc.y += insets.top;
            alloc.width -= insets.left + insets.right;
            alloc.height -= insets.top + insets.bottom;
            return alloc;
        }
        return null;
    }

    public int[] getVisibleLines() {
        int firstLine = this.getFirstVisibleLineNumber();
        int[] topLevelLines = this.m_FoldInfo.getTopLevelLines(firstLine, this.getPartiallyVisibleLineCount());
        return topLevelLines;
    }

    public int getDeviceLineHeight() {
        return this.mMetrics.getHeight();
    }

    public int getYCoordForTopOfDeviceLine(int screenLine) {
        if (this.getPartiallyVisibleLineCount() == 0) {
            return -1;
        }
        int ycoord = screenLine * this.getDeviceLineHeight();
        return ycoord;
    }

    public int getYCoordForBottomOfDeviceLine(int screenLine) {
        if (this.getPartiallyVisibleLineCount() == 0) {
            return -1;
        }
        int ycoord = this.getYCoordForTopOfDeviceLine(screenLine);
        ycoord += this.getDeviceLineHeight();
        ycoord = Math.min(ycoord, this.getClientHeight());
        return ycoord;
    }

    public int getClientHeight() {
        CodeEditorPane host = (CodeEditorPane)this.getContainer();
        Container c = host.getParent();
        if (c instanceof JViewport) {
            JViewport vp = null;
            vp = (JViewport)c;
            return vp.getHeight();
        }
        return 0;
    }

    public int getClientYCoord() {
        CodeEditorPane host = (CodeEditorPane)this.getContainer();
        Container c = host.getParent();
        if (c instanceof JViewport) {
            JViewport vp = null;
            vp = (JViewport)c;
            Component v = vp.getView();
            if (v != null) {
                return v.getY();
            }
        }
        return 0;
    }

    public Rectangle getClientRect() {
        CodeEditorPane host = (CodeEditorPane)this.getContainer();
        Container c = host.getParent();
        if (c instanceof JViewport) {
            JViewport vp = null;
            vp = (JViewport)c;
            Rectangle r = vp.getViewRect();
            return r;
        }
        return null;
    }

    public int getPartiallyVisibleLineCount() {
        int clientHeight = this.getClientHeight();
        int partialAdd = clientHeight % this.mMetrics.getHeight() == 0 ? 0 : 1;
        return clientHeight / this.mMetrics.getHeight() + partialAdd;
    }

    public int getFullyVisibleLineCount() {
        int clientHeight = this.getClientHeight();
        return clientHeight / this.mMetrics.getHeight();
    }

    public int getLastVisibleLineNumber() {
        int lastLine = this.getFirstVisibleLineNumber();
        lastLine = this.m_FoldInfo.getNextTopLevelLine(lastLine, this.getPartiallyVisibleLineCount() - 1);
        return lastLine;
    }

    public int getFirstVisibleLineNumber() {
        Rectangle clientRect = this.getVisibleEditorRect();
        Position.Bias[] biasRet = new Position.Bias[1];
        CodeEditorPane editorPane = (CodeEditorPane)this.getContainer();
        int x = -editorPane.getX();
        int y = -editorPane.getY();
        int charOffset = this.viewToModel(x, y, clientRect, biasRet);
        int line = ((CodeEditorDocument)this.getDocument()).getLineForOffset(charOffset);
        return line;
    }

    protected Color setGraphicsForCurrentToken(Graphics g, TokenMapIterator tmi, boolean bSelected, int offset) {
        Color bg;
        Color fg;
        AttributeSet attrs = null;
        TokenInfo ti = null;
        if (tmi != null && (ti = tmi.getTokenInfo()) != null) {
            attrs = this.m_AttrMap.getElementAttributes(ti.getTokenType());
        }
        if (attrs != null) {
            CodeEditorDocument doc;
            fg = StyleConstants.getForeground(attrs);
            bg = StyleConstants.getBackground(attrs);
            if (this.m_AttrMap.isUsingSingleBgColor()) {
                bg = null;
            }
            if ((doc = (CodeEditorDocument)this.getDocument()).getEditableRegion() != null && doc.isInReadonlyRegion(offset)) {
                fg = doc.getReadonlyFgColor();
                bg = doc.getReadonlyBgColor();
            }
            boolean bold = StyleConstants.isBold(attrs);
            boolean italic = StyleConstants.isItalic(attrs);
        } else {
            fg = SystemColor.windowText;
            bg = SystemColor.window;
            boolean bold = false;
            boolean italic = false;
        }
        Font f = null;
        f = attrs != null ? (Font)attrs.getAttribute("Font") : ((CodeEditorPane)this.getContainer()).getFont();
        g.setFont(f);
        if (fg != null) {
            Color useFg;
            if (bSelected) {
                useFg = new Color(255 - fg.getRed(), 255 - fg.getGreen(), 255 - fg.getBlue());
                bg = ((CodeEditorPane)this.getContainer()).getSelectionColor();
            } else {
                useFg = fg;
            }
            g.setColor(useFg);
        }
        return bg;
    }
}

