/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditor;
import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorLinePrintData;
import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorView;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;

public class CodeEditorPrintManager
implements Printable {
    private PrintRequestAttributeSet mPrinterSettings;
    private CodeEditorPane mPane;
    private Font font;
    private int lineSpacing;
    private int linesPerPage;
    private List mLineStarts;
    private int mLineNumberWidth;
    private int numPages;
    private int baseline = -1;
    protected CodeEditorDefaults defaults;
    public static float LINESPACEFACTOR = 1.1f;
    protected boolean bCodeFolding = false;

    public CodeEditorPrintManager(CodeEditorPane pane) {
        this.initialize(pane);
    }

    public void initialize(CodeEditorPane p) {
        this.mPane = p;
        this.defaults = ((CodeEditor)this.mPane.getScrollPane()).getDefaults();
        this.mPrinterSettings = this.defaults.loadPrinterFormat();
    }

    public void cleanup() {
    }

    public void resetState() {
        this.mLineStarts = null;
        this.numPages = 0;
        this.mLineNumberWidth = 0;
        this.bCodeFolding = false;
    }

    public void printDlg() {
        PrinterJob job = PrinterJob.getPrinterJob();
        this.resetState();
        if (!this.validatePrinter(job)) {
            return;
        }
        job.setPrintable(this);
        try {
            HashPrintRequestAttributeSet currentSettings = new HashPrintRequestAttributeSet(this.mPrinterSettings);
            if (job.printDialog(currentSettings)) {
                job.print(currentSettings);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.resetState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCodeFolding(boolean bShowDialog) {
        this.resetState();
        this.bCodeFolding = true;
        PrinterJob job = PrinterJob.getPrinterJob();
        if (!this.validatePrinter(job)) {
            return;
        }
        job.setPrintable(this);
        try {
            HashPrintRequestAttributeSet currentSettings = new HashPrintRequestAttributeSet(this.mPrinterSettings);
            if (bShowDialog && job.printDialog(currentSettings)) {
                job.print(currentSettings);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.resetState();
        }
    }

    public void print() {
        this.resetState();
        PrinterJob job = PrinterJob.getPrinterJob();
        if (!this.validatePrinter(job)) {
            return;
        }
        job.setPrintable(this);
        try {
            job.print(this.mPrinterSettings);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.resetState();
        }
    }

    public void pageSetupDlg() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat format = job.pageDialog(this.mPrinterSettings);
        if (format != null) {
            this.defaults.savePageFormat(format);
        }
        job.setPrintable(this);
    }

    @Override
    public int print(Graphics graphics, PageFormat format, int pagenum) {
        this.setup(graphics, format);
        if (pagenum < 0 || pagenum >= this.numPages) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setColor(Color.white);
        g2.fillRect((int)format.getImageableX(), (int)format.getImageableY(), (int)format.getImageableWidth(), (int)format.getImageableHeight());
        g2.setFont(this.font);
        g2.setColor(Color.black);
        int startIndex = pagenum * this.linesPerPage;
        int endIndex = Math.min(startIndex + this.linesPerPage, this.mLineStarts.size());
        int x0 = (int)format.getImageableX();
        int y0 = (int)format.getImageableY() + this.baseline;
        CodeEditorView view = this.mPane.getView();
        for (int i = startIndex; i < endIndex; ++i) {
            CodeEditorLinePrintData printData = (CodeEditorLinePrintData)this.mLineStarts.get(i);
            if (printData.mLineNumber > 0 && this.mLineNumberWidth > 0) {
                g2.setFont(this.font);
                g2.setColor(Color.black);
                FontMetrics metrics = g2.getFontMetrics();
                String strLineNum = String.valueOf(printData.mLineNumber);
                int lineIndent = x0 + this.mLineNumberWidth - 10 - metrics.stringWidth(strLineNum);
                g2.drawString(strLineNum, lineIndent, y0);
            }
            view.drawToPrinter(graphics, printData.mStartOffset, printData.mEndOffset, x0 + this.mLineNumberWidth, y0);
            y0 += this.lineSpacing;
        }
        return 0;
    }

    public void setup(Graphics g, PageFormat format) {
        this.font = this.mPane.getFont();
        if (this.mLineStarts == null) {
            FontMetrics fm = g.getFontMetrics(this.font);
            if (this.mPane.isLineNumbers()) {
                int lineCount = this.mPane.getView().getDocument().getDefaultRootElement().getElementCount();
                int digits = 0;
                while (lineCount > 0) {
                    lineCount /= 10;
                    ++digits;
                }
                StringBuffer digitString = new StringBuffer();
                for (int i = 0; i < digits; ++i) {
                    digitString.append('9');
                }
                int numberWidth = fm.stringWidth(digitString.toString());
                this.mLineNumberWidth = numberWidth + 10;
            } else {
                this.mLineNumberWidth = 0;
            }
            this.mLineStarts = new ArrayList();
            this.mPane.getView().cachePrintInfo(g, this.bCodeFolding, (int)format.getImageableWidth() - this.mLineNumberWidth, this.mLineStarts);
            this.lineSpacing = (int)((float)fm.getHeight() * LINESPACEFACTOR);
            this.linesPerPage = (int)Math.floor(format.getImageableHeight() / (double)this.lineSpacing);
            this.numPages = (int)Math.ceil((double)this.mLineStarts.size() / (double)this.linesPerPage);
            this.baseline = fm.getAscent();
        }
    }

    public void setPageFormat(PageFormat pf) {
    }

    public boolean validatePrinter(PrinterJob job) {
        PrintService serv = job.getPrintService();
        if (serv == null) {
            job.pageDialog(this.mPrinterSettings);
            this.defaults.savePrinterFormat(this.mPrinterSettings);
            serv = job.getPrintService();
            return serv != null;
        }
        return true;
    }
}

