/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.AttributeMap;
import com.sas.editor.CodeBlock;
import com.sas.editor.CodeEditor;
import com.sas.editor.CodeEditorAttributeManager;
import com.sas.editor.CodeEditorCaret;
import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorDocument;
import com.sas.editor.CodeEditorKeyManager;
import com.sas.editor.CodeEditorKit;
import com.sas.editor.CodeEditorResource;
import com.sas.editor.CodeEditorSchemeManager;
import com.sas.editor.CodeEditorView;
import com.sas.editor.CodeLanguage;
import com.sas.editor.FindDialog;
import com.sas.editor.GoToLineDialog;
import com.sas.editor.LineOffsets;
import com.sas.editor.LogListViewer;
import com.sas.editor.PreferenceChangeListener;
import com.sas.editor.border.BorderManager;
import com.sas.editor.language.ViewFoldInfo;
import com.sas.swing.visuals.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Utilities;
import javax.swing.text.View;

public class CodeEditorPane
extends JEditorPane
implements PopupMenuListener,
PreferenceChangeListener,
FocusListener {
    JMenuItem cut;
    JMenuItem copy;
    private WindowListener mShutdownListener = new ShutdownListener();
    JMenuItem paste;
    JMenuItem selectall;
    JMenuItem clearall;
    JMenuItem coloron;
    JMenuItem coloroff;
    JMenuItem undo;
    JMenuItem redo;
    JMenuItem find;
    JMenuItem gotoline;
    protected JPopupMenu m_popupMenu;
    protected static FindDialog mFindDialog = null;
    protected static boolean mFindDialogAutoClosed = false;
    protected static Point mFindDialogPosition = null;
    protected static boolean mFindDialogOpening = false;
    protected static List mFindHistory = new ArrayList();
    protected static List mReplaceHistory = new ArrayList();
    protected static int mFindHistorySize = 20;
    protected static Dimension mFindDialogSize = null;
    protected boolean mIsDead = false;
    protected boolean mLineWrap;
    private static final JTextComponent.KeyBinding[] defaultBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(90, 2), "undo"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(89, 2), "redo"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(70, 2), "find-dialog"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(71, 2), "goto-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(91, 2), "match-braces"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(93, 2), "match-braces"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(57, 2), "match-braces"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(48, 2), "match-braces"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(91, 8), "match-do-end"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(93, 8), "match-do-end"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(57, 8), "match-do-end"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(48, 8), "match-do-end"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(68, 2), "delete-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(127, 2), "delete-next-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(8, 2), "delete-previous-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(67, 2), "copy-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(88, 2), "cut-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(86, 2), "paste-from-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(65, 2), "select-all"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(9, 0), "block-indent"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(9, 1), "block-unindent"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(47, 2), "block-comment"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(47, 3), "block-uncomment"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(114, 2), "find-next"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(114, 3), "find-previous"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(82, 3), "toggle read-only"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(76, 3), "make lower-case"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(85, 3), "make upper-case"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(109, 8), "collapse-block"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(107, 8), "expand-block"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(106, 8), "toggle-collapse-expand"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(109, 10), "collapse-all"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(107, 10), "expand-all"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(39, 2), "goto-next-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(39, 3), "select-next-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(37, 2), "goto-previous-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(37, 3), "select-previous-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(80, 2), "print"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(112, 0), "help")};
    private static final JTextComponent.KeyBinding[] standardBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(8, 0), "delete-previous"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(10, 0), "insert-break"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(33, 1), "selection-page-up"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(33, 0), "page-up"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(33, 2), "caret-begin"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(33, 3), "selection-begin"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(34, 1), "selection-page-down"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(34, 0), "page-down"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(34, 2), "caret-end"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(34, 3), "selection-end"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(35, 0), "caret-end-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(35, 3), "selection-end"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(35, 2), "caret-end"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(35, 1), "selection-end-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(36, 0), "caret-begin-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(36, 2), "caret-begin"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(36, 3), "selection-begin"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(36, 1), "selection-begin-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(37, 0), "caret-backward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(37, 1), "selection-backward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(226, 0), "caret-backward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(38, 0), "caret-up"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(38, 1), "selection-up"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(224, 0), "caret-up"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(39, 1), "selection-forward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(39, 0), "caret-forward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(227, 0), "caret-forward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(40, 1), "selection-down"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(40, 0), "caret-down"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(225, 0), "caret-down"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(72, 2), "delete-previous"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(92, 2), "unselect"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(127, 0), "delete-next"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(127, 1), "cut-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(155, 2), "copy-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(155, 1), "paste-from-clipboard")};
    private boolean m_bDoNotCheckSavedContents = false;
    private boolean m_bConstructionComplete = false;
    protected JPopupMenu popup;
    private JScrollPane m_ScrollPane;
    private BorderManager m_BorderManager;
    private int m_LineSelectionInitialStartOffset;
    private int m_LineSelectionInitialEndOffset;
    protected CodeEditorResource resource = new CodeEditorResource(CodeEditorPane.class);
    protected CodeEditorDefaults defaults;
    public CodeEditorKeyManager keyManager;
    protected boolean m_CodeFolding;

    public JTextComponent.KeyBinding[] getStandardKeyBindings() {
        return standardBindings;
    }

    private CodeEditorPane() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.addFocusListener(this);
        this.setCaret(new CodeEditorCaret());
        this.setCaretColor(Color.black);
        this.setSelectionColor(new Color(0, 0, 128));
        this.cut = new JMenuItem(this.getActionMap().get("cut-to-clipboard"));
        this.copy = new JMenuItem(this.getActionMap().get("copy-to-clipboard"));
        this.paste = new JMenuItem(this.getActionMap().get("paste-from-clipboard"));
        this.selectall = new JMenuItem(this.getActionMap().get("select-all"));
        this.clearall = new JMenuItem(this.getActionMap().get("clear-all"));
        this.coloron = new JMenuItem(this.getActionMap().get("enable-coloring"));
        this.coloroff = new JMenuItem(this.getActionMap().get("disable-coloring"));
        this.undo = new JMenuItem(this.getActionMap().get("undo"));
        this.redo = new JMenuItem(this.getActionMap().get("redo"));
        this.find = new JMenuItem(this.getActionMap().get("find-dialog"));
        this.gotoline = new JMenuItem(this.getActionMap().get("goto-line"));
        this.CreatePopupMenu();
        this.m_bConstructionComplete = true;
    }

    CodeEditorPane(JScrollPane scrollPane) {
        this();
        this.m_ScrollPane = scrollPane;
        this.m_BorderManager = new BorderManager(this, this.m_ScrollPane);
        this.InitializeDefaults();
    }

    protected void setupIcons() {
        URL imageURL;
        Action action = this.getActionMap().get("cut-to-clipboard");
        if (action != null) {
            imageURL = this.getClass().getResource("Cut.gif");
            action.putValue("SmallIcon", new ImageIcon(imageURL));
        }
        if ((action = this.getActionMap().get("paste-from-clipboard")) != null) {
            imageURL = this.getClass().getResource("Paste.gif");
            action.putValue("SmallIcon", new ImageIcon(imageURL));
        }
        if ((action = this.getActionMap().get("copy-to-clipboard")) != null) {
            imageURL = this.getClass().getResource("Copy.gif");
            action.putValue("SmallIcon", new ImageIcon(imageURL));
        }
        if ((action = this.getActionMap().get("undo")) != null) {
            imageURL = this.getClass().getResource("Undo.gif");
            action.putValue("SmallIcon", new ImageIcon(imageURL));
        }
        if ((action = this.getActionMap().get("redo")) != null) {
            imageURL = this.getClass().getResource("Redo.gif");
            action.putValue("SmallIcon", new ImageIcon(imageURL));
        }
        imageURL = this.getClass().getResource("Blank.gif");
        Object[] actionKeys = this.getActionMap().allKeys();
        if (actionKeys != null) {
            for (int i = 0; i < actionKeys.length; ++i) {
                action = this.getActionMap().get(actionKeys[i]);
                if (action == null || action.getValue("SmallIcon") != null) continue;
                action.putValue("SmallIcon", new ImageIcon(imageURL));
            }
        }
    }

    protected void InitializeDefaults() {
        this.setLineWrap(false);
        this.defaults = ((CodeEditor)this.m_ScrollPane).getDefaults();
        this.getCodeEditorDocument().setupDefaults(this.defaults);
        this.defaults.addPreferenceChangeListener(this);
        this.setBackground(SystemColor.window);
        this.setupIcons();
        Font f = this.defaults.getFont(this.getCodeEditorDocument().getLanguage().getID());
        if (f == null) {
            f = CodeEditorSchemeManager.PREDEFINED_FONT;
        }
        this.setFont(f);
        this.setupKeymap();
        this.setCodeFolding(this.defaults.getCodeFoldingEnabled());
        this.setLineNumbers(this.defaults.getShowLineNumbers());
        this.EnableDocumentColoring(this.defaults.getDocumentColoring());
        this.m_BorderManager.createBorder();
        this.setSingleBgColor();
    }

    public BorderManager getBorderManager() {
        return this.m_BorderManager;
    }

    public boolean getCodeFolding() {
        return this.m_CodeFolding;
    }

    public boolean getShowSectionLines() {
        return this.defaults.getShowSectionLines();
    }

    public boolean getShowSectionBrackets() {
        return this.defaults.getShowSectionBrackets();
    }

    public void setCodeFolding(boolean b) {
        if (this.getLanguage().getID() != CodeLanguage.SAS.getID()) {
            b = false;
        }
        this.m_CodeFolding = b;
        this.getViewFoldInfo().setFoldingStatus(this.m_CodeFolding);
        this.m_BorderManager.setCodeFolding(this.m_CodeFolding);
    }

    public void setBorderColor(Color backgroundColor) {
        this.m_BorderManager.setBackgroundColor(backgroundColor);
    }

    public CodeEditorDocument getCodeEditorDocument() {
        return (CodeEditorDocument)this.getDocument();
    }

    public JScrollPane getScrollPane() {
        return this.m_ScrollPane;
    }

    public JTextComponent.KeyBinding[] getKeyBindings() {
        return defaultBindings;
    }

    public CodeEditorKeyManager getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(CodeEditorKeyManager manager) {
        this.keyManager = manager;
    }

    public void setReadOnly(boolean b) {
        this.setEditable(!b);
    }

    public boolean isReadOnly() {
        return !this.isEditable();
    }

    public void setLineNumbers(boolean bLineNumbers) {
        this.m_BorderManager.setLineNumbers(bLineNumbers);
    }

    public void setLogListLineNumbers(boolean bLineNumbers) {
        this.m_BorderManager.setLogListLineNumbers(bLineNumbers);
        this.repaint();
    }

    public boolean isLineNumbers() {
        return this.m_BorderManager.isLineNumbers();
    }

    protected void CreatePopupMenu() {
        this.popup = new JPopupMenu(this.resource.getString("CodeEditorPane.PopupMenuTitle.txt"));
        this.popup.add(this.undo);
        this.popup.add(this.redo);
        this.popup.addSeparator();
        this.popup.add(this.cut);
        this.popup.add(this.copy);
        this.popup.add(this.paste);
        this.popup.addSeparator();
        this.popup.add(this.selectall);
        this.popup.add(this.clearall);
        this.add(this.popup);
        this.enableEvents(16L);
        this.popup.addPopupMenuListener(this);
        this.m_popupMenu = this.popup;
    }

    protected void removePopupMenu() {
        if (this.m_popupMenu != null) {
            this.m_popupMenu.removeAll();
            this.m_popupMenu.removePopupMenuListener(this);
            this.m_popupMenu = null;
        }
    }

    public JPopupMenu getPopupMenu() {
        this.FixupPopupMenu();
        return this.m_popupMenu;
    }

    protected void updateMenuItemLabel(JMenuItem menuItem, String resourceName) {
        KeyStroke[] keystrokes = this.getKeymap().getKeyStrokesForAction(menuItem.getAction());
        String actionItem = this.resource.getString(resourceName);
        String actionText = Util.getLabelWithoutMnemonic((String)actionItem);
        if (keystrokes != null && keystrokes.length > 0) {
            menuItem.setAccelerator(keystrokes[0]);
        }
        menuItem.setText(actionText);
        int index = Util.getDisplayedMnemonicIndex((String)actionItem);
        if (index > -1) {
            menuItem.setMnemonic(Util.getDisplayedMnemonic((String)actionItem));
            menuItem.setDisplayedMnemonicIndex(index);
        }
    }

    protected void FixupPopupMenu() {
        this.updateMenuItemLabel(this.cut, "CodeEditorPane.MenuItemCut.txt");
        this.updateMenuItemLabel(this.copy, "CodeEditorPane.MenuItemCopy.txt");
        this.updateMenuItemLabel(this.paste, "CodeEditorPane.MenuItemPaste.txt");
        this.updateMenuItemLabel(this.selectall, "CodeEditorPane.MenuItemSelectAll.txt");
        this.updateMenuItemLabel(this.clearall, "CodeEditorPane.MenuItemClearAll.txt");
        this.updateMenuItemLabel(this.coloron, "CodeEditorPane.MenuItemColorOn.txt");
        this.updateMenuItemLabel(this.coloroff, "CodeEditorPane.MenuItemColorOff.txt");
        this.updateMenuItemLabel(this.undo, "CodeEditorPane.MenuItemUndo.txt");
        this.updateMenuItemLabel(this.redo, "CodeEditorPane.MenuItemRedo.txt");
    }

    @Override
    public void updateUI() {
        if (this.getCodeEditorDocument() != null) {
            String data = this.getText();
            super.updateUI();
            this.setText(data);
        } else {
            super.updateUI();
        }
    }

    @Override
    public void setDocument(Document doc) {
        if (!this.m_bConstructionComplete) {
            super.setDocument(doc);
        } else if (doc instanceof CodeEditorDocument) {
            super.setDocument(doc);
            CodeEditorDocument xDoc = (CodeEditorDocument)doc;
            this.setLanguage(xDoc.getLanguage());
        } else {
            throw new IllegalArgumentException("Model must be a CodeEditorDocument");
        }
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return new CodeEditorKit();
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger() && this.popup != null) {
            this.requestFocus();
            PopupLauncher launcher = new PopupLauncher(e, this);
            SwingUtilities.invokeLater(launcher);
        }
        super.processMouseEvent(e);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int increment = 0;
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        increment = orientation == 0 ? metrics.charWidth('0') : metrics.getHeight();
        return increment;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int increment = 0;
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        if (orientation == 0) {
            int charSize = metrics.charWidth('0');
            int totChars = visibleRect.width / charSize - 1;
            increment = totChars * charSize;
        } else {
            int charSize = metrics.getHeight();
            int totChars = visibleRect.height / charSize - 1;
            increment = totChars * charSize;
        }
        return increment;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.FixupPopupMenu();
        this.cut.setEnabled(((CodeEditor)this.m_ScrollPane).canCut());
        this.copy.setEnabled(((CodeEditor)this.m_ScrollPane).canCopy());
        this.paste.setEnabled(((CodeEditor)this.m_ScrollPane).canPaste());
        this.selectall.setEnabled(this.getCodeEditorDocument().getLength() > 0);
        boolean bEnableClearAll = true;
        bEnableClearAll = ((CodeEditor)this.m_ScrollPane).canClearAll();
        this.clearall.setEnabled(bEnableClearAll);
        this.undo.setEnabled(this.canUndo());
        this.redo.setEnabled(this.canRedo());
    }

    protected void setupKeymap() {
        this.keyManager = new CodeEditorKeyManager(this);
        if (!this.keyManager.LoadKeystrokes()) {
            this.resetKeymap();
        }
    }

    protected void resetKeymap() {
        EditorKit myKit = this.getEditorKit();
        Keymap keyMap = this.getKeymap();
        keyMap.removeBindings();
        CodeEditorPane.loadKeymap(keyMap, defaultBindings, myKit.getActions());
        this.keyManager.InitializeData();
        this.keyManager.SaveKeystrokes(true);
    }

    public JTextComponent.KeyBinding[] getDefaultBindings() {
        return defaultBindings;
    }

    public void EnableDocumentColoring(boolean b) {
        CodeEditorDocument doc = this.getCodeEditorDocument();
        doc.EnableDocumentColoring(b);
    }

    public void moveCaretToEndOfDocument() {
        int endOffset;
        CodeEditorDocument doc = this.getCodeEditorDocument();
        int lastLinePos = endOffset = doc.getLength();
        this.setCaretPosition(Math.max(lastLinePos, 0));
    }

    @Override
    public void setText(String strText) {
        CodeEditorDocument doc = this.getCodeEditorDocument();
        try {
            doc.setEditableRegion(null);
            doc.clear();
            doc.insertString(0, strText, SimpleAttributeSet.EMPTY);
            doc.clearUndoStack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String getText() {
        String strText = null;
        CodeEditorDocument doc = this.getCodeEditorDocument();
        int nLength = doc.getLength();
        try {
            strText = doc.getText(0, nLength);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return strText;
    }

    public void getText(Segment segText) {
        CodeEditorDocument doc = this.getCodeEditorDocument();
        int nLength = doc.getLength();
        try {
            doc.getText(0, nLength, segText);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getLineCount() {
        return this.getCodeEditorDocument().getLineCount();
    }

    public int getCaretLine() {
        if (this.mIsDead) {
            return 0;
        }
        int caretPos = this.getCaretPosition();
        return this.getCodeEditorDocument().getCurrentLineNumber(caretPos);
    }

    public void repaintBorder() {
        if (this.m_BorderManager != null) {
            this.m_BorderManager.repaintBorder();
        }
    }

    public void borderSelectLine(MouseEvent e, int linenum) {
        CodeBlock cb;
        boolean isCollapsedSignatureLine;
        LineOffsets selLine = new LineOffsets();
        CodeEditorDocument doc = this.getCodeEditorDocument();
        boolean lineValid = doc.getLineOffsets(linenum, selLine);
        if (!lineValid) {
            return;
        }
        int blockStartLinenum = linenum;
        LineOffsets blockStartLine = null;
        boolean blockStartLineValid = false;
        int blockEndLinenum = linenum;
        LineOffsets blockEndLine = null;
        boolean blockEndLineValid = false;
        ViewFoldInfo vfi = this.getViewFoldInfo();
        boolean bl = isCollapsedSignatureLine = vfi.isSignatureLine(linenum) && vfi.isLineCollapsed(linenum);
        if (isCollapsedSignatureLine && vfi.getBlockInfo(linenum, cb = new CodeBlock())) {
            blockStartLinenum = cb.m_Start;
            blockStartLine = new LineOffsets();
            blockStartLineValid = doc.getLineOffsets(blockStartLinenum, blockStartLine);
            if (!blockStartLineValid) {
                return;
            }
            blockEndLinenum = cb.m_End;
            blockEndLine = new LineOffsets();
            blockEndLineValid = doc.getLineOffsets(blockEndLinenum, blockEndLine);
            if (!blockEndLineValid) {
                return;
            }
        }
        Caret caret = this.getCaret();
        if (e.isShiftDown()) {
            LineOffsets markLine = new LineOffsets();
            int currMark = this.getCaret().getMark();
            doc.getLineOffsetsForOffset(currMark, markLine);
            this.m_LineSelectionInitialStartOffset = markLine.mStart;
            this.m_LineSelectionInitialEndOffset = markLine.mEnd;
            if (selLine.mStart < markLine.mStart) {
                caret.setDot(markLine.mEnd);
                if (isCollapsedSignatureLine && blockStartLineValid) {
                    caret.moveDot(blockStartLine.mStart);
                } else {
                    caret.moveDot(selLine.mStart);
                }
            } else {
                caret.setDot(markLine.mStart);
                if (isCollapsedSignatureLine && blockEndLineValid) {
                    caret.moveDot(blockEndLine.mEnd);
                } else {
                    caret.moveDot(selLine.mEnd);
                }
            }
        } else {
            if (isCollapsedSignatureLine && blockStartLineValid) {
                this.m_LineSelectionInitialStartOffset = blockStartLine.mStart;
                caret.setDot(blockStartLine.mStart);
            } else {
                this.m_LineSelectionInitialStartOffset = selLine.mStart;
                caret.setDot(selLine.mStart);
            }
            if (isCollapsedSignatureLine && blockEndLineValid) {
                this.m_LineSelectionInitialEndOffset = blockEndLine.mEnd;
                caret.moveDot(blockEndLine.mEnd);
            } else {
                this.m_LineSelectionInitialEndOffset = selLine.mEnd;
                caret.moveDot(selLine.mEnd);
            }
        }
    }

    public void extendLineSelection(MouseEvent e, int linenum) {
        CodeBlock cb;
        boolean isCollapsedSignatureLine;
        CodeEditorDocument doc = this.getCodeEditorDocument();
        Caret caret = this.getCaret();
        LineOffsets currLine = new LineOffsets();
        boolean lineValid = doc.getLineOffsets(linenum, currLine);
        if (!lineValid) {
            return;
        }
        int blockStartLinenum = linenum;
        LineOffsets blockStartLine = null;
        boolean blockStartLineValid = false;
        int blockEndLinenum = linenum;
        LineOffsets blockEndLine = null;
        boolean blockEndLineValid = false;
        ViewFoldInfo vfi = this.getViewFoldInfo();
        boolean bl = isCollapsedSignatureLine = vfi.isSignatureLine(linenum) && vfi.isLineCollapsed(linenum);
        if (isCollapsedSignatureLine && vfi.getBlockInfo(linenum, cb = new CodeBlock())) {
            blockStartLinenum = cb.m_Start;
            blockStartLine = new LineOffsets();
            blockStartLineValid = doc.getLineOffsets(blockStartLinenum, blockStartLine);
            if (!blockStartLineValid) {
                return;
            }
            blockEndLinenum = cb.m_End;
            blockEndLine = new LineOffsets();
            blockEndLineValid = doc.getLineOffsets(blockEndLinenum, blockEndLine);
            if (!blockEndLineValid) {
                return;
            }
        }
        if (currLine.mEnd <= this.m_LineSelectionInitialStartOffset) {
            if (caret.getMark() != this.m_LineSelectionInitialEndOffset) {
                caret.setDot(this.m_LineSelectionInitialEndOffset);
            }
            if (isCollapsedSignatureLine && blockStartLineValid) {
                caret.moveDot(blockStartLine.mStart);
            } else {
                caret.moveDot(currLine.mStart);
            }
        } else {
            if (caret.getMark() != this.m_LineSelectionInitialStartOffset) {
                caret.setDot(this.m_LineSelectionInitialStartOffset);
            }
            if (isCollapsedSignatureLine && blockEndLineValid) {
                caret.moveDot(blockEndLine.mEnd);
            } else {
                caret.moveDot(currLine.mEnd);
            }
        }
    }

    public void extendSelection(MouseEvent e) {
        e.setSource(this);
        this.processMouseMotionEvent(e);
    }

    public void borderMouseReleased(MouseEvent e) {
        e.setSource(this);
        this.processMouseEvent(e);
    }

    public void setTabSize(int tabSize) {
        this.getCodeEditorDocument().setTabSize(tabSize);
    }

    public int getTabSize() {
        return this.getCodeEditorDocument().getTabSize();
    }

    public void setSmartIndent(boolean doIndent) {
        this.getCodeEditorDocument().setSmartIndent(doIndent);
    }

    public boolean isSmartIndent() {
        return this.getCodeEditorDocument().isSmartIndent();
    }

    boolean isDead() {
        return this.mIsDead;
    }

    public boolean checkLineSelect() {
        int end;
        if (this.mIsDead) {
            return false;
        }
        int start = this.getSelectionStart();
        if (start >= (end = this.getSelectionEnd())) {
            return false;
        }
        if (this.getCaretPosition() != end) {
            return false;
        }
        int line = this.getCodeEditorDocument().getLineForOffset(end);
        return end == this.getCodeEditorDocument().getStartOffsetForLine(line);
    }

    public boolean openFile(String strFile) throws IOException {
        CodeEditorDocument doc = this.getCodeEditorDocument();
        boolean shouldContinue = this.checkSaveContents();
        if (!shouldContinue) {
            return false;
        }
        File fStream = new File(strFile);
        if (!fStream.exists()) {
            FileNotFoundException ex = new FileNotFoundException(this.resource.getString("CodeEditorPane.FileDoesNotExistWarning.txt"));
            throw ex;
        }
        doc.doClearAll();
        if (!(this.getScrollPane() instanceof LogListViewer)) {
            this.checkLangExt(strFile);
        }
        boolean ret_val = doc.openFile(strFile);
        this.getCaret().setDot(0);
        return ret_val;
    }

    boolean openFileWithNoUI(String strFile) throws IOException {
        CodeEditorDocument doc = this.getCodeEditorDocument();
        if (!this.m_bDoNotCheckSavedContents && doc.isDocumentModified()) {
            return false;
        }
        File fStream = new File(strFile);
        if (!fStream.exists()) {
            FileNotFoundException ex = new FileNotFoundException(this.resource.getString("CodeEditorPane.FileDoesNotExistWarning.txt"));
            throw ex;
        }
        doc.doClearAll();
        if (!(this.getScrollPane() instanceof LogListViewer)) {
            this.checkLangExt(strFile);
        }
        boolean ret_val = doc.openFile(strFile);
        this.getCaret().setDot(0);
        return ret_val;
    }

    public void appendFile(String strFile) {
        CodeEditorDocument doc = this.getCodeEditorDocument();
        try {
            doc.appendFile(strFile);
        }
        catch (FileNotFoundException ex) {
            String msg = this.resource.getMessageString("CodeEditorDefaults.FileNotFound.fmt.txt", strFile);
            Object[] options = new Object[]{this.resource.getString("Common.OK.txt")};
            JOptionPane.showOptionDialog(null, msg, this.resource.getString("Common.CodeEditor.txt"), -1, 2, null, options, options[0]);
        }
        this.checkLangExt(null);
    }

    public boolean checkSaveContents() throws IOException {
        Component parent;
        if (this.m_bDoNotCheckSavedContents) {
            return true;
        }
        CodeEditorDocument doc = this.getCodeEditorDocument();
        if (!doc.isDocumentModified()) {
            return true;
        }
        if (this.isReadOnly()) {
            return true;
        }
        String filename = doc.getFilename();
        if (filename == null || filename.compareTo("") == 0) {
            filename = this.resource.getString("CodeEditorPane.DefaultFilename.txt");
        }
        String msg = this.resource.getMessageString("CodeEditorPane.SaveContents.fmt.txt", filename);
        String title = this.resource.getString("Common.CodeEditor.txt");
        int doSave = JOptionPane.showConfirmDialog(this.m_ScrollPane, msg, title, 1, 3);
        if (doSave == 0 && (parent = this.getParentFrameOrDialog()) instanceof Frame) {
            return this.save((Frame)parent);
        }
        return doSave != 2;
    }

    boolean checkSaveContentsNoUI() throws IOException {
        Component parent;
        if (this.m_bDoNotCheckSavedContents) {
            return true;
        }
        CodeEditorDocument doc = this.getCodeEditorDocument();
        if (!doc.isDocumentModified()) {
            return true;
        }
        if (this.isReadOnly()) {
            return true;
        }
        String filename = doc.getFilename();
        if (filename == null || filename.compareTo("") == 0) {
            filename = this.resource.getString("CodeEditorPane.DefaultFilename.txt");
        }
        String msg = this.resource.getMessageString("CodeEditorPane.SaveContents.fmt.txt", filename);
        String title = this.resource.getString("Common.CodeEditor.txt");
        int doSave = JOptionPane.showConfirmDialog(this.m_ScrollPane, msg, title, 1, 3);
        if (doSave == 0 && (parent = this.getParentFrameOrDialog()) instanceof Frame) {
            return this.saveFile(filename);
        }
        return doSave != 2;
    }

    public boolean saveFile(String strFile) throws IOException {
        boolean ret_val = false;
        CodeEditorDocument doc = this.getCodeEditorDocument();
        ret_val = doc.saveFile(strFile);
        if (ret_val) {
            doc.setFilename(strFile);
        }
        this.checkLangExt(null);
        return ret_val;
    }

    public void checkLangExt(String newFileName) {
        String filename = newFileName;
        if (filename == null) {
            filename = this.getCodeEditorDocument().getFilename();
        }
        Collator coll = Collator.getInstance(Locale.getDefault());
        int index = filename.lastIndexOf(".");
        String extension = filename.substring(index + 1);
        coll.setStrength(1);
        if (coll.compare(extension, "sas") == 0) {
            this.setLanguage(CodeLanguage.SAS);
        }
        if (coll.compare(extension, "html") == 0 || coll.compare(extension, "htm") == 0 || coll.compare(extension, "xml") == 0) {
            this.setLanguage(CodeLanguage.HTML);
        }
        if (coll.compare(extension, "java") == 0) {
            this.setLanguage(CodeLanguage.JAVA);
        }
    }

    public static void centerWindow(Window window) {
        Dimension size = window.getSize();
        Dimension screenSize = window.getToolkit().getScreenSize();
        window.setLocation(screenSize.width / 4 - size.width / 4, screenSize.height / 4 - size.height / 4);
    }

    public boolean dlgOpen(JFrame frame) throws IOException {
        if (frame == null) {
            frame = new JFrame();
        }
        FileDialog fd = new FileDialog((Frame)frame, this.resource.getString("CodeEditorPane.DialogOpenFile.txt"), 0);
        String dir = this.getCodeEditorDocument().getFilename();
        if (dir != null && dir.lastIndexOf(92) > 0) {
            dir = dir.substring(0, dir.lastIndexOf(92));
        }
        fd.setDirectory(dir);
        CodeEditorPane.centerWindow(fd);
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return false;
        }
        boolean ret_val = this.openFile(fd.getDirectory() + fd.getFile());
        return ret_val;
    }

    public boolean save(Frame frame) throws IOException {
        String filename = this.getCodeEditorDocument().getFilename();
        if (!this.saveFile(filename)) {
            return this.dlgSaveAs(frame);
        }
        return true;
    }

    public boolean dlgSaveAs(Frame frame) throws IOException {
        if (frame == null) {
            frame = new JFrame();
        }
        FileDialog fd = new FileDialog(frame, this.resource.getString("CodeEditorPane.DialogSaveFile.txt"), 1);
        fd.setFile(this.getCodeEditorDocument().getFilename());
        CodeEditorPane.centerWindow(fd);
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return false;
        }
        if (this.saveFile(fd.getDirectory() + fd.getFile())) {
            this.getCodeEditorDocument().setFilename(fd.getDirectory() + fd.getFile());
            this.checkLangExt(null);
            return true;
        }
        return false;
    }

    public void dlgAppend(JFrame frame) {
        if (frame == null) {
            frame = new JFrame();
        }
        FileDialog fd = new FileDialog((Frame)frame, this.resource.getString("CodeEditorPane.DialogAppendFile.txt"), 0);
        String dir = this.getCodeEditorDocument().getFilename();
        if (dir != null && dir.lastIndexOf(92) > 0) {
            dir = dir.substring(0, dir.lastIndexOf(92));
        }
        fd.setDirectory(dir);
        CodeEditorPane.centerWindow(fd);
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return;
        }
        this.appendFile(fd.getDirectory() + fd.getFile());
    }

    public static Component getParentFrameOrDialog(Component startComponent) {
        for (Component comp = startComponent; comp != null; comp = comp.getParent()) {
            if (comp instanceof Dialog) {
                return comp;
            }
            if (!(comp instanceof Frame)) continue;
            return comp;
        }
        return null;
    }

    public Component getParentFrameOrDialog() {
        Container parent = this.getParent();
        return CodeEditorPane.getParentFrameOrDialog(parent);
    }

    public void dlgFind() {
        this.dlgFind(true);
    }

    public String getSelectionUpToEndOfLine() {
        int selStart = this.getSelectionStart();
        int selEnd = this.getSelectionEnd();
        if (selEnd > selStart) {
            Element line = this.getCodeEditorDocument().getParagraphElement(selStart);
            int lastIndex = Math.min(line.getEndOffset(), selEnd);
            try {
                return this.getDocument().getText(selStart, lastIndex);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                return "";
            }
        }
        return "";
    }

    public boolean hasSelection() {
        int selStart = this.getSelectionStart();
        int selEnd = this.getSelectionEnd();
        return selEnd > selStart;
    }

    private void dlgFind(boolean initiallyFocused) {
        FindDialog findDlg = mFindDialog;
        boolean createdNew = false;
        if (mFindDialog == null) {
            findDlg = mFindDialog = FindDialog.CreateDialog(this);
            createdNew = true;
        }
        if (findDlg == null) {
            return;
        }
        if (this.hasSelection() && this.getSelectedText().indexOf(10) < 0) {
            findDlg.setText(this.getSelectedText());
        }
        findDlg.setEditor(this);
        if (createdNew) {
            findDlg.setLocationRelativeTo(null);
            findDlg.setModal(false);
        }
        if (mFindDialogPosition != null) {
            findDlg.setLocation(mFindDialogPosition);
        }
        if (mFindDialogSize != null) {
            findDlg.setSize(mFindDialogSize);
        }
        mFindDialogOpening = true;
        if (!initiallyFocused) {
            findDlg.setFocusableWindowState(false);
        }
        findDlg.setVisible(true);
        if (!initiallyFocused) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (mFindDialog != null) {
                        mFindDialog.setFocusableWindowState(true);
                    }
                }
            });
        }
        this.repaint();
    }

    static void clearFrameFindDialog() {
        mFindDialog = null;
    }

    static void markFindDialogOpened() {
        mFindDialogOpening = false;
    }

    public void dlgGoToLine() {
        GoToLineDialog gotoDlg = GoToLineDialog.CreateDialog(this);
        if (gotoDlg == null) {
            return;
        }
        int line = this.getCodeEditorDocument().getLineNumberFromOffset(this.getCaretPosition());
        gotoDlg.setText(line);
        gotoDlg.setLocationRelativeTo(null);
        gotoDlg.setVisible(true);
        this.repaint();
    }

    public void MatchBraces() {
        int originalPosition;
        int currentPosition = originalPosition = this.getCaretPosition();
        char c = this.getCodeEditorDocument().getCharAt(originalPosition);
        if (!this.getCodeEditorDocument().isMatchableChar(c)) {
            if (originalPosition == 0) {
                return;
            }
            currentPosition = originalPosition - 1;
            c = this.getCodeEditorDocument().getCharAt(currentPosition);
        }
        if (!this.getCodeEditorDocument().isMatchableChar(c)) {
            return;
        }
        int index = this.getCodeEditorDocument().findMatchingChar(c, currentPosition);
        if (index >= 0) {
            this.setCaretPosition(index);
        }
    }

    public void MatchDoEnd() {
        int index = this.getCodeEditorDocument().MatchDoEnd(this.getCaretPosition());
        if (index >= 0) {
            this.setCaretPosition(index);
        }
    }

    public AttributeMap getElementAttributeMap() {
        CodeEditorDocument doc = this.getCodeEditorDocument();
        return doc.getLanguageParser().getElementAttributeMap();
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b);
        if (!b) {
            this.setCursor(Cursor.getPredefinedCursor(2));
            this.repaint();
        }
    }

    public void setLanguage(CodeLanguage language) {
        this.getCodeEditorDocument().setLanguage(language);
        Font f = this.defaults.getFont(language.getID());
        if (f == null) {
            f = CodeEditorSchemeManager.PREDEFINED_FONT;
        }
        this.setFont(f);
        this.setCodeFolding(this.defaults.getCodeFoldingEnabled());
    }

    public CodeLanguage getLanguage() {
        return this.getCodeEditorDocument().getLanguage();
    }

    public String getFilename() {
        return this.getCodeEditorDocument().getFilename();
    }

    public void setFilename(String newFilename) {
        this.getCodeEditorDocument().setFilename(newFilename);
    }

    @Override
    public void setCaret(Caret caret) {
        super.setCaret(caret);
        Object o = UIManager.get("EditorPane.caretBlinkRate");
        if (o != null && o instanceof Integer) {
            Integer rate = (Integer)o;
            caret.setBlinkRate(rate);
        }
    }

    public void deleteLine(int offset) {
        if (this.isReadOnly()) {
            return;
        }
        this.getCodeEditorDocument().deleteLine(offset);
    }

    public void deleteEndLine(int offset) {
        if (this.isReadOnly()) {
            return;
        }
        this.getCodeEditorDocument().deleteEndLine(offset);
    }

    public void deleteBegLine(int offset) {
        if (this.isReadOnly()) {
            return;
        }
        this.getCodeEditorDocument().deleteBegLine(offset);
    }

    public boolean canUndo() {
        return this.getCodeEditorDocument().getUndoManager().canUndo();
    }

    public boolean canRedo() {
        return this.getCodeEditorDocument().getUndoManager().canRedo();
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        switch (e.getID()) {
            case 401: {
                this.processKeyPressed(e);
                return;
            }
            case 402: {
                super.processKeyEvent(e);
                return;
            }
            case 400: {
                super.processKeyEvent(e);
                return;
            }
        }
        super.processKeyEvent(e);
    }

    public void processKeyPressed(KeyEvent e) {
        char c = e.getKeyChar();
        if (!this.isReadOnly() && this.getCodeEditorDocument().isSmartIndent() && c == '\n' && this.getSelectedText() == null) {
            this.getCodeEditorDocument().doSmartIndent(this.getCaretPosition());
            return;
        }
        super.processKeyEvent(e);
    }

    public void doBlockIndent(boolean isShiftDown) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.getSelectedText() == null) {
            try {
                this.getCodeEditorDocument().insertString(this.getCaretPosition(), "\t", SimpleAttributeSet.EMPTY);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd() - 1;
        int colorStart = 0;
        int colorEnd = 0;
        colorStart = this.getCodeEditorDocument().getCurrentLineStartOffset(start);
        colorEnd = isShiftDown ? this.getCodeEditorDocument().doBlockUnIndent(start, end) : this.getCodeEditorDocument().doBlockIndent(start, end);
        this.setSelectionStart(colorStart);
        this.setSelectionEnd(colorEnd);
    }

    public void doBlockComment(boolean isShiftDown) {
        if (this.isReadOnly()) {
            return;
        }
        this.getCodeEditorDocument().EnableDocumentColoring(false);
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd() - 1;
        if (end < start) {
            end = start;
        }
        int colorStart = 0;
        int colorEnd = 0;
        colorStart = this.getCodeEditorDocument().getCurrentLineStartOffset(start);
        colorEnd = isShiftDown ? this.getCodeEditorDocument().doBlockUncomment(start, end) : this.getCodeEditorDocument().doBlockComment(start, end);
        this.getCodeEditorDocument().EnableDocumentColoring(true);
        this.setSelectionStart(colorStart);
        this.setSelectionEnd(colorEnd);
    }

    public boolean doRepeatFind(boolean isShiftDown) {
        String TextToFind = this.getCodeEditorDocument().OldTextToFind;
        if (TextToFind == null) {
            return false;
        }
        int index = this.getCodeEditorDocument().repeatFind(this.getCaretPosition(), isShiftDown);
        this.getCodeEditorDocument();
        if (index == -2) {
            String msg = this.resource.getMessageString("CodeEditorPane.FinishedSearching.fmt.txt", TextToFind);
            Object[] options = new Object[]{this.resource.getString("Common.OK.txt")};
            JOptionPane.showOptionDialog(null, msg, this.resource.getString("Common.CodeEditor.txt"), -1, 2, null, options, options[0]);
            return true;
        }
        if (index >= 0) {
            int line;
            ViewFoldInfo vfi = this.getViewFoldInfo();
            if (!vfi.isTopLevelLine(line = this.getCodeEditorDocument().getLineForOffset(index))) {
                vfi.expand(line);
            }
            this.setSelectionStart(index);
            this.setSelectionEnd(index + this.getCodeEditorDocument().OldTextToFind.length());
        } else {
            String msg = this.resource.getMessageString("CodeEditorPane.CouldNotFind.fmt.txt", TextToFind);
            Object[] options = new Object[]{this.resource.getString("Common.OK.txt")};
            JOptionPane.showOptionDialog(null, msg, this.resource.getString("Common.CodeEditor.txt"), -1, 2, null, options, options[0]);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void goToWord(boolean goRight, boolean isSelected) {
        try {
            oldPosition = this.getCaretPosition();
            newPosition = -1;
            while (true) {
                if (goRight) {
                    try {
                        newPosition = Utilities.getNextWord(this, oldPosition);
                    }
                    catch (BadLocationException b) {
                        newPosition = this.getCodeEditorDocument().getLength();
                        if (oldPosition != newPosition) ** GOTO lbl14
                        throw b;
                    }
                } else {
                    newPosition = Utilities.getPreviousWord(this, oldPosition);
                }
lbl14:
                // 3 sources

                line = this.getCodeEditorDocument().getLineForOffset(newPosition);
                if (this.getViewFoldInfo().isTopLevelLine(line)) break;
                oldPosition = newPosition;
            }
            if (isSelected) {
                this.moveCaretPosition(newPosition);
            } else {
                this.setCaretPosition(newPosition);
            }
        }
        catch (BadLocationException bl) {
            this.getToolkit().beep();
        }
    }

    public void doChangeCase(boolean isUpperCase) {
        if (this.isReadOnly()) {
            return;
        }
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        int len = selectionEnd - selectionStart;
        try {
            String text = this.getText(selectionStart, len);
            this.getCodeEditorDocument().remove(selectionStart, len);
            text = isUpperCase ? text.toUpperCase(Locale.getDefault()) : text.toLowerCase(Locale.getDefault());
            this.getCodeEditorDocument().insertString(selectionStart, text, SimpleAttributeSet.EMPTY);
            this.setSelectionStart(selectionStart);
            this.setSelectionEnd(selectionEnd);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void collapseCurrentBlock() {
        if (!this.getCodeFolding()) {
            return;
        }
        int line = this.getCodeEditorDocument().getLineForOffset(this.getSelectionEnd());
        this.getViewFoldInfo().collapse(line);
    }

    public void expandCurrentBlock() {
        if (!this.getCodeFolding()) {
            return;
        }
        int line = this.getCodeEditorDocument().getLineForOffset(this.getSelectionEnd());
        this.getViewFoldInfo().expand(line);
    }

    public void collapseAll() {
        if (!this.getCodeFolding()) {
            return;
        }
        this.getViewFoldInfo().collapseAll();
    }

    public void expandAll() {
        if (!this.getCodeFolding()) {
            return;
        }
        this.getViewFoldInfo().expandAll();
    }

    public void toggleExpandCurrentBlock() {
        int line;
        if (!this.getCodeFolding()) {
            return;
        }
        ViewFoldInfo foldInfo = this.getViewFoldInfo();
        if (foldInfo.isBlockLine(line = this.getCodeEditorDocument().getLineForOffset(this.getSelectionEnd()))) {
            if (foldInfo.isLineCollapsed(line)) {
                foldInfo.expand(line);
            } else {
                foldInfo.collapse(line);
            }
        }
    }

    public ViewFoldInfo getViewFoldInfo() {
        CodeEditorView v = this.getView();
        if (v != null) {
            return v.getViewFoldInfo();
        }
        return null;
    }

    public CodeEditorView getView() {
        CodeEditorView theView = null;
        View v = this.getUI().getRootView(this);
        View v2 = v.getView(0);
        if (v2 instanceof CodeEditorView) {
            theView = (CodeEditorView)v2;
        }
        return theView;
    }

    @Override
    public void preferenceChangeUpdate() {
        this.getCodeEditorDocument().updatePreferences();
        this.setLineNumbers(this.defaults.getShowLineNumbers());
        if (this.getCodeFolding() != this.defaults.getCodeFoldingEnabled()) {
            this.setCodeFolding(this.defaults.getCodeFoldingEnabled());
            this.getCodeEditorDocument().getLanguageParser().color();
        }
        this.EnableDocumentColoring(this.defaults.getDocumentColoring());
        this.m_BorderManager.createBorder();
        CodeEditorAttributeManager manager = new CodeEditorAttributeManager(this.defaults);
        AttributeMap map = manager.getAttributeMap(this.getLanguage().getID());
        Font f = map.getFontAttributes();
        this.setFont(f);
        if (this.defaults.getDocumentColoring()) {
            this.getCodeEditorDocument().getLanguageParser().setElementAttributeMap(map);
        }
        this.setupKeymap();
        this.setSingleBgColor();
        this.m_ScrollPane.repaint();
    }

    protected boolean prepareForHardExit() {
        String title;
        String msg;
        int doSave;
        if (this.m_bDoNotCheckSavedContents) {
            return false;
        }
        CodeEditorDocument doc = this.getCodeEditorDocument();
        if (!doc.isDocumentModified()) {
            return false;
        }
        if (this.isReadOnly()) {
            return false;
        }
        String filename = doc.getFilename();
        if (filename == null || filename.compareTo("") == 0) {
            filename = this.resource.getString("CodeEditorPane.DefaultFilename.txt");
        }
        return (doSave = JOptionPane.showConfirmDialog(this.m_ScrollPane, msg = this.resource.getMessageString("CodeEditorPane.SaveContents.fmt.txt", filename), title = this.resource.getString("Common.CodeEditor.txt"), 0, 3)) == 0;
    }

    public void cleanup() {
        this.setIgnoreRepaint(true);
        this.mIsDead = true;
        this.autoCloseFindDialog();
        if (this.m_BorderManager != null) {
            this.m_BorderManager.cleanup();
        }
        CodeEditorPane.removeKeymap("Testing123");
        if (this.keyManager != null) {
            // empty if block
        }
        this.getView().cleanup();
        this.getCodeEditorDocument().cleanup();
        this.removePopupMenu();
        if (this.defaults != null) {
            this.defaults.removePreferenceChangeListener(this);
        }
        this.cut.removeActionListener(this.getActionMap().get("cut-to-clipboard"));
        this.copy.removeActionListener(this.getActionMap().get("copy-to-clipboard"));
        this.paste.removeActionListener(this.getActionMap().get("paste-from-clipboard"));
        this.selectall.removeActionListener(this.getActionMap().get("select-all"));
        this.clearall.removeActionListener(this.getActionMap().get("clear-all"));
        this.coloron.removeActionListener(this.getActionMap().get("enable-coloring"));
        this.coloroff.removeActionListener(this.getActionMap().get("disable-coloring"));
        this.undo.removeActionListener(this.getActionMap().get("undo"));
        this.redo.removeActionListener(this.getActionMap().get("redo"));
        this.find.removeActionListener(this.getActionMap().get("find-dialog"));
        this.gotoline.removeActionListener(this.getActionMap().get("goto-line"));
        this.clearActionMap();
        this.setFocusTraversalPolicy(null);
        this.setAutoscrolls(false);
    }

    private void clearActionMap() {
        Object[] actionKeys = this.getActionMap().allKeys();
        if (actionKeys != null) {
            Action action = null;
            for (int i = 0; i < actionKeys.length; ++i) {
                action = this.getActionMap().get(actionKeys[i]);
                if (action == null) continue;
                action.putValue("SmallIcon", null);
            }
        }
    }

    void addShutdownWindowListener(Window parentWindow) {
        parentWindow.addWindowListener(this.mShutdownListener);
    }

    void removeShutdownListener(Window parentWindow) {
        parentWindow.removeWindowListener(this.mShutdownListener);
    }

    public void enablePromptForUnsavedData(boolean bPrompt) {
        this.m_bDoNotCheckSavedContents = !bPrompt;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (mFindDialogAutoClosed) {
            mFindDialogAutoClosed = false;
            this.dlgFind(false);
        } else if (mFindDialog != null) {
            mFindDialog.setEditor(this);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (mFindDialogOpening) {
            return;
        }
        if (mFindDialog != null) {
            Component focusGainer;
            boolean dialogInFocusGainerChain = false;
            for (Component temp = focusGainer = e.getOppositeComponent(); temp != null; temp = temp.getParent()) {
                if (temp == mFindDialog) {
                    dialogInFocusGainerChain = true;
                    break;
                }
                if (!(temp instanceof FindDialog)) continue;
                return;
            }
            if (!dialogInFocusGainerChain) {
                Window oppositeParent;
                Window myParent;
                if (focusGainer instanceof CodeEditorPane && (myParent = SwingUtilities.windowForComponent(this)) == (oppositeParent = SwingUtilities.windowForComponent(focusGainer))) {
                    return;
                }
                this.autoCloseFindDialog();
            }
        }
    }

    void setFindDialogPosition(Point position) {
        mFindDialogPosition = position;
    }

    public void autoCloseFindDialog() {
        if (mFindDialog != null) {
            FindDialog findDialog = mFindDialog;
            mFindDialogAutoClosed = true;
            mFindDialog = null;
            findDialog.OnClose();
        }
    }

    public static FindDialog getFindDialog() {
        return mFindDialog;
    }

    String[] getFindHistoryStrings() {
        if (mFindHistory.size() == 0) {
            String[] historyStrings = this.defaults.getFindHistory();
            mFindHistory = Arrays.asList(historyStrings);
        }
        return mFindHistory.toArray(new String[0]);
    }

    String[] getReplaceHistoryStrings() {
        if (mReplaceHistory.size() == 0) {
            String[] historyStrings = this.defaults.getReplaceHistory();
            mReplaceHistory = Arrays.asList(historyStrings);
        }
        return mReplaceHistory.toArray(new String[0]);
    }

    void setFindHistoryStrings(String[] strings) {
        mFindHistory = Arrays.asList(strings);
        this.defaults.setFindHistory(strings, true);
    }

    void setReplaceHistoryStrings(String[] strings) {
        mReplaceHistory = Arrays.asList(strings);
        this.defaults.setReplaceHistory(strings, true);
    }

    int getFindHistorySize() {
        return mFindHistorySize;
    }

    int getReplaceHistorySize() {
        return mFindHistorySize;
    }

    void setFindDialogSize(Dimension size) {
        mFindDialogSize = size;
    }

    @Override
    public void copy() {
        super.copy();
    }

    @Override
    public String getSelectedText() {
        return super.getSelectedText();
    }

    public boolean canCopy() {
        CodeEditorDocument doc;
        int selStart = this.getSelectionStart();
        int selEnd = this.getSelectionEnd();
        return selEnd > selStart && (doc = this.getCodeEditorDocument()).canCopyAmount(selEnd - selStart);
    }

    public void setLineWrap(boolean wrapLines) {
        this.mLineWrap = wrapLines;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.mLineWrap) {
            return true;
        }
        return super.getScrollableTracksViewportWidth();
    }

    public boolean isLineEditable() {
        if (this.getDocument() instanceof CodeEditorDocument && ((CodeEditorDocument)this.getDocument()).getEditableRegion() != null) {
            CodeEditorDocument doc = (CodeEditorDocument)this.getDocument();
            int p0 = this.getCaret().getDot();
            int p1 = this.getCaret().getMark();
            return !doc.isInReadonlyRegion(p0) && !doc.isInReadonlyRegion(p1);
        }
        return true;
    }

    protected void setSingleBgColor() {
        CodeEditorAttributeManager manager = new CodeEditorAttributeManager(this.defaults);
        AttributeMap map = manager.getAttributeMap(this.getLanguage().getID());
        if (map.isUsingSingleBgColor()) {
            this.setBackground(map.getSingleBgColor());
        } else {
            this.setBackground(SystemColor.window);
        }
    }

    private class ShutdownListener
    extends WindowAdapter {
        private ShutdownListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (CodeEditorPane.this.m_ScrollPane != null) {
                if (CodeEditorPane.this.prepareForHardExit()) {
                    String fileName = CodeEditorPane.this.getCodeEditorDocument().getFilename();
                    while (true) {
                        try {
                            if (fileName.length() > 0 && CodeEditorPane.this.saveFile(fileName)) {
                                break;
                            }
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        JFileChooser fileChooser = new JFileChooser();
                        fileChooser.setMultiSelectionEnabled(false);
                        fileChooser.setSelectedFile(new File(fileName));
                        fileChooser.setDialogTitle(CodeEditorPane.this.resource.getString("CodeEditorPane.DialogSaveFile.txt"));
                        int returnValue = fileChooser.showSaveDialog(e.getComponent());
                        File selectedFile = fileChooser.getSelectedFile();
                        if (selectedFile == null || returnValue == 1) break;
                        if (returnValue != 0) continue;
                        fileName = selectedFile.getAbsolutePath();
                    }
                }
                ((CodeEditor)CodeEditorPane.this.m_ScrollPane).cleanup();
            }
        }
    }

    public class PopupLauncher
    implements Runnable {
        private MouseEvent mEvent = null;
        private CodeEditorPane mPane = null;

        public PopupLauncher(MouseEvent e, CodeEditorPane pane) {
            this.mEvent = e;
            this.mPane = pane;
        }

        @Override
        public void run() {
            CodeEditorPane.this.popup.show(this.mPane, this.mEvent.getX(), this.mEvent.getY());
        }
    }
}

