/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditor;
import com.sas.editor.CodeEditorAppearancePane;
import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorGeneralPane;
import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorResource;
import com.sas.swing.util.DesktopUtil;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class CodeEditorOptionsDialog
extends JDialog
implements KeyEventDispatcher {
    JTabbedPane jtp = new JTabbedPane();
    CodeEditorGeneralPane genPane;
    JPanel genPanel;
    CodeEditorAppearancePane appPane;
    JPanel appPanel;
    CodeEditor m_Editor;
    CodeEditorResource resource;
    CodeEditorDefaults defaults;
    JButton OKButton = new JButton();
    JButton CancelButton = new JButton();
    JButton HelpButton = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    boolean m_ShowAppearancePane;
    boolean m_ShowAssignKeysButton;

    public static CodeEditorOptionsDialog CreateDialog(CodeEditor editor, boolean showAppearancePane, boolean showAssignKeysButton) {
        Component parent = CodeEditorPane.getParentFrameOrDialog(editor);
        if (parent instanceof Frame) {
            return new CodeEditorOptionsDialog((Frame)parent, editor, editor.getDefaults(), showAppearancePane, showAssignKeysButton);
        }
        if (parent instanceof Dialog) {
            return new CodeEditorOptionsDialog((Dialog)parent, editor, editor.getDefaults(), showAppearancePane, showAssignKeysButton);
        }
        return null;
    }

    public static CodeEditorOptionsDialog CreateDialog(Component startComponent, CodeEditorDefaults defaults, boolean showAppearancePane, boolean showAssignKeysButton) {
        Component parent = CodeEditorPane.getParentFrameOrDialog(startComponent);
        if (parent instanceof Frame) {
            return new CodeEditorOptionsDialog((Frame)parent, null, defaults, showAppearancePane, showAssignKeysButton);
        }
        if (parent instanceof Dialog) {
            return new CodeEditorOptionsDialog((Dialog)parent, null, defaults, showAppearancePane, showAssignKeysButton);
        }
        return null;
    }

    private CodeEditorOptionsDialog(Dialog dlg, CodeEditor editor, CodeEditorDefaults editorDefaults, boolean showAppearancePane, boolean showAssignKeysButton) {
        super(dlg);
        this.m_Editor = editor;
        this.m_ShowAppearancePane = showAppearancePane;
        this.m_ShowAssignKeysButton = showAssignKeysButton;
        this.resource = new CodeEditorResource(CodeEditorOptionsDialog.class);
        this.defaults = editorDefaults;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CodeEditorOptionsDialog(Frame frame, CodeEditor editor, CodeEditorDefaults editorDefaults, boolean showAppearancePane, boolean showAssignKeysButton) {
        super(frame);
        this.m_Editor = editor;
        this.m_ShowAppearancePane = showAppearancePane;
        this.m_ShowAssignKeysButton = showAssignKeysButton;
        this.resource = new CodeEditorResource(CodeEditorOptionsDialog.class);
        this.defaults = editorDefaults;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.OKButton.setText(this.resource.getString("Common.OK.txt"));
        this.CancelButton.setText(this.resource.getString("Common.Cancel.txt"));
        String HelpButtonItem = this.resource.getString("Common.Help.txt");
        String HelpButtonText = Util.getLabelWithoutMnemonic((String)HelpButtonItem);
        this.HelpButton.setText(HelpButtonText);
        int index = Util.getDisplayedMnemonicIndex((String)HelpButtonItem);
        if (index > -1) {
            this.HelpButton.setMnemonic(Util.getDisplayedMnemonic((String)HelpButtonItem));
            this.HelpButton.setDisplayedMnemonicIndex(index);
        }
        this.genPane = new CodeEditorGeneralPane((Dialog)this, this.defaults, !this.m_ShowAppearancePane, this.m_ShowAssignKeysButton);
        this.genPanel = new JPanel(new GridBagLayout());
        this.genPanel.add((Component)this.genPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jtp.add(this.resource.getString("CodeEditorOptionsDialog.GeneralTab.txt"), this.genPanel);
        if (this.m_ShowAppearancePane) {
            this.appPane = new CodeEditorAppearancePane(this.m_Editor, this.genPane.getWorkingCopy());
            this.appPanel = new JPanel(new GridBagLayout());
            this.appPanel.add((Component)this.appPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.jtp.add(this.resource.getString("CodeEditorOptionsDialog.AppearanceTab.txt"), this.appPanel);
            this.jtp.setSelectedIndex(this.defaults.getPropertyInt("CodeEditorOptionsDialog.LastSelectedPane.txt", 0));
        } else {
            this.jtp.setSelectedIndex(0);
        }
        Dimension btnSize = new Dimension(100, 25);
        this.OKButton.setMinimumSize(btnSize);
        this.OKButton.setPreferredSize(btnSize);
        this.OKButton.setMaximumSize(btnSize);
        this.CancelButton.setMinimumSize(btnSize);
        this.CancelButton.setPreferredSize(btnSize);
        this.CancelButton.setMaximumSize(btnSize);
        this.HelpButton.setMinimumSize(btnSize);
        this.HelpButton.setPreferredSize(btnSize);
        this.HelpButton.setMaximumSize(btnSize);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.OKButton);
        box.add(Box.createHorizontalStrut(7));
        box.add(this.CancelButton);
        box.add(Box.createHorizontalStrut(7));
        box.add(this.HelpButton);
        this.getContentPane().add((Component)this.jtp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)box, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
        this.setResizable(false);
        this.setSize(545, 505);
        this.setModal(true);
        this.setTitle(this.resource.getString("CodeEditorOptionsDialog.Title.txt"));
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorOptionsDialog.this.onOK();
            }
        });
        this.HelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorOptionsDialog.this.onHelp();
            }
        });
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorOptionsDialog.this.onClose();
            }
        });
    }

    protected void onOK() {
        this.defaults.setPropertyInt("CodeEditorOptionsDialog.LastSelectedPane.txt", this.jtp.getSelectedIndex());
        if (this.m_ShowAppearancePane) {
            this.appPane.onApplyChanges(this.defaults);
        }
        this.genPane.OnApply();
        this.dispose();
    }

    protected void onClose() {
        this.defaults.setPropertyInt("CodeEditorOptionsDialog.LastSelectedPane.txt", this.jtp.getSelectedIndex());
        this.defaults.saveProperties();
        this.dispose();
    }

    protected void onHelp() {
        String context = this.jtp.getSelectedIndex() == 0 ? "editoroptions" : "appearance";
        String docSetId = "texteditor";
        String helpId = context;
        DesktopUtil.openHelpDoc((String)docSetId, (String)helpId, (String)"version", null);
    }

    @Override
    public void dispose() {
        if (this.OKButton == null) {
            return;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.m_Editor = null;
        if (this.genPane != null) {
            this.genPane.cleanup();
            this.genPane = null;
        }
        if (this.genPanel != null) {
            this.genPanel.removeAll();
            this.genPanel = null;
        }
        if (this.appPane != null) {
            this.appPane.cleanup();
            this.appPane = null;
        }
        if (this.appPanel != null) {
            this.appPanel.removeAll();
            this.appPanel = null;
        }
        if (this.jtp != null) {
            this.jtp.removeAll();
            this.jtp = null;
        }
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(null);
        this.removeAll();
        this.removeListeners(this.OKButton);
        this.OKButton = null;
        this.removeListeners(this.CancelButton);
        this.CancelButton = null;
        this.removeListeners(this.HelpButton);
        this.HelpButton = null;
        this.rootPane = null;
        this.resource = null;
        this.defaults = null;
        super.dispose();
    }

    private void removeListeners(JButton button) {
        ActionListener[] listeners = (ActionListener[])button.getListeners(ActionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            button.removeActionListener(listeners[i]);
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getID() != 402) {
            return false;
        }
        if (e.getKeyCode() == 27 && this.isActive()) {
            this.onClose();
            return true;
        }
        return false;
    }
}

