/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditor;
import com.sas.editor.CodeEditorDocument;
import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorView;
import com.sas.editor.CodeLanguage;
import com.sas.editor.LogListDocument;
import com.sas.editor.LogListView;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class CodeEditorKit
extends DefaultEditorKit
implements ViewFactory {
    public static final String clearAllAction = "clear-all";
    public static final String colorOnAction = "enable-coloring";
    public static final String colorOffAction = "disable-coloring";
    public static final String undoAction = "undo";
    public static final String redoAction = "redo";
    public static final String dlgFindAction = "find-dialog";
    public static final String gotoLineAction = "goto-line";
    public static final String dumpAction = "dump-debug-info";
    public static final String matchAction = "match-braces";
    public static final String matchDoEndAction = "match-do-end";
    public static final String delLineAction = "delete-line";
    public static final String delEndLineAction = "delete-to-end";
    public static final String delBegLineAction = "delete-to-beginning";
    public static final String blockIndentAction = "block-indent";
    public static final String blockUnIndentAction = "block-unindent";
    public static final String blockCommentAction = "block-comment";
    public static final String blockUnCommentAction = "block-uncomment";
    public static final String findNextAction = "find-next";
    public static final String findPreviousAction = "find-previous";
    public static final String toggleReadOnlyAction = "toggle read-only";
    public static final String lowerCaseAction = "make lower-case";
    public static final String upperCaseAction = "make upper-case";
    public static final String collapseBlockAction = "collapse-block";
    public static final String expandBlockAction = "expand-block";
    public static final String unselectAction = "unselect";
    public static final String pageUpSelectAction = "selection-page-up";
    public static final String pageDownSelectAction = "selection-page-down";
    public static final String toggleExpandBlockAction = "toggle-collapse-expand";
    public static final String collapseAllAction = "collapse-all";
    public static final String expandAllAction = "expand-all";
    public static final String goToNextWordAction = "goto-next-word";
    public static final String goToPreviousWordAction = "goto-previous-word";
    public static final String selectNextWordAction = "select-next-word";
    public static final String deleteNextWordAction = "delete-next-word";
    public static final String deletePreviousWordAction = "delete-previous-word";
    public static final String selectPreviousWordAction = "select-previous-word";
    public static final String printAction = "print";
    public static final String helpAction = "help";
    public static final String nullAction = "null-action";
    public static final String noOpAction = "noOp-action";
    public static final String deleteNextCharAction = "delete-next";
    public static final String deletePrevCharAction = "delete-previous";
    private static final Action[] defaultActions = new Action[]{new ClearAllAction(), new EnableColoringAction("enable-coloring", true), new EnableColoringAction("disable-coloring", false), new UndoAction(), new RedoAction(), new DlgFindAction(), new GoToLineAction(), new DumpAction(), new MatchAction(), new MatchDoEndAction(), new DelLineAction(), new DelEndLineAction(), new DelBegLineAction(), new BlockIndentAction(), new BlockUnIndentAction(), new BlockCommentAction(), new BlockUnCommentAction(), new FindNextAction(), new FindPreviousAction(), new ToggleReadOnlyAction(), new LowerCaseAction(), new UpperCaseAction(), new CollapseBlockAction(), new ExpandBlockAction(), new ToggleExpandBlockAction(), new CollapseAllAction(), new ExpandAllAction(), new GoToNextWordAction(), new GoToPreviousWordAction(), new SelectNextWordAction(), new SelectPreviousWordAction(), new PrintAction(), new HelpAction(), new NullAction(), new NoOpAction(), new DeleteNextWordAction(), new DeletePreviousWordAction(), new DeleteNextCharAction(), new DeletePrevCharAction()};
    Hashtable viewHash = new Hashtable();
    public CodeLanguage DocumentLanguage = null;

    @Override
    public Object clone() {
        Object o = super.clone();
        return o;
    }

    @Override
    public Document createDefaultDocument() {
        if (this.DocumentLanguage == CodeLanguage.LOG || this.DocumentLanguage == CodeLanguage.LIST) {
            return new LogListDocument(this.DocumentLanguage);
        }
        return new CodeEditorDocument();
    }

    @Override
    public ViewFactory getViewFactory() {
        return this;
    }

    @Override
    public View create(Element elem) {
        CodeEditorView view = (CodeEditorView)this.viewHash.get(elem);
        if (view == null) {
            Document docObject = elem.getDocument();
            view = docObject instanceof LogListDocument ? new LogListView(elem) : new CodeEditorView(elem);
            this.viewHash.put(elem, view);
        }
        return view;
    }

    @Override
    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public static class ClearAllAction
    extends TextAction {
        public ClearAllAction() {
            super(CodeEditorKit.clearAllAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(System.currentTimeMillis());
                target.setCaretPosition(0);
                target.getCodeEditorDocument().doClearAll();
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(0L);
            }
        }
    }

    public static class EnableColoringAction
    extends TextAction {
        private boolean m_bEnabled;

        public EnableColoringAction(String name, boolean bEnable) {
            super(name);
            this.m_bEnabled = bEnable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                target.EnableDocumentColoring(this.m_bEnabled);
            }
        }
    }

    public static class UndoAction
    extends TextAction {
        public UndoAction() {
            super(CodeEditorKit.undoAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int resultOffset;
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null && !target.isReadOnly() && (resultOffset = target.getCodeEditorDocument().getUndoManager().doUndo()) >= 0) {
                target.setCaretPosition(resultOffset);
            }
        }
    }

    public static class RedoAction
    extends TextAction {
        public RedoAction() {
            super(CodeEditorKit.redoAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int resultOffset;
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null && !target.isReadOnly() && (resultOffset = target.getCodeEditorDocument().getUndoManager().doRedo()) >= 0) {
                target.setCaretPosition(resultOffset);
            }
        }
    }

    public static class DlgFindAction
    extends TextAction {
        public DlgFindAction() {
            super(CodeEditorKit.dlgFindAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                target.dlgFind();
            }
        }
    }

    public static class GoToLineAction
    extends TextAction {
        public GoToLineAction() {
            super(CodeEditorKit.gotoLineAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                target.dlgGoToLine();
            }
        }
    }

    public static class DumpAction
    extends TextAction {
        public DumpAction() {
            super(CodeEditorKit.dumpAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                CodeEditorDocument doc = (CodeEditorDocument)target.getDocument();
                doc.DumpElementHierarchy();
            }
        }
    }

    public static class MatchAction
    extends TextAction {
        public MatchAction() {
            super(CodeEditorKit.matchAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                target.MatchBraces();
            }
        }
    }

    public static class MatchDoEndAction
    extends TextAction {
        public MatchDoEndAction() {
            super(CodeEditorKit.matchDoEndAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                target.MatchDoEnd();
            }
        }
    }

    public static class DelLineAction
    extends TextAction {
        public DelLineAction() {
            super(CodeEditorKit.delLineAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(System.currentTimeMillis());
                target.deleteLine(target.getCaretPosition());
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(0L);
            }
        }
    }

    public static class DelEndLineAction
    extends TextAction {
        public DelEndLineAction() {
            super(CodeEditorKit.delEndLineAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(System.currentTimeMillis());
                target.deleteEndLine(target.getCaretPosition());
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(0L);
            }
        }
    }

    public static class DelBegLineAction
    extends TextAction {
        public DelBegLineAction() {
            super(CodeEditorKit.delBegLineAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(System.currentTimeMillis());
                target.deleteBegLine(target.getCaretPosition());
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(0L);
            }
        }
    }

    public static class BlockIndentAction
    extends TextAction {
        public BlockIndentAction() {
            super(CodeEditorKit.blockIndentAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(System.currentTimeMillis());
                target.doBlockIndent(false);
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(0L);
            }
        }
    }

    public static class BlockUnIndentAction
    extends TextAction {
        public BlockUnIndentAction() {
            super(CodeEditorKit.blockUnIndentAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(System.currentTimeMillis());
                target.doBlockIndent(true);
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(0L);
            }
        }
    }

    public static class BlockCommentAction
    extends TextAction {
        public BlockCommentAction() {
            super(CodeEditorKit.blockCommentAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(System.currentTimeMillis());
                target.doBlockComment(false);
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(0L);
            }
        }
    }

    public static class BlockUnCommentAction
    extends TextAction {
        public BlockUnCommentAction() {
            super(CodeEditorKit.blockUnCommentAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(System.currentTimeMillis());
                target.doBlockComment(true);
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(0L);
            }
        }
    }

    public static class FindNextAction
    extends TextAction {
        public FindNextAction() {
            super(CodeEditorKit.findNextAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null && !target.doRepeatFind(false)) {
                target.dlgFind();
            }
        }
    }

    public static class FindPreviousAction
    extends TextAction {
        public FindPreviousAction() {
            super(CodeEditorKit.findPreviousAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null && !target.doRepeatFind(true)) {
                target.dlgFind();
            }
        }
    }

    public static class ToggleReadOnlyAction
    extends TextAction {
        public ToggleReadOnlyAction() {
            super(CodeEditorKit.toggleReadOnlyAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                target.setReadOnly(!target.isReadOnly());
            }
        }
    }

    public static class LowerCaseAction
    extends TextAction {
        public LowerCaseAction() {
            super(CodeEditorKit.lowerCaseAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(System.currentTimeMillis());
                target.doChangeCase(false);
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(0L);
            }
        }
    }

    public static class UpperCaseAction
    extends TextAction {
        public UpperCaseAction() {
            super(CodeEditorKit.upperCaseAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(System.currentTimeMillis());
                target.doChangeCase(true);
                ((CodeEditorDocument)target.getDocument()).setMassReplaceCode(0L);
            }
        }
    }

    public static class CollapseBlockAction
    extends TextAction {
        public CollapseBlockAction() {
            super(CodeEditorKit.collapseBlockAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                target.collapseCurrentBlock();
            }
        }
    }

    public static class ExpandBlockAction
    extends TextAction {
        public ExpandBlockAction() {
            super(CodeEditorKit.expandBlockAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                target.expandCurrentBlock();
            }
        }
    }

    public static class ToggleExpandBlockAction
    extends TextAction {
        public ToggleExpandBlockAction() {
            super(CodeEditorKit.toggleExpandBlockAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                target.toggleExpandCurrentBlock();
            }
        }
    }

    public static class CollapseAllAction
    extends TextAction {
        public CollapseAllAction() {
            super(CodeEditorKit.collapseAllAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                target.collapseAll();
            }
        }
    }

    public static class ExpandAllAction
    extends TextAction {
        public ExpandAllAction() {
            super(CodeEditorKit.expandAllAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                target.expandAll();
            }
        }
    }

    public static class GoToNextWordAction
    extends TextAction {
        public GoToNextWordAction() {
            super(CodeEditorKit.goToNextWordAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                boolean goRight = true;
                boolean isSelected = false;
                target.goToWord(goRight, isSelected);
            }
        }
    }

    public static class GoToPreviousWordAction
    extends TextAction {
        public GoToPreviousWordAction() {
            super(CodeEditorKit.goToPreviousWordAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                boolean goRight = false;
                boolean isSelected = false;
                target.goToWord(goRight, isSelected);
            }
        }
    }

    public static class SelectNextWordAction
    extends TextAction {
        public SelectNextWordAction() {
            super(CodeEditorKit.selectNextWordAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                boolean goRight = true;
                boolean isSelected = true;
                target.goToWord(goRight, isSelected);
            }
        }
    }

    public static class SelectPreviousWordAction
    extends TextAction {
        public SelectPreviousWordAction() {
            super(CodeEditorKit.selectPreviousWordAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                boolean goRight = false;
                boolean isSelected = true;
                target.goToWord(goRight, isSelected);
            }
        }
    }

    public static class PrintAction
    extends TextAction {
        public PrintAction() {
            super(CodeEditorKit.printAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                ((CodeEditor)target.getScrollPane()).printDlg();
            }
        }
    }

    public static class HelpAction
    extends TextAction {
        public HelpAction() {
            super(CodeEditorKit.helpAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                ((CodeEditor)target.getScrollPane()).showJavaHelp();
            }
        }
    }

    public static class NullAction
    extends TextAction {
        public NullAction() {
            super(CodeEditorKit.nullAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public static class NoOpAction
    extends TextAction {
        public NoOpAction() {
            super(CodeEditorKit.noOpAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public static class DeleteNextWordAction
    extends TextAction {
        public DeleteNextWordAction() {
            super(CodeEditorKit.deleteNextWordAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                boolean goRight = true;
                boolean isSelected = false;
                int oldLocation = target.getCaretPosition();
                target.goToWord(goRight, isSelected);
                int newLocation = target.getCaretPosition();
                try {
                    target.getCodeEditorDocument().remove(oldLocation, newLocation - oldLocation);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static class DeletePreviousWordAction
    extends TextAction {
        public DeletePreviousWordAction() {
            super(CodeEditorKit.deletePreviousWordAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorPane target = (CodeEditorPane)this.getTextComponent(e);
            if (target != null) {
                boolean goRight = false;
                boolean isSelected = false;
                int oldLocation = target.getCaretPosition();
                target.goToWord(goRight, isSelected);
                int newLocation = target.getCaretPosition();
                try {
                    target.getCodeEditorDocument().remove(newLocation, oldLocation - newLocation);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    static class DeleteNextCharAction
    extends TextAction {
        DeleteNextCharAction() {
            super(CodeEditorKit.deleteNextCharAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            boolean beep = true;
            if (target != null && target.isEditable()) {
                try {
                    Document doc = target.getDocument();
                    Caret caret = target.getCaret();
                    int dot = caret.getDot();
                    int mark = caret.getMark();
                    if (doc instanceof CodeEditorDocument && ((CodeEditorDocument)doc).getEditableRegion() != null && ((CodeEditorDocument)doc).isInReadonlyRegion(Math.min(dot, mark) + 1)) {
                        UIManager.getLookAndFeel().provideErrorFeedback(target);
                        return;
                    }
                    if (dot != mark) {
                        doc.remove(Math.min(dot, mark), Math.abs(dot - mark));
                        beep = false;
                    } else if (dot < doc.getLength()) {
                        int delChars = 1;
                        if (dot < doc.getLength() - 1) {
                            String dotChars = doc.getText(dot, 2);
                            char c0 = dotChars.charAt(0);
                            char c1 = dotChars.charAt(1);
                            if (c0 >= '\ud800' && c0 <= '\udbff' && c1 >= '\udc00' && c1 <= '\udfff') {
                                delChars = 2;
                            }
                        }
                        doc.remove(dot, delChars);
                        beep = false;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (beep) {
                UIManager.getLookAndFeel().provideErrorFeedback(target);
            }
        }
    }

    static class DeletePrevCharAction
    extends TextAction {
        DeletePrevCharAction() {
            super(CodeEditorKit.deletePrevCharAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            boolean beep = true;
            if (target != null && target.isEditable()) {
                try {
                    Document doc = target.getDocument();
                    Caret caret = target.getCaret();
                    int dot = caret.getDot();
                    int mark = caret.getMark();
                    int readOnlyAdjustment = -1;
                    if (dot != mark) {
                        readOnlyAdjustment = 0;
                    }
                    if (doc instanceof CodeEditorDocument && ((CodeEditorDocument)doc).getEditableRegion() != null && ((CodeEditorDocument)doc).isInReadonlyRegion(Math.min(dot, mark) + readOnlyAdjustment)) {
                        UIManager.getLookAndFeel().provideErrorFeedback(target);
                        return;
                    }
                    if (dot != mark) {
                        doc.remove(Math.min(dot, mark), Math.abs(dot - mark));
                        beep = false;
                    } else if (dot > 0) {
                        int delChars = 1;
                        if (dot > 1) {
                            String dotChars = doc.getText(dot - 2, 2);
                            char c0 = dotChars.charAt(0);
                            char c1 = dotChars.charAt(1);
                            if (c0 >= '\ud800' && c0 <= '\udbff' && c1 >= '\udc00' && c1 <= '\udfff') {
                                delChars = 2;
                            }
                        }
                        doc.remove(dot - delChars, delChars);
                        beep = false;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (beep) {
                UIManager.getLookAndFeel().provideErrorFeedback(target);
            }
        }
    }
}

