/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorResource;
import java.text.NumberFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

class CodeEditorKeyManager {
    protected static CodeEditorResource resource = new CodeEditorResource(CodeEditorKeyManager.class);
    protected static final int keyVersion = 2;
    protected CodeEditorDefaults defaults;
    protected int mVersion;
    protected static String[] mIndexToCommandMap = null;
    protected Keymap mKeymap;
    protected InputMap mParentInputMap;
    protected List data = new ArrayList();
    protected CodeEditorPane m_Editor;
    private boolean mMigratingKeystrokes;

    public CodeEditorKeyManager(CodeEditorPane editor) {
        this.m_Editor = editor;
        this.defaults = this.m_Editor.defaults;
        this.mMigratingKeystrokes = false;
        this.mVersion = 2;
        this.InitializeData();
    }

    protected void cacheParentInputMap() {
        KeyStroke[] keys;
        KeyStroke[] keymapKeys = this.mKeymap.getBoundKeyStrokes();
        this.mParentInputMap = this.m_Editor.getInputMap();
        while (this.mParentInputMap != null && ((keys = this.mParentInputMap.keys()) == null || keys.length <= 0 || this.compareKeystrokeArrays(keys, keymapKeys))) {
            this.mParentInputMap = this.mParentInputMap.getParent();
        }
    }

    protected boolean compareKeystrokeArrays(KeyStroke[] keys1, KeyStroke[] keys2) {
        if (keys1.length != keys2.length) {
            return false;
        }
        HashSet<KeyStroke> set1 = new HashSet<KeyStroke>();
        set1.addAll(Arrays.asList(keys1));
        for (int i = 0; i < keys2.length; ++i) {
            KeyStroke stroke = keys2[i];
            if (set1.contains(stroke)) continue;
            return false;
        }
        return true;
    }

    public void InitializeData() {
        Object n;
        this.mKeymap = this.m_Editor.getKeymap();
        this.cacheParentInputMap();
        String numOfKeys = resource.getString("CodeEditorKeyManager.NumberOfTableItems.txt");
        int num = 0;
        try {
            NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
            n = nf.parse(numOfKeys);
            num = ((Number)n).intValue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.data.clear();
        for (int i = 1; i <= num; ++i) {
            String d;
            String g;
            n = resource.getString("CodeEditorKeyManager.TableItem.name." + i + ".txt");
            if (n == null || (g = resource.getString("CodeEditorKeyManager.TableItem.group." + i + ".txt")) == null || (d = resource.getString("CodeEditorKeyManager.TableItem.description." + i + ".txt")) == null) continue;
            String actionID = this.getActionIDForIndex(i);
            this.data.add(new KeyInfoItem((String)n, g, d, actionID));
        }
    }

    private String getActionIDForIndex(int i) {
        if (mIndexToCommandMap == null) {
            mIndexToCommandMap = new String[60];
            CodeEditorKeyManager.mIndexToCommandMap[1] = "copy-to-clipboard";
            CodeEditorKeyManager.mIndexToCommandMap[2] = "cut-to-clipboard";
            CodeEditorKeyManager.mIndexToCommandMap[3] = "delete-line";
            CodeEditorKeyManager.mIndexToCommandMap[4] = "delete-to-beginning";
            CodeEditorKeyManager.mIndexToCommandMap[5] = "delete-to-end";
            CodeEditorKeyManager.mIndexToCommandMap[6] = "find-next";
            CodeEditorKeyManager.mIndexToCommandMap[7] = "find-previous";
            CodeEditorKeyManager.mIndexToCommandMap[8] = "goto-line";
            CodeEditorKeyManager.mIndexToCommandMap[9] = "block-comment";
            CodeEditorKeyManager.mIndexToCommandMap[10] = "block-uncomment";
            CodeEditorKeyManager.mIndexToCommandMap[11] = "make lower-case";
            CodeEditorKeyManager.mIndexToCommandMap[12] = "make upper-case";
            CodeEditorKeyManager.mIndexToCommandMap[13] = "paste-from-clipboard";
            CodeEditorKeyManager.mIndexToCommandMap[14] = "redo";
            CodeEditorKeyManager.mIndexToCommandMap[15] = "match-braces";
            CodeEditorKeyManager.mIndexToCommandMap[16] = "select-all";
            CodeEditorKeyManager.mIndexToCommandMap[17] = "toggle read-only";
            CodeEditorKeyManager.mIndexToCommandMap[18] = "undo";
            CodeEditorKeyManager.mIndexToCommandMap[19] = "collapse-block";
            CodeEditorKeyManager.mIndexToCommandMap[20] = "expand-block";
            CodeEditorKeyManager.mIndexToCommandMap[21] = "toggle-collapse-expand";
            CodeEditorKeyManager.mIndexToCommandMap[22] = "collapse-all";
            CodeEditorKeyManager.mIndexToCommandMap[23] = "expand-all";
            CodeEditorKeyManager.mIndexToCommandMap[24] = "find-dialog";
            CodeEditorKeyManager.mIndexToCommandMap[25] = "goto-next-word";
            CodeEditorKeyManager.mIndexToCommandMap[26] = "goto-previous-word";
            CodeEditorKeyManager.mIndexToCommandMap[27] = "select-next-word";
            CodeEditorKeyManager.mIndexToCommandMap[28] = "select-previous-word";
            CodeEditorKeyManager.mIndexToCommandMap[29] = "print";
            CodeEditorKeyManager.mIndexToCommandMap[30] = "block-indent";
            CodeEditorKeyManager.mIndexToCommandMap[31] = "block-unindent";
            CodeEditorKeyManager.mIndexToCommandMap[32] = "unselect";
            CodeEditorKeyManager.mIndexToCommandMap[33] = "selection-page-down";
            CodeEditorKeyManager.mIndexToCommandMap[34] = "selection-page-up";
            CodeEditorKeyManager.mIndexToCommandMap[35] = "delete-previous";
            CodeEditorKeyManager.mIndexToCommandMap[36] = "insert-break";
            CodeEditorKeyManager.mIndexToCommandMap[37] = "page-up";
            CodeEditorKeyManager.mIndexToCommandMap[38] = "caret-begin";
            CodeEditorKeyManager.mIndexToCommandMap[39] = "selection-begin";
            CodeEditorKeyManager.mIndexToCommandMap[40] = "page-down";
            CodeEditorKeyManager.mIndexToCommandMap[41] = "caret-end";
            CodeEditorKeyManager.mIndexToCommandMap[42] = "selection-end";
            CodeEditorKeyManager.mIndexToCommandMap[43] = "caret-end-line";
            CodeEditorKeyManager.mIndexToCommandMap[44] = "selection-end-line";
            CodeEditorKeyManager.mIndexToCommandMap[45] = "caret-begin-line";
            CodeEditorKeyManager.mIndexToCommandMap[46] = "selection-begin-line";
            CodeEditorKeyManager.mIndexToCommandMap[47] = "caret-backward";
            CodeEditorKeyManager.mIndexToCommandMap[48] = "selection-backward";
            CodeEditorKeyManager.mIndexToCommandMap[49] = "caret-up";
            CodeEditorKeyManager.mIndexToCommandMap[50] = "selection-up";
            CodeEditorKeyManager.mIndexToCommandMap[51] = "selection-forward";
            CodeEditorKeyManager.mIndexToCommandMap[52] = "caret-forward";
            CodeEditorKeyManager.mIndexToCommandMap[53] = "selection-down";
            CodeEditorKeyManager.mIndexToCommandMap[54] = "caret-down";
            CodeEditorKeyManager.mIndexToCommandMap[55] = "delete-next";
            CodeEditorKeyManager.mIndexToCommandMap[56] = "null-action";
            CodeEditorKeyManager.mIndexToCommandMap[57] = "noOp-action";
            CodeEditorKeyManager.mIndexToCommandMap[58] = "delete-next-word";
            CodeEditorKeyManager.mIndexToCommandMap[59] = "delete-previous-word";
        }
        if (i < 1 || i >= mIndexToCommandMap.length) {
            return "";
        }
        return mIndexToCommandMap[i];
    }

    public boolean isKeystrokeJTextComponentDefault(KeyStroke k, String actionID) {
        InputMap parentMap = this.mParentInputMap;
        if (parentMap == null) {
            return false;
        }
        Object binding = parentMap.get(k);
        if (binding == null) {
            return false;
        }
        if (actionID == null) {
            return true;
        }
        if (binding instanceof String) {
            String mappedActionName = (String)binding;
            return mappedActionName.equals(actionID);
        }
        System.out.println("Debug: A non-String mapping found for: " + binding);
        return true;
    }

    public KeyInfoItem getInfoItemForKeyStroke(KeyStroke k) {
        for (KeyInfoItem kii : this.data) {
            for (KeyStroke key : kii.getKeyStrokeSet().values()) {
                if (!key.equals(k)) continue;
                return kii;
            }
        }
        return null;
    }

    protected Action getEditorActionForKey(KeyStroke k) {
        Object actionKey = this.m_Editor.getInputMap().get(k);
        ActionMap actionMap = this.m_Editor.getActionMap();
        if (actionKey == null) {
            return null;
        }
        Action action = actionMap.get(actionKey);
        return action;
    }

    public void ResetAll() {
        this.m_Editor.resetKeymap();
        this.InitializeData();
        this.SaveKeystrokes(false);
    }

    public void ResetAction(KeyInfoItem targetItem) {
        targetItem.reset();
    }

    public KeyInfoItem getKeyInfoItem(String actionName) {
        for (int i = 0; i < this.data.size(); ++i) {
            KeyInfoItem item = (KeyInfoItem)this.data.get(i);
            if (!item.GetActionID().equals(actionName)) continue;
            return item;
        }
        return null;
    }

    public void AssignKeystrokeForCommand(KeyInfoItem targetItem, KeyStroke k) {
        if (k == null) {
            return;
        }
        KeyInfoItem commandItem = this.getInfoItemForKeyStroke(k);
        if (commandItem != null) {
            String msg;
            int rc;
            if (!commandItem.GetActionID().equals("null-action") && (rc = JOptionPane.showOptionDialog(null, msg = resource.getString("CodeEditorKeyManager.KeystrokeInUse.txt"), resource.getString("Common.CodeEditor.txt"), 0, 2, null, null, null)) != 0) {
                return;
            }
            commandItem.removeKeystroke(k);
        }
        targetItem.addKeystroke(k);
    }

    public void RemoveKeystroke(KeyInfoItem targetItem, String keyStrokeString) {
        for (KeyStroke keyStroke : targetItem.getKeyStrokeSet().values()) {
            Action nullAction;
            String existingKeyStrokeString = CodeEditorKeyManager.KeystrokeToString(keyStroke);
            if (!existingKeyStrokeString.equals(keyStrokeString)) continue;
            targetItem.removeKeystroke(keyStroke);
            if (!this.isKeystrokeJTextComponentDefault(keyStroke, null) || this.isJTextComponentKeystrokeOkay(keyStroke) || (nullAction = targetItem.getAction("null-action")) == null) break;
            KeyInfoItem nullItem = this.getKeyInfoItem("null-action");
            if (nullItem != null) {
                nullItem.addKeystroke(keyStroke);
                break;
            }
            System.out.println("Error: Can't find null action");
            break;
        }
    }

    private boolean isJTextComponentKeystrokeOkay(KeyStroke keyStroke) {
        return keyStroke.getKeyCode() == 9 && keyStroke.getModifiers() == 0;
    }

    protected KeyInfoItem getCommandItemForActionName(String actionName) {
        if (actionName == null) {
            return null;
        }
        for (int index = 0; index < this.data.size(); ++index) {
            KeyInfoItem kii = (KeyInfoItem)this.data.get(index);
            if (!kii.getTranslatedName().equals(actionName)) continue;
            return kii;
        }
        return null;
    }

    public void PopulateCategoryComboBox(JComboBox cb) {
        int limit = 0;
        try {
            String num = resource.getString("CodeEditorKeyManager.NumberOfCategoryComboItems.txt");
            NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
            Number n = nf.parse(num);
            limit = n.intValue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i <= limit; ++i) {
            cb.addItem(resource.getString("CodeEditorKeyManager.CategoryComboItem." + i + ".txt"));
        }
    }

    protected void applyKeystrokesToEditor(boolean persist) {
        this.mKeymap.removeBindings();
        for (int index = 0; index < this.data.size(); ++index) {
            KeyInfoItem kii = (KeyInfoItem)this.data.get(index);
            kii.applyKeystrokes();
        }
        if (persist) {
            this.SaveKeystrokes(true);
        }
    }

    public void ApplyKeystrokes() {
        this.applyKeystrokesToEditor(true);
    }

    public void SaveKeystrokes(boolean persist) {
        this.defaults.setPropertyInt("CodeEditorKeyManager.version.txt", 2);
        for (int i = 0; i < this.data.size(); ++i) {
            String propertyString;
            String value;
            KeyInfoItem kii = (KeyInfoItem)this.data.get(i);
            KeyStroke[] keys = kii.getKeyStrokes();
            String name = kii.GetActionID();
            if (name.length() == 0) continue;
            for (int j = 0; j >= 0 && (value = this.defaults.getPropertyString(propertyString = "CodeEditorKeyManager." + name + "." + j + ".txt")) != null && value.length() != 0; ++j) {
                this.defaults.removePropertyString(propertyString);
            }
            int writtenItems = 0;
            for (int j = 0; j < keys.length; ++j) {
                if (this.isKeystrokeJTextComponentDefault(keys[j], name)) continue;
                this.defaults.setPropertyString("CodeEditorKeyManager." + name + "." + writtenItems + ".txt", keys[j].toString());
                ++writtenItems;
            }
        }
        if (persist) {
            this.defaults.saveProperties();
        }
    }

    protected boolean applyKeystrokesFromUserSettings() {
        this.mVersion = this.defaults.getPropertyInt("CodeEditorKeyManager.version.txt", 1);
        Action[] a = this.m_Editor.getEditorKit().getActions();
        boolean valuesFound = false;
        for (int i = 0; i < a.length; ++i) {
            String value;
            String name = (String)a[i].getValue("Name");
            int j = 0;
            while ((value = this.defaults.getPropertyString("CodeEditorKeyManager." + name + "." + j + ".txt")) != null && value.length() != 0) {
                valuesFound = true;
                ++j;
                KeyStroke k = this.stringToKeystroke(value);
                if (k == null) continue;
                this.mKeymap.removeKeyStrokeBinding(k);
                this.mKeymap.addActionForKeyStroke(k, a[i]);
            }
        }
        return valuesFound;
    }

    public boolean LoadKeystrokes() {
        boolean successful = true;
        this.InitializeData();
        boolean valuesFound = this.applyKeystrokesFromUserSettings();
        this.InitializeData();
        if (!valuesFound || this.mVersion < 2) {
            this.mKeymap.removeBindings();
            CodeEditorPane.loadKeymap(this.mKeymap, this.m_Editor.getDefaultBindings(), this.m_Editor.getEditorKit().getActions());
            this.InitializeData();
            this.applyKeystrokesFromUserSettings();
            this.InitializeData();
            this.mMigratingKeystrokes = false;
            this.SaveKeystrokes(true);
        } else if (this.mMigratingKeystrokes) {
            this.mMigratingKeystrokes = false;
            this.SaveKeystrokes(true);
        }
        return successful;
    }

    public static String KeystrokeToString(KeyStroke k) {
        String shift = resource.getString("Common.Shift.txt");
        String ctrl = resource.getString("Common.Ctrl.txt");
        String alt = resource.getString("Common.Alt.txt");
        if (k == null) {
            return "";
        }
        StringBuffer ret_val = new StringBuffer();
        int code = k.getKeyCode();
        String s = CodeEditorKeyManager.translateCharToString(code);
        if (s.length() == 0) {
            return "";
        }
        if ((k.getModifiers() & 1) != 0) {
            ret_val.append(shift);
            ret_val.append('+');
        }
        if ((k.getModifiers() & 2) != 0) {
            ret_val.append(ctrl);
            ret_val.append('+');
        }
        if ((k.getModifiers() & 8) != 0) {
            ret_val.append(alt);
            ret_val.append('+');
        }
        ret_val.append(s);
        return ret_val.toString();
    }

    protected KeyStroke stringToKeystroke(String s) {
        KeyStroke k = KeyStroke.getKeyStroke(s);
        if (k != null) {
            return k;
        }
        if (this.mVersion < 2) {
            this.mMigratingKeystrokes = true;
            return CodeEditorKeyManager.StringToKeystroke(s);
        }
        System.out.println("Error: unable to interpret keystring: " + s);
        return null;
    }

    public static KeyStroke StringToKeystroke(String s) {
        KeyStroke k = KeyStroke.getKeyStroke(s);
        if (k != null) {
            return k;
        }
        String str = s;
        String shift = resource.getString("Common.Shift.txt");
        String ctrl = resource.getString("Common.Ctrl.txt");
        String alt = resource.getString("Common.Alt.txt");
        int mask = 0;
        int key = 0;
        if (str.startsWith(shift)) {
            mask |= 1;
            str = str.substring(str.indexOf("+") + 1);
        }
        if (str.startsWith(ctrl)) {
            mask |= 2;
            str = str.substring(str.indexOf("+") + 1);
        }
        if (str.startsWith(alt)) {
            mask |= 8;
            str = str.substring(str.indexOf("+") + 1);
        }
        key = CodeEditorKeyManager.translateStringToChar(str);
        return KeyStroke.getKeyStroke(key, mask);
    }

    public static String translateCharToString(int c) {
        if (c == 10) {
            return resource.getString("CodeEditorKeyManager.EnterKey.txt");
        }
        if (c == 127) {
            return resource.getString("CodeEditorKeyManager.DeleteKey.txt");
        }
        if (c == 8) {
            return resource.getString("CodeEditorKeyManager.BackspaceKey.txt");
        }
        if (c == 35) {
            return resource.getString("CodeEditorKeyManager.EndKey.txt");
        }
        if (c == 36) {
            return resource.getString("CodeEditorKeyManager.HomeKey.txt");
        }
        if (c == 34) {
            return resource.getString("CodeEditorKeyManager.PageDownKey.txt");
        }
        if (c == 33) {
            return resource.getString("CodeEditorKeyManager.PageUpKey.txt");
        }
        if (c == 155) {
            return resource.getString("CodeEditorKeyManager.InsertKey.txt");
        }
        if (c == 9) {
            return resource.getString("CodeEditorKeyManager.TabKey.txt");
        }
        if (c == 222) {
            return resource.getString("CodeEditorKeyManager.QuoteKey.txt");
        }
        if (c == 32) {
            return resource.getString("CodeEditorKeyManager.SpacebarKey.txt");
        }
        if (c == 192) {
            return resource.getString("CodeEditorKeyManager.BackQuoteKey.txt");
        }
        if (c == 112) {
            return resource.getString("CodeEditorKeyManager.F1Key.txt");
        }
        if (c == 113) {
            return resource.getString("CodeEditorKeyManager.F2Key.txt");
        }
        if (c == 114) {
            return resource.getString("CodeEditorKeyManager.F3Key.txt");
        }
        if (c == 115) {
            return resource.getString("CodeEditorKeyManager.F4Key.txt");
        }
        if (c == 116) {
            return resource.getString("CodeEditorKeyManager.F5Key.txt");
        }
        if (c == 117) {
            return resource.getString("CodeEditorKeyManager.F6Key.txt");
        }
        if (c == 118) {
            return resource.getString("CodeEditorKeyManager.F7Key.txt");
        }
        if (c == 119) {
            return resource.getString("CodeEditorKeyManager.F8Key.txt");
        }
        if (c == 120) {
            return resource.getString("CodeEditorKeyManager.F9Key.txt");
        }
        if (c == 121) {
            return resource.getString("CodeEditorKeyManager.F10Key.txt");
        }
        if (c == 122) {
            return resource.getString("CodeEditorKeyManager.F11Key.txt");
        }
        if (c == 123) {
            return resource.getString("CodeEditorKeyManager.F12Key.txt");
        }
        if (c == 107) {
            return resource.getString("CodeEditorKeyManager.AddKey.txt");
        }
        if (c == 109) {
            return resource.getString("CodeEditorKeyManager.SubtractKey.txt");
        }
        if (c == 106) {
            return resource.getString("CodeEditorKeyManager.MultiplyKey.txt");
        }
        if (c == 38) {
            return resource.getString("CodeEditorKeyManager.UpKey.txt");
        }
        if (c == 40) {
            return resource.getString("CodeEditorKeyManager.DownKey.txt");
        }
        if (c == 39) {
            return resource.getString("CodeEditorKeyManager.RightKey.txt");
        }
        if (c == 37) {
            return resource.getString("CodeEditorKeyManager.LeftKey.txt");
        }
        if (c == 225) {
            return resource.getString("CodeEditorKeyManager.KpDownKey.txt");
        }
        if (c == 224) {
            return resource.getString("CodeEditorKeyManager.KpUpKey.txt");
        }
        if (c == 226) {
            return resource.getString("CodeEditorKeyManager.KpLeftKey.txt");
        }
        if (c == 227) {
            return resource.getString("CodeEditorKeyManager.KpRightKey.txt");
        }
        if (c == 96) {
            return "0";
        }
        if (c == 97) {
            return "1";
        }
        if (c == 98) {
            return "2";
        }
        if (c == 99) {
            return "3";
        }
        if (c == 100) {
            return "4";
        }
        if (c == 101) {
            return "5";
        }
        if (c == 102) {
            return "6";
        }
        if (c == 103) {
            return "7";
        }
        if (c == 104) {
            return "8";
        }
        if (c == 105) {
            return "9";
        }
        if (c == 111) {
            return resource.getString("CodeEditorKeyManager.DivideKey.txt");
        }
        if (c == 110) {
            return resource.getString("CodeEditorKeyManager.DecimalKey.txt");
        }
        if (c == 65485 || c == 65489 || c == 65487) {
            return "";
        }
        if (!Character.isISOControl((char)c)) {
            return String.valueOf((char)c);
        }
        return "";
    }

    public static int translateStringToChar(String s) {
        StringCharacterIterator sci = new StringCharacterIterator(s);
        if (s.length() == 1) {
            return sci.setIndex(0);
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.EnterKey.txt"))) {
            return 10;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.DeleteKey.txt"))) {
            return 127;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.BackspaceKey.txt"))) {
            return 8;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.EndKey.txt"))) {
            return 35;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.HomeKey.txt"))) {
            return 36;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.PageDownKey.txt"))) {
            return 34;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.PageUpKey.txt"))) {
            return 33;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.InsertKey.txt"))) {
            return 155;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.TabKey.txt"))) {
            return 9;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.SemicolonKey.txt"))) {
            return 59;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.QuoteKey.txt"))) {
            return 222;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.SpacebarKey.txt"))) {
            return 32;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.CommaKey.txt"))) {
            return 44;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.PeriodKey.txt"))) {
            return 46;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.F1Key.txt"))) {
            return 112;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.F2Key.txt"))) {
            return 113;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.F3Key.txt"))) {
            return 114;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.F4Key.txt"))) {
            return 115;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.F5Key.txt"))) {
            return 116;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.F6Key.txt"))) {
            return 117;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.F7Key.txt"))) {
            return 118;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.F8Key.txt"))) {
            return 119;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.F9Key.txt"))) {
            return 120;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.F10Key.txt"))) {
            return 121;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.F11Key.txt"))) {
            return 122;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.F12Key.txt"))) {
            return 123;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.AddKey.txt"))) {
            return 107;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.SubtractKey.txt"))) {
            return 109;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.MultiplyKey.txt"))) {
            return 106;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.UpKey.txt"))) {
            return 38;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.DownKey.txt"))) {
            return 40;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.RightKey.txt"))) {
            return 39;
        }
        if (s.equals(resource.getString("CodeEditorKeyManager.LeftKey.txt"))) {
            return 37;
        }
        return 0;
    }

    public KeyInfoItem[] getCommandItems() {
        return this.data.toArray(new KeyInfoItem[0]);
    }

    class KeyInfoItem {
        protected String m_TranslatedName;
        protected String m_Group;
        protected Map mKeystrokeSet;
        protected String mActionID;
        protected String m_Description;

        public void addKeystroke(KeyStroke k) {
            this.mKeystrokeSet.put(CodeEditorKeyManager.KeystrokeToString(k), k);
        }

        public KeyInfoItem(String n, String g, String d, String actionID) {
            this.m_TranslatedName = n;
            this.m_Group = g;
            this.m_Description = d;
            this.mActionID = actionID;
            if (this.mActionID.length() == 0) {
                System.out.println("Internal Error: Unknown action ID for:" + this.m_TranslatedName);
            }
            this.mKeystrokeSet = new HashMap();
            this.PopulateKeystrokeVector();
        }

        public String getTranslatedName() {
            return this.m_TranslatedName;
        }

        public String getGroup() {
            return this.m_Group;
        }

        public String getDescription() {
            return this.m_Description;
        }

        public Map getKeyStrokeSet() {
            return this.mKeystrokeSet;
        }

        public String getKeystrokeString() {
            if (this.mKeystrokeSet.size() == 0) {
                return "";
            }
            StringBuffer sb = new StringBuffer("");
            Iterator iter = this.mKeystrokeSet.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                sb.append(key);
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }

        public KeyStroke[] getKeyStrokes() {
            return this.mKeystrokeSet.values().toArray(new KeyStroke[0]);
        }

        public String[] getKeystrokeList() {
            return this.mKeystrokeSet.keySet().toArray(new String[0]);
        }

        public void removeKeystroke(KeyStroke ks) {
            boolean found;
            boolean bl = found = this.mKeystrokeSet.remove(CodeEditorKeyManager.KeystrokeToString(ks)) != null;
            if (!found) {
                System.out.println("Error: KeyStroke not found: " + ks);
            }
        }

        public void reset() {
            Action a = this.getAction();
            if (a == null) {
                return;
            }
            this.mKeystrokeSet.clear();
            String actionName = (String)a.getValue("Name");
            JTextComponent.KeyBinding[] kb = CodeEditorKeyManager.this.m_Editor.getDefaultBindings();
            this.updateDefaultKeys(kb, actionName);
            kb = CodeEditorKeyManager.this.m_Editor.getStandardKeyBindings();
            this.updateDefaultKeys(kb, actionName);
        }

        private void updateDefaultKeys(JTextComponent.KeyBinding[] defaultBindings, String actionName) {
            for (int i = 0; i < defaultBindings.length; ++i) {
                String testName = defaultBindings[i].actionName;
                if (!testName.equals(actionName)) continue;
                KeyInfoItem commandItem = CodeEditorKeyManager.this.getInfoItemForKeyStroke(defaultBindings[i].key);
                if (commandItem != null) {
                    commandItem.removeKeystroke(defaultBindings[i].key);
                }
                this.mKeystrokeSet.put(CodeEditorKeyManager.KeystrokeToString(defaultBindings[i].key), defaultBindings[i].key);
            }
        }

        public String GetActionID() {
            return this.mActionID;
        }

        public void PopulateKeystrokeVector() {
            this.mKeystrokeSet.clear();
            Action a = this.getAction();
            KeyStroke[] allKeys = CodeEditorKeyManager.this.m_Editor.getInputMap().allKeys();
            for (int i = 0; i < allKeys.length; ++i) {
                String keyString;
                KeyStroke key = allKeys[i];
                Action action = CodeEditorKeyManager.this.getEditorActionForKey(key);
                if (action == null || !action.equals(a) || (keyString = CodeEditorKeyManager.KeystrokeToString(key)).length() <= 0) continue;
                this.mKeystrokeSet.put(keyString, key);
            }
        }

        public Action getAction(String actionID) {
            Action[] a = CodeEditorKeyManager.this.m_Editor.getEditorKit().getActions();
            for (int i = 0; i < a.length; ++i) {
                Action cfr_ignored_0 = a[i];
                if (!actionID.equals(a[i].getValue("Name"))) continue;
                return a[i];
            }
            return null;
        }

        public Action getAction() {
            String actionID = this.GetActionID();
            if (actionID.length() == 0) {
                return null;
            }
            return this.getAction(actionID);
        }

        public void applyKeystrokes() {
            Action a = this.getAction();
            if (a == null) {
                return;
            }
            for (KeyStroke keystroke : this.mKeystrokeSet.values()) {
                CodeEditorKeyManager.this.mKeymap.removeKeyStrokeBinding(keystroke);
                CodeEditorKeyManager.this.mKeymap.addActionForKeyStroke(keystroke, a);
            }
        }
    }
}

