/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CSpinButton;
import com.sas.editor.CodeEditor;
import com.sas.editor.CodeEditorAppearanceDialog;
import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorKeysDialog;
import com.sas.editor.CodeEditorResource;
import com.sas.editor.CodeLanguage;
import com.sas.editor.LogListViewer;
import com.sas.editor.UserKeywordsDialog;
import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.StringCharacterIterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CodeEditorGeneralPane
extends JPanel {
    private static int MAX_TAB_SIZE = 15;
    private static FontMetrics fm;
    protected CodeEditorResource resource = null;
    protected CodeEditorDefaults defaults;
    protected CodeEditorDefaults mWorkingDefaults;
    protected Dialog m_dlg;
    protected CodeEditor m_Editor;
    protected boolean m_bCreateAppButton = true;
    protected boolean m_bCreateAssignKeysButton = true;
    protected JLabel FileTypeOptionsBorder = new JLabel();
    protected JLabel GeneralOptionsBorder = new JLabel();
    protected JLabel FileTypeOptionsCap = new JLabel();
    protected JLabel GeneralOptionsCap = new JLabel();
    protected JLabel tabBorder = new JLabel();
    protected JLabel tabCap = new JLabel();
    protected JLabel fileTypeLabel = new JLabel();
    protected JComboBox FileTypeCombo = new WideComboBox();
    protected JCheckBox ShowLineNumbersCheckbox = new JCheckBox();
    protected JCheckBox AutoIndentationCheckbox = new JCheckBox();
    protected JCheckBox DocumentColoringCheckbox = new JCheckBox();
    protected JCheckBox ReadOnlyCheckbox = new JCheckBox();
    protected CSpinButton TabSizeSpinButton = new CSpinButton(1, MAX_TAB_SIZE, 1, 1, 150);
    protected JLabel TabSizeLabel = new JLabel();
    protected JLabel SpaceLabel = new JLabel();
    protected JButton AppearanceButton = new JButton();
    protected JButton AssignKeysButton = new JButton();
    protected JButton UserKeywordsButton = new JButton();
    protected JLabel CodeFoldingBorder = new JLabel();
    protected JCheckBox CodeFoldingCheckbox = new JCheckBox();
    protected JCheckBox SectionLinesCheckbox = new JCheckBox();
    protected JCheckBox SectionBracketsCheckbox = new JCheckBox();
    protected GridBagLayout gridBagLayout1 = new GridBagLayout();
    protected CodeLanguage[] m_AppLanguages = null;

    public CodeEditorGeneralPane(Dialog dlg, boolean createAppButton, boolean createKeysButton) {
        this.initialize(dlg, null, new CodeEditorDefaults(), createAppButton, createKeysButton);
    }

    public CodeEditorGeneralPane(Dialog dlg, CodeEditorDefaults defs, boolean createAppButton, boolean createKeysButton) {
        this.initialize(dlg, null, defs, createAppButton, createKeysButton);
    }

    public CodeEditorGeneralPane(Dialog dlg, String defaults_file, boolean createAppButton, boolean createKeysButton) {
        this.initialize(dlg, null, new CodeEditorDefaults(defaults_file), createAppButton, createKeysButton);
    }

    private void initialize(Dialog dlg, CodeEditor editor, CodeEditorDefaults defs, boolean createAppButton, boolean createKeysButton) {
        this.m_dlg = dlg;
        this.m_Editor = editor;
        this.mWorkingDefaults = defs.newDataCopy();
        if (this.mWorkingDefaults == null) {
            this.mWorkingDefaults = new CodeEditorDefaults((String)null);
        }
        this.defaults = defs;
        this.m_bCreateAppButton = createAppButton;
        this.m_bCreateAssignKeysButton = createKeysButton;
        this.resource = new CodeEditorResource(CodeEditorGeneralPane.class);
        fm = this.getFontMetrics(this.getFont());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() {
        this.setupMnemonics(this.ShowLineNumbersCheckbox, "CodeEditorGeneralPane.ShowLineNumbers.txt");
        this.setupMnemonics(this.AutoIndentationCheckbox, "CodeEditorGeneralPane.AutoIndent.txt");
        this.setupMnemonics(this.DocumentColoringCheckbox, "CodeEditorGeneralPane.DocumentColoring.txt");
        this.setupMnemonics(this.ReadOnlyCheckbox, "CodeEditorGeneralPane.ReadOnly.txt");
        this.setupMnemonics(this.TabSizeLabel, "CodeEditorGeneralPane.TabSizeLabel.txt");
        this.SpaceLabel.setText(this.resource.getString("CodeEditorGeneralPane.SpaceLabel.txt"));
        this.GeneralOptionsCap.setText(this.resource.getString("CodeEditorGeneralPane.GeneralOptionsBoxLabel.txt") + "  ");
        this.tabCap.setText(this.resource.getString("CodeEditorGeneralPane.TabBoxTitle.txt") + "  ");
        this.setupMnemonics(this.AppearanceButton, "CodeEditorGeneralPane.AppearanceButtonLabel.txt");
        this.setupMnemonics(this.AssignKeysButton, "CodeEditorGeneralPane.AssignKeysButtonLabel.txt");
        this.setupMnemonics(this.UserKeywordsButton, "CodeEditorGeneralPane.UserKeywordsButtonLabel.txt");
        this.setupMnemonics(this.fileTypeLabel, "CodeEditorGeneralPane.FileTypeComboLabel.txt");
        this.FileTypeOptionsCap.setText(this.resource.getString("CodeEditorGeneralPane.FileTypeOptionsLabel.txt") + "  ");
        this.setupMnemonics(this.CodeFoldingCheckbox, "CodeEditorGeneralPane.CodeFoldingEnabled.txt");
        this.setupMnemonics(this.SectionLinesCheckbox, "CodeEditorGeneralPane.ShowSectionLines.txt");
        this.setupMnemonics(this.SectionBracketsCheckbox, "CodeEditorGeneralPane.ShowSectionBrackets.txt");
        this.TabSizeSpinButton.setValue(this.mWorkingDefaults.getTabSize());
        this.FileTypeCombo.addItem(this.resource.getString("CodeEditorGeneralPane.FileTypeComboItem.sas.txt"));
        this.FileTypeCombo.addItem(this.resource.getString("CodeEditorGeneralPane.FileTypeComboItem.html.txt"));
        this.FileTypeCombo.addItem(this.resource.getString("CodeEditorGeneralPane.FileTypeComboItem.java.txt"));
        if (this.m_Editor != null) {
            if (this.m_Editor.getLanguage() == CodeLanguage.SAS) {
                this.FileTypeCombo.setSelectedIndex(0);
            } else if (this.m_Editor.getLanguage() == CodeLanguage.HTML) {
                this.FileTypeCombo.setSelectedIndex(1);
            } else if (this.m_Editor.getLanguage() == CodeLanguage.JAVA) {
                this.FileTypeCombo.setSelectedIndex(2);
            }
        } else {
            this.FileTypeCombo.setSelectedIndex(this.mWorkingDefaults.getPropertyInt("CodeEditorGeneralPane.LastSelectedFileType.txt", 0));
        }
        this.CodeFoldingCheckbox.setSelected(this.mWorkingDefaults.getCodeFoldingEnabled());
        this.SectionBracketsCheckbox.setSelected(this.mWorkingDefaults.getShowSectionBrackets());
        this.SectionLinesCheckbox.setSelected(this.mWorkingDefaults.getShowSectionLines());
        this.FileTypeClicked();
        this.ShowLineNumbersCheckbox.setSelected(this.mWorkingDefaults.getShowLineNumbers());
        this.AutoIndentationCheckbox.setSelected(this.mWorkingDefaults.getSmartIndent());
        if (this.m_Editor != null) {
            this.DocumentColoringCheckbox.setSelected(this.m_Editor.isDocumentColoringEnabled());
            this.ReadOnlyCheckbox.setSelected(this.m_Editor.isReadOnly());
        } else {
            this.DocumentColoringCheckbox.setSelected(this.mWorkingDefaults.getDocumentColoring());
            this.ReadOnlyCheckbox.setSelected(false);
        }
        this.InitializeCodeFoldingItems();
        this.GeneralOptionsBorder.setBorder(BorderFactory.createEtchedBorder());
        this.tabBorder.setBorder(BorderFactory.createEtchedBorder());
        this.GeneralOptionsCap.setOpaque(true);
        this.tabCap.setOpaque(true);
        this.FileTypeOptionsBorder.setBorder(BorderFactory.createEtchedBorder());
        this.CodeFoldingBorder.setBorder(BorderFactory.createEtchedBorder());
        this.FileTypeOptionsCap.setOpaque(true);
        this.CodeFoldingCheckbox.setOpaque(true);
        Dimension spbtnSize = new Dimension(1000, (int)this.TabSizeSpinButton.getDataEntryField().getPreferredSize().getHeight());
        this.TabSizeSpinButton.setMaximumSize(spbtnSize);
        this.TabSizeSpinButton.addValueChangedListener(new CSpinButton.ValueChangedListener(){

            @Override
            public void valueChanged(int oldValue, int newValue) {
                int ts = CodeEditorGeneralPane.this.TabSizeSpinButton.getValue();
                if (ts >= 1 && ts <= MAX_TAB_SIZE) {
                    CodeEditorGeneralPane.this.mWorkingDefaults.setTabSize(ts, false);
                    CodeEditorGeneralPane.this.mWorkingDefaults.firePreferenceChangeUpdate();
                }
            }
        });
        JPanel checkPane = new JPanel(new GridLayout(2, 2));
        checkPane.add(this.ShowLineNumbersCheckbox);
        checkPane.add(this.DocumentColoringCheckbox);
        checkPane.add(this.AutoIndentationCheckbox);
        checkPane.add(this.ReadOnlyCheckbox);
        this.AutoIndentationCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorGeneralPane.this.mWorkingDefaults.setSmartIndent(CodeEditorGeneralPane.this.AutoIndentationCheckbox.isSelected(), false);
                CodeEditorGeneralPane.this.mWorkingDefaults.firePreferenceChangeUpdate();
            }
        });
        this.ShowLineNumbersCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorGeneralPane.this.mWorkingDefaults.setShowLineNumbers(CodeEditorGeneralPane.this.ShowLineNumbersCheckbox.isSelected(), false);
                CodeEditorGeneralPane.this.mWorkingDefaults.firePreferenceChangeUpdate();
            }
        });
        this.DocumentColoringCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorGeneralPane.this.mWorkingDefaults.setDocumentColoring(CodeEditorGeneralPane.this.DocumentColoringCheckbox.isSelected(), false);
                CodeEditorGeneralPane.this.mWorkingDefaults.firePreferenceChangeUpdate();
            }
        });
        Box genBox = Box.createHorizontalBox();
        genBox.add(Box.createHorizontalStrut(7));
        genBox.add(checkPane);
        genBox.add(Box.createHorizontalStrut(7));
        Box ftSubBox = Box.createHorizontalBox();
        ftSubBox.add(this.fileTypeLabel);
        ftSubBox.add(Box.createHorizontalStrut(7));
        ftSubBox.add(this.FileTypeCombo);
        Dimension preferredSize = ftSubBox.getPreferredSize();
        ftSubBox.setMaximumSize(new Dimension(1000, (int)preferredSize.getHeight()));
        Box ftBox = Box.createVerticalBox();
        ftBox.add(ftSubBox);
        ftBox.add(Box.createVerticalGlue());
        Box tabBox = Box.createHorizontalBox();
        tabBox.add(this.TabSizeLabel);
        tabBox.add(Box.createHorizontalStrut(7));
        tabBox.add(this.TabSizeSpinButton);
        tabBox.add(Box.createHorizontalStrut(7));
        tabBox.add(this.SpaceLabel);
        tabBox.add(Box.createHorizontalGlue());
        Box foldBox = Box.createVerticalBox();
        foldBox.add(this.SectionLinesCheckbox);
        foldBox.add(this.SectionBracketsCheckbox);
        Box btnBox = Box.createHorizontalBox();
        if (this.m_bCreateAssignKeysButton && this.m_bCreateAppButton) {
            Box btnBox1 = Box.createVerticalBox();
            btnBox1.add(this.UserKeywordsButton);
            btnBox1.add(Box.createVerticalStrut(5));
            btnBox1.add(this.AppearanceButton);
            btnBox1.add(Box.createVerticalGlue());
            Box btnBox2 = Box.createVerticalBox();
            btnBox2.add(this.AssignKeysButton);
            btnBox2.add(Box.createVerticalStrut(5));
            btnBox2.add(Box.createVerticalGlue());
            btnBox.add(btnBox1);
            btnBox.add(Box.createHorizontalStrut(5));
            btnBox.add(Box.createHorizontalGlue());
            btnBox.add(btnBox2);
        } else if (this.m_bCreateAssignKeysButton) {
            btnBox.add(this.UserKeywordsButton);
            btnBox.add(Box.createHorizontalStrut(5));
            btnBox.add(Box.createHorizontalGlue());
            btnBox.add(this.AssignKeysButton);
        } else if (this.m_bCreateAppButton) {
            btnBox.add(this.UserKeywordsButton);
            btnBox.add(Box.createHorizontalStrut(5));
            btnBox.add(Box.createHorizontalGlue());
            btnBox.add(this.AppearanceButton);
        } else {
            btnBox.add(this.UserKeywordsButton);
            btnBox.add(Box.createHorizontalGlue());
        }
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.GeneralOptionsCap, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.GeneralOptionsBorder, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)genBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(20, 5, 15, 5), 0, 0));
        this.add((Component)tabBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)ftBox, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.CodeFoldingCheckbox, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 15, 0, 0), 0, 0));
        this.add((Component)this.CodeFoldingBorder, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)foldBox, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(25, 30, 12, 10), 0, 0));
        this.add((Component)btnBox, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.TabSizeLabel.setLabelFor(this.TabSizeSpinButton.getDataEntryField());
        this.fileTypeLabel.setLabelFor(this.FileTypeCombo);
        this.AppearanceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorGeneralPane.this.OnAppearance();
            }
        });
        this.AssignKeysButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorGeneralPane.this.OnAssignKeys();
            }
        });
        this.UserKeywordsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorGeneralPane.this.OnUserKeywords();
            }
        });
        this.CodeFoldingCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorGeneralPane.this.CodeFoldingClicked();
            }
        });
        this.SectionBracketsCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorGeneralPane.this.CodeFoldingClicked();
            }
        });
        this.SectionLinesCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorGeneralPane.this.CodeFoldingClicked();
            }
        });
        this.FileTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorGeneralPane.this.FileTypeClicked();
            }
        });
    }

    public void InitializeCodeFoldingItems() {
        this.CodeFoldingCheckbox.setSelected(this.mWorkingDefaults.getCodeFoldingEnabled());
        this.SectionLinesCheckbox.setSelected(this.mWorkingDefaults.getShowSectionLines());
        this.SectionBracketsCheckbox.setSelected(this.mWorkingDefaults.getShowSectionBrackets());
        boolean bEnable = this.CodeFoldingCheckbox.isSelected();
        this.SectionLinesCheckbox.setEnabled(bEnable);
        this.SectionBracketsCheckbox.setEnabled(bEnable);
    }

    public void OnAppearance() {
        CodeEditorAppearanceDialog ad = CodeEditorAppearanceDialog.CreateDialog(this.m_dlg.getOwner(), this.mWorkingDefaults, this.m_Editor);
        if (ad == null) {
            return;
        }
        if (this.m_AppLanguages != null) {
            ad.customizeFileTypes(this.m_AppLanguages);
        } else {
            ad.setInitialLanguage(this.FileTypeCombo.getSelectedIndex());
        }
        ad.setLocationRelativeTo(null);
        ad.setVisible(true);
    }

    public void OnAssignKeys() {
        CodeEditorKeysDialog jd = CodeEditorKeysDialog.CreateDialog(this.m_dlg, this.mWorkingDefaults);
        if (jd == null) {
            return;
        }
        jd.setLocationRelativeTo(null);
        jd.setVisible(true);
    }

    public void OnUserKeywords() {
        UserKeywordsDialog ukd = UserKeywordsDialog.CreateDialog(this.m_dlg.getOwner(), this.mWorkingDefaults);
        ukd.setLocationRelativeTo(null);
        ukd.setVisible(true);
    }

    public void CodeFoldingClicked() {
        boolean enabled = this.CodeFoldingCheckbox.isSelected() && this.CodeFoldingCheckbox.isEnabled();
        this.SectionLinesCheckbox.setEnabled(enabled);
        this.SectionBracketsCheckbox.setEnabled(enabled);
        this.mWorkingDefaults.setCodeFoldingEnabled(this.CodeFoldingCheckbox.isSelected(), false);
        this.mWorkingDefaults.setShowSectionBrackets(this.SectionBracketsCheckbox.isSelected(), false);
        this.mWorkingDefaults.setShowSectionLines(this.SectionLinesCheckbox.isSelected(), false);
        this.mWorkingDefaults.firePreferenceChangeUpdate();
    }

    public void FileTypeClicked() {
        int lang = this.FileTypeCombo.getSelectedIndex();
        boolean bEnable = lang == 0;
        this.CodeFoldingCheckbox.setEnabled(bEnable);
        this.CodeFoldingClicked();
    }

    public void OnApply() {
        if (this.m_Editor != null && !(this.m_Editor instanceof LogListViewer)) {
            this.m_Editor.SetReadOnly(this.ReadOnlyCheckbox.isSelected());
        }
        this.mWorkingDefaults.setPropertyInt("CodeEditorGeneralPane.LastSelectedFileType.txt", this.FileTypeCombo.getSelectedIndex());
        this.defaults.copyPropertiesFrom(this.mWorkingDefaults);
        this.defaults.saveProperties();
    }

    public void cleanup() {
        if (this.TabSizeSpinButton != null) {
            this.TabSizeSpinButton.cleanup();
        }
    }

    public int getWidthOfString(String s) {
        StringCharacterIterator sci = new StringCharacterIterator("null");
        sci.setText(s);
        int size = 0;
        for (int i = sci.getBeginIndex(); i <= sci.getEndIndex(); ++i) {
            size += fm.charWidth(sci.setIndex(i));
        }
        return size;
    }

    public void customizeAppearanceFileTypes(CodeLanguage[] langs) {
        this.m_AppLanguages = langs;
    }

    public void customizeFileTypes(CodeLanguage[] langs) {
        if (langs.length == 0) {
            return;
        }
        this.FileTypeCombo.removeAllItems();
        String sas = this.resource.getString("CodeEditorGeneralPane.FileTypeComboItem.sas.txt");
        String html = this.resource.getString("CodeEditorGeneralPane.FileTypeComboItem.html.txt");
        String java = this.resource.getString("CodeEditorGeneralPane.FileTypeComboItem.java.txt");
        CodeLanguage currLang = this.m_Editor == null ? langs[0] : this.m_Editor.getLanguage();
        int selIndex = 0;
        for (int i = 0; i < langs.length; ++i) {
            if (langs[i] == CodeLanguage.SAS) {
                this.FileTypeCombo.addItem(sas);
            } else if (langs[i] == CodeLanguage.HTML) {
                this.FileTypeCombo.addItem(html);
            } else if (langs[i] == CodeLanguage.JAVA) {
                this.FileTypeCombo.addItem(java);
            }
            if (langs[i] != currLang) continue;
            selIndex = i;
        }
        this.FileTypeCombo.setSelectedIndex(selIndex);
    }

    public void showReadOnlyCheckbox(boolean b) {
        this.ReadOnlyCheckbox.setVisible(b);
    }

    public CodeEditorDefaults getDefaults() {
        return this.defaults;
    }

    public CodeEditorDefaults getWorkingCopy() {
        return this.mWorkingDefaults;
    }

    protected void setupMnemonics(JLabel lbl, String key) {
        String lblItem = this.resource.getString(key);
        String lblText = Util.getLabelWithoutMnemonic((String)lblItem);
        lbl.setText(lblText);
        int index = Util.getDisplayedMnemonicIndex((String)lblItem);
        if (index > -1) {
            lbl.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)lblItem));
            lbl.setDisplayedMnemonicIndex(index);
        }
    }

    protected void setupMnemonics(JButton btn, String key) {
        String buttonItem = this.resource.getString(key);
        String buttonText = Util.getLabelWithoutMnemonic((String)buttonItem);
        btn.setText(buttonText);
        int index = Util.getDisplayedMnemonicIndex((String)buttonItem);
        if (index > -1) {
            btn.setMnemonic(Util.getDisplayedMnemonic((String)buttonItem));
            btn.setDisplayedMnemonicIndex(index);
        }
    }

    protected void setupMnemonics(JCheckBox chb, String key) {
        String buttonItem = this.resource.getString(key);
        String buttonText = Util.getLabelWithoutMnemonic((String)buttonItem);
        chb.setText(buttonText);
        int index = Util.getDisplayedMnemonicIndex((String)buttonItem);
        if (index > -1) {
            chb.setMnemonic(Util.getDisplayedMnemonic((String)buttonItem));
            chb.setDisplayedMnemonicIndex(index);
        }
    }
}

