/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.AttributeMap;
import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorResource;
import com.sas.editor.CodeEditorSchemeManager;
import com.sas.editor.SasColor;
import com.sas.editor.language.HtmlElements;
import com.sas.editor.language.IElements;
import com.sas.editor.language.JavaElements;
import com.sas.editor.language.ListElements;
import com.sas.editor.language.LogElements;
import com.sas.editor.language.SasElements;
import java.awt.Color;
import java.awt.Font;
import java.text.Collator;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;

public class CodeEditorAttributeManager {
    Collator coll = Collator.getInstance(Locale.getDefault());
    protected CodeEditorResource resource = new CodeEditorResource(CodeEditorAttributeManager.class);
    protected CodeEditorDefaults defaults;
    protected static Color[] Colors = new Color[]{SasColor.black, SasColor.blue, SasColor.burgandy, SasColor.cyan, SasColor.darkGray, SasColor.darkGreen, SasColor.gray, SasColor.green, SasColor.lightGray, SasColor.lightYellow, SasColor.magenta, SasColor.navy, SasColor.offWhite, SasColor.orange, SasColor.pink, SasColor.purple, SasColor.red, SasColor.teal, SasColor.white, SasColor.yellow};
    protected String[] ColorNames = new String[]{this.resource.getString("CodeEditorAttributeManager.black.txt"), this.resource.getString("CodeEditorAttributeManager.blue.txt"), this.resource.getString("CodeEditorAttributeManager.burgandy.txt"), this.resource.getString("CodeEditorAttributeManager.cyan.txt"), this.resource.getString("CodeEditorAttributeManager.darkgray.txt"), this.resource.getString("CodeEditorAttributeManager.darkgreen.txt"), this.resource.getString("CodeEditorAttributeManager.gray.txt"), this.resource.getString("CodeEditorAttributeManager.green.txt"), this.resource.getString("CodeEditorAttributeManager.lightgray.txt"), this.resource.getString("CodeEditorAttributeManager.lightyellow.txt"), this.resource.getString("CodeEditorAttributeManager.magenta.txt"), this.resource.getString("CodeEditorAttributeManager.navy.txt"), this.resource.getString("CodeEditorAttributeManager.offwhite.txt"), this.resource.getString("CodeEditorAttributeManager.orange.txt"), this.resource.getString("CodeEditorAttributeManager.pink.txt"), this.resource.getString("CodeEditorAttributeManager.purple.txt"), this.resource.getString("CodeEditorAttributeManager.red.txt"), this.resource.getString("CodeEditorAttributeManager.teal.txt"), this.resource.getString("CodeEditorAttributeManager.white.txt"), this.resource.getString("CodeEditorAttributeManager.yellow.txt")};
    protected String[] FontStyleNames = new String[]{this.resource.getString("CodeEditorAttributeManager.normal.txt"), this.resource.getString("CodeEditorAttributeManager.bold.txt"), this.resource.getString("CodeEditorAttributeManager.italic.txt"), this.resource.getString("CodeEditorAttributeManager.bolditalic.txt")};

    public CodeEditorAttributeManager(CodeEditorDefaults defs) {
        this.defaults = defs;
    }

    public String[] getColorNames() {
        return this.ColorNames;
    }

    public String[] getFontStyleNames() {
        return this.FontStyleNames;
    }

    protected Color getSingleBgColor(int langID) {
        String c = this.defaults.getPropertyString("CodeEditorDefaults." + langID + ".SingleBgColor.txt");
        if (c != null) {
            return this.StringToColor(c);
        }
        return null;
    }

    public boolean isUsingSingleBgColor(int langID) {
        String b = this.defaults.getPropertyString("CodeEditorDefaults." + langID + ".UsingSingleBgColor.txt");
        if (b != null) {
            return this.StringToBoolean(b);
        }
        return false;
    }

    public Color[] getColors() {
        return Colors;
    }

    protected IElements getElements(int langID) {
        switch (langID) {
            case 2: {
                return new SasElements();
            }
            case 3: {
                return new HtmlElements();
            }
            case 4: {
                return new JavaElements();
            }
            case 5: {
                return new LogElements();
            }
            case 6: {
                return new ListElements();
            }
        }
        return null;
    }

    public AttributeMap getAttributeMap(int langID) {
        AttributeMap map = new AttributeMap();
        String base = "CodeEditorAttributeManager.";
        String end = ".txt";
        String fgstr = ".foreground";
        String bgstr = ".background";
        String boldstr = ".bold";
        String italstr = ".italic";
        String name = "";
        IElements langElements = this.getElements(langID);
        if (langElements == null) {
            return null;
        }
        short first = langElements.getLowerBound();
        short last = langElements.getUpperBound();
        for (short index = first; index <= last; index = (short)(index + 1)) {
            name = langElements.toString(index);
            Color fg = this.StringToColor(this.defaults.getPropertyString(base + name + fgstr + end));
            Color bg = this.StringToColor(this.defaults.getPropertyString(base + name + bgstr + end));
            boolean bold = this.StringToBoolean(this.defaults.getPropertyString(base + name + boldstr + end));
            boolean italic = this.StringToBoolean(this.defaults.getPropertyString(base + name + italstr + end));
            if (fg == null || bg == null) {
                return null;
            }
            map.addElementAttributes(index, fg, bg, bold, italic);
        }
        Font f = this.defaults.getFont(langID);
        if (f == null) {
            f = CodeEditorSchemeManager.PREDEFINED_FONT;
        }
        map.addFontAttributes(f);
        map.setUsingSingleBgColor(this.isUsingSingleBgColor(langID));
        map.setSingleBgColor(this.getSingleBgColor(langID));
        return map;
    }

    public AttributeMap getUserDefinedScheme(String schemeName, int langID) {
        AttributeMap map = new AttributeMap();
        String base = "";
        String end = ".txt";
        String fgstr = ".foreground";
        String bgstr = ".background";
        String boldstr = ".bold";
        String italstr = ".italic";
        String name = "";
        IElements langElements = this.getElements(langID);
        switch (langID) {
            case 2: {
                base = "UserDefinedScheme.Sas.";
                break;
            }
            case 3: {
                base = "UserDefinedScheme.Html.";
                break;
            }
            case 4: {
                base = "UserDefinedScheme.Java.";
                break;
            }
            case 5: {
                base = "UserDefinedScheme.Log.";
                break;
            }
            case 6: {
                base = "UserDefinedScheme.List.";
                break;
            }
            default: {
                return null;
            }
        }
        short first = langElements.getLowerBound();
        short last = langElements.getUpperBound();
        for (short index = first; index <= last; index = (short)(index + 1)) {
            name = langElements.toString(index);
            Color fg = this.StringToColor(this.defaults.getPropertyString(base + schemeName + "." + name + fgstr + end));
            Color bg = this.StringToColor(this.defaults.getPropertyString(base + schemeName + "." + name + bgstr + end));
            boolean bold = this.StringToBoolean(this.defaults.getPropertyString(base + schemeName + "." + name + boldstr + end));
            boolean italic = this.StringToBoolean(this.defaults.getPropertyString(base + schemeName + "." + name + italstr + end));
            if (fg == null || bg == null) {
                return null;
            }
            map.addElementAttributes(index, fg, bg, bold, italic);
        }
        String fontName = base + schemeName + ".FontName.txt";
        String fontSize = base + schemeName + ".FontSize.txt";
        Font f = new Font(this.defaults.getPropertyString(fontName), 0, this.defaults.getPropertyInt(fontSize));
        map.addFontAttributes(f);
        return map;
    }

    public void setAttributeMap(AttributeMap map, int langID, boolean saveAttrs) {
        if (map == null) {
            return;
        }
        IElements langElements = this.getElements(langID);
        if (langElements == null) {
            return;
        }
        short first = langElements.getLowerBound();
        short last = langElements.getUpperBound();
        for (short index = first; index <= last; index = (short)(index + 1)) {
            AttributeSet attrs = map.getElementAttributes(index);
            if (attrs == null) continue;
            String fg = this.ColorToString(StyleConstants.getForeground(attrs));
            String bg = this.ColorToString(StyleConstants.getBackground(attrs));
            String bold = this.BooleanToString(StyleConstants.isBold(attrs));
            String italic = this.BooleanToString(StyleConstants.isItalic(attrs));
            String name = langElements.toString(index);
            this.writeAttribute(name, fg, bg, bold, italic);
        }
        Font f = map.getFontAttributes();
        this.defaults.storeFont(f, langID, false);
        this.storeSingleBgColor(map.getSingleBgColor(), map.isUsingSingleBgColor(), langID, false);
        if (saveAttrs) {
            this.defaults.saveProperties();
        }
    }

    public void saveScheme(AttributeMap map, String schemeName, int langID, boolean saveAttrs) {
        if (map == null) {
            return;
        }
        IElements langElements = this.getElements(langID);
        if (langElements == null) {
            return;
        }
        short first = langElements.getLowerBound();
        short last = langElements.getUpperBound();
        for (short index = first; index <= last; index = (short)(index + 1)) {
            AttributeSet attrs = map.getElementAttributes(index);
            if (attrs == null) continue;
            String fg = this.ColorToString(StyleConstants.getForeground(attrs));
            String bg = this.ColorToString(StyleConstants.getBackground(attrs));
            String bold = this.BooleanToString(StyleConstants.isBold(attrs));
            String italic = this.BooleanToString(StyleConstants.isItalic(attrs));
            String name = langElements.toString(index);
            this.writeSchemedAttribute(schemeName + "." + name, fg, bg, bold, italic);
        }
        String fontName = "UserDefinedScheme." + schemeName + ".FontName.txt";
        String fontSize = "UserDefinedScheme." + schemeName + ".FontSize.txt";
        Font f = map.getFontAttributes();
        this.defaults.setPropertyString(fontName, f.getName());
        this.defaults.setPropertyInt(fontSize, f.getSize());
        if (saveAttrs) {
            this.defaults.saveProperties();
        }
    }

    public Color StringToColor(String s) {
        for (int i = 0; i < Colors.length; ++i) {
            if (this.coll.compare(s, this.ColorNames[i]) != 0) continue;
            return Colors[i];
        }
        return null;
    }

    public String ColorToString(Color c) {
        for (int i = 0; i < this.ColorNames.length; ++i) {
            if (c != Colors[i]) continue;
            return this.ColorNames[i];
        }
        return "";
    }

    public boolean StringToBoolean(String s) {
        return this.coll.compare(s, Boolean.TRUE.toString()) == 0;
    }

    public String BooleanToString(boolean b) {
        return Boolean.valueOf(b).toString();
    }

    public void writeAttribute(String name, String fg, String bg, String bold, String italic) {
        String key1 = "CodeEditorAttributeManager." + name + ".foreground.txt";
        String key2 = "CodeEditorAttributeManager." + name + ".background.txt";
        String key3 = "CodeEditorAttributeManager." + name + ".bold.txt";
        String key4 = "CodeEditorAttributeManager." + name + ".italic.txt";
        this.defaults.setPropertyString(key1, fg);
        this.defaults.setPropertyString(key2, bg);
        this.defaults.setPropertyString(key3, bold);
        this.defaults.setPropertyString(key4, italic);
    }

    public void writeSchemedAttribute(String name, String fg, String bg, String bold, String italic) {
        String key1 = "UserDefinedScheme." + name + ".foreground.txt";
        String key2 = "UserDefinedScheme." + name + ".background.txt";
        String key3 = "UserDefinedScheme." + name + ".bold.txt";
        String key4 = "UserDefinedScheme." + name + ".italic.txt";
        this.defaults.setPropertyString(key1, fg);
        this.defaults.setPropertyString(key2, bg);
        this.defaults.setPropertyString(key3, bold);
        this.defaults.setPropertyString(key4, italic);
    }

    public void removeScheme(String schemeName, int langID, boolean saveAttrs) {
        String lang;
        IElements langElements = this.getElements(langID);
        switch (langID) {
            case 2: {
                lang = "Sas.";
                break;
            }
            case 3: {
                lang = "Html.";
                break;
            }
            case 4: {
                lang = "Java.";
                break;
            }
            case 5: {
                lang = "Log.";
                break;
            }
            case 6: {
                lang = "List.";
                break;
            }
            default: {
                return;
            }
        }
        short first = langElements.getLowerBound();
        short last = langElements.getUpperBound();
        for (short index = first; index <= last; index = (short)(index + 1)) {
            String attributeName = lang + schemeName + "." + langElements.toString(index);
            this.removeSchemedAttribute(attributeName);
        }
        String fontName = "UserDefinedScheme." + schemeName + ".FontName.txt";
        String fontSize = "UserDefinedScheme." + schemeName + ".FontSize.txt";
        this.defaults.removePropertyString(fontName);
        this.defaults.removePropertyString(fontSize);
        if (saveAttrs) {
            this.defaults.saveProperties();
        }
    }

    public void removeSchemedAttribute(String name) {
        String key1 = "UserDefinedScheme." + name + ".foreground.txt";
        String key2 = "UserDefinedScheme." + name + ".background.txt";
        String key3 = "UserDefinedScheme." + name + ".bold.txt";
        String key4 = "UserDefinedScheme." + name + ".italic.txt";
        this.defaults.removePropertyString(key1);
        this.defaults.removePropertyString(key2);
        this.defaults.removePropertyString(key3);
        this.defaults.removePropertyString(key4);
    }

    public void storeFont(Font f, int langID, boolean saveAttrs) {
        this.defaults.storeFont(f, langID, saveAttrs);
    }

    public void storeSingleBgColor(Color c, boolean usingSingleBgColor, int langID, boolean saveAttrs) {
        this.defaults.setPropertyString("CodeEditorDefaults." + langID + ".UsingSingleBgColor.txt", c == null ? "false" : this.BooleanToString(usingSingleBgColor));
        this.defaults.setPropertyString("CodeEditorDefaults." + langID + ".SingleBgColor.txt", c == null ? "" : this.ColorToString(c));
        if (saveAttrs) {
            this.defaults.saveProperties();
        }
    }

    public Font getFont(int langID) {
        return this.defaults.getFont(langID);
    }
}

