/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.AttributeMap;
import com.sas.editor.CodeEditor;
import com.sas.editor.CodeEditorAttributeManager;
import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorPreview;
import com.sas.editor.CodeEditorResource;
import com.sas.editor.CodeEditorSchemeManager;
import com.sas.editor.CodeLanguage;
import com.sas.editor.LogListHolder;
import com.sas.editor.LogListPreview;
import com.sas.editor.language.HtmlElements;
import com.sas.editor.language.IElements;
import com.sas.editor.language.JavaElements;
import com.sas.editor.language.ListElements;
import com.sas.editor.language.LogElements;
import com.sas.editor.language.SasElements;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControl;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.text.NumberFormat;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;

public class CodeEditorAppearancePane
extends JPanel {
    protected CodeEditor m_Editor;
    protected CodeEditorResource resource;
    protected CodeEditorDefaults mWorkingDefaults;
    protected CodeLanguage m_Lang;
    private Collator coll = Collator.getInstance(Locale.getDefault());
    protected int m_nCurrentFileType = 0;
    protected short m_ElementOffset = 0;
    protected AttributeMap HtmlMap;
    protected AttributeMap SasMap;
    protected AttributeMap JavaMap;
    protected AttributeMap LogMap;
    protected AttributeMap ListMap;
    protected AttributeMap CurrentMap;
    private boolean UpdateInProgress = false;
    private boolean freezeSchemeInput = false;
    protected CodeEditorAttributeManager attrManager;
    protected CodeEditorSchemeManager schemeManager;
    protected ElementListManager m_ElementManager;
    private static FontMetrics fm;
    private static final int[] FontSizes;
    protected JLabel FileTypeLabel = new JLabel();
    protected JLabel SchemeLabel = new JLabel();
    protected JComboBox FileTypeCombo = new WideComboBox();
    protected JComboBox SchemeCombo = new WideComboBox();
    protected JButton SaveAsButton = new JButton();
    protected JButton DeleteButton = new JButton();
    protected JLabel FontLabel = new JLabel();
    protected JLabel FontLine = new JLabel();
    protected JLabel FontNameLabel = new JLabel();
    protected JLabel FontSizeLabel = new JLabel();
    protected JComboBox FontNameCombo = new WideComboBox();
    protected JComboBox FontSizeCombo = new WideComboBox();
    protected JLabel ElementsLabel = new JLabel();
    protected JLabel ElementLine = new JLabel();
    protected JList ElementList = new JList();
    protected JScrollPane ListScroll;
    protected JLabel ForegroundLabel = new JLabel();
    protected JLabel BackgroundLabel = new JLabel();
    protected JLabel FontStyleLabel = new JLabel();
    protected JComboBox ForegroundCombo = new WideComboBox();
    protected JComboBox BackgroundCombo = new WideComboBox();
    protected JComboBox FontStyleCombo = new WideComboBox();
    protected JLabel PreviewLabel = new JLabel();
    protected JLabel PreviewLine = new JLabel();
    protected JComponent previewComp;
    protected CodeEditorPreview codeEditorPreview;
    protected LogListPreview logListPreview;
    protected JComboBox bgColorComboBox = new WideComboBox();
    protected JLabel bgColorTitleLable = new JLabel();
    protected JLabel bgColorLableLine = new JLabel();
    protected JCheckBox bgColorCheckBox = new JCheckBox();
    protected JLabel bgColorLable = new JLabel();

    public CodeEditorAppearancePane(CodeEditor editor, CodeEditorDefaults workingDefaults) {
        this.initialize(workingDefaults, editor);
    }

    private void initialize(CodeEditorDefaults workingDefaults, CodeEditor editor) {
        this.mWorkingDefaults = workingDefaults;
        this.m_Editor = editor;
        this.m_Lang = editor == null ? CodeLanguage.SAS : this.m_Editor.getLanguage();
        this.resource = new CodeEditorResource(CodeEditorAppearancePane.class);
        this.attrManager = new CodeEditorAttributeManager(this.mWorkingDefaults);
        this.schemeManager = new CodeEditorSchemeManager(this.attrManager);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.SasMap = this.attrManager.getAttributeMap(2);
        this.HtmlMap = this.attrManager.getAttributeMap(3);
        this.JavaMap = this.attrManager.getAttributeMap(4);
        this.LogMap = this.attrManager.getAttributeMap(5);
        this.ListMap = this.attrManager.getAttributeMap(6);
        if (this.SasMap == null) {
            this.SasMap = this.schemeManager.getSasDefaultScheme();
        }
        if (this.HtmlMap == null) {
            this.HtmlMap = this.schemeManager.getHtmlDefaultScheme();
        }
        if (this.JavaMap == null) {
            this.JavaMap = this.schemeManager.getJavaDefaultScheme();
        }
        if (this.LogMap == null) {
            this.LogMap = this.schemeManager.getLogDefaultScheme();
        }
        if (this.ListMap == null) {
            this.ListMap = this.schemeManager.getListDefaultScheme();
        }
        this.setupMnemonics(this.FileTypeLabel, "CodeEditorAppearancePane.FileTypeLabel.txt");
        this.setupMnemonics(this.SchemeLabel, "CodeEditorAppearancePane.SchemeLabel.txt");
        this.setupMnemonics(this.SaveAsButton, "CodeEditorAppearancePane.SaveAsLabel.txt");
        this.setupMnemonics(this.DeleteButton, "CodeEditorAppearancePane.DeleteLabel.txt");
        this.FontLabel.setText(this.resource.getString("CodeEditorAppearancePane.FontLabel.txt") + "  ");
        this.setupMnemonics(this.FontNameLabel, "CodeEditorAppearancePane.FontNameLabel.txt");
        this.setupMnemonics(this.FontSizeLabel, "CodeEditorAppearancePane.FontSizeLabel.txt");
        this.setupMnemonics(this.ForegroundLabel, "CodeEditorAppearancePane.ForegroundLabel.txt");
        this.setupMnemonics(this.BackgroundLabel, "CodeEditorAppearancePane.BackgroundLabel.txt");
        this.setupMnemonics(this.FontStyleLabel, "CodeEditorAppearancePane.FontStyleLabel.txt");
        this.setupMnemonics(this.ElementsLabel, "CodeEditorAppearancePane.ElementsLabel.txt");
        this.PreviewLabel.setText(this.resource.getString("CodeEditorAppearancePane.PreviewLabel.txt") + "  ");
        this.FileTypeLabel.setLabelFor(this.FileTypeCombo);
        this.SchemeLabel.setLabelFor(this.SchemeCombo);
        this.FontNameLabel.setLabelFor(this.FontNameCombo);
        this.FontSizeLabel.setLabelFor(this.FontSizeCombo);
        this.ForegroundLabel.setLabelFor(this.ForegroundCombo);
        this.BackgroundLabel.setLabelFor(this.BackgroundCombo);
        this.FontStyleLabel.setLabelFor(this.FontStyleCombo);
        this.ListScroll = new JScrollPane(this.ElementList);
        this.ElementList.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new BoxLayout(this, 1));
        this.FontLabel.setOpaque(true);
        this.FontLine.setBorder(BorderFactory.createEtchedBorder());
        this.ElementLine.setBorder(BorderFactory.createEtchedBorder());
        this.ElementsLabel.setOpaque(true);
        this.ElementsLabel.setLabelFor(this.ElementList);
        this.PreviewLine.setBorder(BorderFactory.createEtchedBorder());
        this.PreviewLabel.setOpaque(true);
        this.ListScroll.setVerticalScrollBarPolicy(20);
        this.ListScroll.setHorizontalScrollBarPolicy(31);
        this.setupPreviewStatus(this.m_Lang.getID());
        this.loadFileTypes(this.FileTypeCombo);
        this.loadSchemeCombo(this.SchemeCombo);
        this.loadFontNames(this.FontNameCombo);
        this.loadFontSizes(this.FontSizeCombo);
        this.previewComp.setFont(this.CurrentMap.getFontAttributes());
        this.loadElementList(this.ElementList);
        this.loadComboColors(this.ForegroundCombo);
        this.loadComboColors(this.BackgroundCombo);
        this.loadComboFontStyles(this.FontStyleCombo);
        this.doListChange(new ListSelectionEvent(this, 0, 0, false));
        Dimension lineSize = new Dimension(10000, 2);
        this.FontLine.setMaximumSize(lineSize);
        this.ElementLine.setMaximumSize(lineSize);
        this.PreviewLine.setMaximumSize(lineSize);
        Dimension btnSize = new Dimension(170, 25);
        this.DeleteButton.setMinimumSize(btnSize);
        this.DeleteButton.setPreferredSize(btnSize);
        this.DeleteButton.setMaximumSize(btnSize);
        this.SaveAsButton.setMinimumSize(btnSize);
        this.SaveAsButton.setPreferredSize(btnSize);
        this.SaveAsButton.setMaximumSize(btnSize);
        Dimension cmbSizeLg = new Dimension(180, 20);
        Dimension cmbSizeMed = new Dimension(170, 20);
        Dimension cmbSizeSm = new Dimension(60, 20);
        this.FileTypeCombo.setMinimumSize(cmbSizeLg);
        this.FileTypeCombo.setPreferredSize(cmbSizeLg);
        this.SchemeCombo.setMinimumSize(cmbSizeLg);
        this.SchemeCombo.setPreferredSize(cmbSizeLg);
        this.FontNameCombo.setMinimumSize(cmbSizeLg);
        this.FontNameCombo.setPreferredSize(cmbSizeLg);
        this.FontNameCombo.setMaximumSize(cmbSizeLg);
        this.FontSizeCombo.setMinimumSize(cmbSizeSm);
        this.FontSizeCombo.setPreferredSize(cmbSizeSm);
        this.FontSizeCombo.setMaximumSize(cmbSizeSm);
        this.ForegroundCombo.setMinimumSize(cmbSizeMed);
        this.ForegroundCombo.setPreferredSize(cmbSizeMed);
        this.ForegroundCombo.setMaximumSize(cmbSizeMed);
        this.BackgroundCombo.setMinimumSize(cmbSizeMed);
        this.BackgroundCombo.setPreferredSize(cmbSizeMed);
        this.BackgroundCombo.setMaximumSize(cmbSizeMed);
        this.FontStyleCombo.setMinimumSize(cmbSizeMed);
        this.FontStyleCombo.setPreferredSize(cmbSizeMed);
        this.FontStyleCombo.setMaximumSize(cmbSizeMed);
        this.FontNameLabel.setMinimumSize(cmbSizeLg);
        this.FontNameLabel.setPreferredSize(cmbSizeLg);
        this.FontNameLabel.setMaximumSize(cmbSizeLg);
        this.FontSizeLabel.setMinimumSize(cmbSizeSm);
        this.FontSizeLabel.setPreferredSize(cmbSizeSm);
        this.FontSizeLabel.setMaximumSize(cmbSizeSm);
        this.ListScroll.setMinimumSize(new Dimension(100, 90));
        this.ListScroll.setPreferredSize(new Dimension(100, 90));
        this.ListScroll.setMaximumSize(new Dimension(10000, 90));
        Dimension lblSizeLg = new Dimension(120, 20);
        Dimension lblSizeSm = new Dimension(120, 20);
        this.ForegroundLabel.setMinimumSize(lblSizeLg);
        this.ForegroundLabel.setPreferredSize(lblSizeLg);
        this.ForegroundLabel.setMaximumSize(lblSizeLg);
        this.BackgroundLabel.setMinimumSize(lblSizeLg);
        this.BackgroundLabel.setPreferredSize(lblSizeLg);
        this.BackgroundLabel.setMaximumSize(lblSizeLg);
        this.FontStyleLabel.setMinimumSize(lblSizeLg);
        this.FontStyleLabel.setPreferredSize(lblSizeLg);
        this.FontStyleLabel.setMaximumSize(lblSizeLg);
        this.FileTypeLabel.setMinimumSize(lblSizeSm);
        this.FileTypeLabel.setPreferredSize(lblSizeSm);
        this.FileTypeLabel.setMaximumSize(lblSizeSm);
        this.SchemeLabel.setMinimumSize(lblSizeSm);
        this.SchemeLabel.setPreferredSize(lblSizeSm);
        this.SchemeLabel.setMaximumSize(lblSizeSm);
        Box box1 = Box.createHorizontalBox();
        box1.add(Box.createHorizontalStrut(7));
        box1.add(this.FileTypeLabel);
        box1.add(Box.createHorizontalStrut(15));
        box1.add(this.FileTypeCombo);
        box1.add(Box.createHorizontalStrut(7));
        box1.add(this.SaveAsButton);
        box1.add(Box.createHorizontalStrut(7));
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalStrut(7));
        box2.add(this.SchemeLabel);
        box2.add(Box.createHorizontalStrut(15));
        box2.add(this.SchemeCombo);
        box2.add(Box.createHorizontalStrut(7));
        box2.add(this.DeleteButton);
        box2.add(Box.createHorizontalStrut(7));
        Box box3 = Box.createHorizontalBox();
        box3.add(Box.createHorizontalStrut(7));
        box3.add(this.FontNameCombo);
        box3.add(Box.createHorizontalStrut(7));
        box3.add(this.FontSizeCombo);
        box3.add(Box.createHorizontalStrut(7));
        box3.add(Box.createHorizontalGlue());
        Box box3label = Box.createHorizontalBox();
        box3label.add(Box.createHorizontalStrut(7));
        box3label.add(this.FontNameLabel);
        box3label.add(Box.createHorizontalStrut(7));
        box3label.add(this.FontSizeLabel);
        box3label.add(Box.createHorizontalStrut(7));
        box3label.add(Box.createHorizontalGlue());
        Box box4label = Box.createVerticalBox();
        box4label.add(this.ForegroundLabel);
        box4label.add(Box.createVerticalGlue());
        box4label.add(this.BackgroundLabel);
        box4label.add(Box.createVerticalGlue());
        box4label.add(this.FontStyleLabel);
        Box box4combo = Box.createVerticalBox();
        box4combo.add(this.ForegroundCombo);
        box4combo.add(Box.createVerticalGlue());
        box4combo.add(this.BackgroundCombo);
        box4combo.add(Box.createVerticalGlue());
        box4combo.add(this.FontStyleCombo);
        Box box4 = Box.createHorizontalBox();
        box4.add(Box.createHorizontalStrut(7));
        box4.add(this.ListScroll);
        box4.add(Box.createHorizontalStrut(7));
        box4.add(box4label);
        box4.add(Box.createHorizontalStrut(7));
        box4.add(box4combo);
        box4.add(Box.createHorizontalStrut(7));
        Box fontTitle = Box.createHorizontalBox();
        fontTitle.add(Box.createHorizontalStrut(5));
        fontTitle.add(this.FontLabel);
        fontTitle.add(this.FontLine);
        fontTitle.add(Box.createHorizontalStrut(5));
        Box elementTitle = Box.createHorizontalBox();
        elementTitle.add(Box.createHorizontalStrut(5));
        elementTitle.add(this.ElementsLabel);
        elementTitle.add(this.ElementLine);
        elementTitle.add(Box.createHorizontalStrut(5));
        Box previewTitle = Box.createHorizontalBox();
        previewTitle.add(Box.createHorizontalStrut(5));
        previewTitle.add(this.PreviewLabel);
        previewTitle.add(this.PreviewLine);
        previewTitle.add(Box.createHorizontalStrut(5));
        this.bgColorTitleLable.setText(this.resource.getString("CodeEditorAppearancePane.bgColorTitleLabel.txt") + "  ");
        this.bgColorTitleLable.setOpaque(true);
        this.bgColorLableLine.setBorder(BorderFactory.createEtchedBorder());
        this.bgColorLableLine.setMaximumSize(lineSize);
        String bgColorCheckBoxItem = this.resource.getString("CodeEditorAppearancePane.bgColorCheckBox.txt");
        String bgColorCheckBoxText = Util.getLabelWithoutMnemonic((String)bgColorCheckBoxItem);
        this.bgColorCheckBox.setText(bgColorCheckBoxText);
        int index = Util.getDisplayedMnemonicIndex((String)bgColorCheckBoxItem);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)bgColorCheckBoxItem);
            this.bgColorCheckBox.setMnemonic(mnemonic);
            this.bgColorCheckBox.setDisplayedMnemonicIndex(index);
        }
        Dimension checkBoxSizeLg = new Dimension(100, 20);
        this.bgColorCheckBox.setMinimumSize(checkBoxSizeLg);
        this.bgColorCheckBox.setPreferredSize(checkBoxSizeLg);
        this.bgColorCheckBox.setMaximumSize(new Dimension(1000, 20));
        this.bgColorCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorAppearancePane.this.onSingleBgColorChecked();
            }
        });
        this.setupMnemonics(this.bgColorLable, "CodeEditorAppearancePane.bgColorLabel.txt");
        this.bgColorLable.setLabelFor(this.bgColorComboBox);
        this.bgColorLable.setMinimumSize(lblSizeLg);
        this.bgColorLable.setPreferredSize(lblSizeLg);
        this.bgColorLable.setMaximumSize(lblSizeLg);
        this.loadComboColors(this.bgColorComboBox);
        this.bgColorComboBox.setMinimumSize(cmbSizeMed);
        this.bgColorComboBox.setPreferredSize(cmbSizeMed);
        this.bgColorComboBox.setMaximumSize(cmbSizeMed);
        this.bgColorComboBox.setEnabled(false);
        this.bgColorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorAppearancePane.this.onSingleBgColorChange();
            }
        });
        Box bgColorTitle = Box.createHorizontalBox();
        bgColorTitle.add(Box.createHorizontalStrut(5));
        bgColorTitle.add(this.bgColorTitleLable);
        bgColorTitle.add(this.bgColorLableLine);
        bgColorTitle.add(Box.createHorizontalStrut(5));
        Box boxBgColor = Box.createHorizontalBox();
        boxBgColor.add(Box.createHorizontalStrut(7));
        boxBgColor.add(this.bgColorCheckBox);
        boxBgColor.add(Box.createHorizontalStrut(7));
        boxBgColor.add(this.bgColorLable);
        boxBgColor.add(Box.createHorizontalStrut(7));
        boxBgColor.add(this.bgColorComboBox);
        boxBgColor.add(Box.createHorizontalStrut(7));
        this.initSingleBgColor();
        this.add(Box.createVerticalStrut(7));
        this.add(box1);
        this.add(Box.createVerticalStrut(7));
        this.add(box2);
        this.add(Box.createVerticalStrut(3));
        this.add(fontTitle);
        this.add(Box.createVerticalStrut(2));
        this.add(box3label);
        this.add(box3);
        this.add(Box.createVerticalStrut(3));
        this.add(bgColorTitle);
        this.add(Box.createVerticalStrut(7));
        this.add(boxBgColor);
        this.add(Box.createVerticalStrut(5));
        this.add(elementTitle);
        this.add(Box.createVerticalStrut(2));
        this.add(box4);
        this.add(Box.createVerticalStrut(5));
        this.add(previewTitle);
        this.add(Box.createVerticalStrut(2));
        this.add(this.previewComp);
        Component[] c = this.ListScroll.getComponents();
        ((JScrollBar)c[1]).setUnitIncrement(17);
        this.FileTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorAppearancePane.this.CheckForFileTypeChange();
            }
        });
        this.ForegroundCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorAppearancePane.this.comboClicked();
            }
        });
        this.BackgroundCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorAppearancePane.this.comboClicked();
            }
        });
        this.FontStyleCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorAppearancePane.this.comboClicked();
            }
        });
        this.SchemeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorAppearancePane.this.schemeComboClicked();
            }
        });
        this.SaveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorAppearancePane.this.saveSchemeButtonClicked();
            }
        });
        this.DeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorAppearancePane.this.onDeleteScheme();
            }
        });
        this.FontNameCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorAppearancePane.this.onFontChange();
            }
        });
        this.FontSizeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeEditorAppearancePane.this.onFontChange();
            }
        });
        this.ElementList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CodeEditorAppearancePane.this.doListChange(e);
            }
        });
    }

    public void cleanup() {
        if (this.codeEditorPreview != null) {
            this.codeEditorPreview.cleanup();
        }
        if (this.logListPreview != null) {
            this.logListPreview.cleanup();
        }
    }

    protected void schemeComboClicked() {
        if (this.freezeSchemeInput) {
            return;
        }
        this.freezeSchemeInput = true;
        this.getScheme();
        this.freezeSchemeInput = false;
    }

    protected void saveSchemeButtonClicked() {
        this.freezeSchemeInput = true;
        this.onSaveScheme();
        this.freezeSchemeInput = false;
    }

    protected void comboClicked() {
        if (this.UpdateInProgress) {
            return;
        }
        this.setNewAttribute();
    }

    public void onApplyChanges(CodeEditorDefaults realDefaults) {
        this.schemeManager.saveWorkingSchemes();
        realDefaults.copyPropertiesFrom(this.mWorkingDefaults);
        realDefaults.saveProperties();
    }

    public AttributeMap getAttributeMap(int langID) {
        switch (langID) {
            case 2: {
                return this.SasMap;
            }
            case 3: {
                return this.HtmlMap;
            }
            case 4: {
                return this.JavaMap;
            }
            case 5: {
                return this.LogMap;
            }
            case 6: {
                return this.ListMap;
            }
        }
        return null;
    }

    protected void onSaveScheme() {
        String name = "";
        int langID = this.getSelectedFileType();
        switch (langID) {
            case 2: {
                name = this.schemeManager.saveUserDefinedScheme(this.CurrentMap, 2, false);
                break;
            }
            case 3: {
                name = this.schemeManager.saveUserDefinedScheme(this.CurrentMap, 3, false);
                break;
            }
            case 4: {
                name = this.schemeManager.saveUserDefinedScheme(this.CurrentMap, 4, false);
                break;
            }
            case 5: {
                name = this.schemeManager.saveUserDefinedScheme(this.CurrentMap, 5, false);
                break;
            }
            case 6: {
                name = this.schemeManager.saveUserDefinedScheme(this.CurrentMap, 6, false);
                break;
            }
            default: {
                return;
            }
        }
        if (name == null) {
            return;
        }
        this.loadSchemeCombo(this.SchemeCombo);
        this.mWorkingDefaults.saveProperties();
    }

    protected void onDeleteScheme() {
        String name = (String)this.SchemeCombo.getSelectedItem();
        int langID = this.getSelectedFileType();
        this.schemeManager.deleteScheme(name, langID);
        this.loadSchemeCombo(this.SchemeCombo);
    }

    protected void onFontChange() {
        Font workingFont = CodeEditorSchemeManager.PREDEFINED_FONT;
        NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
        try {
            String fontName = this.CurrentMap.getFontAttributes().getFontName();
            if (this.FontNameCombo.getSelectedIndex() != -1) {
                fontName = (String)this.FontNameCombo.getSelectedItem();
            }
            Number n = nf.parse((String)this.FontSizeCombo.getSelectedItem());
            workingFont = new Font(fontName, 0, n.intValue());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!this.UpdateInProgress) {
            this.CurrentMap.addFontAttributes(workingFont);
            this.updateWorkingDefaultsObject();
        }
        if (!this.freezeSchemeInput) {
            this.updateSchemeMemory("");
        }
    }

    protected void loadSchemeCombo(JComboBox cb) {
        Object[] schemes = null;
        String savedScheme = "";
        int langID = this.getSelectedFileType();
        cb.removeAllItems();
        schemes = this.schemeManager.getSchemeList(langID);
        savedScheme = this.schemeManager.getWorkingScheme(langID);
        int startIndex = -1;
        for (int i = 0; i < schemes.length; ++i) {
            cb.addItem(schemes[i]);
            if (this.coll.compare((String)schemes[i], savedScheme) != 0) continue;
            startIndex = i;
        }
        cb.setSelectedIndex(startIndex);
        this.setDeleteButtonStatus();
    }

    protected void selectFontByName(JComboBox cb, String fontName) {
        String currentFontName = fontName;
        for (int i = 0; i < cb.getItemCount(); ++i) {
            String testFontName = (String)cb.getItemAt(i);
            if (this.coll.compare(currentFontName, testFontName) != 0) continue;
            cb.setSelectedIndex(i);
            return;
        }
        cb.setSelectedIndex(-1);
    }

    protected void loadFontNames(JComboBox cb) {
        int i;
        String[] fam = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Vector<String> fontNames = new Vector<String>(fam.length);
        for (int i2 = 0; i2 < fam.length; ++i2) {
            fontNames.add(i2, fam[i2]);
        }
        int numBanned = this.resource.getInteger("CodeEditorAppearancePane.BannedFonts.notrans");
        for (i = 0; i < numBanned; ++i) {
            fontNames.remove(this.resource.getString("CodeEditorAppearancePane.BannedFont." + i + ".txt"));
        }
        for (i = 0; i < fontNames.size(); ++i) {
            String newFontName = (String)fontNames.get(i);
            cb.addItem(newFontName);
        }
        Font workingFont = this.CurrentMap.getFontAttributes();
        String currentFontName = workingFont.getName();
        this.selectFontByName(cb, currentFontName);
    }

    protected void loadFontSizes(JComboBox cb) {
        for (int i = 0; i < FontSizes.length; ++i) {
            cb.addItem(String.valueOf(FontSizes[i]));
        }
        Font workingFont = this.CurrentMap.getFontAttributes();
        for (int i = 0; i < FontSizes.length; ++i) {
            if (workingFont.getSize() != FontSizes[i]) continue;
            cb.setSelectedIndex(i);
        }
    }

    protected void loadFileTypes(JComboBox cb) {
        cb.addItem(this.resource.getString("CodeEditorAppearancePane.SasFile.txt"));
        cb.addItem(this.resource.getString("CodeEditorAppearancePane.HtmlFile.txt"));
        cb.addItem(this.resource.getString("CodeEditorAppearancePane.JavaFile.txt"));
        cb.addItem(this.resource.getString("CodeEditorAppearancePane.LogFile.txt"));
        cb.addItem(this.resource.getString("CodeEditorAppearancePane.ListFile.txt"));
        switch (this.m_Lang.getID()) {
            case 2: {
                cb.setSelectedIndex(0);
                this.CurrentMap = this.SasMap;
                break;
            }
            case 3: {
                cb.setSelectedIndex(1);
                this.CurrentMap = this.HtmlMap;
                break;
            }
            case 4: {
                cb.setSelectedIndex(2);
                this.CurrentMap = this.JavaMap;
                break;
            }
            case 5: {
                cb.setSelectedIndex(3);
                this.CurrentMap = this.LogMap;
                break;
            }
            case 6: {
                cb.setSelectedIndex(4);
                this.CurrentMap = this.ListMap;
            }
        }
        this.m_nCurrentFileType = this.m_Lang.getID();
    }

    protected void loadElementList(JList jl) {
        int langID = this.getSelectedFileType();
        this.m_ElementManager = new ElementListManager(langID);
        DefaultListModel<String> dlm = new DefaultListModel<String>();
        int end = this.m_ElementManager.getSize();
        for (int i = 0; i < end; ++i) {
            dlm.addElement(this.m_ElementManager.getItem(i));
        }
        jl.setModel(dlm);
        jl.setSelectedIndex(0);
        jl.scrollRectToVisible(jl.getCellBounds(0, 0));
    }

    protected void loadComboColors(JComboBox cb) {
        String[] colorNames = this.attrManager.getColorNames();
        Color[] colors = this.attrManager.getColors();
        for (int i = 0; i < colorNames.length; ++i) {
            cb.addItem(new Object[]{colors[i], colorNames[i]});
        }
        cb.setRenderer(new ColorRenderer());
    }

    protected void loadComboFontStyles(JComboBox cb) {
        String[] fontNames = this.attrManager.getFontStyleNames();
        for (int i = 0; i < fontNames.length; ++i) {
            cb.addItem(fontNames[i]);
        }
    }

    protected void setDeleteButtonStatus() {
        int langID;
        String schemeName = (String)this.SchemeCombo.getSelectedItem();
        if (this.schemeManager.isSchemePredefined(schemeName, langID = this.getSelectedFileType())) {
            this.DeleteButton.setEnabled(false);
        } else {
            this.DeleteButton.setEnabled(true);
        }
    }

    protected void setupPreviewStatus(int langID) {
        switch (langID) {
            case 2: 
            case 3: 
            case 4: {
                this.codeEditorPreview = new CodeEditorPreview(this);
                if (langID == 2) {
                    this.codeEditorPreview.setLanguage(CodeLanguage.SAS);
                } else if (langID == 3) {
                    this.codeEditorPreview.setLanguage(CodeLanguage.HTML);
                } else if (langID == 4) {
                    this.codeEditorPreview.setLanguage(CodeLanguage.JAVA);
                }
                this.addPreviewComponent(this.codeEditorPreview);
                this.codeEditorPreview.setDisplayText(langID);
                break;
            }
            case 5: 
            case 6: {
                LogListHolder llHolder = this.getLogListHolder(langID);
                this.logListPreview = new LogListPreview(langID, llHolder, this);
                this.logListPreview.getEditorPane().setCaretPosition(0);
                this.addPreviewComponent(this.logListPreview);
            }
        }
        this.previewComp.repaint();
    }

    protected void addPreviewComponent(JComponent cPreview) {
        if (this.previewComp != null) {
            this.remove(this.previewComp);
        }
        this.previewComp = cPreview;
        this.add(this.previewComp);
    }

    protected void CheckForFileTypeChange() {
        int langID = this.getSelectedFileType();
        if (this.m_nCurrentFileType == langID) {
            return;
        }
        if (langID == 0) {
            return;
        }
        this.m_nCurrentFileType = langID;
        this.UpdateInProgress = true;
        this.setupPreviewStatus(langID);
        this.freezeSchemeInput = true;
        this.loadSchemeCombo(this.SchemeCombo);
        this.getScheme();
        this.freezeSchemeInput = false;
        this.loadElementList(this.ElementList);
        this.ElementList.setSelectedIndex(0);
        this.doListChange(new ListSelectionEvent(this, 0, 0, false));
        this.UpdateInProgress = false;
    }

    protected void doListChange(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.UpdateInProgress = true;
        if (this.CurrentMap == null) {
            return;
        }
        short elementShort = this.getSelectedShort();
        AttributeSet attrs = this.CurrentMap.getElementAttributes(elementShort);
        if (attrs == null) {
            return;
        }
        Color fg = StyleConstants.getForeground(attrs);
        this.setComboToColor(fg, this.ForegroundCombo);
        Color bg = StyleConstants.getBackground(attrs);
        this.setComboToColor(bg, this.BackgroundCombo);
        boolean bold = StyleConstants.isBold(attrs);
        boolean italic = StyleConstants.isItalic(attrs);
        this.setComboFontStyle(bold, italic, this.FontStyleCombo);
        this.UpdateInProgress = false;
    }

    protected void setClickedElement(short selection) {
        int index = this.m_ElementManager.getIndexForID(selection);
        this.ElementList.setSelectedIndex(index);
        this.ElementList.scrollRectToVisible(this.ElementList.getCellBounds(index, index));
    }

    protected short getSelectedShort() {
        int selectedItem = this.ElementList.getSelectedIndex();
        int sel = this.m_ElementManager.getID(selectedItem);
        return (short)sel;
    }

    protected void setComboToColor(Color c, JComboBox cb) {
        Color[] colors = this.attrManager.getColors();
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] != c) continue;
            cb.setSelectedIndex(i);
            break;
        }
    }

    protected void setComboFontStyle(boolean bold, boolean italic, JComboBox cb) {
        if (bold && italic) {
            cb.setSelectedIndex(3);
        } else if (italic) {
            cb.setSelectedIndex(2);
        } else if (bold) {
            cb.setSelectedIndex(1);
        } else {
            cb.setSelectedIndex(0);
        }
    }

    protected void setNewAttribute() {
        boolean italic;
        Color[] colors = this.attrManager.getColors();
        Color fg = colors[this.ForegroundCombo.getSelectedIndex()];
        Color bg = colors[this.BackgroundCombo.getSelectedIndex()];
        int fontStyle = this.FontStyleCombo.getSelectedIndex();
        boolean bold = fontStyle == 1 || fontStyle == 3;
        boolean bl = italic = fontStyle == 2 || fontStyle == 3;
        if (!this.UpdateInProgress) {
            this.CurrentMap.addElementAttributes(this.getSelectedShort(), fg, bg, bold, italic);
            this.updateWorkingDefaultsObject();
        }
        this.updateSchemeMemory("");
    }

    public void getScheme() {
        String schemeName = (String)this.SchemeCombo.getSelectedItem();
        this.getScheme(schemeName);
        this.setDeleteButtonStatus();
    }

    private void updateWorkingDefaultsObject() {
        this.attrManager.setAttributeMap(this.HtmlMap, 3, false);
        this.attrManager.setAttributeMap(this.SasMap, 2, false);
        this.attrManager.setAttributeMap(this.JavaMap, 4, false);
        this.attrManager.setAttributeMap(this.LogMap, 5, false);
        this.attrManager.setAttributeMap(this.ListMap, 6, false);
        this.mWorkingDefaults.firePreferenceChangeUpdate();
    }

    public void getScheme(String schemeName) {
        int langID = this.getSelectedFileType();
        AttributeMap SchemeMap = new AttributeMap();
        if (schemeName == null) {
            schemeName = "";
            SchemeMap = this.getAttributeMap(langID);
        } else {
            SchemeMap = this.schemeManager.getScheme(schemeName, langID);
        }
        this.updateSchemeMemory(schemeName);
        if (SchemeMap != null) {
            this.CurrentMap = SchemeMap;
            switch (langID) {
                case 2: {
                    this.SasMap = this.CurrentMap;
                    break;
                }
                case 3: {
                    this.HtmlMap = this.CurrentMap;
                    break;
                }
                case 4: {
                    this.JavaMap = this.CurrentMap;
                    break;
                }
                case 5: {
                    this.LogMap = this.CurrentMap;
                    break;
                }
                case 6: {
                    this.ListMap = this.CurrentMap;
                }
            }
        }
        Font f = this.CurrentMap.getFontAttributes();
        this.selectFontByName(this.FontNameCombo, f.getName());
        for (int i = 0; i < FontSizes.length; ++i) {
            if (f.getSize() != FontSizes[i]) continue;
            this.FontSizeCombo.setSelectedIndex(i);
        }
        this.doListChange(new ListSelectionEvent(this, 0, 0, false));
        this.updateWorkingDefaultsObject();
    }

    public int getSelectedFileType() {
        String lang = (String)this.FileTypeCombo.getSelectedItem();
        if (lang == null) {
            return 0;
        }
        if (this.coll.compare(lang, this.resource.getString("CodeEditorAppearancePane.SasFile.txt")) == 0) {
            return 2;
        }
        if (this.coll.compare(lang, this.resource.getString("CodeEditorAppearancePane.HtmlFile.txt")) == 0) {
            return 3;
        }
        if (this.coll.compare(lang, this.resource.getString("CodeEditorAppearancePane.JavaFile.txt")) == 0) {
            return 4;
        }
        if (this.coll.compare(lang, this.resource.getString("CodeEditorAppearancePane.LogFile.txt")) == 0) {
            return 5;
        }
        if (this.coll.compare(lang, this.resource.getString("CodeEditorAppearancePane.ListFile.txt")) == 0) {
            return 6;
        }
        return 0;
    }

    public void customizeFileTypes(CodeLanguage[] langs) {
        if (langs.length == 0) {
            return;
        }
        this.FileTypeCombo.removeAllItems();
        String sas = this.resource.getString("CodeEditorAppearancePane.SasFile.txt");
        String html = this.resource.getString("CodeEditorAppearancePane.HtmlFile.txt");
        String java = this.resource.getString("CodeEditorAppearancePane.JavaFile.txt");
        String log = this.resource.getString("CodeEditorAppearancePane.LogFile.txt");
        String list = this.resource.getString("CodeEditorAppearancePane.ListFile.txt");
        CodeLanguage currLang = this.m_Editor != null ? this.m_Editor.getLanguage() : langs[0];
        int selIndex = 0;
        for (int i = 0; i < langs.length; ++i) {
            if (langs[i] == CodeLanguage.SAS) {
                this.FileTypeCombo.addItem(sas);
            } else if (langs[i] == CodeLanguage.HTML) {
                this.FileTypeCombo.addItem(html);
            } else if (langs[i] == CodeLanguage.JAVA) {
                this.FileTypeCombo.addItem(java);
            } else if (langs[i] == CodeLanguage.LOG) {
                this.FileTypeCombo.addItem(log);
            } else if (langs[i] == CodeLanguage.LIST) {
                this.FileTypeCombo.addItem(list);
            }
            if (langs[i] != currLang) continue;
            selIndex = i;
        }
        this.FileTypeCombo.setSelectedIndex(selIndex);
    }

    protected void updateSchemeMemory(String s) {
        if (this.UpdateInProgress) {
            return;
        }
        this.schemeManager.setWorkingScheme(s, this.m_nCurrentFileType);
        if (this.coll.compare(s, "") == 0) {
            this.SchemeCombo.setSelectedIndex(-1);
        }
    }

    protected int getWidthOfString(String s) {
        StringCharacterIterator sci = new StringCharacterIterator("null");
        sci.setText(s);
        int size = 0;
        for (int i = sci.getBeginIndex(); i <= sci.getEndIndex(); ++i) {
            size += fm.charWidth(sci.setIndex(i));
        }
        return size;
    }

    protected LogListHolder getLogListHolder(int langID) {
        String strNumLines = "";
        String strSampleCode = "";
        String strSampleLineType = "";
        String strSampleCC = "";
        switch (langID) {
            case 5: {
                strNumLines = "CodeEditorPreviewPane.NumberOfLogLines.txt";
                strSampleCode = "CodeEditorPreviewPane.SampleLogCode.";
                strSampleLineType = "CodeEditorPreviewPane.SampleLogLineType.";
                strSampleCC = "CodeEditorPreviewPane.SampleLogCC.";
                break;
            }
            case 6: {
                strNumLines = "CodeEditorPreviewPane.NumberOfListLines.txt";
                strSampleCode = "CodeEditorPreviewPane.SampleListCode.";
                strSampleLineType = "CodeEditorPreviewPane.SampleListLineType.";
                strSampleCC = "CodeEditorPreviewPane.SampleListCC.";
                break;
            }
            default: {
                return null;
            }
        }
        int nLines = this.resource.getInteger(strNumLines);
        String[] strDummy = new String[nLines];
        LineType[] ltDummy = new LineType[nLines];
        CarriageControl[] ccDummy = new CarriageControl[nLines];
        for (int i = 1; i <= nLines; ++i) {
            strDummy[i - 1] = this.resource.getString(strSampleCode + i + ".txt");
            ltDummy[i - 1] = LineType.from_int(this.resource.getInteger(strSampleLineType + i + ".notrans"));
            ccDummy[i - 1] = CarriageControl.from_int(this.resource.getInteger(strSampleCC + i + ".notrans"));
        }
        StringSeqHolder textLines = new StringSeqHolder(strDummy);
        CarriageControlSeqHolder cc = new CarriageControlSeqHolder(ccDummy);
        LineTypeSeqHolder lineTypes = new LineTypeSeqHolder(ltDummy);
        LogListHolder llHolder = new LogListHolder(textLines, cc, lineTypes);
        return llHolder;
    }

    CodeEditorDefaults getWorkingDefaults() {
        return this.mWorkingDefaults;
    }

    private void initSingleBgColor() {
        this.bgColorCheckBox.setSelected(this.CurrentMap.isUsingSingleBgColor());
        this.bgColorComboBox.setEnabled(this.CurrentMap.isUsingSingleBgColor());
        this.BackgroundCombo.setEnabled(!this.CurrentMap.isUsingSingleBgColor());
        this.setComboToColor(this.CurrentMap.getSingleBgColor(), this.bgColorComboBox);
    }

    protected void onSingleBgColorChecked() {
        this.bgColorComboBox.setEnabled(!this.bgColorComboBox.isEnabled());
        this.BackgroundCombo.setEnabled(!this.BackgroundCombo.isEnabled());
        this.CurrentMap.setUsingSingleBgColor(this.bgColorCheckBox.isSelected());
        if (this.bgColorCheckBox.isSelected() && this.CurrentMap.getSingleBgColor() == null) {
            this.bgColorComboBox.setSelectedIndex(this.BackgroundCombo.getSelectedIndex());
        }
        this.onSingleBgColorChange();
    }

    protected void onSingleBgColorChange() {
        Color[] colors = this.attrManager.getColors();
        Color bg = colors[this.bgColorComboBox.getSelectedIndex()];
        if (!this.UpdateInProgress) {
            this.CurrentMap.setSingleBgColor(bg);
            this.updateWorkingDefaultsObject();
        }
    }

    protected void setupMnemonics(JLabel lbl, String key) {
        String lblItem = this.resource.getString(key);
        String lblText = Util.getLabelWithoutMnemonic((String)lblItem);
        lbl.setText(lblText);
        int index = Util.getDisplayedMnemonicIndex((String)lblItem);
        if (index > -1) {
            lbl.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)lblItem));
            lbl.setDisplayedMnemonicIndex(index);
        }
    }

    protected void setupMnemonics(JButton btn, String key) {
        String buttonItem = this.resource.getString(key);
        String buttonText = Util.getLabelWithoutMnemonic((String)buttonItem);
        btn.setText(buttonText);
        int index = Util.getDisplayedMnemonicIndex((String)buttonItem);
        if (index > -1) {
            btn.setMnemonic(Util.getDisplayedMnemonic((String)buttonItem));
            btn.setDisplayedMnemonicIndex(index);
        }
    }

    static {
        FontSizes = new int[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 28, 36, 48, 72};
    }

    protected class ElementListManager {
        private int m_langID;
        private Vector m_vNames = new Vector();
        private Vector m_vID = new Vector();

        public ElementListManager(int langID) {
            IElements langElements;
            String constDisplayType = "CodeEditorAppearancePane.DisplayType.";
            this.m_langID = langID;
            switch (this.m_langID) {
                case 2: {
                    langElements = new SasElements();
                    break;
                }
                case 3: {
                    langElements = new HtmlElements();
                    break;
                }
                case 4: {
                    langElements = new JavaElements();
                    break;
                }
                case 5: {
                    langElements = new LogElements();
                    break;
                }
                case 6: {
                    langElements = new ListElements();
                    break;
                }
                default: {
                    return;
                }
            }
            short first = langElements.getLowerBound();
            short last = langElements.getUpperBound();
            for (short i = first; i <= last; i = (short)(i + 1)) {
                String itemName = CodeEditorAppearancePane.this.resource.getString(constDisplayType + langElements.toString(i) + ".txt");
                this.insert(itemName, i);
            }
        }

        private void insert(String text, int id) {
            Integer ID = new Integer(id);
            for (int i = 0; i < this.m_vNames.size(); ++i) {
                if (CodeEditorAppearancePane.this.coll.compare((Object)text, this.m_vNames.get(i)) >= 0) continue;
                this.m_vNames.insertElementAt(text, i);
                this.m_vID.insertElementAt(ID, i);
                return;
            }
            this.m_vNames.add(text);
            this.m_vID.add(ID);
        }

        public int getSize() {
            return this.m_vNames.size();
        }

        public String getItem(int index) {
            if (index > this.getSize() || index < 0) {
                return null;
            }
            return (String)this.m_vNames.get(index);
        }

        public int getID(int index) {
            if (index > this.getSize() || index < 0) {
                return -1;
            }
            return (Integer)this.m_vID.get(index);
        }

        public int getIndexForID(int ID) {
            for (int i = 0; i < this.getSize(); ++i) {
                int temp = (Integer)this.m_vID.get(i);
                if (ID != temp) continue;
                return i;
            }
            return -1;
        }
    }

    class ColorRenderer
    extends JLabel
    implements ListCellRenderer {
        private ColorIcon icon;

        public ColorRenderer() {
            this.icon = new ColorIcon();
            this.setOpaque(true);
            this.setIcon(this.icon);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object[] array = (Object[])value;
            this.icon.setColor((Color)array[0]);
            this.setText((String)array[1]);
            if (isSelected) {
                this.setForeground(list.getSelectionForeground());
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setForeground(list.getForeground());
                this.setBackground(list.getBackground());
            }
            return this;
        }
    }

    class ColorIcon
    implements Icon {
        private Color mColor;
        private int mWidth;
        private int mHeight;

        public ColorIcon() {
            this(Color.gray, 20, 10);
        }

        public ColorIcon(Color newColor, int width, int height) {
            this.mColor = newColor;
            this.mWidth = width;
            this.mHeight = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.black);
            g.drawRect(x + 2, y, this.mWidth - 1, this.mHeight - 1);
            g.setColor(this.mColor);
            g.fillRect(x + 3, y + 1, this.mWidth - 2, this.mHeight - 2);
        }

        public Color getColor() {
            return this.mColor;
        }

        public void setColor(Color newColor) {
            this.mColor = newColor;
        }

        @Override
        public int getIconWidth() {
            return this.mWidth;
        }

        @Override
        public int getIconHeight() {
            return this.mHeight;
        }
    }
}

