/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorDocument;
import com.sas.editor.CodeEditorKeysDialog;
import com.sas.editor.CodeEditorOptionsDialog;
import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorPrintManager;
import com.sas.editor.CodeLanguage;
import com.sas.editor.EditableRegion;
import com.sas.editor.EditorViewPort;
import com.sas.swing.util.DesktopUtil;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.text.Collator;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;

public class CodeEditor
extends JScrollPane {
    private Window mParentWindow;
    protected CodeEditorPane m_EditPane;
    protected CodeEditorDefaults m_Defaults;
    protected CodeEditorPrintManager m_PrintManager;
    protected boolean m_ClearAllEnabled = true;
    protected boolean m_HelpEnabled = true;
    protected Collator coll = Collator.getInstance(Locale.getDefault());

    public CodeEditor(Frame frame) {
        this(frame, new CodeEditorDefaults());
    }

    public CodeEditor(Dialog dlg) {
        this(dlg, new CodeEditorDefaults());
    }

    public CodeEditor(CodeEditorDefaults defaults) {
        this.mParentWindow = null;
        this.addAncestorListener(new MyComponentAncestorListener());
        if (defaults == null) {
            defaults = new CodeEditorDefaults();
        }
        this.setDefaults(defaults);
        this.m_EditPane = new CodeEditorPane(this);
        this.setViewportView(this.m_EditPane);
        this.m_PrintManager = new CodeEditorPrintManager(this.m_EditPane);
    }

    public CodeEditor(Frame frame, CodeEditorDefaults defaults) {
        super(22, 30);
        if (defaults == null) {
            defaults = new CodeEditorDefaults();
        }
        this.setDefaults(defaults);
        this.m_EditPane = new CodeEditorPane(this);
        this.setViewportView(this.m_EditPane);
        this.m_PrintManager = new CodeEditorPrintManager(this.m_EditPane);
    }

    public CodeEditor(Dialog dlg, CodeEditorDefaults defaults) {
        super(22, 30);
        if (defaults == null) {
            defaults = new CodeEditorDefaults();
        }
        this.setDefaults(defaults);
        this.m_EditPane = new CodeEditorPane(this);
        this.setViewportView(this.m_EditPane);
        this.m_PrintManager = new CodeEditorPrintManager(this.m_EditPane);
    }

    public CodeEditor(Frame frame, String defaults_file) {
        this(frame, new CodeEditorDefaults(defaults_file));
    }

    public CodeEditor(Dialog dlg, String defaults_file) {
        this(dlg, new CodeEditorDefaults(defaults_file));
    }

    public void cleanup() {
        if (this.mParentWindow != null) {
            this.m_EditPane.removeShutdownListener(this.mParentWindow);
        }
        if (this.m_EditPane != null) {
            this.m_EditPane.cleanup();
        }
        if (this.m_PrintManager != null) {
            this.m_PrintManager.cleanup();
        }
    }

    public void listenToFrame(Frame f) {
    }

    public void setBorderColor(Color color) {
        this.m_EditPane.setBorderColor(color);
    }

    public void EnableDocumentColoring(boolean b, boolean saveAttrs) {
        this.m_Defaults.setDocumentColoring(b, saveAttrs);
    }

    public void enablePromptForUnsavedData(boolean bPrompt) {
        this.getEditorPane().enablePromptForUnsavedData(bPrompt);
    }

    public void setReadOnly(boolean b, boolean saveAttrs) {
        this.m_EditPane.setReadOnly(b);
    }

    public void SetReadOnly(boolean b) {
        this.m_EditPane.setReadOnly(b);
    }

    public void setLanguage(CodeLanguage language) {
        if (language != CodeLanguage.LOG && language != CodeLanguage.LIST) {
            this.m_EditPane.setLanguage(language);
        }
    }

    public CodeLanguage getLanguage() {
        return this.m_EditPane.getLanguage();
    }

    public CodeEditorDefaults getDefaults() {
        return this.m_Defaults;
    }

    public void setDefaults(CodeEditorDefaults defaults) {
        this.m_Defaults = defaults;
    }

    public void setText(String strText) {
        this.m_EditPane.setText(strText);
    }

    public boolean openFile(String strFile) throws IOException {
        boolean success = this.m_EditPane.openFileWithNoUI(strFile);
        this.repaint();
        if (this.mParentWindow != null) {
            this.mParentWindow.repaint();
        }
        this.m_EditPane.requestFocus();
        return success;
    }

    public void appendFile(String strFile) {
        this.m_EditPane.appendFile(strFile);
        this.repaint();
        if (this.mParentWindow != null) {
            this.mParentWindow.repaint();
        }
        this.m_EditPane.requestFocus();
    }

    public boolean save() throws IOException {
        String fileName = this.m_EditPane.getCodeEditorDocument().getFilename();
        if (fileName.length() == 0) {
            return false;
        }
        return this.m_EditPane.saveFile(fileName);
    }

    public boolean saveFile(String strFile) throws IOException {
        return this.m_EditPane.saveFile(strFile);
    }

    public String getText() {
        return this.m_EditPane.getText();
    }

    public String getLine(int line) throws ParseException {
        CodeEditorDocument doc = this.m_EditPane.getCodeEditorDocument();
        if (line < 0 || line >= doc.getLineCount()) {
            throw new ParseException("Line " + line + " does not exist.", line);
        }
        String strLine = doc.getLine(line);
        if (strLine.endsWith("\n")) {
            return strLine.substring(0, strLine.length() - 1);
        }
        return strLine;
    }

    public void setLine(int line, String text) throws BadLocationException {
        CodeEditorDocument doc = this.m_EditPane.getCodeEditorDocument();
        if (line < 0 || line >= this.getLineCount()) {
            throw new BadLocationException("Line " + line + " does not exist.", line);
        }
        int p1 = doc.getStartOffsetForLine(line);
        int p2 = doc.getStartOffsetForLine(line + 1);
        if (p2 == -1) {
            p2 = doc.getLength();
        }
        doc.remove(p1, p2 - p1);
        doc.insertString(p1, text + "\n", SimpleAttributeSet.EMPTY);
    }

    public void insertAfterLine(int line, String text) throws BadLocationException {
        CodeEditorDocument doc = this.m_EditPane.getCodeEditorDocument();
        if (line < 0 || line >= this.getLineCount()) {
            throw new BadLocationException("Line " + line + " does not exist.", line);
        }
        int p1 = doc.getStartOffsetForLine(line + 1);
        if (p1 == -1) {
            doc.insertString(doc.getLength(), "\n" + text + "\n", SimpleAttributeSet.EMPTY);
        } else {
            doc.insertString(p1, text + "\n", SimpleAttributeSet.EMPTY);
        }
    }

    public void insertLine(int line, String text) throws BadLocationException {
        CodeEditorDocument doc = this.m_EditPane.getCodeEditorDocument();
        if (line < 0 || line >= this.getLineCount()) {
            throw new BadLocationException("Line " + line + " + does not exist.", line);
        }
        int p1 = doc.getStartOffsetForLine(line);
        doc.insertString(p1, text + "\n", SimpleAttributeSet.EMPTY);
    }

    public void appendLine(String text) {
        CodeEditorDocument doc = this.m_EditPane.getCodeEditorDocument();
        if (doc.getLastEditableLine() < 0) {
            return;
        }
        int lastLine = doc.getLastEditableLine();
        try {
            String strLast = this.getLine(lastLine);
            if (strLast.compareTo("") == 0) {
                doc.insertString(doc.getLength(), text + "\n", SimpleAttributeSet.EMPTY);
            } else {
                doc.insertString(doc.getLength(), "\n" + text + "\n", SimpleAttributeSet.EMPTY);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getLineCount() {
        return this.m_EditPane.getCodeEditorDocument().getLineCount();
    }

    public String getSelectedText() {
        return this.m_EditPane.getSelectedText();
    }

    public Document getDocument() {
        return this.m_EditPane.getDocument();
    }

    public void setFilename(String newFilename) {
        this.m_EditPane.setFilename(newFilename);
    }

    public String getFilename() {
        return this.m_EditPane.getFilename();
    }

    public CodeEditorPane getEditorPane() {
        return this.m_EditPane;
    }

    public void setFocus() {
        this.m_EditPane.requestFocus();
    }

    @Override
    protected JViewport createViewport() {
        return new EditorViewPort();
    }

    public boolean dlgOpen(JFrame frame) throws IOException {
        boolean ret_val = this.m_EditPane.dlgOpen(frame);
        this.repaint();
        if (this.mParentWindow != null) {
            this.mParentWindow.repaint();
        }
        this.m_EditPane.requestFocus();
        return ret_val;
    }

    public void dlgOptions(boolean showAppPane, boolean showKeysBtn) {
        CodeEditorOptionsDialog dlg = CodeEditorOptionsDialog.CreateDialog(this, showAppPane, showKeysBtn);
        if (dlg == null) {
            return;
        }
        dlg.setVisible(true);
        this.repaint();
    }

    public void dlgKeys() {
        CodeEditorKeysDialog jd = CodeEditorKeysDialog.CreateDialog(this, this.getDefaults());
        if (jd == null) {
            return;
        }
        jd.setVisible(true);
    }

    public boolean save(JFrame frame) throws IOException {
        return this.m_EditPane.save(frame);
    }

    public boolean dlgSaveAs(JFrame frame) throws IOException {
        boolean ret_val = this.m_EditPane.dlgSaveAs(frame);
        this.repaint();
        if (this.mParentWindow != null) {
            this.mParentWindow.repaint();
        }
        this.m_EditPane.requestFocus();
        return ret_val;
    }

    public void dlgAppend(JFrame frame) {
        this.m_EditPane.dlgAppend(frame);
        this.repaint();
        if (this.mParentWindow != null) {
            this.mParentWindow.repaint();
        }
        this.m_EditPane.requestFocus();
    }

    public void setLineNumbers(boolean bLineNumbers, boolean saveAttrs) {
        this.m_Defaults.setShowLineNumbers(bLineNumbers, saveAttrs);
    }

    public boolean isLineNumbers() {
        return this.m_EditPane.isLineNumbers();
    }

    public boolean isReadOnly() {
        return this.m_EditPane.isReadOnly();
    }

    public boolean isClearAllEnabled() {
        return this.m_ClearAllEnabled;
    }

    public void enableClearAll(boolean enabled) {
        this.m_ClearAllEnabled = enabled;
    }

    public void setSmartIndent(boolean doIndent, boolean saveAttrs) {
        this.m_Defaults.setSmartIndent(doIndent, saveAttrs);
    }

    public boolean isSmartIndent() {
        return this.m_EditPane.isSmartIndent();
    }

    public void setTabSize(int tabSize, boolean saveAttrs) {
        this.m_Defaults.setTabSize(tabSize, saveAttrs);
    }

    public int getTabSize() {
        return this.m_EditPane.getTabSize();
    }

    public boolean canSave() {
        return this.coll.compare(this.m_EditPane.getCodeEditorDocument().getFilename(), "") != 0;
    }

    public boolean isDocumentColoringEnabled() {
        return this.m_EditPane.getCodeEditorDocument().IsDocumentColoringEnabled();
    }

    public boolean canCopy() {
        return this.m_EditPane.canCopy();
    }

    public boolean canCut() {
        if (!this.m_EditPane.isReadOnly() && this.m_EditPane.isLineEditable()) {
            return this.m_EditPane.canCopy();
        }
        return false;
    }

    public boolean canPaste() {
        return !this.m_EditPane.isReadOnly() && this.m_EditPane.isLineEditable();
    }

    public boolean canSelectAll() {
        return this.m_EditPane.getCodeEditorDocument().getLength() > 0;
    }

    public boolean canClearAll() {
        boolean bEnableClearAll = true;
        if (this.getDocument().getLength() == 0) {
            bEnableClearAll = false;
        }
        if (!this.isClearAllEnabled()) {
            bEnableClearAll = false;
        }
        if (this.isReadOnly() && this.getLanguage() != CodeLanguage.LIST && this.getLanguage() != CodeLanguage.LOG) {
            bEnableClearAll = false;
        }
        return bEnableClearAll;
    }

    public boolean canUndo() {
        return this.m_EditPane.canUndo();
    }

    public boolean canRedo() {
        return this.m_EditPane.canRedo();
    }

    public boolean prepareToExit() {
        try {
            return this.getEditorPane().checkSaveContentsNoUI();
        }
        catch (IOException ex) {
            return false;
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.m_EditPane.getPopupMenu();
    }

    public void enableHelp(boolean enabled) {
        this.m_HelpEnabled = enabled;
    }

    public String getHelpProduct() {
        return "texteditor";
    }

    public String getHelpTopic() {
        if (this.getLanguage() == CodeLanguage.LOG) {
            return "logspace";
        }
        if (this.getLanguage() == CodeLanguage.LIST) {
            return "outputspace";
        }
        return "editorspace";
    }

    public void showJavaHelp(String context) {
        if (!this.m_HelpEnabled) {
            return;
        }
        String docSetId = "texteditor";
        String helpId = this.getHelpTopic();
        DesktopUtil.openHelpDoc((String)docSetId, (String)helpId, (String)"version", null);
    }

    public void showJavaHelp() {
        if (!this.m_HelpEnabled) {
            return;
        }
        this.showJavaHelp(this.getHelpTopic());
    }

    public Action getAction(String id) {
        return this.m_EditPane.getActionMap().get(id);
    }

    public void printDlg() {
        this.m_PrintManager.printDlg();
    }

    public void print() {
        this.m_PrintManager.print();
    }

    public void pageSetupDlg() {
        this.m_PrintManager.pageSetupDlg();
    }

    public void setPageFormat(PageFormat pf) {
        this.m_PrintManager.setPageFormat(pf);
    }

    public void printCodeFolding(boolean showDialog) {
        this.m_PrintManager.printCodeFolding(showDialog);
    }

    public boolean checkSaveContents() {
        return this.prepareToExit();
    }

    public void setEditableRegion(EditableRegion rgn, Color fgColor, Color bgColor) {
        ((CodeEditorDocument)this.getDocument()).setEditableRegion(rgn, fgColor, bgColor);
    }

    public void setEditableRegion(EditableRegion rgn) {
        ((CodeEditorDocument)this.getDocument()).setEditableRegion(rgn);
    }

    private class MyComponentAncestorListener
    implements AncestorListener {
        private MyComponentAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            if (CodeEditor.this.mParentWindow == null) {
                CodeEditor.this.mParentWindow = SwingUtilities.getWindowAncestor(CodeEditor.this);
                if (CodeEditor.this.mParentWindow != null) {
                    CodeEditor.this.m_EditPane.addShutdownWindowListener(CodeEditor.this.mParentWindow);
                }
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }
    }
}

