/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CArrowRepeatButton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CSpinButton
extends JPanel
implements ActionListener,
FocusListener {
    protected ValueChangedListener mListener = null;
    protected JTextField m_data;
    protected CArrowRepeatButton m_inc;
    protected CArrowRepeatButton m_dec;
    protected int m_nMin;
    protected int m_nMax;
    protected int m_nInitial;
    protected int m_nDelta;
    protected int m_nPeriod;
    protected int m_nCurrVal;

    public CSpinButton(int min, int max, int initial, int delta, int period) {
        this.m_inc = new CArrowRepeatButton(1, period);
        this.m_dec = new CArrowRepeatButton(5, period);
        this.m_data = new JTextField("" + initial);
        this.m_data.setHorizontalAlignment(4);
        this.m_data.addFocusListener(this);
        this.m_dec.addActionListener(this);
        this.m_inc.addActionListener(this);
        this.m_nMin = min;
        this.m_nMax = max;
        this.m_nDelta = delta;
        this.m_nInitial = initial;
        this.m_nCurrVal = initial;
        this.m_nPeriod = period;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_data, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_inc, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.5, 14, 1, new Insets(0, 0, 0, 0), 10, 0));
        this.add((Component)this.m_dec, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.5, 12, 1, new Insets(0, 0, 0, 0), 10, 0));
    }

    public synchronized void setValue(int value) {
        int oldValue = this.m_nCurrVal;
        this.m_nCurrVal = value;
        this.m_data.setText("" + this.m_nCurrVal);
        if (this.mListener != null) {
            this.mListener.valueChanged(oldValue, this.m_nCurrVal);
        }
    }

    public synchronized int getValue() {
        return this.m_nCurrVal;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent ev) {
        int origValue;
        int currValue;
        boolean increment = ev.getSource() == this.m_inc;
        try {
            origValue = currValue = Integer.parseInt(this.m_data.getText());
        }
        catch (NumberFormatException ex) {
            return;
        }
        if (increment && currValue + this.m_nDelta <= this.m_nMax) {
            currValue += this.m_nDelta;
        } else if (!increment && currValue - this.m_nDelta >= this.m_nMin) {
            currValue -= this.m_nDelta;
        }
        currValue = Math.max(Math.min(this.m_nMax, currValue), this.m_nMin);
        if (origValue != currValue) {
            this.setValue(currValue);
        }
    }

    public JTextField getDataEntryField() {
        return this.m_data;
    }

    @Override
    public void setEnabled(boolean bEnable) {
        this.m_data.setEnabled(bEnable);
        this.m_inc.setEnabled(bEnable);
        this.m_dec.setEnabled(bEnable);
    }

    @Override
    public boolean isEnabled() {
        return this.m_data.isEnabled();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.checkBounds();
    }

    public void checkBounds() {
        int nEditValue;
        try {
            nEditValue = Integer.parseInt(this.m_data.getText());
        }
        catch (NumberFormatException ex) {
            nEditValue = this.m_nInitial;
        }
        int nLegalValue = Math.min(this.m_nMax, Math.max(this.m_nMin, nEditValue));
        this.setValue(nLegalValue);
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.mListener = listener;
    }

    public void cleanup() {
        this.m_inc.cleanup();
        this.m_dec.cleanup();
    }

    public static interface ValueChangedListener {
        public void valueChanged(int var1, int var2);
    }
}

