/*
 * Decompiled with CFR 0.152.
 */
package com.sas.editor;

import com.sas.editor.CodeEditorKeyManager;
import com.sas.editor.CodeEditorPane;
import com.sas.editor.CodeEditorResource;
import com.sas.editor.CommandWrapper;
import com.sas.editor.KeyStrokeTextField;
import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AssignEditorKeysPane
extends JPanel {
    DefaultListModel dlm = new DefaultListModel();
    CodeEditorResource resource = new CodeEditorResource(AssignEditorKeysPane.class);
    CodeEditorKeyManager keyManager;
    KeyStroke currentKeystroke;
    JLabel CategoryLabel = new JLabel();
    JLabel CommandsLabel = new JLabel();
    JLabel DescriptionLabel = new JLabel();
    JLabel CurrentKeysLabel = new JLabel();
    JLabel NewKeyLabel = new JLabel();
    JScrollPane CommandsScroll;
    JScrollPane KeysScroll;
    WideComboBox CategoryCombo = new WideComboBox();
    JList CommandsList = new JList();
    JList KeysList = new JList();
    JTextField ShortcutTextField = new KeyStrokeTextField();
    JTextArea DescriptionText = new JTextArea(){

        @Override
        public boolean isFocusTraversable() {
            return false;
        }
    };
    JButton RemoveButton = new JButton();
    JButton ResetButton = new JButton();
    JButton AssignButton = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public AssignEditorKeysPane(CodeEditorPane editor, CodeEditorKeyManager manager) {
        this(manager);
    }

    public AssignEditorKeysPane(CodeEditorKeyManager manager) {
        this.keyManager = manager;
        this.keyManager.InitializeData();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.CommandsScroll = new JScrollPane(this.CommandsList);
        this.KeysScroll = new JScrollPane(this.KeysList);
        this.keyManager.PopulateCategoryComboBox((JComboBox)this.CategoryCombo);
        this.loadCommands();
        this.setupMnemonics(this.CategoryLabel, "AssignEditorKeysPane.CategoryLabel.txt");
        this.setupMnemonics(this.CommandsLabel, "AssignEditorKeysPane.CommandsLabel.txt");
        this.DescriptionLabel.setText(this.resource.getString("AssignEditorKeysPane.DescriptionLabel.txt"));
        this.setupMnemonics(this.CurrentKeysLabel, "AssignEditorKeysPane.CurrentKeysLabel.txt");
        this.setupMnemonics(this.NewKeyLabel, "AssignEditorKeysPane.NewKeyLabel.txt");
        this.setupMnemonics(this.RemoveButton, "Common.Remove.txt");
        this.setupMnemonics(this.ResetButton, "Common.Reset.txt");
        this.setupMnemonics(this.AssignButton, "Common.Assign.txt");
        this.DescriptionText.setBorder(BorderFactory.createEtchedBorder());
        this.DescriptionText.setBackground(Color.lightGray);
        this.DescriptionText.setEditable(false);
        this.DescriptionText.setLineWrap(true);
        this.DescriptionText.setWrapStyleWord(true);
        this.CategoryLabel.setLabelFor((Component)this.CategoryCombo);
        this.CommandsLabel.setLabelFor(this.CommandsList);
        this.CurrentKeysLabel.setLabelFor(this.KeysList);
        this.NewKeyLabel.setLabelFor(this.ShortcutTextField);
        Dimension btnSize = new Dimension(150, 25);
        this.setStaticComponentSize(this.RemoveButton, btnSize);
        this.setStaticComponentSize(this.ResetButton, btnSize);
        this.setStaticComponentSize(this.AssignButton, btnSize);
        Dimension scrSize = new Dimension(178, 160);
        this.setStaticComponentSize(this.CommandsScroll, scrSize);
        Dimension cmbSize = new Dimension((int)(scrSize.getWidth() + 200.0 + 7.0), 20);
        this.CategoryCombo.setMinimumSize(cmbSize);
        this.CategoryCombo.setPreferredSize(cmbSize);
        this.CategoryCombo.setMaximumSize(new Dimension(10000, 60));
        Dimension lblSize = new Dimension((int)scrSize.getWidth(), 20);
        this.setStaticComponentSize(this.CommandsLabel, lblSize);
        Dimension efldSize = new Dimension(200, 20);
        this.NewKeyLabel.setMinimumSize(efldSize);
        this.NewKeyLabel.setPreferredSize(efldSize);
        this.NewKeyLabel.setMaximumSize(new Dimension(10000, 20));
        this.ShortcutTextField.setMinimumSize(efldSize);
        this.ShortcutTextField.setPreferredSize(efldSize);
        this.ShortcutTextField.setMaximumSize(new Dimension(10000, 20));
        this.KeysList.setMaximumSize(new Dimension(10000, 10000));
        this.KeysList.setBorder(BorderFactory.createEtchedBorder());
        Box box1 = Box.createHorizontalBox();
        box1.add(this.CategoryLabel);
        box1.add(Box.createHorizontalGlue());
        Box box2 = Box.createHorizontalBox();
        box2.add((Component)this.CategoryCombo);
        box2.add(Box.createHorizontalStrut(7));
        box2.add(Box.createRigidArea(new Dimension((int)btnSize.getWidth(), 20)));
        Box box3 = Box.createHorizontalBox();
        box3.add(this.CommandsLabel);
        box3.add(Box.createHorizontalStrut(5));
        box3.add(this.CurrentKeysLabel);
        box3.add(Box.createHorizontalGlue());
        Box labelBox = Box.createHorizontalBox();
        labelBox.add(this.NewKeyLabel);
        labelBox.add(Box.createHorizontalGlue());
        Box keystrokeBox = Box.createVerticalBox();
        keystrokeBox.add(this.KeysList);
        keystrokeBox.add(Box.createVerticalStrut(5));
        keystrokeBox.add(labelBox);
        keystrokeBox.add(this.ShortcutTextField);
        Box buttonBox = Box.createVerticalBox();
        buttonBox.add(this.RemoveButton);
        buttonBox.add(Box.createVerticalStrut(7));
        buttonBox.add(this.ResetButton);
        buttonBox.add(Box.createVerticalGlue());
        buttonBox.add(this.AssignButton);
        buttonBox.setMaximumSize(new Dimension((int)btnSize.getWidth(), 10000));
        Box box4 = Box.createHorizontalBox();
        box4.add(this.CommandsScroll);
        box4.add(Box.createHorizontalStrut(7));
        box4.add(keystrokeBox);
        box4.add(Box.createHorizontalStrut(7));
        box4.add(buttonBox);
        Box box5 = Box.createHorizontalBox();
        box5.add(this.DescriptionLabel);
        box5.add(Box.createHorizontalGlue());
        Box box6 = Box.createHorizontalBox();
        this.DescriptionText.setMinimumSize(cmbSize);
        box6.add(this.DescriptionText);
        box6.add(Box.createHorizontalStrut(7));
        box6.add(Box.createRigidArea(btnSize));
        Box box = Box.createVerticalBox();
        box.add(box1);
        box.add(box2);
        box.add(Box.createVerticalStrut(3));
        box.add(box3);
        box.add(box4);
        box.add(Box.createVerticalStrut(3));
        box.add(box5);
        box.add(box6);
        this.setLayout(this.gridBagLayout1);
        this.add((Component)box, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.CategoryCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignEditorKeysPane.this.loadCommands();
            }
        });
        this.CommandsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AssignEditorKeysPane.this.ListChanged();
            }
        });
        this.ShortcutTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                AssignEditorKeysPane.this.ShortcutTextField.setText("");
                AssignEditorKeysPane.this.grabKeyStroke(e);
                e.consume();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.AssignButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignEditorKeysPane.this.onAssign();
            }
        });
        this.RemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignEditorKeysPane.this.onRemove();
            }
        });
        this.ResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignEditorKeysPane.this.onReset();
            }
        });
    }

    private void setStaticComponentSize(JComponent jc, Dimension d) {
        jc.setMinimumSize(d);
        jc.setPreferredSize(d);
        jc.setMaximumSize(d);
    }

    public void loadCommands() {
        Collator coll = Collator.getInstance(Locale.getDefault());
        String res = "";
        this.CommandsList.removeAll();
        this.dlm.clear();
        String selectedType = (String)this.CategoryCombo.getSelectedItem();
        res = this.resource.getString("CodeEditorKeyManager.CategoryComboItem.0.txt");
        boolean allTypes = coll.compare(selectedType, res) == 0;
        CodeEditorKeyManager.KeyInfoItem[] allItems = this.keyManager.getCommandItems();
        ArrayList<CommandWrapper> allListItems = new ArrayList<CommandWrapper>();
        for (int i = 0; i < allItems.length; ++i) {
            CodeEditorKeyManager.KeyInfoItem keyInfoItem = allItems[i];
            String groupName = keyInfoItem.getGroup();
            if (groupName.length() <= 0 || !allTypes && coll.compare(selectedType, groupName) != 0) continue;
            allListItems.add(new CommandWrapper(keyInfoItem));
        }
        Collections.sort(allListItems, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                CommandWrapper c0 = (CommandWrapper)arg0;
                CommandWrapper c1 = (CommandWrapper)arg1;
                return c0.getCommandInfo().getTranslatedName().compareTo(c1.getCommandInfo().getTranslatedName());
            }
        });
        for (Object e : allListItems) {
            this.dlm.addElement(e);
        }
        this.CommandsList.setModel(this.dlm);
        this.CommandsList.setSelectedIndex(0);
        this.ListChanged();
    }

    public void ListChanged() {
        CommandWrapper wrapper = (CommandWrapper)this.CommandsList.getSelectedValue();
        if (wrapper == null) {
            return;
        }
        String[] strokes = wrapper.getCommandInfo().getKeystrokeList();
        this.dlm = new DefaultListModel();
        if (strokes == null) {
            return;
        }
        for (int i = 0; i < strokes.length; ++i) {
            this.dlm.addElement(strokes[i]);
        }
        this.KeysList.setModel(this.dlm);
        String desc = wrapper.getCommandInfo().getDescription();
        this.DescriptionText.setText(desc);
        this.KeysList.setSelectedIndex(0);
    }

    public void grabKeyStroke(KeyEvent e) {
        block3: {
            block2: {
                if (e.getKeyCode() == 18) break block2;
                if (e.getKeyCode() == 17) break block2;
                if (e.getKeyCode() != 16) break block3;
            }
            return;
        }
        this.currentKeystroke = KeyStroke.getKeyStrokeForEvent(e);
        String strKey = CodeEditorKeyManager.KeystrokeToString(this.currentKeystroke);
        this.ShortcutTextField.setText(strKey);
    }

    public void onAssign() {
        CommandWrapper wrapper = (CommandWrapper)this.CommandsList.getSelectedValue();
        if (wrapper == null) {
            return;
        }
        if (this.ShortcutTextField.getText().compareTo("") == 0) {
            return;
        }
        this.keyManager.AssignKeystrokeForCommand(wrapper.getCommandInfo(), this.currentKeystroke);
        this.ListChanged();
        this.ShortcutTextField.setText("");
    }

    public void onApply() {
        this.keyManager.ApplyKeystrokes();
    }

    public void onCancel() {
        this.keyManager.InitializeData();
    }

    public void onRemove() {
        CommandWrapper wrapper = (CommandWrapper)this.CommandsList.getSelectedValue();
        if (wrapper == null) {
            return;
        }
        this.keyManager.RemoveKeystroke(wrapper.getCommandInfo(), (String)this.KeysList.getSelectedValue());
        this.ListChanged();
    }

    public void onReset() {
        CommandWrapper wrapper = (CommandWrapper)this.CommandsList.getSelectedValue();
        this.keyManager.ResetAction(wrapper.getCommandInfo());
        this.ListChanged();
    }

    protected void setupMnemonics(JLabel lbl, String key) {
        String lblItem = this.resource.getString(key);
        String lblText = Util.getLabelWithoutMnemonic((String)lblItem);
        lbl.setText(lblText);
        int index = Util.getDisplayedMnemonicIndex((String)lblItem);
        if (index > -1) {
            lbl.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)lblItem));
            lbl.setDisplayedMnemonicIndex(index);
        }
    }

    protected void setupMnemonics(JButton btn, String key) {
        String buttonItem = this.resource.getString(key);
        String buttonText = Util.getLabelWithoutMnemonic((String)buttonItem);
        btn.setText(buttonText);
        int index = Util.getDisplayedMnemonicIndex((String)buttonItem);
        if (index > -1) {
            btn.setMnemonic(Util.getDisplayedMnemonic((String)buttonItem));
            btn.setDisplayedMnemonicIndex(index);
        }
    }
}

