/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.AxisParser;
import com.sas.graphics.silk.xml.parsers.ComponentParser;
import com.sas.graphics.silk.xml.parsers.LegendParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.RoleParser;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.Vec3d;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Element;

public abstract class Silk3DChartParser
extends ComponentParser {
    public Object getFromXML(Hashtable context, Element element, Object instance) {
        int xmlType = SILKParser.getXMLType((Hashtable)context);
        this.setObject(instance);
        String n = element.getAttribute("name");
        this.name = n == null || n.length() == 0 ? ParserUtils.getUniqueChartName((Hashtable)context) : n;
        if (context != null && this.getObject() != null) {
            context.put(this.name, this.getObject());
        }
        if (this.getObject() instanceof SourceInterface) {
            SourceInterface chart = (SourceInterface)this.getObject();
            String data = element.getAttribute("data");
            if (data != null && data.length() > 0 && chart.getDataSource() == null) {
                chart.setDataSource(SILKParser.getData((String)data, (Hashtable)context));
            }
            if (chart.getDataSource() == null) {
                String sasData = element.getAttribute("sasData");
                SourceInterface dri = null;
                if (sasData != null && sasData.length() > 0 && (dri = SILKParser.getDataRepository((Hashtable)context)) != null) {
                    chart.setDataSource(dri.getDataSource((Object)sasData));
                }
            }
        }
        Element role = null;
        int i = 1;
        while ((role = ParserUtils.getChildWithTagName((String)"Role", (Element)element, (int)i)) != null) {
            RoleParser rp = new RoleParser();
            rp.getFromXML(context, role, this.getObject());
            ++i;
        }
        if (this.getObject() instanceof ComponentInterface) {
            ((ComponentInterface)this.getObject()).setId((Object)this.name);
        }
        Object rc = super.getFromXML(context, element, instance);
        switch (xmlType) {
            case 1: {
                this.loadFromODS(context, element);
                break;
            }
            case 0: {
                this.loadFromStatgraph(context, element);
            }
        }
        SILKParser.addChart((Hashtable)context, (String)this.getName());
        if (this.getObject() instanceof GraphInterface) {
            Element zAxis;
            Element yAxis;
            GraphInterface graph = (GraphInterface)this.getObject();
            Element xAxis = ParserUtils.getChildWithTagName((String)"XAxis", (Element)element);
            if (xAxis != null) {
                AxisInterface axis = graph.getAxis((Object)"X");
                AxisParser ap = new AxisParser(axis);
                ap.getFromXML(context, xAxis, (Object)axis);
            }
            if ((yAxis = ParserUtils.getChildWithTagName((String)"YAxis", (Element)element)) != null) {
                AxisInterface axis = graph.getAxis((Object)"Y");
                AxisParser ap = new AxisParser(axis);
                ap.getFromXML(context, yAxis, (Object)axis);
            }
            if ((zAxis = ParserUtils.getChildWithTagName((String)"ZAxis", (Element)element)) != null) {
                AxisInterface axis = graph.getAxis((Object)"Z");
                AxisParser ap = new AxisParser(axis);
                ap.getFromXML(context, zAxis, (Object)axis);
            }
            Element legend = null;
            int index = 1;
            while ((legend = ParserUtils.getChildWithTagName((String)"Legend", (Element)element, (int)index)) != null) {
                String type = legend.getAttribute("type");
                if (type == null || type.trim().length() == 0) {
                    type = null;
                }
                LegendParser.parseLegend((Element)legend, (LegendInterface)graph.getLegend((Object)type));
                ++index;
            }
        }
        if (this.getObject() instanceof PropertyInterface) {
            String cartesian;
            String projection;
            String pz;
            String pt;
            PropertyInterface prop = (PropertyInterface)this.getObject();
            String or = element.getAttribute("rotation");
            if (or != null && or.length() > 0) {
                prop.setPropertyValue(10202, (Object)new Double(ParserUtils.getDoubleValue((String)or)));
            }
            if ((pt = element.getAttribute("tilt")) != null && pt.length() > 0) {
                prop.setPropertyValue(10203, (Object)new Double(ParserUtils.getDoubleValue((String)pt)));
            }
            if ((pz = element.getAttribute("zoom")) != null && pz.length() > 0) {
                prop.setPropertyValue(10204, (Object)new Double(ParserUtils.getDoubleValue((String)pz)));
            }
            String fpx = element.getAttribute("focalPointX");
            String fpy = element.getAttribute("focalPointY");
            String fpz = element.getAttribute("focalPointZ");
            if (fpx != null && fpx.length() > 0 && fpy != null && fpy.length() > 0 && fpz != null && fpz.length() > 0) {
                prop.setPropertyValue(10205, (Object)new Vec3d(ParserUtils.getDoubleValue((String)fpx), ParserUtils.getDoubleValue((String)fpy), ParserUtils.getDoubleValue((String)fpz)));
            }
            if ((projection = element.getAttribute("projection")) != null && projection.length() > 0) {
                prop.setPropertyValue(10200, (Object)projection);
            }
            if ((cartesian = element.getAttribute("cartesian")) != null && cartesian.length() > 0) {
                prop.setPropertyValue(10206, (Object)new Boolean(ParserUtils.getBooleanValue((String)cartesian)));
            }
            String cox = element.getAttribute("cartesianOriginX");
            String coy = element.getAttribute("cartesianOriginY");
            String coz = element.getAttribute("cartesianOriginZ");
            if (cox != null && cox.length() > 0 && coy != null && coy.length() > 0 && coz != null && coz.length() > 0) {
                prop.setPropertyValue(10207, (Object)new Vec3d(ParserUtils.getDoubleValue((String)cox), ParserUtils.getDoubleValue((String)coy), ParserUtils.getDoubleValue((String)coz)));
            }
        }
        if (rc instanceof PropertyInterface) {
            ((PropertyInterface)rc).applyPropertyChanges();
        }
        return rc;
    }

    protected abstract void loadFromStatgraph(Hashtable var1, Element var2);

    protected abstract void loadFromODS(Hashtable var1, Element var2);

    public Element putToXML(Hashtable context, Object object) {
        int xmlType = SILKParser.getXMLType((Hashtable)context);
        Element rc = null;
        switch (xmlType) {
            case 1: {
                rc = this.getODSXML(context, object);
                break;
            }
            case 0: {
                rc = this.getStatgraphXML(context, object);
            }
        }
        rc = super.putToXML(context, object, rc);
        if (object instanceof PropertyInterface) {
            Object obj;
            PropertyInterface prop = (PropertyInterface)object;
            boolean userSet = false;
            Object value = prop.getPropertyValue(10202);
            userSet = prop.hasUserSetValue(10202);
            if (value != null && userSet && value instanceof Double) {
                rc.setAttribute("rotation", ((Double)value).toString());
            }
            value = prop.getPropertyValue(10203);
            userSet = prop.hasUserSetValue(10203);
            if (value != null && userSet && value instanceof Double) {
                rc.setAttribute("tilt", ((Double)value).toString());
            }
            value = prop.getPropertyValue(10204);
            userSet = prop.hasUserSetValue(10204);
            if (value != null && userSet && value instanceof Double) {
                rc.setAttribute("zoom", ((Double)value).toString());
            }
            value = prop.getPropertyValue(10205);
            userSet = prop.hasUserSetValue(10205);
            if (value != null && userSet && value instanceof Vec3d) {
                rc.setAttribute("focalPointX", Double.toString(((Vec3d)value).x));
                rc.setAttribute("focalPointY", Double.toString(((Vec3d)value).y));
                rc.setAttribute("focalPointZ", Double.toString(((Vec3d)value).z));
            }
            value = prop.getPropertyValue(10200);
            userSet = prop.hasUserSetValue(10200);
            if (value != null && userSet && value instanceof Number) {
                if (((Number)value).intValue() == 0) {
                    rc.setAttribute("projection", "oblique");
                } else if (((Number)value).intValue() == 1) {
                    rc.setAttribute("projection", "perspective");
                }
            }
            value = prop.getPropertyValue(10206);
            userSet = prop.hasUserSetValue(10206);
            if (value != null && userSet && value instanceof Boolean) {
                rc.setAttribute("cartesian", ((Boolean)value).toString());
            }
            value = prop.getPropertyValue(10207);
            userSet = prop.hasUserSetValue(10207);
            if (value != null && userSet && value instanceof Vec3d) {
                rc.setAttribute("cartesianOriginX", Double.toString(((Vec3d)value).x));
                rc.setAttribute("cartesianOriginY", Double.toString(((Vec3d)value).y));
                rc.setAttribute("cartesianOriginZ", Double.toString(((Vec3d)value).z));
            }
            if ((obj = prop.getPropertyValue(24)) == null && prop instanceof GraphInterface) {
                obj = ((GraphInterface)prop).getLegend(null);
            }
            Enumeration e = Extract.elements((Object)obj);
            while (e.hasMoreElements()) {
                Object o;
                Object legendName = o = e.nextElement();
                String type = null;
                if (!(o instanceof LegendInterface)) {
                    type = o.toString();
                    prop.setPropertyValue(23, o);
                    o = prop instanceof GraphInterface ? ((GraphInterface)prop).getLegend(o) : null;
                }
                if (o == null) continue;
                LegendParser parser = new LegendParser();
                Element elem = parser.putToXML(context, o);
                if (type != null) {
                    elem.setAttribute("type", ParserUtils.getString(legendName));
                }
                if (elem == null) continue;
                rc.appendChild(elem);
            }
        }
        if (object instanceof GraphInterface) {
            AxisParser aParser = new AxisParser();
            Element e = aParser.putToXML(context, (Object)((GraphInterface)object).getAxis((Object)"X"), "XAxis");
            if (e != null) {
                rc.appendChild(e);
            }
            if ((e = aParser.putToXML(context, (Object)((GraphInterface)object).getAxis((Object)"Y"), "YAxis")) != null) {
                rc.appendChild(e);
            }
            if ((e = aParser.putToXML(context, (Object)((GraphInterface)object).getAxis((Object)"Z"), "ZAxis")) != null) {
                rc.appendChild(e);
            }
        }
        return rc;
    }

    protected abstract Element getODSXML(Hashtable var1, Object var2);

    protected abstract Element getStatgraphXML(Hashtable var1, Object var2);

    public abstract Object getObject();

    public abstract boolean setObject(Object var1);
}

