/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ui.AxisOriginDialog;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.PropertyUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ViewPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -4435419736135100069L;
    protected Vector listeners = null;
    protected boolean showWireframe;
    protected boolean showCartesian;
    protected JLabel projectionLabel;
    protected JComboBox projectionCombo;
    protected JCheckBox wallCheck;
    protected JCheckBox wireframeCheck;
    protected JCheckBox cartesianCheck;
    protected JButton originButton;
    protected AxisOriginDialog originDialog;
    private ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public ViewPanel() {
        this(true, true);
    }

    public ViewPanel(boolean showWireframe) {
        this(showWireframe, true);
    }

    public ViewPanel(boolean showWireframe, boolean showCartesian) {
        this.showWireframe = showWireframe;
        this.showCartesian = showCartesian;
        this.initialize();
        this.addListeners();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.wireframeCheck) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10301, (Object)new Boolean(this.wireframeCheck.isSelected()));
        } else if (source == this.projectionCombo) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10200, (Object)this.projectionCombo.getSelectedItem());
            this.enableControls();
        } else if (source == this.wallCheck) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)26, (Object)new Boolean(this.wallCheck.isSelected()));
        } else if (source == this.cartesianCheck) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10206, (Object)new Boolean(this.cartesianCheck.isSelected()));
            this.enableControls();
        } else if (source == this.originButton) {
            this.originDialog.setVisible(true);
        }
    }

    public void setListeners(Vector listeners) {
        this.listeners = listeners;
        this.originDialog.setListeners(listeners);
    }

    private void addListeners() {
        if (this.wireframeCheck != null) {
            this.wireframeCheck.addActionListener(this);
        }
        if (this.cartesianCheck != null) {
            this.cartesianCheck.addActionListener(this);
        }
        if (this.originButton != null) {
            this.originButton.addActionListener(this);
        }
        this.projectionCombo.addActionListener(this);
        this.wallCheck.addActionListener(this);
    }

    private void removeListeners() {
        if (this.wireframeCheck != null) {
            this.wireframeCheck.removeActionListener(this);
        }
        if (this.cartesianCheck != null) {
            this.cartesianCheck.removeActionListener(this);
        }
        if (this.originButton != null) {
            this.originButton.removeActionListener(this);
        }
        this.projectionCombo.removeActionListener(this);
        this.wallCheck.removeActionListener(this);
    }

    public void initFromSource() {
        Object o;
        this.removeListeners();
        if (this.wireframeCheck != null && (o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10301)) != null && o instanceof Boolean) {
            this.wireframeCheck.setSelected((Boolean)o);
        }
        this.projectionCombo.removeAllItems();
        o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10201);
        if (o != null && o instanceof Object[]) {
            Object[] list = (Object[])o;
            for (int i = 0; i < list.length; ++i) {
                this.projectionCombo.addItem(list[i]);
            }
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10200)) != null && o instanceof Number) {
            this.projectionCombo.setSelectedIndex(((Number)o).intValue());
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)26)) != null && o instanceof Boolean) {
            this.wallCheck.setSelected((Boolean)o);
        }
        if (this.cartesianCheck != null && (o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10206)) != null && o instanceof Boolean) {
            this.cartesianCheck.setSelected((Boolean)o);
        }
        this.enableControls();
        this.addListeners();
    }

    private void initialize() {
        this.setLayout(new GridLayout(0, 1, 5, 5));
        TitledBorder viewBorder = new TitledBorder(new EtchedBorder(), ResourceLoader.getResourceString((Object)this.rb, (String)"ViewPanel.View.txt", (String)"View"));
        viewBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.setBorder(new CompoundBorder(viewBorder, new EmptyBorder(5, 5, 5, 5)));
        this.add(this.getProjectionPanel());
        if (this.showCartesian) {
            this.add(this.getCartesianCheckPanel());
        }
        this.add(this.getWallCheckPanel());
        if (this.showWireframe) {
            this.add(this.getWireframeCheckPanel());
        }
        this.originDialog = new AxisOriginDialog(UIUtilities.getParentFrame((Component)this));
        UIUtilities.center((Window)this.originDialog);
    }

    private JPanel getProjectionPanel() {
        JPanel projectionPanel = new JPanel();
        projectionPanel.setLayout(new BorderLayout(15, 15));
        this.projectionLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"ViewPanel.Projection.txt", (String)"Projection:"));
        this.projectionLabel.setFont(TabbedPropertiesDialog.dialogFont);
        projectionPanel.add((Component)this.projectionLabel, "West");
        projectionPanel.add((Component)this.getProjectionCombo(), "Center");
        return projectionPanel;
    }

    private JComboBox getProjectionCombo() {
        if (this.projectionCombo == null) {
            this.projectionCombo = new JComboBox();
            this.projectionCombo.setFont(TabbedPropertiesDialog.dialogFont);
            this.projectionCombo.setBackground(Color.WHITE);
        }
        return this.projectionCombo;
    }

    private JPanel getWallCheckPanel() {
        JPanel wallCheckPanel = new JPanel(new BorderLayout(5, 5));
        this.wallCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"ViewPanel.ShowWall.txt", (String)"Show wall"));
        this.wallCheck.setFont(TabbedPropertiesDialog.dialogFont);
        wallCheckPanel.add((Component)this.wallCheck, "West");
        wallCheckPanel.add((Component)new JPanel(), "East");
        return wallCheckPanel;
    }

    private JPanel getWireframeCheckPanel() {
        JPanel wireframeCheckPanel = new JPanel(new BorderLayout(5, 5));
        this.wireframeCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"ViewPanel.WireframeRotate.txt", (String)"Wireframe rotation"));
        this.wireframeCheck.setFont(TabbedPropertiesDialog.dialogFont);
        wireframeCheckPanel.add((Component)this.wireframeCheck, "West");
        wireframeCheckPanel.add((Component)new JPanel(), "East");
        return wireframeCheckPanel;
    }

    private JPanel getCartesianCheckPanel() {
        JPanel cartesianCheckPanel = new JPanel(new BorderLayout(5, 5));
        this.cartesianCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"ViewPanel.Cartesian.txt", (String)"Cartesian"));
        this.cartesianCheck.setFont(TabbedPropertiesDialog.dialogFont);
        this.originButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"ViewPanel.Origin.txt", (String)"Origin"));
        this.originButton.setFont(TabbedPropertiesDialog.dialogFont);
        cartesianCheckPanel.add((Component)this.cartesianCheck, "West");
        cartesianCheckPanel.add((Component)this.originButton, "East");
        return cartesianCheckPanel;
    }

    private void enableControls() {
        if (this.showCartesian) {
            boolean enableCartesian = this.projectionCombo.getSelectedIndex() == 1;
            boolean enableProjection = !this.cartesianCheck.isSelected();
            this.cartesianCheck.setEnabled(enableCartesian);
            this.originButton.setEnabled(enableCartesian && !enableProjection);
            this.projectionCombo.setEnabled(enableProjection);
            this.projectionLabel.setEnabled(enableProjection);
            this.wallCheck.setEnabled(enableProjection);
        }
    }
}

