/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.ColorMapperChooserPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.ViewPanel;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.PropertyUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Scatter3DPanel
extends JPanel
implements TabPanelInterface,
ActionListener,
ChangeListener {
    private static final long serialVersionUID = -4517212265170068051L;
    protected Vector listeners = new Vector();
    protected ViewPanel viewPanel;
    protected JSlider opacitySlider;
    protected JCheckBox colorByCheck;
    protected JComboBox colorByCombo;
    protected String opacitySliderPattern;
    protected JLabel opacityLabel;
    protected JCheckBox showOutlinesCheck;
    protected JLabel sizeLabel;
    protected JSlider sizeSlider;
    protected int sizeMin = 0;
    protected int sizeMax = 0;
    protected String sizeSliderPattern;
    protected ColorMapperChooserPanel colorMapperChooserPanel = null;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public Scatter3DPanel(PropertyInterface scatter) {
        this.sizeSliderPattern = ResourceLoader.getResourceString((Object)this.rb, (String)"Scatter3DPanel.SizeSliderText.fmt", (String)"Size: {0,number,integer}");
        this.opacitySliderPattern = ResourceLoader.getResourceString((Object)this.rb, (String)"Scatter3DPanel.OpacitySliderText.fmt", (String)"Opacity: {0,number,integer}");
        this.addPropertyListener(scatter);
        this.initGUI();
        this.initSizeSlider();
        this.addListeners();
    }

    private void addListeners() {
        this.opacitySlider.addChangeListener(this);
        this.colorByCheck.addActionListener(this);
        this.colorByCombo.addActionListener(this);
        this.showOutlinesCheck.addActionListener(this);
        this.sizeSlider.addChangeListener(this);
    }

    private void removeListeners() {
        this.opacitySlider.removeChangeListener(this);
        this.colorByCheck.removeActionListener(this);
        this.colorByCombo.removeActionListener(this);
        this.showOutlinesCheck.removeActionListener(this);
        this.sizeSlider.removeChangeListener(this);
    }

    public boolean applyChanges() {
        boolean status = PropertyUtils.applyChanges((Vector)this.listeners);
        this.initFromSource();
        return status;
    }

    public boolean cancelChanges() {
        return PropertyUtils.cancelChanges((Vector)this.listeners);
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        return PropertyUtils.addPropertyListener((Vector)this.listeners, (PropertyInterface)prop);
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.removePropertyListener((Vector)this.listeners, (PropertyInterface)prop);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.colorByCheck) {
            boolean colorBy = this.colorByCheck.isSelected();
            Object selectedRole = this.colorByCombo.getSelectedItem();
            if (colorBy) {
                PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10101, (Object)selectedRole);
            } else {
                PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10101, null);
            }
            this.colorByCombo.setEnabled(colorBy);
            this.updateMarkerSettings();
        } else if (source == this.colorByCombo) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10101, (Object)this.colorByCombo.getSelectedItem());
        } else if (source == this.showOutlinesCheck) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)2018, (Object)new Boolean(this.showOutlinesCheck.isSelected()));
            this.updateMarkerSettings();
        }
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.sizeSlider = new JSlider();
        this.opacitySlider = new JSlider();
        this.opacitySlider.setMinimum(0);
        this.opacitySlider.setMaximum(100);
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new GridLayout(0, 1, 15, 15));
        sliderPanel.setBorder(new EmptyBorder(5, 0, 5, 0));
        sliderPanel.add(this.sizeSlider);
        sliderPanel.add(this.opacitySlider);
        this.sizeLabel = new JLabel(MessageFormat.format(this.sizeSliderPattern, new Integer(0)));
        this.sizeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        Dimension labelSize = this.sizeLabel.getPreferredSize();
        this.sizeLabel.setMinimumSize(labelSize);
        this.opacityLabel = new JLabel(MessageFormat.format(this.opacitySliderPattern, new Integer(100)));
        this.opacityLabel.setFont(TabbedPropertiesDialog.dialogFont);
        labelSize = this.opacityLabel.getPreferredSize();
        this.opacityLabel.setPreferredSize(labelSize);
        this.opacityLabel.setMinimumSize(labelSize);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1, 5, 5));
        labelPanel.add(this.sizeLabel);
        labelPanel.add(this.opacityLabel);
        JPanel labelsSlidersPanel = new JPanel();
        labelsSlidersPanel.setLayout(new BorderLayout(5, 5));
        labelsSlidersPanel.add((Component)labelPanel, "West");
        labelsSlidersPanel.add((Component)sliderPanel, "Center");
        this.showOutlinesCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"Scatter3DPanel.ShowOutlines.txt", (String)"Show outlines"));
        this.showOutlinesCheck.setFont(TabbedPropertiesDialog.dialogFont);
        JPanel outlinesCheckPanel = new JPanel();
        outlinesCheckPanel.setLayout(new BorderLayout(5, 5));
        outlinesCheckPanel.add((Component)this.showOutlinesCheck, "West");
        outlinesCheckPanel.add((Component)new JPanel(), "East");
        JPanel markerPanel = new JPanel();
        markerPanel.setLayout(new BorderLayout(5, 5));
        TitledBorder markerBorder = new TitledBorder(new EtchedBorder(), ResourceLoader.getResourceString((Object)this.rb, (String)"Scatter3DPanel.Markers.txt", (String)"Markers"));
        markerBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        markerPanel.setBorder(new CompoundBorder(markerBorder, new EmptyBorder(5, 5, 5, 5)));
        markerPanel.add((Component)outlinesCheckPanel, "North");
        markerPanel.add((Component)labelsSlidersPanel, "South");
        this.colorByCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"Scatter3DPanel.ColorBy.txt", (String)"Color by:"));
        this.colorByCheck.setFont(TabbedPropertiesDialog.dialogFont);
        this.colorByCombo = new JComboBox();
        this.colorByCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.colorByCombo.setBackground(Color.WHITE);
        Roles roles = Roles.getInstance(null);
        this.colorByCombo.addItem(roles.getRoleObject("ROLE_X"));
        this.colorByCombo.addItem(roles.getRoleObject("ROLE_Y"));
        this.colorByCombo.addItem(roles.getRoleObject("ROLE_Z"));
        JPanel colorByPanel = new JPanel();
        colorByPanel.setLayout(new BorderLayout(15, 15));
        colorByPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        colorByPanel.add((Component)this.colorByCheck, "West");
        colorByPanel.add((Component)this.colorByCombo, "Center");
        this.viewPanel = new ViewPanel(false, true);
        this.viewPanel.setListeners(this.listeners);
        JPanel chartPanel = new JPanel();
        chartPanel.setLayout(new BorderLayout(5, 5));
        chartPanel.add((Component)colorByPanel, "North");
        chartPanel.add((Component)this.viewPanel, "South");
        this.colorMapperChooserPanel = new ColorMapperChooserPanel(this.listeners);
        JPanel panel0 = new JPanel();
        JPanel panel1 = new JPanel();
        panel0.setLayout(new BorderLayout(5, 5));
        panel0.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel0.add((Component)panel1, "Center");
        panel1.setLayout(new BorderLayout(5, 5));
        panel1.add((Component)chartPanel, "North");
        panel1.add((Component)markerPanel, "Center");
        panel1.add((Component)this.colorMapperChooserPanel, "South");
        this.add((Component)panel0, "North");
    }

    private void initFromSource() {
        this.colorMapperChooserPanel.initFromSource();
        this.viewPanel.initFromSource();
        this.removeListeners();
        double opacity = this.getDoubleProperty(10302, 0.0);
        int min = this.opacitySlider.getMinimum();
        int max = this.opacitySlider.getMaximum();
        int value = min + (int)(opacity * (double)(max - min));
        this.opacitySlider.setValue(value);
        this.opacityLabel.setText(MessageFormat.format(this.opacitySliderPattern, new Integer(value)));
        Object colorByRoles = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10116);
        if (colorByRoles == null) {
            this.colorByCheck.setEnabled(false);
            this.colorByCombo.setEnabled(false);
        } else {
            this.colorByCheck.setEnabled(true);
            this.colorByCombo.setEnabled(true);
            this.colorByCombo.removeAllItems();
            Enumeration e = Extract.elements((Object)colorByRoles);
            while (e.hasMoreElements()) {
                this.colorByCombo.addItem(e.nextElement());
            }
            Object colorBy = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10101);
            boolean colorMapped = this.getBooleanProperty(10102, false);
            if (colorMapped) {
                this.colorByCheck.setSelected(false);
                this.colorByCheck.setEnabled(false);
                this.colorByCombo.setEnabled(false);
            } else {
                this.colorByCheck.setEnabled(true);
                if (colorBy == null) {
                    this.colorByCheck.setSelected(false);
                    this.colorByCombo.setEnabled(false);
                } else {
                    this.colorByCheck.setSelected(true);
                    this.colorByCombo.setEnabled(true);
                    this.colorByCombo.setSelectedItem(colorBy);
                }
            }
        }
        this.addListeners();
        this.updateMarkerSettings();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.opacitySlider) {
            int min = this.opacitySlider.getMinimum();
            int max = this.opacitySlider.getMaximum();
            int v = this.opacitySlider.getValue();
            double opacity = (double)(v - min) / (double)(max - min);
            opacity = Math.max(opacity, 0.0);
            opacity = Math.min(opacity, 1.0);
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10302, (Object)new Double(opacity));
            this.opacityLabel.setText(MessageFormat.format(this.opacitySliderPattern, new Integer(v)));
        } else if (source == this.sizeSlider) {
            int v = this.sizeSlider.getValue();
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)2006, (Object)new Integer(v));
            this.sizeLabel.setText(MessageFormat.format(this.sizeSliderPattern, new Integer(v)));
        }
    }

    protected void initSizeSlider() {
        this.sizeMin = this.getIntProperty(2008, 0);
        this.sizeMax = this.getIntProperty(2009, 0);
        this.sizeSlider.setMinimum(this.sizeMin);
        this.sizeSlider.setMaximum(this.sizeMax);
    }

    protected void updateMarkerSettings() {
        this.removeListeners();
        boolean fillOn = this.getBooleanProperty(2017, true);
        boolean outlineOn = this.getBooleanProperty(2018, true);
        int markerSize = this.getIntProperty(2006, 1);
        this.showOutlinesCheck.setEnabled(fillOn);
        this.showOutlinesCheck.setSelected(outlineOn);
        this.sizeSlider.setValue(markerSize);
        this.sizeLabel.setText(MessageFormat.format(this.sizeSliderPattern, new Integer(markerSize)));
        this.addListeners();
    }

    protected boolean getBooleanProperty(int id, boolean defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)id);
        if (o == null || !(o instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)o;
    }

    protected int getIntProperty(int id, int defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)id);
        if (o == null || !(o instanceof Number)) {
            return defaultValue;
        }
        return ((Number)o).intValue();
    }

    protected double getDoubleProperty(int id, double defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)id);
        if (o == null || !(o instanceof Number)) {
            return defaultValue;
        }
        return ((Number)o).doubleValue();
    }

    protected Color getColorProperty(int id, Color defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)id);
        if (o == null || !(o instanceof Color)) {
            return defaultValue;
        }
        return (Color)o;
    }

    protected Color showColorChooserDialog(Color initialColor) {
        return JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"Scatter3DPanel.ColorChooserTitle.txt", (String)"Choose a color"), initialColor);
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            this.initFromSource();
        }
        super.setVisible(show);
    }
}

