/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.silk3d.util;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.ReferenceLineInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.silk3d.util.SILK3DAxisSet;
import com.sas.graphics.silk.util.AxisDefaults;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.RangeModel;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.ContinuousTickSpacer;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.ContinuousTimeToNumericMapper;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericToNumericMapper;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.TickMarkStyle;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.util.Vector;

public class SILK3DAxis
implements AxisInterface,
PropertyInterface,
RenderInterface,
TextListenerInterface {
    private static final int DEFAULT_MAJOR_TICKS = 6;
    private RectangularAxis axis = null;
    private LineAttrib axisLineStyle = null;
    private LineAttrib gridLineStyle = null;
    private LineAttrib majorTicksStyle = null;
    private LineAttrib minorTicksStyle = null;
    private TextAttrib labelTextStyle = null;
    private TextAttrib valuesTextStyle = null;
    private NumericMapper mapper = null;
    private boolean constantMapper = false;
    private ContinuousTickSpacer tickSpacer = null;
    protected Vector redrawListeners;
    private double padding = 0.0;
    private double axisSize = 1.0;
    private boolean rebuildRequired = true;
    private boolean fireEvents = true;
    private Object low = null;
    private Object high = null;
    private int nMajor = -1;
    private int nMinor = -1;
    private Object[] values = null;
    private boolean autoCalculate = true;
    private boolean forceInteger = false;
    private int maxTicks = 6;
    protected PropertyList pending = null;
    private SILK3DAxisSet axisSet = null;
    private boolean visible = true;
    private boolean isValues = true;
    private boolean labelTooSmall = false;
    private boolean valueTooSmall = false;
    private Font labelFont = null;
    private Font valueFont = null;
    private AxisDefaults axisDefaults = null;
    private ContinuousRange numericRange = null;
    private DiscreteRange discreteRange = null;
    protected RangeModel rangeModel = null;

    public SILK3DAxis(SILK3DAxisSet axisSet, RectangularAxis inAxis, NumericMapper inMapper) {
        if (inAxis != null && inMapper != null) {
            this.setRectangularAxis(inAxis, inMapper);
        }
        this.axisSet = axisSet;
        this.axisDefaults = new AxisDefaults();
        this.axisLineStyle = new LineAttrib();
        this.labelTextStyle = new TextAttrib(null, (Object)FontManager.getFont((String)this.axisDefaults.labelFontName, (int)this.axisDefaults.labelFontType, (int)16));
        this.labelTextStyle.setFormatSupported(false);
        this.labelTextStyle.setEffectsSupported(false);
        this.labelTextStyle.setJustifySupported(false);
        this.labelTextStyle.addTextListener((TextListenerInterface)this);
        this.valuesTextStyle = new TextAttrib(null, (Object)FontManager.getFont((String)this.axisDefaults.valueFontName, (int)this.axisDefaults.valueFontType, (int)12));
        this.valuesTextStyle.setFormatSupported(false);
        this.valuesTextStyle.setEffectsSupported(false);
        this.valuesTextStyle.setJustifySupported(false);
        this.valuesTextStyle.addTextListener((TextListenerInterface)this);
        this.majorTicksStyle = new LineAttrib();
        this.minorTicksStyle = new LineAttrib();
        this.gridLineStyle = new LineAttrib();
        this.labelFont = this.labelTextStyle.getFont();
        this.valueFont = this.valuesTextStyle.getFont();
        this.tickSpacer = new ContinuousTickSpacer();
        this.redrawListeners = new Vector();
        this.pending = new PropertyList();
    }

    public SILK3DAxis(SILK3DAxisSet axisSet) {
        this(axisSet, null, null);
    }

    public void dispose() {
        this.axis = null;
        this.axisLineStyle = null;
        this.gridLineStyle = null;
        this.majorTicksStyle = null;
        this.minorTicksStyle = null;
        this.labelTextStyle = null;
        this.valuesTextStyle = null;
        this.mapper = null;
        this.tickSpacer = null;
        if (this.redrawListeners != null) {
            this.redrawListeners.removeAllElements();
            this.redrawListeners = null;
        }
        this.low = null;
        this.high = null;
        this.values = null;
        this.pending = null;
        this.axisSet = null;
        this.labelFont = null;
        this.valueFont = null;
        this.axisDefaults = null;
    }

    public void setRectangularAxis(RectangularAxis inAxis, NumericMapper inMapper) {
        if (inAxis == null || inMapper == null) {
            return;
        }
        this.axis = inAxis;
        this.mapper = inMapper;
    }

    public void resetAxis() {
        this.axis = null;
        this.mapper = null;
        this.valuesTextStyle.setFormat(null);
        this.axisSize = 1.0;
        this.rebuildRequired = true;
    }

    public RectangularAxis getAxis() {
        return this.axis;
    }

    public LineStyleInterface getLine() {
        return this.axisLineStyle;
    }

    public boolean setLine(Object line) {
        if (line == null) {
            return false;
        }
        if (line instanceof LineStyleInterface) {
            this.axisLineStyle = new LineAttrib((LineStyleInterface)line);
        } else if (line instanceof Boolean) {
            this.axisLineStyle.setVisible(((Boolean)line).booleanValue());
        } else if (line instanceof Color) {
            this.axisLineStyle.setColor((Object)((Color)line));
        } else if (line instanceof Number) {
            this.axisLineStyle.setWidth(((Number)line).intValue());
        } else {
            return false;
        }
        if (this.axis != null) {
            this.setLineAttributes();
            this.fireRedrawEvent(1);
        }
        return true;
    }

    public TextStyleInterface getLabel() {
        return this.labelTextStyle;
    }

    public boolean setLabel(Object labelIn) {
        if (labelIn == null) {
            return false;
        }
        if (labelIn instanceof TextStyleInterface) {
            this.labelTextStyle = new TextAttrib((TextStyleInterface)labelIn);
        } else if (labelIn instanceof String) {
            this.labelTextStyle.setText(labelIn);
        } else if (labelIn instanceof Boolean) {
            this.labelTextStyle.setVisible(((Boolean)labelIn).booleanValue());
        } else if (labelIn instanceof Color) {
            this.labelTextStyle.setColor((Object)((Color)labelIn));
        } else if (labelIn instanceof Font) {
            this.labelTextStyle.setFont(labelIn);
        } else if (labelIn instanceof SASFormat) {
            this.labelTextStyle.setFormat(labelIn);
        } else {
            return false;
        }
        if (this.axis != null) {
            this.setLabelAttributes();
            this.fireRedrawEvent(1);
        }
        return true;
    }

    public String getLabelString() {
        return this.labelTextStyle.getTextString();
    }

    public TextStyleInterface getValues() {
        return this.valuesTextStyle;
    }

    public boolean setValues(Object valuesIn) {
        if (valuesIn == null) {
            return false;
        }
        if (valuesIn instanceof TextStyleInterface) {
            this.valuesTextStyle = new TextAttrib((TextStyleInterface)valuesIn);
        } else if (valuesIn instanceof String) {
            this.valuesTextStyle.setText(valuesIn);
        } else if (valuesIn instanceof Boolean) {
            this.valuesTextStyle.setVisible(((Boolean)valuesIn).booleanValue());
        } else if (valuesIn instanceof Color) {
            this.valuesTextStyle.setColor((Object)((Color)valuesIn));
        } else if (valuesIn instanceof Font) {
            this.valuesTextStyle.setFont(valuesIn);
        } else if (valuesIn instanceof SASFormat) {
            if (this.mapper != null && (this.mapper instanceof StringToNumericMapper ? !((SASFormat)valuesIn).isCharacterFormat() : ((SASFormat)valuesIn).isCharacterFormat())) {
                return false;
            }
            this.valuesTextStyle.setFormat(valuesIn);
        } else {
            return false;
        }
        if (this.axis != null) {
            this.setValueAttributes();
            this.fireRedrawEvent(1);
        }
        return true;
    }

    public LineStyleInterface getMajorTicks() {
        return this.majorTicksStyle;
    }

    public boolean setMajorTicks(Object ticks) {
        if (ticks == null) {
            return false;
        }
        if (ticks instanceof LineStyleInterface) {
            this.majorTicksStyle = new LineAttrib((LineStyleInterface)ticks);
        } else if (ticks instanceof Boolean) {
            this.majorTicksStyle.setVisible(((Boolean)ticks).booleanValue());
        } else if (ticks instanceof Color) {
            this.majorTicksStyle.setColor((Object)((Color)ticks));
        } else if (ticks instanceof Number) {
            this.majorTicksStyle.setWidth(((Number)ticks).intValue());
        } else {
            return false;
        }
        if (this.axis != null) {
            this.setMajorTickAttributes();
            this.fireRedrawEvent(1);
        }
        return true;
    }

    public LineStyleInterface getMinorTicks() {
        return null;
    }

    public boolean setMinorTicks(Object ticks) {
        if (ticks == null) {
            return false;
        }
        if (ticks instanceof LineStyleInterface) {
            this.minorTicksStyle = new LineAttrib((LineStyleInterface)ticks);
        } else if (ticks instanceof Boolean) {
            this.minorTicksStyle.setVisible(((Boolean)ticks).booleanValue());
        } else if (ticks instanceof Color) {
            this.minorTicksStyle.setColor((Object)((Color)ticks));
        } else if (ticks instanceof Number) {
            this.minorTicksStyle.setWidth(((Number)ticks).intValue());
        } else {
            return false;
        }
        if (this.axis != null) {
            this.setMinorTickAttributes();
            this.fireRedrawEvent(1);
        }
        return true;
    }

    public LineStyleInterface getGridLines() {
        return this.gridLineStyle;
    }

    public boolean setGridLines(Object lines) {
        if (this.gridLineStyle == null || lines == null) {
            return false;
        }
        if (lines instanceof LineStyleInterface) {
            this.gridLineStyle = new LineAttrib((LineStyleInterface)lines);
        } else if (lines instanceof Boolean) {
            this.gridLineStyle.setVisible(((Boolean)lines).booleanValue());
        } else if (lines instanceof Color) {
            this.gridLineStyle.setColor(lines);
        } else if (lines instanceof Number) {
            this.gridLineStyle.setWidth(((Number)lines).intValue());
        }
        if (this.axisSet != null && this.axisSet.setGridLines(this, (LineStyleInterface)this.gridLineStyle)) {
            this.fireRedrawEvent(1);
        }
        return true;
    }

    public boolean setAxis(Object low, Object high, int nMajor, int nMinor, Object[] values, Boolean autoCalculate, Boolean equallySpacedDiscrete) {
        if (low != null && low instanceof Number && !Double.isInfinite(((Number)low).doubleValue()) && !Double.isNaN(((Number)low).doubleValue())) {
            this.low = low;
        }
        if (high != null && high instanceof Number && !Double.isInfinite(((Number)high).doubleValue()) && !Double.isNaN(((Number)high).doubleValue())) {
            this.high = high;
        }
        this.nMajor = nMajor;
        this.nMinor = nMinor;
        if (values != null) {
            this.values = values;
        }
        this.autoCalculate = autoCalculate == null ? true : autoCalculate;
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
        return true;
    }

    public boolean isAxisAutoCalculated() {
        return this.autoCalculate;
    }

    public double[] getEndPoint(boolean high, boolean screen) {
        if (screen) {
            return null;
        }
        if (this.mapper instanceof ContinuousRangeToNumericMapper) {
            ContinuousRangeToNumericMapper crtnm = (ContinuousRangeToNumericMapper)this.mapper;
            return new double[]{crtnm.getInputMin(), crtnm.getInputMax()};
        }
        if (this.mapper instanceof NumericToNumericMapper) {
            if (this.values != null && this.values.length >= 2) {
                double[] endValues = new double[]{((Number)this.values[0]).doubleValue(), ((Number)this.values[this.values.length - 1]).doubleValue()};
                return endValues;
            }
            return null;
        }
        return null;
    }

    public Object[] getTickMarkValues(boolean formatted) {
        return null;
    }

    public int getNumberMajorTicks() {
        if (this.mapper instanceof ContinuousRangeToNumericMapper) {
            return ((ContinuousTimeToNumericMapper)this.mapper).getLabelCount();
        }
        return 0;
    }

    public int getNumberMinorTicks() {
        return this.axis.getStyle().getMinorTickStyle().getMinorTickCount();
    }

    public void setMultiRole(boolean multi) {
    }

    public ReferenceLineInterface addReferenceLine(Object value, String label) {
        return null;
    }

    public boolean removeReferenceLine(Object id, boolean nearest) {
        return false;
    }

    public boolean removeAllReferenceLines() {
        return false;
    }

    public ReferenceLineInterface getReferenceLineByValue(Object value, boolean nearest) {
        return null;
    }

    public ReferenceLineInterface getReferenceLine(int index) {
        return null;
    }

    public int getNumberReferenceLines() {
        return 0;
    }

    public boolean setRangeModel(Object rm) {
        if (rm == null) {
            if (this.rangeModel != null) {
                this.rangeModel.removePropertyChangeListener((PropertyChangeListener)this.axisSet);
            }
            this.rangeModel = null;
            return true;
        }
        if (rm instanceof RangeModel) {
            if (this.rangeModel != null) {
                this.rangeModel.removePropertyChangeListener((PropertyChangeListener)this.axisSet);
            }
            this.rangeModel = (RangeModel)rm;
            this.rangeModel.addPropertyChangeListener((PropertyChangeListener)this.axisSet);
            return true;
        }
        return false;
    }

    public Object getRangeModel(boolean createFlag) {
        if (createFlag && this.rangeModel == null) {
            this.rangeModel = new RangeModel();
            this.rangeModel.addPropertyChangeListener((PropertyChangeListener)this.axisSet);
        }
        return this.rangeModel;
    }

    public int getTimeSplittingPolicy() {
        return 0;
    }

    public void setTimeSplittingPolicy(int policy) {
    }

    public boolean isFixedFormat() {
        return false;
    }

    public void setFixedFormat(boolean fix) {
    }

    public void setThreshold(double thresholdVal) {
    }

    public Object getTransformInfo(int transformType) {
        return null;
    }

    public int getTransformType() {
        return 1;
    }

    public void setTransformType(int type, Object transInfo) {
    }

    protected void fireRedrawEvent(int type) {
        if (!this.fireEvents) {
            return;
        }
        RedrawEvent re = new RedrawEvent((Object)this);
        re.type = type;
        block5: for (int i = 0; i < this.redrawListeners.size(); ++i) {
            RedrawListener rl = (RedrawListener)this.redrawListeners.elementAt(i);
            switch (type) {
                case 1: {
                    rl.redraw(re);
                    continue block5;
                }
                case 2: {
                    rl.boundingBoxChanged(re);
                    continue block5;
                }
                case 3: {
                    rl.outerMarginChanged(re);
                    continue block5;
                }
            }
        }
    }

    public void addRedrawListener(RedrawListener listener) {
        if (!this.redrawListeners.contains(listener)) {
            this.redrawListeners.addElement(listener);
        }
    }

    public void removeRedrawListener(RedrawListener listener) {
        if (this.redrawListeners.contains(listener)) {
            this.redrawListeners.removeElement(listener);
        }
    }

    public void removeAllRedrawListeners() {
        this.redrawListeners.removeAllElements();
    }

    private void setAxisAttributes() {
        if (this.axis == null) {
            return;
        }
        this.axis.setIgnoreFudge(true);
        this.axis.setLabelMargin(0);
        String[] fit = new String[]{"thin"};
        this.axis.setFitAlgorithm(fit);
        this.setLineAttributes();
        this.setLabelAttributes();
        this.setValueAttributes();
        this.setMajorTickAttributes();
        this.setMinorTickAttributes();
    }

    private void setLineAttributes() {
        if (this.axis != null) {
            AxisStyle style = this.axis.getStyle();
            if (this.visible && (!this.valueTooSmall || this.valuesTextStyle.hasUserSetValue(9002))) {
                style.setAxisLineOn(this.axisLineStyle.isVisible());
            } else {
                style.setAxisLineOn(false);
            }
            style.setAxisLineColor(this.axisLineStyle.getColor());
            style.setLineWidth(this.axisLineStyle.getWidth());
        }
    }

    private void setLabelAttributes() {
        if (this.axis != null) {
            TextStyle titleStyle = this.axis.getStyle().getTitleStyle();
            if (!this.constantMapper && this.visible && (!this.labelTooSmall || this.labelTextStyle.hasUserSetValue(9002))) {
                this.axis.getStyle().setTitleOn(this.labelTextStyle.isVisible());
            } else {
                this.axis.getStyle().setTitleOn(false);
            }
            this.axis.title.setValue(this.labelTextStyle.getTextString());
            titleStyle.setColor(this.labelTextStyle.getColor());
            titleStyle.setFont(this.labelTextStyle.getFont());
        }
    }

    private void setValueAttributes() {
        if (this.axis != null) {
            TextStyle labelStyle = this.axis.getStyle().getLabelStyle();
            if (!this.constantMapper && this.visible && (!this.valueTooSmall || this.valuesTextStyle.hasUserSetValue(9002))) {
                this.axis.getStyle().setLabelsOn(this.valuesTextStyle.isVisible());
            } else {
                this.axis.getStyle().setLabelsOn(false);
            }
            this.axis.labelColor.setValue(this.valuesTextStyle.getColor());
            labelStyle.setFont(this.valuesTextStyle.getFont());
            if (this.mapper != null) {
                SASFormat format = (SASFormat)this.valuesTextStyle.getFormat();
                if (format == null) {
                    this.mapper.setFormat(null);
                } else {
                    this.mapper.setFormat(new GTKFormat((Format)format));
                }
            }
        }
    }

    private void setMajorTickAttributes() {
        if (this.axis != null) {
            TickMarkStyle majorStyle = this.axis.getStyle().getMajorTickStyle();
            if (!this.constantMapper && this.visible && (!this.valueTooSmall || this.valuesTextStyle.hasUserSetValue(9002))) {
                this.axis.getStyle().setMajorTickMarksOn(this.majorTicksStyle.isVisible());
            } else {
                this.axis.getStyle().setMajorTickMarksOn(false);
            }
            majorStyle.setColor(this.majorTicksStyle.getColor());
            majorStyle.setLineWidth(this.majorTicksStyle.getWidth());
        }
    }

    private void setMinorTickAttributes() {
        if (this.axis != null) {
            TickMarkStyle minorStyle = this.axis.getStyle().getMinorTickStyle();
            if (!this.constantMapper && this.visible && (!this.valueTooSmall || this.valuesTextStyle.hasUserSetValue(9002))) {
                this.axis.getStyle().setMinorTickMarksOn(this.minorTicksStyle.isVisible());
            } else {
                this.axis.getStyle().setMinorTickMarksOn(false);
            }
            minorStyle.setColor(this.minorTicksStyle.getColor());
            minorStyle.setLineWidth(this.minorTicksStyle.getWidth());
        }
    }

    public boolean create(Object createData) {
        return false;
    }

    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    protected boolean isRebuildRequired(Object buildData) {
        if (this.rebuildRequired) {
            return true;
        }
        return buildData instanceof Boolean && (Boolean)buildData != false;
    }

    public boolean build(Object buildData) {
        if (!this.isRebuildRequired(buildData)) {
            return true;
        }
        if (this.axis == null || this.mapper == null) {
            return false;
        }
        this.setAxisAttributes();
        boolean success = this.setupAxisMapper();
        boolean bl = this.rebuildRequired = !success;
        if (success) {
            this.fireRedrawEvent(1);
        }
        return success;
    }

    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        return this.build(buildData);
    }

    private boolean isDiscrete() {
        return !(this.mapper instanceof ContinuousRangeToNumericMapper);
    }

    public boolean setRange(DataRange range) {
        if (range == null) {
            this.numericRange = null;
            this.discreteRange = null;
            return false;
        }
        if (range instanceof ContinuousRange) {
            this.numericRange = (ContinuousRange)range;
            this.discreteRange = null;
        } else if (range instanceof DiscreteRange) {
            this.numericRange = null;
            this.discreteRange = (DiscreteRange)range;
        }
        if (this.mapper == null) {
            return false;
        }
        this.constantMapper = false;
        if (this.mapper instanceof StringToNumericMapper || this.mapper instanceof NumericToNumericMapper) {
            if (!(range instanceof DiscreteRange)) {
                return false;
            }
            Vector rangeValues = ((DiscreteRange)range).getValues();
            if (rangeValues == null || rangeValues.isEmpty()) {
                this.constantMapper = true;
                this.values = new Object[]{"CONSTANT"};
            } else {
                this.values = rangeValues.toArray();
            }
        } else if (this.mapper instanceof ContinuousRangeToNumericMapper) {
            if (!(range instanceof ContinuousRange)) {
                return false;
            }
            this.low = new Double(((ContinuousRange)range).getMin());
            this.high = new Double(((ContinuousRange)range).getMax());
            this.nMajor = -1;
            this.nMinor = -1;
            this.values = null;
        } else {
            return false;
        }
        this.rebuildRequired = true;
        this.build(null);
        this.fireRedrawEvent(1);
        return true;
    }

    public DataRange getDataRange() {
        if (this.numericRange != null) {
            return this.numericRange;
        }
        return this.discreteRange;
    }

    public DataRange getOutputRange() {
        if (this.numericRange != null) {
            double[] range = this.getEndPoint(false, false);
            if (range != null) {
                ContinuousRange outputRange = new ContinuousRange(range[0], range[1]);
                return outputRange;
            }
            return this.numericRange;
        }
        return this.discreteRange;
    }

    private boolean setupAxisMapper() {
        if (this.mapper == null) {
            return false;
        }
        if (this.mapper instanceof StringToNumericMapper) {
            if (this.values == null || this.values.length == 0) {
                return false;
            }
            String[] list = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                if (!(this.values[i] instanceof String)) {
                    return false;
                }
                list[i] = (String)this.values[i];
            }
            StringVectorVariable svv = new StringVectorVariable();
            svv.connectFrom(list);
            ((StringToNumericMapper)this.mapper).input.connectFrom(svv.value);
            int tickCount = ((StringToNumericMapper)this.mapper).getUniqueValueCount();
            double totalSpace = this.axisSize - this.padding * 2.0;
            double tickSpace = totalSpace / (double)tickCount;
            ((StringToNumericMapper)this.mapper).setStartValue(this.padding + 0.5 * tickSpace);
            ((StringToNumericMapper)this.mapper).setStrideValue(tickSpace);
        } else if (this.mapper instanceof NumericToNumericMapper) {
            if (this.values == null || this.values.length == 0) {
                return false;
            }
            double[] list = new double[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                if (!(this.values[i] instanceof Number)) {
                    return false;
                }
                list[i] = ((Number)this.values[i]).doubleValue();
            }
            NumericVectorVariable nvv = new NumericVectorVariable();
            nvv.connectFrom(list);
            ((NumericToNumericMapper)this.mapper).input.connectFrom(nvv.value);
            int tickCount = ((NumericToNumericMapper)this.mapper).getUniqueValueCount();
            double totalSpace = this.axisSize - this.padding * 2.0;
            double tickSpace = totalSpace / (double)tickCount;
            ((NumericToNumericMapper)this.mapper).setStartValue(this.padding + 0.5 * tickSpace);
            ((NumericToNumericMapper)this.mapper).setStrideValue(tickSpace);
        } else if (this.mapper instanceof ContinuousRangeToNumericMapper) {
            ContinuousRangeToNumericMapper crtnm = (ContinuousRangeToNumericMapper)this.mapper;
            if (this.low == null || !(this.low instanceof Number)) {
                return false;
            }
            double dataMin = ((Number)this.low).doubleValue();
            if (this.high == null || !(this.high instanceof Number)) {
                return false;
            }
            double dataMax = ((Number)this.high).doubleValue();
            if (Double.isNaN(dataMin) || Double.isNaN(dataMax)) {
                return false;
            }
            if (this.nMajor > 0) {
                crtnm.setLabelCount(this.nMajor);
            }
            if (this.nMinor > 0) {
                this.axis.getStyle().getMinorTickStyle().setMinorTickCount(this.nMinor);
            }
            if (this.forceInteger) {
                this.tickSpacer.setDataMin(Math.floor(dataMin));
                this.tickSpacer.setDataMax(Math.ceil(dataMax));
            } else {
                this.tickSpacer.setDataMin(dataMin);
                this.tickSpacer.setDataMax(dataMax);
            }
            if (this.autoCalculate) {
                this.tickSpacer.getPreference().setMaxCalc(0);
                this.tickSpacer.getPreference().setMinCalc(0);
            } else {
                this.tickSpacer.getPreference().setMaxCalc(2);
                this.tickSpacer.getPreference().setMinCalc(2);
            }
            this.tickSpacer.getTickSpacingInfo().setInteger(this.forceInteger);
            this.tickSpacer.getTickSpacingInfo().setMaxTicks(this.maxTicks);
            this.tickSpacer.doTickSpacing();
            double[] tmv = this.tickSpacer.getTickValues();
            double tickMin = tmv[0];
            double tickMax = tmv[tmv.length - 1];
            crtnm.setLabelCount(tmv.length);
            if (tickMin == tickMax) {
                crtnm.setZeroRangeOutput(2);
                crtnm.setLabelCount(1);
            }
            crtnm.setInputMin(tickMin);
            crtnm.setInputMax(tickMax);
            crtnm.setOutputMin(this.padding);
            crtnm.setOutputMax(this.axisSize - this.padding);
        } else {
            return false;
        }
        return true;
    }

    public void setForceIntegerValues(boolean forceInt) {
        if (this.forceInteger == forceInt) {
            return;
        }
        this.forceInteger = forceInt;
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
    }

    public boolean getForceIntegerValues() {
        return this.forceInteger;
    }

    public void setMaxTicks(int numTicks) {
        if (this.maxTicks == numTicks || numTicks < 1) {
            return;
        }
        this.maxTicks = numTicks;
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setFireEvents(boolean b) {
        this.fireEvents = b;
    }

    public boolean getFireEvents() {
        return this.fireEvents;
    }

    protected void setPadding(double pad) {
        if (pad == this.padding) {
            return;
        }
        this.padding = pad;
        this.rebuildRequired = true;
    }

    protected double getPadding() {
        return this.padding;
    }

    protected void setSize(double size) {
        if (size == this.axisSize) {
            return;
        }
        this.axisSize = size;
        this.setRectangularAxisSize(size);
        this.rebuildRequired = true;
    }

    private void setRectangularAxisSize(double size) {
        if (this.axis != null) {
            this.axis.setLength(size);
        }
    }

    public void setDefaultFontSize(int height) {
        Font f;
        int size = 0;
        this.labelTooSmall = false;
        if (!this.labelTextStyle.hasUserSetValue(9002)) {
            size = (int)(0.5 * Math.sqrt(height) * this.axisDefaults.fontSizeAdjust * this.axisDefaults.labelFraction / this.axisDefaults.valueFraction);
            if (size < this.axisDefaults.adjustedLabelSuppressionSize) {
                this.labelTooSmall = true;
            }
            size = Math.max(this.axisDefaults.minAdjustedLabelFontSize, Math.min(this.axisDefaults.maxAdjustedLabelFontSize, size));
            this.labelFont = f = FontManager.getFont((String)this.labelFont.getName(), (int)this.labelFont.getStyle(), (int)size);
            this.labelTextStyle.setFont((Object)f);
            this.labelTextStyle.setCurrentValueAsDefault(9002);
        }
        this.valueTooSmall = false;
        if (!this.valuesTextStyle.hasUserSetValue(9002)) {
            size = (int)(0.5 * Math.sqrt(height) * this.axisDefaults.fontSizeAdjust);
            if (size < this.axisDefaults.adjustedValueSuppressionSize) {
                this.valueTooSmall = true;
            }
            size = Math.max(this.axisDefaults.minAdjustedValueFontSize, Math.min(this.axisDefaults.maxAdjustedValueFontSize, size));
            this.valueFont = f = FontManager.getFont((String)this.valueFont.getName(), (int)this.valueFont.getStyle(), (int)size);
            this.valuesTextStyle.setFont((Object)f);
            this.valuesTextStyle.setCurrentValueAsDefault(9002);
        }
        this.rebuildRequired = true;
    }

    public boolean applyStyle(Style style) {
        if (style == null) {
            return false;
        }
        Color labelColor = style.getTextStyleElement("LabelText").getTextColor();
        Color valueColor = style.getTextStyleElement("ValueText").getTextColor();
        Color axisColor = style.getLineStyleElement("AxisLines").getLineColor();
        Color gridColor = style.getLineStyleElement("GridLines").getLineColor();
        this.labelTextStyle.setColor((Object)labelColor);
        this.labelTextStyle.setCurrentValueAsDefault(9001);
        this.valuesTextStyle.setColor((Object)valueColor);
        this.valuesTextStyle.setCurrentValueAsDefault(9001);
        this.axisLineStyle.setColor((Object)axisColor);
        this.axisLineStyle.setCurrentValueAsDefault(9502);
        this.majorTicksStyle.setColor((Object)axisColor);
        this.majorTicksStyle.setCurrentValueAsDefault(9502);
        this.minorTicksStyle.setColor((Object)axisColor);
        this.minorTicksStyle.setCurrentValueAsDefault(9502);
        this.gridLineStyle.setColor((Object)gridColor);
        this.gridLineStyle.setCurrentValueAsDefault(9502);
        if (this.axisSet != null) {
            this.axisSet.setGridLines(this, (LineStyleInterface)this.gridLineStyle);
        }
        this.setAxisAttributes();
        return true;
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 200: 
            case 201: 
            case 202: {
                this.setLine(value);
                break;
            }
            case 203: 
            case 205: 
            case 206: 
            case 212: {
                this.setLabel(value);
                break;
            }
            case 204: {
                if (value instanceof String) {
                    this.setLabel(value);
                }
                this.isValues = false;
                break;
            }
            case 213: 
            case 215: 
            case 216: 
            case 222: {
                this.setValues(value);
                break;
            }
            case 214: {
                this.isValues = true;
                break;
            }
            case 223: 
            case 224: 
            case 225: {
                this.setMajorTicks(value);
                break;
            }
            case 226: 
            case 227: 
            case 228: {
                this.setMinorTicks(value);
                break;
            }
            case 229: 
            case 230: 
            case 231: {
                this.setGridLines(value);
                break;
            }
            case 237: {
                if (!(value instanceof Boolean)) break;
                this.setVisible((Boolean)value);
                break;
            }
            case 9001: 
            case 9002: {
                if (this.isValues) {
                    this.setValues(value);
                    break;
                }
                this.setLabel(value);
                break;
            }
            case 256: {
                this.setRangeModel(value);
                break;
            }
        }
    }

    public boolean applyPropertyChanges(Object source) {
        Vector changes = this.pending.getChangesBySource(source);
        this.fireEvents = false;
        for (int i = 0; i < changes.size(); ++i) {
            PropertyEvent event = (PropertyEvent)changes.elementAt(i);
            int key = event.id;
            Object value = event.value;
            this.applyChange(key, value);
        }
        this.fireEvents = true;
        if (changes.size() > 0) {
            this.fireRedrawEvent(1);
        }
        this.pending.removeChangesBySource(source);
        return true;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        Object value = null;
        switch (id) {
            case 200: {
                value = new Boolean(this.axisLineStyle.isVisible());
                break;
            }
            case 201: {
                value = this.axisLineStyle.getColor();
                break;
            }
            case 202: {
                value = new Integer(this.axisLineStyle.getWidth());
                break;
            }
            case 203: {
                value = new Boolean(this.labelTextStyle.isVisible());
                break;
            }
            case 204: {
                value = this.labelTextStyle.getTextString();
                break;
            }
            case 205: {
                value = this.labelTextStyle.getColor();
                break;
            }
            case 206: {
                value = this.labelTextStyle.getFont();
                break;
            }
            case 207: {
                value = new Boolean(this.labelTextStyle.areShadowsOn());
                break;
            }
            case 208: {
                value = new Double(this.labelTextStyle.getShadowSoftness());
                break;
            }
            case 209: {
                value = this.labelTextStyle.getShadowColor();
                break;
            }
            case 210: {
                value = new Integer(this.labelTextStyle.getHorizontalJustification());
                break;
            }
            case 211: {
                value = new Integer(this.labelTextStyle.getVerticalJustification());
                break;
            }
            case 212: {
                value = this.labelTextStyle.getFormat();
                break;
            }
            case 213: {
                value = new Boolean(this.valuesTextStyle.isVisible());
                break;
            }
            case 214: {
                value = this.valuesTextStyle.getTextString();
                break;
            }
            case 215: {
                value = this.valuesTextStyle.getColor();
                break;
            }
            case 216: {
                value = this.valuesTextStyle.getFont();
                break;
            }
            case 217: {
                value = new Boolean(this.valuesTextStyle.areShadowsOn());
                break;
            }
            case 218: {
                value = new Double(this.valuesTextStyle.getShadowSoftness());
                break;
            }
            case 219: {
                value = this.valuesTextStyle.getShadowColor();
                break;
            }
            case 220: {
                value = new Integer(this.valuesTextStyle.getHorizontalJustification());
                break;
            }
            case 221: {
                value = new Integer(this.valuesTextStyle.getVerticalJustification());
                break;
            }
            case 222: {
                value = this.valuesTextStyle.getFormat();
                break;
            }
            case 223: {
                value = new Boolean(this.majorTicksStyle.isVisible());
                break;
            }
            case 224: {
                value = this.majorTicksStyle.getColor();
                break;
            }
            case 225: {
                value = new Integer(this.majorTicksStyle.getWidth());
                break;
            }
            case 226: {
                value = new Boolean(this.minorTicksStyle.isVisible());
                break;
            }
            case 227: {
                value = this.minorTicksStyle.getColor();
                break;
            }
            case 228: {
                value = new Integer(this.minorTicksStyle.getWidth());
                break;
            }
            case 229: {
                value = new Boolean(this.gridLineStyle.isVisible());
                break;
            }
            case 230: {
                value = this.gridLineStyle.getColor();
                break;
            }
            case 231: {
                value = new Integer(this.gridLineStyle.getWidth());
                break;
            }
            case 232: {
                double[] endPoint = this.getEndPoint(false, false);
                if (endPoint != null) {
                    value = new Double(endPoint[0]);
                    break;
                }
                value = null;
                break;
            }
            case 233: {
                double[] endPoint = this.getEndPoint(false, false);
                if (endPoint != null) {
                    value = new Double(endPoint[1]);
                    break;
                }
                value = null;
                break;
            }
            case 234: {
                value = null;
                break;
            }
            case 235: {
                value = null;
                break;
            }
            case 236: {
                value = null;
                break;
            }
            case 237: {
                value = new Boolean(this.visible);
                break;
            }
            case 238: {
                value = null;
                break;
            }
            case 239: {
                value = null;
                break;
            }
            case 241: {
                value = new Boolean(this.isDiscrete());
                break;
            }
            case 242: {
                value = null;
                break;
            }
            case 243: {
                value = null;
                break;
            }
            case 9014: {
                value = new Boolean(true);
                break;
            }
            case 9001: {
                if (this.isValues) {
                    value = this.valuesTextStyle.getColor();
                    break;
                }
                value = this.labelTextStyle.getColor();
                break;
            }
            case 9002: {
                if (this.isValues) {
                    value = this.valuesTextStyle.getFont();
                    break;
                }
                value = this.labelTextStyle.getFont();
                break;
            }
            case 256: {
                value = this.getRangeModel(true);
                break;
            }
            case 257: {
                value = Boolean.FALSE;
                break;
            }
            case 249: {
                value = this.labelTextStyle;
                break;
            }
            case 250: {
                value = this.valuesTextStyle;
                break;
            }
            case 265: {
                value = Boolean.FALSE;
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public boolean isPropertySupported(int idx) {
        switch (idx) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 237: 
            case 241: 
            case 249: 
            case 250: 
            case 256: 
            case 257: 
            case 9001: 
            case 9002: 
            case 9014: {
                return true;
            }
        }
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        boolean rc = this.pending.store(id, value);
        return rc;
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = false;
        if (id == 237 && !this.visible) {
            rc = true;
        }
        return rc;
    }

    public void draw(Object p, boolean callHighlightDraw) {
    }

    public void drawHighlight(Object p) {
    }

    public long getMasks() {
        return 0L;
    }

    public Object getOpacityValue() {
        return null;
    }

    public long setMasks(long mask, long bits) {
        return 0L;
    }

    public boolean setOpacityValue(Object newOpacity) {
        return false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean vis) {
        if (this.visible == vis) {
            return;
        }
        this.visible = vis;
        this.setAxisAttributes();
        if (this.visible && this.gridLineStyle.isVisible()) {
            if (this.axisSet != null) {
                this.axisSet.setGridLines(this, (LineStyleInterface)this.gridLineStyle);
            }
        } else if (!this.visible && this.gridLineStyle.isVisible()) {
            LineAttrib tempGridStyle = new LineAttrib((LineStyleInterface)this.gridLineStyle);
            tempGridStyle.setVisible(this.visible);
            if (this.axisSet != null) {
                this.axisSet.setGridLines(this, (LineStyleInterface)tempGridStyle);
            }
        }
        this.fireRedrawEvent(1);
    }

    public void textUpdated(DvrTextEvent evt) {
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
    }
}

