/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.silk3d.util;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.silk.silk3d.SILK3DObject;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Plane;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.gl.CuttingPlane;
import java.awt.Color;

public class ReferencePlane
extends SILK3DObject {
    protected BoundingBox boundingBox;
    protected Style style;
    protected NumericMap xMap;
    protected NumericMap yMap;
    protected NumericMap zMap;
    protected Object xIntercept;
    protected Object yIntercept;
    protected Object zIntercept;

    public ReferencePlane() {
        this.opacity = 0.5;
        this.enableBlend = true;
        this.enableCullFace = false;
    }

    @Override
    public boolean isWireframeSupported() {
        return false;
    }

    @Override
    public boolean isPropertySupported(int id) {
        return false;
    }

    @Override
    public Object getPropertyValue(int id) {
        return null;
    }

    @Override
    public boolean applyStyle(Style style) {
        this.style = style;
        return true;
    }

    @Override
    protected void applyChange(int key, Object value) {
    }

    public void setIntercepts(Object x, Object y, Object z) {
        this.xIntercept = x;
        this.yIntercept = y;
        this.zIntercept = z;
        this.rebuildRequired = true;
    }

    public void setXIntercept(Object intercept) {
        this.xIntercept = intercept;
        this.rebuildRequired = true;
    }

    public Object getXIntercept() {
        return this.xIntercept;
    }

    public void setYIntercept(Object intercept) {
        this.yIntercept = intercept;
        this.rebuildRequired = true;
    }

    public Object getYIntercept() {
        return this.yIntercept;
    }

    public void setZIntercept(Object intercept) {
        this.zIntercept = intercept;
        this.rebuildRequired = true;
    }

    public Object getZIntercept() {
        return this.zIntercept;
    }

    public boolean setBoundingBox(BoundingBox bbox) {
        if (bbox == null) {
            return false;
        }
        BoundingBox newBox = this.transformBBox(bbox);
        if (this.boundingBox != null && this.boundingBox.equals((Object)newBox)) {
            return true;
        }
        this.boundingBox = newBox;
        this.rebuildRequired = true;
        return true;
    }

    private BoundingBox transformBBox(BoundingBox boxIn) {
        BoundingBox boxOut = new BoundingBox(boxIn);
        Vec3d c = boxOut.getCenter();
        Vec3d s = boxOut.getSize();
        boxOut.setCenter(c.y, c.z, c.x);
        boxOut.setSize(s.y, s.z, s.x);
        return boxOut;
    }

    @Override
    public boolean build(Object buildData) {
        if (!this.isRebuildRequired(buildData)) {
            return true;
        }
        this.networkBuilt = this.buildNetwork();
        this.rebuildRequired = !this.networkBuilt;
        return this.networkBuilt;
    }

    private boolean buildNetwork() {
        if (this.root == null || this.boundingBox == null) {
            return false;
        }
        this.root.removeAllElements();
        Plane plane = this.createPlane();
        if (plane == null) {
            return false;
        }
        CuttingPlane cp = new CuttingPlane();
        cp.setPlane(plane);
        cp.setBoundingBox(this.boundingBox);
        FillStyleElement fse = this.style.getStyleElement("Reference").getAsFillStyle();
        Color planeColor = fse.getFillColor();
        int alpha = (int)(this.opacity * 255.0);
        Color c = new Color(planeColor.getRed(), planeColor.getGreen(), planeColor.getBlue(), alpha);
        cp.color.setValue(c);
        cp.edgeColor.setValue(planeColor);
        cp.edgeOn.setValue(true);
        cp.fillOn.setValue(true);
        this.root.addElement((Element)cp);
        return true;
    }

    @Override
    public void setOpacity(double opacityValue) {
        if (this.opacity == opacityValue) {
            return;
        }
        if (opacityValue >= 1.0) {
            this.opacity = 1.0;
            this.enableBlend = false;
        } else {
            this.enableBlend = true;
            this.opacity = opacityValue < 0.0 ? 0.0 : opacityValue;
        }
        this.userSetProperties.set(10302);
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
    }

    public void setRange(byte dimension, DataRange range) {
        if (range == null) {
            return;
        }
        if (range instanceof ContinuousRange) {
            ContinuousRange cr = (ContinuousRange)range;
            if (dimension == 1) {
                this.xRange = new ContinuousRange((DataRange)cr);
            } else if (dimension == 2) {
                this.yRange = new ContinuousRange((DataRange)cr);
            } else if (dimension == 3) {
                this.zRange = new ContinuousRange((DataRange)cr);
            }
        } else if (range instanceof DiscreteRange) {
            DiscreteRange dr = (DiscreteRange)range;
            if (dimension == 1) {
                this.xRange = new DiscreteRange((DataRange)dr);
            } else if (dimension == 2) {
                this.yRange = new DiscreteRange((DataRange)dr);
            } else if (dimension == 3) {
                this.zRange = new DiscreteRange((DataRange)dr);
            }
        }
    }

    @Override
    public NumericMap getMap(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xMap;
            }
            case 2: {
                return this.yMap;
            }
            case 3: {
                return this.zMap;
            }
        }
        return null;
    }

    public void setMap(NumericMap map, byte dimension) {
        switch (dimension) {
            case 1: {
                this.xMap = map;
                break;
            }
            case 2: {
                this.yMap = map;
                break;
            }
            case 3: {
                this.zMap = map;
            }
        }
    }

    private Vec3d transformIntercepts() {
        Vec3d intercepts = new Vec3d();
        try {
            ContinuousRangeToNumericMap cMap;
            StringToNumericMap sMap;
            if (this.xMap != null) {
                if (this.xIntercept == null) {
                    intercepts.z = Double.NaN;
                } else if (this.xMap instanceof StringToNumericMap) {
                    sMap = (StringToNumericMap)this.xMap;
                    if (this.xIntercept instanceof String) {
                        String xVal = this.xIntercept.toString();
                        intercepts.z = sMap.getValue((Object)xVal);
                    } else {
                        intercepts.z = Double.NaN;
                    }
                } else if (this.xMap instanceof ContinuousRangeToNumericMap) {
                    cMap = (ContinuousRangeToNumericMap)this.xMap;
                    if (this.xIntercept instanceof Double) {
                        if (((Double)this.xIntercept).isNaN()) {
                            intercepts.z = Double.NaN;
                        } else {
                            double xVal = (Double)this.xIntercept;
                            intercepts.z = cMap.getValue(xVal);
                        }
                    } else {
                        intercepts.z = Double.NaN;
                    }
                } else {
                    intercepts.z = Double.NaN;
                }
            }
            if (this.yMap != null) {
                if (this.yIntercept == null) {
                    intercepts.x = Double.NaN;
                } else if (this.yMap instanceof StringToNumericMap) {
                    sMap = (StringToNumericMap)this.yMap;
                    if (this.yIntercept instanceof String) {
                        String yVal = this.yIntercept.toString();
                        intercepts.x = sMap.getValue((Object)yVal);
                    } else {
                        intercepts.x = Double.NaN;
                    }
                } else if (this.yMap instanceof ContinuousRangeToNumericMap) {
                    cMap = (ContinuousRangeToNumericMap)this.yMap;
                    if (this.yIntercept instanceof Double) {
                        if (((Double)this.yIntercept).isNaN()) {
                            intercepts.x = Double.NaN;
                        } else {
                            double yVal = (Double)this.yIntercept;
                            intercepts.x = cMap.getValue(yVal);
                        }
                    } else {
                        intercepts.x = Double.NaN;
                    }
                } else {
                    intercepts.x = Double.NaN;
                }
            }
            if (this.zMap != null) {
                if (this.zIntercept == null) {
                    intercepts.y = Double.NaN;
                } else if (this.zMap instanceof StringToNumericMap) {
                    sMap = (StringToNumericMap)this.zMap;
                    if (this.zIntercept instanceof String) {
                        String zVal = this.zIntercept.toString();
                        intercepts.y = sMap.getValue((Object)zVal);
                    } else {
                        intercepts.y = Double.NaN;
                    }
                } else if (this.zMap instanceof ContinuousRangeToNumericMap) {
                    cMap = (ContinuousRangeToNumericMap)this.zMap;
                    if (this.zIntercept instanceof Double) {
                        if (((Double)this.zIntercept).isNaN()) {
                            intercepts.y = Double.NaN;
                        } else {
                            double zVal = (Double)this.zIntercept;
                            intercepts.y = cMap.getValue(zVal);
                        }
                    } else {
                        intercepts.y = Double.NaN;
                    }
                } else {
                    intercepts.y = Double.NaN;
                }
            }
        }
        catch (MissingValueException e) {
            return null;
        }
        return intercepts;
    }

    private Plane createPlane() {
        Vec3d intercepts = this.transformIntercepts();
        if (intercepts == null) {
            return null;
        }
        Vec3d xVec = new Vec3d(1.0, 0.0, 0.0);
        Vec3d yVec = new Vec3d(0.0, 1.0, 0.0);
        Vec3d zVec = new Vec3d(0.0, 0.0, 1.0);
        if (Double.isNaN(intercepts.x)) {
            if (Double.isNaN(intercepts.y)) {
                if (Double.isNaN(intercepts.z)) {
                    return null;
                }
                xVec.z = intercepts.z;
            } else {
                xVec.y = intercepts.y;
            }
        } else {
            xVec.x = intercepts.x;
        }
        if (Double.isNaN(intercepts.y)) {
            if (Double.isNaN(intercepts.x)) {
                yVec.z = intercepts.z;
            } else {
                yVec.x = intercepts.x;
            }
        } else {
            yVec.y = intercepts.y;
        }
        if (Double.isNaN(intercepts.z)) {
            if (Double.isNaN(intercepts.x)) {
                zVec.y = intercepts.y;
            } else {
                zVec.x = intercepts.x;
            }
        } else {
            zVec.z = intercepts.z;
        }
        Plane rc = new Plane(xVec, yVec, zVec);
        return rc;
    }

    @Override
    public void draw() {
        Channel ch = this.root.getChannel();
        if (ch == null || !this.networkBuilt) {
            return;
        }
        ch.glPushAttrib(0);
        ch.glEnable(4);
        ch.glDisable(1);
        if (this.opacity < 1.0) {
            ch.glEnable(12);
        } else {
            ch.glDisable(12);
        }
        this.root.draw();
        ch.glPopAttrib();
    }
}

