/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.silk3d.surface;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.GTKNumericDataFilterVariable;
import com.sas.graphics.silk.interfaces.MarkerStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.silk3d.SILK3DChart;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.SurfacePanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.StyleElementAttrs;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.Plane;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorCache;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.DataGridder;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.TriangleConnectorDetail;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.gtk.gl.TriangleConnector;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class SurfaceObject
extends SILK3DChart {
    private SILKNumber xRole = null;
    private SILKNumber yRole = null;
    private SILKNumber zRole = null;
    private SILKNumber colorRole = null;
    private SILKNumber colorByRole = null;
    private GTKNumericDataFilterVariable xVar = null;
    private GTKNumericDataFilterVariable yVar = null;
    private GTKNumericDataFilterVariable zVar = null;
    private GTKNumericDataFilterVariable colorVar = null;
    private DataGridder dataGridder = null;
    private ContinuousRangeToColorMapper colorMapper = null;
    private String probeFormat = null;
    private ResourceBundle rb = null;
    public static final int[] supportedSurfaceProperties = new int[]{19001, 19003, 19002, 10101, 10102, 24, 25, 23, 433, 426, 434, 441, 19010};

    public SurfaceObject() {
        Roles role = Roles.getInstance(null);
        this.xRole = role.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, (Object)"X", 1);
        this.roles.setRoleType((Object)this.xRole, 1);
        this.yRole = role.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, (Object)"Y", 1);
        this.roles.setRoleType((Object)this.yRole, 1);
        this.zRole = role.getRoleObject("ROLE_Z");
        this.roles.newRole((Object)this.zRole, (Object)"Z", 1);
        this.roles.setRoleType((Object)this.zRole, 1);
        this.colorRole = role.getRoleObject("ROLE_COLOR");
        this.roles.newRole((Object)this.colorRole, (Object)"Color", 1);
        this.roles.setRoleType((Object)this.colorRole, 1);
        this.colorByRole = this.zRole;
        this.fillAttrs = new StyleElementAttrs();
        this.xVar = new GTKNumericDataFilterVariable();
        this.yVar = new GTKNumericDataFilterVariable();
        this.zVar = new GTKNumericDataFilterVariable();
        this.colorVar = new GTKNumericDataFilterVariable();
        this.dataGridder = new DataGridder();
        this.dataGridder.setXVariable((NumericVariable)this.xVar);
        this.dataGridder.setYVariable((NumericVariable)this.yVar);
        this.dataGridder.setZVariable((NumericVariable)this.zVar);
        this.dataGridder.setGriddingAlgorithm(0);
        this.dataGridder.setPreferredGridPlane(Plane.XY);
        this.xMapper = new ContinuousRangeToNumericMapper();
        this.yMapper = new ContinuousRangeToNumericMapper();
        this.zMapper = new ContinuousRangeToNumericMapper();
        this.colorMapper = new ContinuousRangeToColorMapper();
        ((ContinuousRangeToNumericMapper)this.xMapper).input.connectFrom(this.dataGridder.outX);
        ((ContinuousRangeToNumericMapper)this.yMapper).input.connectFrom(this.dataGridder.outY);
        ((ContinuousRangeToNumericMapper)this.zMapper).input.connectFrom(this.dataGridder.outZ);
        this.normalized = true;
        this.wireframeRotate = true;
        this.enableCullFace = false;
        this.setSupportedProperties(supportedSurfaceProperties);
        this.userSetProperties.appendProperties(supportedSurfaceProperties);
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk3d.surface.silk_surface_NLS");
        this.probeFormat = ResourceLoader.getResourceString((Object)this.rb, (String)"SurfaceObject.Probe.fmt.txt", (String)"{0} \t= \t{1}");
    }

    @Override
    public void dispose() {
        super.dispose();
        this.xRole = null;
        this.yRole = null;
        this.zRole = null;
        this.colorRole = null;
        this.colorByRole = null;
        this.xVar = null;
        this.yVar = null;
        this.zVar = null;
        this.dataGridder = null;
        this.colorVar = null;
        this.colorMapper = null;
        if (this.silkColorMapper != null) {
            this.silkColorMapper.unRegister((CellItemInterface)this);
        }
        this.silkColorMapper = null;
    }

    @Override
    public boolean build(Object buildData) {
        if (!this.isRebuildRequired(buildData)) {
            return true;
        }
        this.rebuildRequired = false;
        Object xvar = null;
        Object yvar = null;
        Object zvar = null;
        Object colorvar = null;
        Object colorbyvar = null;
        xvar = this.getObject(this.roles.getVariable((Object)this.xRole));
        yvar = this.getObject(this.roles.getVariable((Object)this.yRole));
        zvar = this.getObject(this.roles.getVariable((Object)this.zRole));
        colorvar = this.getObject(this.roles.getVariable((Object)this.colorRole));
        if (this.colorByRole != null) {
            colorbyvar = this.getObject(this.roles.getVariable((Object)this.colorByRole));
        }
        if (this.dataFilter == null || !this.dataFilter.isNumericVariable(xvar)) {
            xvar = null;
        }
        if (this.dataFilter == null || !this.dataFilter.isNumericVariable(yvar)) {
            yvar = null;
        }
        if (this.dataFilter == null || !this.dataFilter.isNumericVariable(zvar)) {
            zvar = null;
        }
        if (this.dataFilter == null || !this.dataFilter.isNumericVariable(colorvar)) {
            colorvar = null;
        }
        if (this.dataFilter == null || !this.dataFilter.isNumericVariable(colorbyvar)) {
            colorbyvar = null;
        }
        if (this.dataFilter == null || this.dataFilter.getNumberObservations(-1) == 0) {
            this.networkBuilt = false;
            this.errorCode = 2;
        } else if (xvar == null || yvar == null || zvar == null) {
            this.networkBuilt = false;
            this.errorCode = 4;
        } else {
            this.initializeColorMapper();
            this.networkBuilt = this.buildNetwork();
            this.errorCode = 0;
        }
        this.rebuildRequired = !this.networkBuilt;
        return this.networkBuilt;
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        DataRange rc = null;
        switch (dimension) {
            case 4: {
                double colorMin = Double.NaN;
                double colorMax = Double.NaN;
                if (this.areRequiredVariablesSet()) {
                    double min = Double.NaN;
                    double max = Double.NaN;
                    if (this.dataGridder.getResponse2Variable() != null) {
                        min = this.dataGridder.getResponse2Min();
                        max = this.dataGridder.getResponse2Max();
                    } else if (this.colorByRole != null) {
                        int roleInt = this.getRoleInt(this.colorByRole);
                        switch (roleInt) {
                            case 24: {
                                min = this.dataGridder.getXMin();
                                max = this.dataGridder.getXMax();
                                break;
                            }
                            case 25: {
                                min = this.dataGridder.getYMin();
                                max = this.dataGridder.getYMax();
                                break;
                            }
                            case 51: {
                                min = this.dataGridder.getZMin();
                                max = this.dataGridder.getZMax();
                            }
                        }
                    }
                    if (min != Double.NaN && min <= max) {
                        colorMin = min;
                        colorMax = max;
                    }
                }
                rc = new ContinuousRange(colorMin, colorMax);
                break;
            }
            default: {
                rc = super.getDataRange(dimension);
            }
        }
        return rc;
    }

    private void initializeColorMapper() {
        this.initColorRamp();
        double[] breakValues = new double[Double.isNaN(this.silkColorMapper.getNeutralValue()) ? 2 : 3];
        int count = 0;
        breakValues[count++] = this.silkColorMapper.getMinValue();
        if (!Double.isNaN(this.silkColorMapper.getNeutralValue())) {
            breakValues[count++] = this.silkColorMapper.getNeutralValue();
        }
        breakValues[count++] = this.silkColorMapper.getMaxValue();
        Color[] rampClrs = new Color[this.silkColorMapper.getNeutralColor() == null ? 2 : 3];
        count = 0;
        rampClrs[count++] = this.silkColorMapper.getMinColor();
        if (this.silkColorMapper.getNeutralColor() != null) {
            rampClrs[count++] = this.silkColorMapper.getNeutralColor();
        }
        rampClrs[count++] = this.silkColorMapper.getMaxColor();
        int alpha = (int)(this.opacity * 255.0);
        for (int i = 0; i < rampClrs.length; ++i) {
            rampClrs[i] = new Color(rampClrs[i].getRed(), rampClrs[i].getGreen(), rampClrs[i].getBlue(), alpha);
        }
        this.colorMapper.setColorSpectrumValues(breakValues);
        this.colorMapper.setColorSpectrumColors(rampClrs);
        this.colorMapper.setMissingReplacement(this.style.getFillStyleElement("Missing").getFillColor());
        this.colorMapper.setReplaceMissingValues(true);
    }

    protected void initColorVar() {
        Object cvar = this.roles.getVariable((Object)this.colorRole, 0);
        if (cvar != null) {
            this.colorVar.connectFrom(this.dataFilter, cvar.toString());
            this.dataGridder.setResponse2Variable((NumericVariable)this.colorVar);
            this.colorMapper.input.connectFrom(this.dataGridder.outResponse2);
        } else if (this.colorByRole != null) {
            this.colorVar.disconnect();
            this.dataGridder.setResponse2Variable(null);
            int roleInt = this.getRoleInt(this.colorByRole);
            switch (roleInt) {
                case 24: {
                    this.colorMapper.input.connectFrom(this.dataGridder.outX);
                    break;
                }
                case 25: {
                    this.colorMapper.input.connectFrom(this.dataGridder.outY);
                    break;
                }
                case 51: {
                    this.colorMapper.input.connectFrom(this.dataGridder.outZ);
                }
            }
        } else {
            this.colorVar.disconnect();
            this.dataGridder.setResponse2Variable(null);
            this.colorMapper.input.disconnect();
        }
    }

    public boolean buildNetwork() {
        if (this.xVar == null || this.yVar == null || this.zVar == null) {
            return false;
        }
        TriangleConnector triangleConnect = new TriangleConnector();
        triangleConnect.selectDetailEnabled.setValue(true);
        triangleConnect.pointX.connectFrom((NumericPipe)this.yMapper);
        triangleConnect.pointY.connectFrom((NumericPipe)this.zMapper);
        triangleConnect.pointZ.connectFrom((NumericPipe)this.xMapper);
        if (this.colorMapper != null && this.colorMapper.input.isConnected()) {
            ColorCache colorCache = new ColorCache();
            colorCache.input.connectFrom(this.colorMapper.value);
            triangleConnect.color.connectFrom(colorCache.value);
        } else {
            String zId = this.roles.getVariable((Object)this.zRole, 0).toString();
            StyleElement se = SILKUtilities.getStyleElement((String)zId, (int)-1, (int)1, (Style)this.style, (String)this.fillAttrs.getReference(), (StyleElement)this.fillAttrs.getOverrides(false));
            DataStyleElement dse = se.getAsDataStyle();
            Color dataFillColor = dse.getFillColor();
            int alpha = (int)(this.opacity * 255.0);
            Color dataColor = new Color(dataFillColor.getRed(), dataFillColor.getGreen(), dataFillColor.getBlue(), alpha);
            triangleConnect.color.setValue(dataColor);
        }
        triangleConnect.setGridPlane(this.convertGridPlane(this.dataGridder.getGridPlane()));
        triangleConnect.setMajorGridCount(this.dataGridder.getMajorGridCount());
        if (this.drawWireframe) {
            triangleConnect.fillOn.setValue(false);
            triangleConnect.edgeOn.setValue(true);
        } else {
            triangleConnect.fillOn.setValue(true);
            triangleConnect.edgeOn.setValue(false);
        }
        this.root.removeAllElements();
        this.root.addElement((Element)triangleConnect);
        return true;
    }

    private Plane convertGridPlane(Plane planeIn) {
        if (planeIn == Plane.XY) {
            return Plane.ZX;
        }
        if (planeIn == Plane.XZ) {
            return Plane.ZY;
        }
        if (planeIn == Plane.YX) {
            return Plane.XZ;
        }
        if (planeIn == Plane.YZ) {
            return Plane.XY;
        }
        if (planeIn == Plane.ZX) {
            return Plane.YZ;
        }
        if (planeIn == Plane.ZY) {
            return Plane.YX;
        }
        return planeIn;
    }

    @Override
    protected int getRoleInt(Object role) {
        int roleInt = -1;
        if (role != null) {
            if (role instanceof String) {
                String s = (String)role;
                if (s.equalsIgnoreCase("x") || s.equalsIgnoreCase(this.xRole.toString())) {
                    roleInt = this.xRole.intValue();
                } else if (s.equalsIgnoreCase("y") || s.equalsIgnoreCase(this.yRole.toString())) {
                    roleInt = this.yRole.intValue();
                } else if (s.equalsIgnoreCase("z") || s.equalsIgnoreCase(this.zRole.toString())) {
                    roleInt = this.zRole.intValue();
                } else if (s.equalsIgnoreCase("color") || s.equalsIgnoreCase(this.colorRole.toString())) {
                    roleInt = this.colorRole.intValue();
                }
            } else if (role instanceof Number) {
                roleInt = ((Number)role).intValue();
            }
        }
        return roleInt;
    }

    private double[][] getCornerPoints(TriangleConnector connector, int[] corners) {
        if (corners == null) {
            return null;
        }
        int numPts = corners.length;
        double[][] points = new double[numPts][3];
        for (int i = 0; i < numPts; ++i) {
            try {
                points[i][0] = connector.pointX.getValue(corners[i]);
                points[i][1] = connector.pointY.getValue(corners[i]);
                points[i][2] = connector.pointZ.getValue(corners[i]);
                continue;
            }
            catch (MissingValueException e) {
                return null;
            }
        }
        return points;
    }

    public double[] getSurfacePoint(int winX, int winY) {
        SelectResult sr = this.root.selectClosest(winX, winY, 1, 1);
        SelectDetail sd = null;
        double[] surfacePoint = null;
        Element element = null;
        if (sr != null && (element = sr.getElement()) != null && element instanceof TriangleConnector && (sd = sr.getDetail()) != null && sd instanceof TriangleConnectorDetail) {
            int[] corners = new int[4];
            double[][] points = this.getCornerPoints((TriangleConnector)element, corners = ((TriangleConnectorDetail)sd).getCellCorners(corners));
            if (points == null) {
                return null;
            }
            Channel ch = this.root.getChannel();
            double[] nearPoint = new double[3];
            double[] farPoint = new double[3];
            double[] windowPoint = new double[]{winX, winY, 0.0};
            ch.gluUnProject(windowPoint, nearPoint);
            windowPoint[2] = 1.0;
            ch.gluUnProject(windowPoint, farPoint);
            Plane plane = new Plane(points[0][0], points[0][1], points[0][2], points[1][0], points[1][1], points[1][2], points[2][0], points[2][1], points[2][2]);
            Vec3d intersection = plane.getPointOfIntersection(new Vec3d(nearPoint[0], nearPoint[1], nearPoint[2]), new Vec3d(farPoint[0], farPoint[1], farPoint[2]));
            if (intersection == null) {
                return null;
            }
            surfacePoint = new double[]{((ContinuousRangeToNumericMapper)this.xMapper).getInverseValue(intersection.z), ((ContinuousRangeToNumericMapper)this.yMapper).getInverseValue(intersection.x), ((ContinuousRangeToNumericMapper)this.zMapper).getInverseValue(intersection.y)};
        }
        return surfacePoint;
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        return false;
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        if (!this.networkBuilt) {
            return null;
        }
        double[] surfacePoint = this.getSurfacePoint(screenX, screenY);
        if (surfacePoint == null) {
            return null;
        }
        Object xvar = this.roles.getVariable((Object)RoleInterface.ROLE_X, 0);
        Object yvar = this.roles.getVariable((Object)RoleInterface.ROLE_Y, 0);
        Object zvar = this.roles.getVariable((Object)RoleInterface.ROLE_Z, 0);
        Object xlabel = this.dataFilter.getVariableDescription(xvar);
        Object ylabel = this.dataFilter.getVariableDescription(yvar);
        Object zlabel = this.dataFilter.getVariableDescription(zvar);
        String xval = this.dataFilter.getFormattedValue(xvar, (Object)new Double(surfacePoint[0]), null);
        String yval = this.dataFilter.getFormattedValue(yvar, (Object)new Double(surfacePoint[1]), null);
        String zval = this.dataFilter.getFormattedValue(zvar, (Object)new Double(surfacePoint[2]), null);
        Message probeMessage = new Message(this.probeFormat);
        String xTip = probeMessage.toString(xlabel, (Object)xval);
        String yTip = probeMessage.toString(ylabel, (Object)yval);
        String zTip = probeMessage.toString(zlabel, (Object)zval);
        String tip = xTip + "\n" + yTip + "\n" + zTip;
        return tip;
    }

    protected void setRole(RoleEvent e) {
        if (this.dataFilter == null) {
            return;
        }
        switch (e.role) {
            case 24: {
                if (this.dataFilter.isNumericVariable(this.roles.getVariable((Object)this.xRole, 0))) {
                    this.connectVariableToData((Variable)this.xVar, this.roles.getVariable((Object)this.xRole, 0));
                    break;
                }
                this.xVar.disconnect();
                break;
            }
            case 25: {
                if (this.dataFilter.isNumericVariable(this.roles.getVariable((Object)this.yRole, 0))) {
                    this.connectVariableToData((Variable)this.yVar, this.roles.getVariable((Object)this.yRole, 0));
                    break;
                }
                this.yVar.disconnect();
                break;
            }
            case 51: {
                if (this.dataFilter.isNumericVariable(this.roles.getVariable((Object)this.zRole, 0))) {
                    this.connectVariableToData((Variable)this.zVar, this.roles.getVariable((Object)this.zRole, 0));
                    break;
                }
                this.zVar.disconnect();
            }
        }
        this.initColorVar();
        if (e.role == 2 || this.colorByRole != null) {
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
            this.fireLayerListenerChanged(6, this.colorRole);
        }
    }

    protected void removeRole(RoleEvent e) {
        switch (e.role) {
            case 24: {
                this.xVar.disconnect();
                break;
            }
            case 25: {
                this.yVar.disconnect();
                break;
            }
            case 51: {
                this.zVar.disconnect();
                break;
            }
            case 2: {
                this.initColorVar();
            }
        }
        if (e.role == 2 && this.colorByRole != null) {
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
            this.fireLayerListenerChanged(6, this.colorRole);
        }
    }

    @Override
    protected void updateVariables() {
        if (this.xVar != null) {
            this.xVar.setModified(true);
        }
        if (this.yVar != null) {
            this.yVar.setModified(true);
        }
        if (this.zVar != null) {
            this.zVar.setModified(true);
        }
        if (this.colorVar != null) {
            this.colorVar.setModified(true);
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
        }
    }

    @Override
    protected void validateData() {
    }

    @Override
    public double[] getPreferredAxisSize() {
        if (!this.networkBuilt) {
            return null;
        }
        double xSpan = 0.0;
        double ySpan = 0.0;
        double zSpan = 0.0;
        double[] size = new double[]{1.0, 1.0, 1.0};
        if (this.normalized) {
            return size;
        }
        if (!(this.xRange instanceof ContinuousRange)) {
            return size;
        }
        xSpan = ((ContinuousRange)this.xRange).getMax() - ((ContinuousRange)this.xRange).getMin();
        if (!(this.yRange instanceof ContinuousRange)) {
            return size;
        }
        ySpan = ((ContinuousRange)this.yRange).getMax() - ((ContinuousRange)this.yRange).getMin();
        if (!(this.zRange instanceof ContinuousRange)) {
            return size;
        }
        zSpan = ((ContinuousRange)this.zRange).getMax() - ((ContinuousRange)this.zRange).getMin();
        double max = Math.max(xSpan, Math.max(ySpan, zSpan));
        double min = Math.min(xSpan, Math.min(ySpan, zSpan));
        if (min / max < 0.2) {
            size[0] = xSpan * 0.2 / min;
            size[1] = ySpan * 0.2 / min;
            size[2] = zSpan * 0.2 / min;
        } else {
            size[0] = xSpan / max;
            size[1] = ySpan / max;
            size[2] = zSpan / max;
        }
        return size;
    }

    @Override
    protected boolean areRequiredVariablesSet() {
        return this.getObject(this.roles.getVariable((Object)this.xRole)) != null && this.getObject(this.roles.getVariable((Object)this.yRole)) != null && this.getObject(this.roles.getVariable((Object)this.zRole)) != null;
    }

    @Override
    public void setColorBy(Object role) {
        SILKNumber oldColorBy = this.colorByRole;
        int roleInt = this.getRoleInt(role);
        switch (roleInt) {
            case 24: {
                this.colorByRole = this.xRole;
                break;
            }
            case 25: {
                this.colorByRole = this.yRole;
                break;
            }
            case 51: {
                this.colorByRole = this.zRole;
                break;
            }
            default: {
                this.colorByRole = null;
            }
        }
        if (oldColorBy != this.colorByRole) {
            this.initColorVar();
            this.userSetProperties.set(10101);
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
            this.fireLayerListenerChanged(6, this.colorRole);
            this.rebuildRequired = true;
            this.fireRedrawEvent(1);
        }
    }

    @Override
    public SILKNumber getColorBy() {
        return this.colorByRole;
    }

    private boolean isColorMapped() {
        if (this.colorRole == null) {
            return false;
        }
        Object cvar = this.getObject(this.roles.getVariable((Object)this.colorRole));
        return cvar != null;
    }

    @Override
    public boolean isLegendNeeded() {
        if (this.isColorMapped()) {
            return true;
        }
        return this.colorByRole != null;
    }

    protected Object getLegendTitle(SILKNumber currentLegend) {
        if (currentLegend == null || this.dataFilter == null) {
            return null;
        }
        if (this.colorRole.equals((Object)currentLegend)) {
            if (this.isColorMapped()) {
                return this.dataFilter.getVariableDescription(this.roles.getVariable((Object)this.colorRole, 0));
            }
            if (this.colorByRole != null) {
                return this.dataFilter.getVariableDescription(this.roles.getVariable((Object)this.colorByRole, 0));
            }
            return null;
        }
        return null;
    }

    protected Object getLegendEntries(SILKNumber currentLegend) {
        if (currentLegend == null || !this.colorRole.equals((Object)currentLegend)) {
            return null;
        }
        if (this.silkColorMapper == null) {
            this.initColorRamp();
        }
        if (this.silkColorMapper == null) {
            return null;
        }
        Vector<LegendEntry> legendEntries = new Vector<LegendEntry>();
        ContinuousRange r = (ContinuousRange)this.getDataRange((byte)4);
        Color c = this.silkColorMapper.getColor(r.getMin());
        double cv = r.getMin();
        MarkerAttrib msi = new MarkerAttrib(true, c);
        legendEntries.addElement(new LegendEntry((Object)new Double(cv), (MarkerStyleInterface)msi, null));
        c = this.silkColorMapper.getNeutralColor();
        if (c != null && r.contains((DataPoint)new ContinuousPoint(this.silkColorMapper.getNeutralValue()))) {
            cv = this.silkColorMapper.getNeutralValue();
            msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry((Object)new Double(cv), (MarkerStyleInterface)msi, null));
        }
        c = this.silkColorMapper.getColor(r.getMax());
        cv = r.getMax();
        msi = new MarkerAttrib(true, c);
        legendEntries.addElement(new LegendEntry((Object)new Double(cv), (MarkerStyleInterface)msi, null));
        return legendEntries;
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        boolean rc = super.setPropertyValue(id, value);
        switch (id) {
            case 23: {
                if (value == null) break;
                String leg = value.toString();
                if (leg.equalsIgnoreCase(this.colorRole.toString()) || leg.equalsIgnoreCase(this.colorRole.getEnglishName())) {
                    this.currentLegend = this.colorRole;
                    break;
                }
                if (this.colorByRole == null || !leg.equalsIgnoreCase(this.colorByRole.toString()) && !leg.equalsIgnoreCase(this.colorByRole.getEnglishName())) break;
                this.currentLegend = this.colorByRole;
            }
        }
        return rc;
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pending != null && this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        Object value = null;
        Object obj = null;
        switch (id) {
            case 53: {
                value = this.isColorMapped() || this.colorByRole != null ? this.rampName : null;
                break;
            }
            case 10302: {
                value = new Double(this.opacity);
                break;
            }
            case 10101: {
                value = this.colorByRole;
                break;
            }
            case 10102: {
                value = new Boolean(this.isColorMapped());
                break;
            }
            case 19010: {
                value = this.fillAttrs;
                break;
            }
            case 23: {
                value = this.currentLegend;
                break;
            }
            case 434: {
                if (!this.colorRole.equals((Object)this.currentLegend)) break;
                if (this.isColorMapped()) {
                    value = this.roles.getVariable((Object)this.colorRole, 0);
                    break;
                }
                if (this.colorByRole == null) break;
                value = this.roles.getVariable((Object)this.colorByRole, 0);
                break;
            }
            case 24: 
            case 25: {
                if (!this.isLegendNeeded()) break;
                value = this.colorRole;
                break;
            }
            case 433: {
                value = this.getLegendEntries(this.currentLegend);
                break;
            }
            case 426: {
                value = this.getLegendTitle(this.currentLegend);
                break;
            }
            case 441: {
                value = Boolean.TRUE;
                break;
            }
            case 10103: {
                value = this.getVarLabel(this.roles.getVariable((Object)RoleInterface.ROLE_X, 0));
                break;
            }
            case 10105: {
                value = this.getVarLabel(this.roles.getVariable((Object)RoleInterface.ROLE_Y, 0));
                break;
            }
            case 10107: {
                value = this.getVarLabel(this.roles.getVariable((Object)RoleInterface.ROLE_Z, 0));
                break;
            }
            case 10104: {
                obj = this.roles.getVariable((Object)RoleInterface.ROLE_X, 0);
                if (obj == null || this.dataFilter == null) break;
                value = this.dataFilter.getFormat(obj, SASFormat.class);
                break;
            }
            case 10106: {
                obj = this.roles.getVariable((Object)RoleInterface.ROLE_Y, 0);
                if (obj == null || this.dataFilter == null) break;
                value = this.dataFilter.getFormat(obj, SASFormat.class);
                break;
            }
            case 10108: {
                obj = this.roles.getVariable((Object)RoleInterface.ROLE_Z, 0);
                if (obj == null || this.dataFilter == null) break;
                value = this.dataFilter.getFormat(obj, SASFormat.class);
                break;
            }
            case 10109: {
                value = new Object[]{RoleInterface.ROLE_X};
                break;
            }
            case 10110: {
                value = new Object[]{RoleInterface.ROLE_Y};
                break;
            }
            case 10111: {
                value = new Object[]{RoleInterface.ROLE_Z};
                break;
            }
            case 10112: {
                value = "perspective";
                break;
            }
            default: {
                value = super.getPropertyValue(id);
            }
        }
        return value;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 53: {
                if (!(value instanceof String)) break;
                this.setColorRampName(value.toString());
                this.initColorRamp();
                this.initializeColorMapper();
                break;
            }
            case 10302: {
                if (!(value instanceof Number)) break;
                this.setOpacity(((Number)value).doubleValue());
                break;
            }
            case 10101: {
                this.setColorBy(value);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public boolean isWireframeSupported() {
        return true;
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        SurfaceObject pi = this;
        if (listener != null && listener instanceof PropertyInterface) {
            pi = (PropertyInterface)listener;
        }
        if (category == 1 && dialogIn instanceof TabbedPropertiesDialog) {
            TabbedPropertiesDialog tpd = (TabbedPropertiesDialog)dialogIn;
            TabPanelInterface tpi = null;
            tpi = tpd.getTab(SurfacePanel.class);
            if (tpi != null) {
                tpi.addPropertyListener((PropertyInterface)pi);
            } else {
                tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"SurfaceObject.SurfacePanelTitle.txt", (String)"Surface"), (TabPanelInterface)new SurfacePanel(pi));
            }
        } else if (category == 1 && dialogIn instanceof GraphPropertiesDialog) {
            GraphPropertiesDialog gpd = (GraphPropertiesDialog)dialogIn;
            GraphPropertiesDialog.PropertiesTreeNode node = gpd.getRootNode((Object)"Chart", true);
            node.setDisplayName(ResourceLoader.getResourceString((Object)this.rb, (String)"SurfaceObject.SurfacePanelTitle.txt", (String)"Surface"));
            if (node.getPanel() == null) {
                node.setPanel((Component)new SurfacePanel(pi));
            } else if (node.getPanel() instanceof TabPanelInterface) {
                ((TabPanelInterface)node.getPanel()).addPropertyListener((PropertyInterface)pi);
            }
        }
        return true;
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                this.rebuildRequired = true;
                break;
            }
            case 3: {
                this.removeRole(e);
                this.rebuildRequired = true;
            }
        }
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        ContinuousRange cr;
        if (this.dataFilter == null) {
            return null;
        }
        ContinuousRange rc = null;
        DataRange superRange = super.getPreferredRange(which);
        if (!(this.xVar.isConnected() && this.yVar.isConnected() && this.zVar.isConnected())) {
            return superRange;
        }
        if (superRange instanceof ContinuousRange && (Double.isNaN((cr = (ContinuousRange)superRange).getMax()) || Double.isNaN(cr.getMin()))) {
            return superRange;
        }
        Enumeration rolesEnum = Extract.elements((Object)which);
        while (rolesEnum.hasMoreElements()) {
            Object role = rolesEnum.nextElement();
            ContinuousRange cr2 = null;
            if (role == RoleInterface.ROLE_X && this.xVar.isConnected()) {
                cr2 = new ContinuousRange(this.dataGridder.getXMin(), this.dataGridder.getXMax());
            } else if (role == RoleInterface.ROLE_Y && this.yVar.isConnected()) {
                cr2 = new ContinuousRange(this.dataGridder.getYMin(), this.dataGridder.getYMax());
            } else if (role == RoleInterface.ROLE_Z && this.zVar.isConnected()) {
                cr2 = new ContinuousRange(this.dataGridder.getZMin(), this.dataGridder.getZMax());
            }
            if (rc == null) {
                rc = cr2;
                continue;
            }
            if (!(rc instanceof ContinuousRange)) continue;
            rc.union((DataRange)cr2);
        }
        return rc;
    }

    @Override
    public void draw() {
        Channel ch = this.root.getChannel();
        if (ch == null || !this.networkBuilt) {
            return;
        }
        if (!(this.xVar != null && this.xVar.isConnected() && this.yVar != null && this.yVar.isConnected() && this.zVar != null && this.zVar.isConnected())) {
            return;
        }
        ch.glPushAttrib(0);
        ch.glEnable(4);
        ch.glDisable(1);
        if (this.opacity < 1.0) {
            ch.glEnable(12);
        } else {
            ch.glDisable(12);
        }
        this.root.draw();
        ch.glPopAttrib();
    }
}

