/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.silk3d.bar3d;

import com.sas.MissingValues;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.GTKDataFilterSelectionVariable;
import com.sas.graphics.data.GTKNumericDataFilterVariable;
import com.sas.graphics.data.GTKStringDataFilterVariable;
import com.sas.graphics.silk.interfaces.Bar3DPropertyInterface;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.MarkerStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.silk3d.ColorModifier;
import com.sas.graphics.silk.silk3d.SILK3DChart;
import com.sas.graphics.silk.ui.Bar3DPanel;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.StyleElementAttrs;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.Plane;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorCache;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.FrequencyVariable;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.LineConnectorDetail;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.LineConnector;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class Bar3DObject
extends SILK3DChart
implements Bar3DPropertyInterface {
    private SILKNumber categoryRole = null;
    private SILKNumber seriesRole = null;
    private SILKNumber responseRole = null;
    private SILKNumber colorByRole = null;
    private SILKNumber statisticTypeRole = null;
    private Variable categoryVar = null;
    private Variable seriesVar = null;
    private Variable responseVar = null;
    private Variable colorVar = null;
    private ColorMapper colorMapper = null;
    private VariableProcessor vp = null;
    private NumericVariable barHeightVar = null;
    private FrequencyVariable freqVar = null;
    private GTKDataFilterSelectionVariable selectionVar;
    private NumericVariable selectedPercentVar;
    private ResourceBundle rb = null;
    private double cellWidth = 1.0;
    private double barWidth = 0.666666666666;
    private double padding = 0.0;
    private double categoryPadding = 0.0;
    private double seriesPadding = 0.0;
    private double categoryBarSpace = 0.5;
    private double seriesBarSpace = 0.5;
    private double baseline = 0.0;
    private int statType;
    private static final int NUM_STATISTICS = 5;
    public static final int STAT_NONE = 0;
    public static final int STAT_SUM = 1;
    public static final int STAT_MEAN = 2;
    public static final int STAT_FREQUENCY = 3;
    public static final int STAT_PERCENT = 4;
    public static String[] STAT_NAMES = new String[5];
    public static String[] ENGLISH_STAT_NAMES = new String[5];
    public static String[] STAT_SUFFIX_NAMES = new String[5];
    public static int[] STAT_NUMBER_MAPPINGS = new int[5];
    private static SILKNumber[] statTypes = new SILKNumber[5];
    private boolean fillConnect;
    private SILKNumber connectByRole = null;
    private boolean showGradient;
    private String probeFormat = null;
    public static final int[] supportedBarProperties = new int[]{10000, 10001, 10002, 10003, 10004, 10005, 10006, 19001, 19003, 19002, 10101, 10102, 24, 25, 23, 433, 426, 434, 441};
    public static final int[] unsupportedProperties = new int[]{53, 10302, 10300, 10301};

    public Bar3DObject() {
        Roles role = Roles.getInstance(null);
        this.categoryRole = role.getRoleObject("ROLE_CATEGORY");
        this.roles.newRole((Object)this.categoryRole, (Object)"Category", 1);
        this.roles.setRoleType((Object)this.categoryRole, 0);
        this.roles.setDiscrete((Object)this.categoryRole, true);
        this.roles.setSortsSupported((Object)this.categoryRole, new int[]{1, -1, 0});
        this.roles.setSortOrder((Object)this.categoryRole, (Object)RoleInterface.ROLE_SORT_DATA);
        this.seriesRole = role.getRoleObject("ROLE_SERIES");
        this.roles.newRole((Object)this.seriesRole, (Object)"Series", 1);
        this.roles.setRoleType((Object)this.seriesRole, 0);
        this.roles.setDiscrete((Object)this.seriesRole, true);
        this.roles.setSortsSupported((Object)this.seriesRole, new int[]{1, -1, 0});
        this.roles.setSortOrder((Object)this.seriesRole, (Object)RoleInterface.ROLE_SORT_DATA);
        this.responseRole = role.getRoleObject("ROLE_RESPONSE");
        this.roles.newRole((Object)this.responseRole, (Object)"Response", 1);
        this.roles.setRoleType((Object)this.responseRole, 1);
        this.statisticTypeRole = role.getRoleObject("ROLE_STATISTIC_TYPE");
        this.roles.newRole((Object)this.statisticTypeRole, (Object)"StatisticType", 1);
        this.roles.setDiscrete((Object)this.statisticTypeRole, true);
        this.roles.setRoleType((Object)this.statisticTypeRole, 0);
        this.roles.setNonVariableRole((Object)this.statisticTypeRole, true);
        this.fillAttrs = new StyleElementAttrs();
        this.freqVar = new FrequencyVariable();
        this.barHeightVar = this.freqVar;
        this.xMapper = new StringToNumericMapper();
        this.yMapper = new StringToNumericMapper();
        this.zMapper = new ContinuousRangeToNumericMapper();
        this.connectMapperToVariable(this.zMapper, (Variable)this.freqVar);
        this.connectMapperToVariable(this.xMapper, null);
        this.vp = new VariableProcessor();
        this.selectionVar = new GTKDataFilterSelectionVariable();
        this.statType = 3;
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk3d.bar3d.silk_bar3d_NLS");
        this.probeFormat = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DObject.Probe.fmt.txt", (String)"{0} \t= \t{1}");
        Bar3DObject.STAT_NAMES[0] = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DObject.None.txt", (String)"None");
        Bar3DObject.STAT_NAMES[1] = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DObject.Sum.txt", (String)"Sum");
        Bar3DObject.STAT_NAMES[2] = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DObject.Mean.txt", (String)"Mean");
        Bar3DObject.STAT_NAMES[3] = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DObject.Frequency.txt", (String)"Frequency");
        Bar3DObject.STAT_NAMES[4] = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DObject.Percent.txt", (String)"Percent");
        Bar3DObject.ENGLISH_STAT_NAMES[0] = "None";
        Bar3DObject.ENGLISH_STAT_NAMES[1] = "Sum";
        Bar3DObject.ENGLISH_STAT_NAMES[2] = "Mean";
        Bar3DObject.ENGLISH_STAT_NAMES[3] = "Frequency";
        Bar3DObject.ENGLISH_STAT_NAMES[4] = "Percent";
        Bar3DObject.STAT_SUFFIX_NAMES[0] = "";
        Bar3DObject.STAT_SUFFIX_NAMES[1] = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DObject.Suffix.Sum.txt", (String)"(Sum)");
        Bar3DObject.STAT_SUFFIX_NAMES[2] = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DObject.Suffix.Mean.txt", (String)"(Mean)");
        Bar3DObject.STAT_SUFFIX_NAMES[3] = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DObject.Suffix.Frequency.txt", (String)"(Frequency)");
        Bar3DObject.STAT_SUFFIX_NAMES[4] = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DObject.Suffix.Percent.txt", (String)"(Percent)");
        Bar3DObject.STAT_NUMBER_MAPPINGS[0] = -1;
        Bar3DObject.STAT_NUMBER_MAPPINGS[1] = 1;
        Bar3DObject.STAT_NUMBER_MAPPINGS[2] = 2;
        Bar3DObject.STAT_NUMBER_MAPPINGS[3] = 12;
        Bar3DObject.STAT_NUMBER_MAPPINGS[4] = 11;
        Bar3DObject.statTypes[0] = new SILKNumber(0, STAT_NAMES[0], ENGLISH_STAT_NAMES[0]);
        Bar3DObject.statTypes[1] = new SILKNumber(1, STAT_NAMES[1], ENGLISH_STAT_NAMES[1]);
        Bar3DObject.statTypes[2] = new SILKNumber(2, STAT_NAMES[2], ENGLISH_STAT_NAMES[2]);
        Bar3DObject.statTypes[3] = new SILKNumber(12, STAT_NAMES[3], ENGLISH_STAT_NAMES[3]);
        Bar3DObject.statTypes[4] = new SILKNumber(11, STAT_NAMES[4], ENGLISH_STAT_NAMES[4]);
        this.roles.setRole((Object)statTypes[3], (Object)this.statisticTypeRole);
        this.fillConnect = true;
        this.showGradient = true;
        this.setSupportedProperties(supportedBarProperties);
        this.removePropertySupport(unsupportedProperties);
        this.userSetProperties.appendProperties(supportedBarProperties);
        Bar3DObject.statTypes[1] = new SILKNumber(1, STAT_NAMES[1], ENGLISH_STAT_NAMES[1]);
        Bar3DObject.statTypes[2] = new SILKNumber(2, STAT_NAMES[2], ENGLISH_STAT_NAMES[2]);
        Bar3DObject.statTypes[3] = new SILKNumber(12, STAT_NAMES[3], ENGLISH_STAT_NAMES[3]);
        Bar3DObject.statTypes[4] = new SILKNumber(11, STAT_NAMES[4], ENGLISH_STAT_NAMES[4]);
        this.roles.setRole((Object)statTypes[3], (Object)this.statisticTypeRole);
        this.fillConnect = true;
        this.showGradient = true;
        this.userSetProperties.appendProperties(supportedBarProperties);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.categoryRole = null;
        this.seriesRole = null;
        this.responseRole = null;
        this.colorByRole = null;
        this.connectByRole = null;
        this.statisticTypeRole = null;
        this.categoryVar = null;
        this.seriesVar = null;
        this.responseVar = null;
        this.colorVar = null;
        this.colorMapper = null;
        this.vp = null;
        this.barHeightVar = null;
        this.freqVar = null;
        this.selectionVar = null;
        this.selectedPercentVar = null;
        this.rb = null;
    }

    public boolean hasSeriesVariable() {
        return this.seriesVar != null;
    }

    protected void setSortOrder(RoleEvent e) {
        if (this.dataFilter == null) {
            return;
        }
        switch (e.role) {
            case 1: {
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 4, null, 2));
                break;
            }
            case 58: {
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 4, null, 1));
            }
        }
    }

    protected void setRole(RoleEvent e) {
        if (this.dataFilter == null) {
            return;
        }
        switch (e.role) {
            case 1: {
                this.disconnectMapper(this.yMapper);
                if (this.categoryVar != null) {
                    this.categoryVar.disconnect();
                }
                this.categoryVar = this.dataFilter.isNumericVariable(this.roles.getVariable((Object)this.categoryRole, 0)) ? new GTKNumericDataFilterVariable() : new GTKStringDataFilterVariable();
                this.connectVariableToData(this.categoryVar, this.roles.getVariable((Object)this.categoryRole, 0));
                this.connectMapperToVariable(this.yMapper, this.categoryVar);
                this.calculateStatistics();
                break;
            }
            case 58: {
                this.disconnectMapper(this.xMapper);
                if (this.seriesVar != null) {
                    this.seriesVar.disconnect();
                }
                this.seriesVar = this.dataFilter.isNumericVariable(this.roles.getVariable((Object)this.seriesRole, 0)) ? new GTKNumericDataFilterVariable() : new GTKStringDataFilterVariable();
                this.connectVariableToData(this.seriesVar, this.roles.getVariable((Object)this.seriesRole, 0));
                this.connectMapperToVariable(this.xMapper, this.seriesVar);
                this.calculateStatistics();
                break;
            }
            case 17: {
                if (!this.dataFilter.isNumericVariable(this.roles.getVariable((Object)this.responseRole, 0))) break;
                if (this.roles.getVariable((Object)this.responseRole, 0) == null && (this.statType == 1 || this.statType == 2)) {
                    this.statType = 3;
                    this.roles.setRole((Object)statTypes[3], (Object)this.statisticTypeRole);
                } else if (this.statType == 3 || this.statType == 4) {
                    this.statType = 1;
                    this.roles.setRole((Object)statTypes[1], (Object)this.statisticTypeRole);
                }
                this.disconnectMapper(this.zMapper);
                if (this.responseVar != null) {
                    this.responseVar.disconnect();
                }
                this.responseVar = new GTKNumericDataFilterVariable();
                this.connectVariableToData(this.responseVar, this.roles.getVariable((Object)this.responseRole, 0));
                this.disconnectMapper(this.zMapper);
                this.connectMapperToVariable(this.zMapper, this.responseVar);
                this.calculateStatistics();
                break;
            }
            case 38: {
                Object var = this.roles.getVariable((Object)this.statisticTypeRole, 0);
                this.setStatisticFromRole(var);
                if (!(var instanceof SILKNumber)) {
                    this.roles.setRole((Object)this.getStatistic(), (Object)this.statisticTypeRole);
                }
                this.calculateStatistics();
            }
        }
    }

    protected void removeRole(RoleEvent e) {
        switch (e.role) {
            case 1: {
                this.disconnectMapper(this.yMapper);
                if (this.categoryVar != null) {
                    this.categoryVar.disconnect();
                }
                this.categoryVar = null;
                this.vp.removeAllVariables();
                break;
            }
            case 58: {
                this.disconnectMapper(this.xMapper);
                this.connectMapperToVariable(this.xMapper, null);
                if (this.seriesVar != null) {
                    this.seriesVar.disconnect();
                }
                this.seriesVar = null;
                this.calculateStatistics();
                break;
            }
            case 17: {
                if (this.roles.getVariable((Object)this.responseRole, 0) == null && (this.statType == 1 || this.statType == 2)) {
                    this.statType = 3;
                    this.roles.setRole((Object)statTypes[3], (Object)this.statisticTypeRole);
                } else if (this.statType == 3 || this.statType == 4) {
                    this.statType = 1;
                    this.roles.setRole((Object)statTypes[1], (Object)this.statisticTypeRole);
                }
                this.disconnectMapper(this.zMapper);
                this.connectMapperToVariable(this.zMapper, (Variable)this.freqVar);
                if (this.responseVar != null) {
                    this.responseVar.disconnect();
                }
                this.responseVar = null;
                this.calculateStatistics();
            }
        }
    }

    @Override
    protected void updateVariables() {
        if (this.categoryVar != null) {
            this.categoryVar.setModified(true);
        }
        if (this.seriesVar != null) {
            this.seriesVar.setModified(true);
        }
        if (this.responseVar != null) {
            this.responseVar.setModified(true);
        }
        if (this.selectionVar != null) {
            this.selectionVar.setModified(true);
        }
        if (this.freqVar != null) {
            this.freqVar.setModified(true);
        }
        if (this.colorVar != null) {
            this.colorVar.setModified(true);
        }
        if (this.selectedPercentVar != null) {
            this.selectedPercentVar.setModified(true);
        }
    }

    @Override
    protected void validateData() {
    }

    @Override
    public boolean build(Object buildData) {
        if (this.dataFilter == null) {
            return false;
        }
        if (!this.isRebuildRequired(buildData)) {
            return true;
        }
        this.rebuildRequired = false;
        this.networkBuilt = false;
        Object cvar = null;
        cvar = this.getObject(this.roles.getVariable((Object)this.categoryRole));
        if (this.dataFilter.getNumberObservations(-1) == 0) {
            this.networkBuilt = false;
            this.errorCode = 2;
        } else if (cvar == null) {
            this.networkBuilt = false;
            this.errorCode = 4;
        } else {
            this.initializeColorBy();
            this.networkBuilt = this.buildNetwork();
            this.errorCode = 0;
        }
        this.rebuildRequired = !this.networkBuilt;
        return this.networkBuilt;
    }

    public boolean buildNetwork() {
        if (this.xMapper == null || this.yMapper == null || this.zMapper == null) {
            return false;
        }
        this.root.removeAllElements();
        if (this.connectByRole != null) {
            LineConnector wall = this.createWallElement();
            this.root.addElement((Element)wall);
        } else {
            Bar bar = this.createBarElement();
            this.root.addElement((Element)bar);
        }
        return true;
    }

    private Bar createBarElement() {
        Bar bar = new Bar();
        if (this.drawWireframe) {
            bar.edgeOn.setValue(true);
            bar.fillOn.setValue(false);
        } else {
            bar.edgeOn.setValue(false);
            bar.fillOn.setValue(true);
        }
        bar.setTwoD(false);
        bar.thickness.setValue(this.cellWidth * this.barWidth);
        bar.startValue.setValue(((ContinuousRangeToNumericMapper)this.zMapper).getValue(this.baseline));
        String catId = this.roles.getVariable((Object)this.categoryRole, 0).toString();
        StyleElement se = SILKUtilities.getStyleElement((String)catId, (int)-1, (int)1, (Style)this.style, (String)this.fillAttrs.getReference(), (StyleElement)this.fillAttrs.getOverrides(false));
        DataStyleElement dse = se.getAsDataStyle();
        Color barColor = dse.getFillColor();
        Color selectionColor = this.style.getFillStyleElement("Selection").getFillColor();
        bar.gradientOn.setValue(this.showGradient);
        bar.gradientDirection.setValue(1);
        if (this.colorMapper != null) {
            ColorCache colorCache = new ColorCache();
            colorCache.input.connectFrom(this.colorMapper.value);
            if (this.showGradient) {
                ColorCache brighterColorCache = new ColorCache();
                brighterColorCache.input.connectFrom((ColorPipe)new ColorModifier(colorCache.value, ColorModifier.COLOR_BRIGHTER, 0.2));
                bar.color1.connectFrom(brighterColorCache.value);
                bar.color2.connectFrom(colorCache.value);
            } else {
                bar.color1.connectFrom(colorCache.value);
            }
            bar.edgeColor.connectFrom(colorCache.value);
        } else {
            if (this.showGradient) {
                bar.color1.setValue(ColorUtilities.brighter((Color)barColor, (double)0.2));
                bar.color2.setValue(barColor);
            } else {
                bar.color1.setValue(barColor);
            }
            bar.edgeColor.setValue(barColor);
        }
        bar.highlightFillColor.setValue(selectionColor);
        bar.highlightOn.connectFrom(this.selectionVar.value);
        bar.highlightPercentage.connectFrom(this.selectedPercentVar.value);
        bar.endValue.connectFrom((NumericPipe)this.zMapper);
        bar.transform.translateX.connectFrom((NumericPipe)this.yMapper);
        bar.transform.translateZ.connectFrom((NumericPipe)this.xMapper);
        return bar;
    }

    private LineConnector createWallElement() {
        LineConnector wall = new LineConnector();
        wall.setMultipleGroup(true);
        if (this.fillConnect) {
            wall.lineOn.setValue(false);
            wall.fillOn.setValue(true);
        } else {
            wall.lineOn.setValue(true);
            wall.fillOn.setValue(false);
        }
        Plane floor = new Plane(Plane.XZ);
        floor.setDistance(((ContinuousRangeToNumericMapper)this.zMapper).getValue(this.baseline));
        wall.setFillToPlane(Plane.XZ);
        String catId = this.roles.getVariable((Object)this.categoryRole, 0).toString();
        StyleElement se = SILKUtilities.getStyleElement((String)catId, (int)-1, (int)1, (Style)this.style, (String)this.fillAttrs.getReference(), (StyleElement)this.fillAttrs.getOverrides(false));
        DataStyleElement dse = se.getAsDataStyle();
        Color wallColor = dse.getFillColor();
        Color selectionColor = this.style.getFillStyleElement("Selection").getFillColor();
        if (this.colorMapper != null) {
            wall.color.connectFrom(this.colorMapper.value);
            wall.fillColor.connectFrom(this.colorMapper.value);
        } else {
            wall.color.setValue(wallColor);
            wall.fillColor.setValue(wallColor);
        }
        wall.highlightColor.setValue(selectionColor);
        wall.highlightOn.connectFrom(this.selectionVar.value);
        wall.pointX.connectFrom((NumericPipe)this.yMapper);
        wall.pointY.connectFrom((NumericPipe)this.zMapper);
        wall.pointZ.connectFrom((NumericPipe)this.xMapper);
        Variable connectVar = null;
        int connectionOrder = -1;
        Vec3d depthVec = null;
        if (this.connectByRole == this.categoryRole) {
            connectVar = this.categoryVar;
            connectionOrder = 3;
            depthVec = new Vec3d(this.cellWidth * this.barWidth, 0.0, 0.0);
        } else {
            connectVar = this.seriesVar;
            connectionOrder = 1;
            depthVec = new Vec3d(0.0, 0.0, this.cellWidth * this.barWidth);
        }
        if (connectVar != null) {
            if (connectVar instanceof NumericVariable) {
                wall.numericGroup.connectFrom(((NumericVariable)connectVar).value);
            } else {
                wall.stringGroup.connectFrom(((StringVariable)connectVar).value);
            }
        }
        wall.setConnectionOrder(connectionOrder);
        wall.setDepth(depthVec);
        wall.setSkipMissingOn(true);
        return wall;
    }

    private void calculateStatistics() {
        this.vp.removeAllVariables();
        this.vp.setWhereExpression(null);
        if (this.categoryVar != null) {
            this.vp.addGroupVariable(this.categoryVar);
        }
        if (this.seriesVar != null) {
            this.vp.addGroupVariable(this.seriesVar);
        }
        if (this.responseVar != null) {
            this.barHeightVar = (NumericVariable)this.responseVar;
            this.setGTKStatistic((Variable)this.barHeightVar, this.statType);
            this.vp.setWhereExpression("^" + this.responseVar.getName() + " is missing");
        } else {
            this.barHeightVar = this.freqVar;
            if (this.statType == 1 || this.statType == 2 || this.statType == 3) {
                SASFormat format = SASFormat.getInstance((String)"Best8.0");
                this.barHeightVar.setFormat(new GTKFormat((Format)format));
                this.vp.addVariable((Variable)this.barHeightVar, 2);
            } else if (this.statType == 4) {
                this.barHeightVar.setFormat((GTKFormat)new MultiplierFormat());
                this.vp.addVariable((Variable)this.barHeightVar, 3);
            }
        }
        if (this.selectionVar != null) {
            this.vp.setSelectionVariable((NumericVariable)this.selectionVar);
        }
        this.selectedPercentVar = this.vp.newSelectedPercentageVariable();
    }

    private void setGTKStatistic(Variable var, int stat) {
        switch (stat) {
            case 3: {
                this.vp.addVariable(var, 2);
                break;
            }
            case 1: {
                this.vp.addVariable(var, 6);
                break;
            }
            case 2: {
                this.vp.addVariable(var, 1);
                break;
            }
            case 4: {
                this.vp.addVariable(var, 3);
                break;
            }
        }
    }

    private void setStatisticFromRole(Object stat) {
        int typeInt = -1;
        for (int i = 0; i < statTypes.length; ++i) {
            if (!statTypes[i].equals(stat)) continue;
            typeInt = i;
            break;
        }
        switch (typeInt) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.statType = typeInt;
            }
        }
    }

    public void setStatistic(Object type) {
        if (type == null) {
            return;
        }
        SILKNumber st = null;
        if (type instanceof Number) {
            int typeInt = ((Number)type).intValue();
            switch (typeInt) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    st = statTypes[typeInt];
                }
            }
        } else if (type instanceof String) {
            for (int i = 0; i < statTypes.length; ++i) {
                if (!statTypes[i].equals(type)) continue;
                st = statTypes[i];
                break;
            }
        }
        if (st != null) {
            this.roles.setRole((Object)st, (Object)this.statisticTypeRole);
        }
    }

    public SILKNumber getStatistic() {
        return statTypes[this.statType];
    }

    public Object[] getBarValues(int winX, int winY, boolean formatted) {
        Element element;
        SelectResult sr = this.root.selectClosest(winX, winY, 1, 1);
        Object[] barValues = null;
        if (sr != null && (element = sr.getElement()) != null) {
            MissingValues missing;
            int index = sr.getValueIndex();
            barValues = new Object[3];
            try {
                barValues[0] = this.categoryVar instanceof StringVariable ? (formatted ? ((StringVariable)this.categoryVar).formattedValue.getValue(index) : ((StringVariable)this.categoryVar).value.getValue(index)) : (formatted ? ((NumericVariable)this.categoryVar).formattedValue.getValue(index) : new Double(((NumericVariable)this.categoryVar).value.getValue(index)));
            }
            catch (MissingValueException mve) {
                missing = mve.getMissingValue();
                barValues[0] = this.yMapper.getMissingValueLabel(missing);
            }
            try {
                barValues[1] = this.seriesVar != null ? (this.seriesVar instanceof StringVariable ? (formatted ? ((StringVariable)this.seriesVar).formattedValue.getValue(index) : ((StringVariable)this.seriesVar).value.getValue(index)) : (formatted ? ((NumericVariable)this.seriesVar).formattedValue.getValue(index) : new Double(((NumericVariable)this.seriesVar).value.getValue(index)))) : null;
            }
            catch (MissingValueException mve) {
                missing = mve.getMissingValue();
                barValues[1] = this.xMapper.getMissingValueLabel(missing);
            }
            try {
                if (formatted) {
                    if (this.statType == 4) {
                        SASFormat format = SASFormat.getInstance((String)"Percent8.2");
                        Double value = new Double(this.barHeightVar.value.getValue(index));
                        barValues[2] = format.format((Object)value);
                    } else {
                        barValues[2] = this.barHeightVar.formattedValue.getValue(index);
                    }
                } else {
                    barValues[2] = new Double(this.barHeightVar.value.getValue(index));
                }
            }
            catch (MissingValueException mve) {
                missing = mve.getMissingValue();
                barValues[2] = this.zMapper.getMissingValueLabel(missing);
            }
        }
        return barValues;
    }

    public List getBarIndices(int winX, int winY) {
        Element element;
        SelectResult sr = this.root.selectClosest(winX, winY, 1, 1);
        if (sr != null && (element = sr.getElement()) != null) {
            if (element instanceof Bar) {
                return this.vp.getIndicesPriorToProcessing(sr.getValueIndex());
            }
            if (element instanceof LineConnector) {
                LineConnectorDetail details = (LineConnectorDetail)sr.getDetail();
                Vector selectionList = new Vector();
                for (int i = 0; i < details.getGroupValueIndexCount(); ++i) {
                    selectionList.addAll(this.vp.getIndicesPriorToProcessing(details.getGroupValueIndexAt(i)));
                }
                return selectionList;
            }
            return null;
        }
        return null;
    }

    public List getBarIndices(Rectangle r) {
        if (r == null || r.isEmpty()) {
            return null;
        }
        Vector selections = this.root.select(r.x, r.y, r.width, r.height, true, true);
        if (selections == null || selections.isEmpty()) {
            return null;
        }
        Vector selectList = new Vector();
        for (int i = 0; i < selections.size(); ++i) {
            Element element;
            SelectResult sr = (SelectResult)selections.elementAt(i);
            if (sr == null || (element = sr.getElement()) == null) continue;
            if (element instanceof Bar) {
                selectList.addAll(this.vp.getIndicesPriorToProcessing(sr.getValueIndex()));
                continue;
            }
            if (!(element instanceof LineConnector)) continue;
            LineConnectorDetail details = (LineConnectorDetail)sr.getDetail();
            for (int j = 0; j < details.getGroupValueIndexCount(); ++j) {
                selectList.addAll(this.vp.getIndicesPriorToProcessing(details.getGroupValueIndexAt(j)));
            }
        }
        return selectList;
    }

    public List getVariableObservations(int axis, int index) {
        switch (axis) {
            case 0: {
                return this.getVariableObservations(this.seriesVar, index);
            }
            case 1: {
                return this.getVariableObservations(this.categoryVar, index);
            }
        }
        return null;
    }

    public List getVariableObservations(Variable var, int index) {
        if (var == null) {
            return null;
        }
        Object varValue = null;
        try {
            if (var instanceof NumericVariable) {
                varValue = new Double(((NumericVariable)var).uniqueValue.getValue(index));
            } else if (var instanceof StringVariable) {
                varValue = ((StringVariable)var).uniqueValue.getValue(index);
            }
        }
        catch (MissingValueException e) {
            return null;
        }
        Vector<Integer> indices = new Vector<Integer>();
        for (int i = 0; i < this.dataFilter.getNumberObservations(null); ++i) {
            Object dataValue = this.dataFilter.getValue((Object)var.getName(), (long)i);
            if (!dataValue.equals(varValue)) continue;
            indices.add(new Integer(i));
        }
        return indices;
    }

    public void selectBars(Object selectIndecies, boolean toggle) {
        if (!toggle) {
            this.dataFilter.unselectAll();
        }
        if (selectIndecies == null) {
            return;
        }
        if (selectIndecies instanceof Integer) {
            int index = (Integer)selectIndecies;
            if (index >= 0) {
                boolean selected = this.dataFilter.isSelected((long)index);
                if (selected) {
                    this.dataFilter.setSelected((long)index, false);
                } else {
                    this.dataFilter.setSelected((long)index, true);
                }
            }
        } else if (selectIndecies instanceof List) {
            List selectList = (List)selectIndecies;
            Vector selectVec = new Vector();
            Vector unselectVec = new Vector();
            for (int i = 0; i < selectList.size(); ++i) {
                Object dataIndex = selectList.get(i);
                if (dataIndex == null || !(dataIndex instanceof Integer)) continue;
                if (this.dataFilter.isSelected((long)((Integer)dataIndex).intValue())) {
                    unselectVec.add(dataIndex);
                    continue;
                }
                selectVec.add(dataIndex);
            }
            if (!selectVec.isEmpty()) {
                this.dataFilter.setSelected(selectVec, true);
            }
            if (!unselectVec.isEmpty()) {
                this.dataFilter.setSelected(unselectVec, false);
            }
        }
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        boolean extSel;
        Rectangle selectArea = null;
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        selectArea = (Rectangle)selectRegion;
        boolean bl = extSel = (event.getModifiers() & 2) != 0;
        if (selectArea.isEmpty()) {
            List barIndices = this.getBarIndices(selectArea.x, selectArea.y);
            this.selectBars(barIndices, extSel);
        } else {
            List barIndices = this.getBarIndices(selectArea);
            this.selectBars(barIndices, false);
        }
        return true;
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        Object rvar;
        Object svar;
        if (!this.networkBuilt) {
            return null;
        }
        Object[] values = this.getBarValues(screenX, screenY, true);
        if (values == null) {
            return null;
        }
        String catLabel = "";
        String serLabel = "";
        String resLabel = "";
        Object cvar = this.roles.getVariable((Object)RoleInterface.ROLE_CATEGORY, 0);
        if (cvar != null) {
            catLabel = (String)this.dataFilter.getVariableDescription(cvar);
        }
        if ((svar = this.roles.getVariable((Object)RoleInterface.ROLE_SERIES, 0)) != null) {
            serLabel = (String)this.dataFilter.getVariableDescription(svar);
        }
        resLabel = (rvar = this.roles.getVariable((Object)RoleInterface.ROLE_RESPONSE, 0)) == null ? (this.statType == 4 ? STAT_NAMES[4] : STAT_NAMES[3]) : (String)this.dataFilter.getVariableDescription(rvar) + " " + STAT_SUFFIX_NAMES[this.statType];
        Message probeMessage = new Message(this.probeFormat);
        String catTip = probeMessage.toString((Object)catLabel, values[0]);
        String serTip = probeMessage.toString((Object)serLabel, values[1]);
        String resTip = probeMessage.toString((Object)resLabel, values[2]);
        String tip = svar != null ? catTip + "\n" + serTip + "\n" + resTip : catTip + "\n" + resTip;
        return tip;
    }

    public void setConnectBy(Object role) {
        SILKNumber oldConnectBy = this.connectByRole;
        int roleInt = this.getRoleInt(role);
        switch (roleInt) {
            case 1: {
                this.connectByRole = this.categoryRole;
                break;
            }
            case 58: {
                this.connectByRole = this.seriesRole;
                break;
            }
            default: {
                this.connectByRole = null;
            }
        }
        if (oldConnectBy != this.connectByRole) {
            this.userSetProperties.set(10004);
            this.rebuildRequired = true;
            this.fireRedrawEvent(1);
        }
    }

    public SILKNumber getConnectBy() {
        return this.connectByRole;
    }

    public void setFillConnect(boolean fill) {
        if (this.fillConnect == fill) {
            return;
        }
        this.fillConnect = fill;
        this.userSetProperties.set(10005);
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
    }

    public boolean getFillConnect() {
        return this.fillConnect;
    }

    public void setShowGradient(boolean show) {
        if (this.showGradient == show) {
            return;
        }
        this.showGradient = show;
        this.userSetProperties.set(10006);
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
    }

    public boolean getShowGradient() {
        return this.showGradient;
    }

    public void setBarSpace(double space, Object which) {
        block16: {
            block15: {
                if (which == null) {
                    return;
                }
                if (space < 0.0) {
                    return;
                }
                if (!(which instanceof Number)) break block15;
                switch (((Number)which).intValue()) {
                    case 1: {
                        if (space == this.categoryBarSpace) {
                            return;
                        }
                        this.categoryBarSpace = space;
                        this.userSetProperties.set(10000);
                        break block16;
                    }
                    case 58: {
                        if (space == this.seriesBarSpace) {
                            return;
                        }
                        this.seriesBarSpace = space;
                        this.userSetProperties.set(10001);
                        break block16;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (which instanceof String) {
                if (((String)which).equalsIgnoreCase("category") || ((String)which).equalsIgnoreCase(this.categoryRole.toString())) {
                    if (space == this.categoryBarSpace) {
                        return;
                    }
                    this.categoryBarSpace = space;
                    this.userSetProperties.set(10000);
                } else if (((String)which).equalsIgnoreCase("series") || ((String)which).equalsIgnoreCase(this.seriesRole.toString())) {
                    if (space == this.seriesBarSpace) {
                        return;
                    }
                    this.seriesBarSpace = space;
                    this.userSetProperties.set(10001);
                }
            } else {
                return;
            }
        }
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
    }

    public double getBarSpace(Object which) {
        if (which == null) {
            return Double.NaN;
        }
        if (which instanceof Number) {
            switch (((Number)which).intValue()) {
                case 1: {
                    return this.categoryBarSpace;
                }
                case 58: {
                    return this.seriesBarSpace;
                }
            }
            return Double.NaN;
        }
        if (which instanceof String) {
            if (((String)which).equalsIgnoreCase("category") || ((String)which).equalsIgnoreCase(this.categoryRole.toString())) {
                return this.categoryBarSpace;
            }
            if (((String)which).equalsIgnoreCase("series") || ((String)which).equalsIgnoreCase(this.seriesRole.toString())) {
                return this.seriesBarSpace;
            }
        }
        return Double.NaN;
    }

    public void setBaseValue(double value) {
        if (this.baseline == value) {
            return;
        }
        this.baseline = value;
        this.userSetProperties.set(10002);
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
    }

    public double getBaseValue() {
        return this.baseline;
    }

    @Override
    public Object[] getSupportedRoles(Object arg0, boolean arg1) {
        if (arg1) {
            return new Object[]{this.categoryRole, this.seriesRole, this.responseRole};
        }
        return new Object[]{this.responseRole};
    }

    @Override
    protected int getRoleInt(Object role) {
        int roleInt = -1;
        if (role != null) {
            if (role instanceof String) {
                String s = (String)role;
                if (s.equalsIgnoreCase("category") || s.equalsIgnoreCase(this.categoryRole.toString())) {
                    roleInt = this.categoryRole.intValue();
                } else if (s.equalsIgnoreCase("response") || s.equalsIgnoreCase(this.responseRole.toString())) {
                    roleInt = this.responseRole.intValue();
                } else if (s.equalsIgnoreCase("series") || s.equalsIgnoreCase(this.seriesRole.toString())) {
                    roleInt = this.seriesRole.intValue();
                } else if (s.equalsIgnoreCase("statistictype") || s.equalsIgnoreCase(this.statisticTypeRole.toString())) {
                    roleInt = this.statisticTypeRole.intValue();
                }
            } else if (role instanceof Number) {
                roleInt = ((Number)role).intValue();
            }
        }
        return roleInt;
    }

    private double[] computeAxisSize() {
        int numCategories = 0;
        int numSeries = 0;
        double[] axisSize = new double[]{1.0, 1.0, 1.0};
        this.barWidth = 0.1;
        if (this.yMapper == null || !((StringToNumericMapper)this.yMapper).input.isConnected()) {
            return null;
        }
        numCategories = ((StringToNumericMapper)this.yMapper).getUniqueValueCount();
        if (this.seriesVar == null) {
            numSeries = 1;
        } else if (this.xMapper != null && ((StringToNumericMapper)this.xMapper).input.isConnected()) {
            numSeries = ((StringToNumericMapper)this.xMapper).getUniqueValueCount();
        } else {
            return null;
        }
        if (numCategories <= 0 || numSeries <= 0) {
            return null;
        }
        if (numCategories >= numSeries) {
            this.barWidth = (1.0 - 2.0 * this.padding) / ((double)numCategories + (double)numCategories * this.categoryBarSpace);
            axisSize[1] = 1.0;
            axisSize[0] = 2.0 * this.padding + (double)numSeries * (this.barWidth + this.barWidth * this.seriesBarSpace);
            axisSize[2] = Math.max(axisSize[0], 0.4);
        } else {
            this.barWidth = (1.0 - 2.0 * this.padding) / ((double)numSeries + (double)numSeries * this.seriesBarSpace);
            axisSize[1] = 2.0 * this.padding + (double)numCategories * (this.barWidth + this.barWidth * this.categoryBarSpace);
            axisSize[2] = Math.max(axisSize[1], 0.4);
            axisSize[0] = 1.0;
        }
        return axisSize;
    }

    @Override
    public double[] getPreferredAxisSize() {
        if (this.normalized) {
            return new double[]{1.0, 1.0, 1.0};
        }
        return this.computeAxisSize();
    }

    @Override
    protected boolean areRequiredVariablesSet() {
        return this.getObject(this.roles.getVariable((Object)this.categoryRole)) != null && this.getObject(this.roles.getVariable((Object)this.seriesRole)) != null;
    }

    @Override
    public void setColorBy(Object role) {
        SILKNumber oldColorBy = this.colorByRole;
        int roleInt = this.getRoleInt(role);
        switch (roleInt) {
            case 1: {
                this.colorByRole = this.categoryRole;
                break;
            }
            case 58: {
                this.colorByRole = this.seriesRole;
                break;
            }
            default: {
                this.colorByRole = null;
            }
        }
        if (oldColorBy != this.colorByRole) {
            this.userSetProperties.set(10101);
            this.rebuildRequired = true;
            this.fireRedrawEvent(1);
        }
    }

    @Override
    public SILKNumber getColorBy() {
        return this.colorByRole;
    }

    private void initializeColorBy() {
        if (this.colorByRole == this.categoryRole) {
            this.colorVar = this.categoryVar;
        } else if (this.colorByRole == this.seriesRole) {
            this.colorVar = this.seriesVar;
        } else {
            this.colorVar = null;
            this.colorMapper = null;
            return;
        }
        if (this.colorVar != null && this.colorVar.isConnected()) {
            LinkedHashMap colorMap = this.buildColorMap(this.colorVar);
            int oldSort = this.colorVar.getUniqueValueSort();
            this.colorVar.setUniqueValueSort(0);
            this.colorMapper = new StringToColorMapper();
            this.colorMapper.setLabelMissingValues(true);
            this.colorMapper.setReplaceMissingValues(true);
            if (this.colorVar instanceof GTKNumericDataFilterVariable) {
                ((StringToColorMapper)this.colorMapper).input.connectFrom(((GTKNumericDataFilterVariable)this.colorVar).formattedValue);
                int numValues = ((GTKNumericDataFilterVariable)this.colorVar).getUniqueValueCount();
                this.colorVar.init();
                for (int i = 0; i < numValues; ++i) {
                    try {
                        String value = ((GTKNumericDataFilterVariable)this.colorVar).formattedUniqueValue.getValue(i);
                        int index = this.getColorIndex(value, i, colorMap);
                        DataStyleElement dse = SILKUtilities.getStyleElement((String)value, (int)index, (int)2, (Style)this.style, (String)this.fillAttrs.getReference(), (StyleElement)this.fillAttrs.getOverrides(false)).getAsDataStyle();
                        Color color = dse.getFillColor();
                        ((StringToColorMapper)this.colorMapper).add(value, color);
                        continue;
                    }
                    catch (MissingValueException e) {
                        MissingValues missing = e.getMissingValue();
                        String value = this.colorMapper.getMissingValueLabel(missing);
                        int index = this.getColorIndex(value, i, colorMap);
                        DataStyleElement dse = SILKUtilities.getStyleElement((String)value, (int)index, (int)2, (Style)this.style, (String)this.fillAttrs.getReference(), (StyleElement)this.fillAttrs.getOverrides(false)).getAsDataStyle();
                        Color color = dse.getFillColor();
                        ((StringToColorMapper)this.colorMapper).setReplaceMissingValues(true, missing);
                        ((StringToColorMapper)this.colorMapper).setMissingReplacement(color, missing);
                    }
                }
            } else {
                ((StringToColorMapper)this.colorMapper).input.connectFrom(((GTKStringDataFilterVariable)this.colorVar).formattedValue);
                int numValues = ((GTKStringDataFilterVariable)this.colorVar).getUniqueValueCount();
                for (int i = 0; i < numValues; ++i) {
                    try {
                        String value = ((GTKStringDataFilterVariable)this.colorVar).formattedUniqueValue.getValue(i);
                        int index = this.getColorIndex(value, i, colorMap);
                        DataStyleElement dse = SILKUtilities.getStyleElement((String)value, (int)index, (int)2, (Style)this.style, (String)this.fillAttrs.getReference(), (StyleElement)this.fillAttrs.getOverrides(false)).getAsDataStyle();
                        Color color = dse.getFillColor();
                        ((StringToColorMapper)this.colorMapper).add(value, color);
                        continue;
                    }
                    catch (MissingValueException e) {
                        MissingValues missing = e.getMissingValue();
                        String value = this.colorMapper.getMissingValueLabel(missing);
                        int index = this.getColorIndex(value, i, colorMap);
                        DataStyleElement dse = SILKUtilities.getStyleElement((String)value, (int)index, (int)2, (Style)this.style, (String)this.fillAttrs.getReference(), (StyleElement)this.fillAttrs.getOverrides(false)).getAsDataStyle();
                        Color color = dse.getFillColor();
                        ((StringToColorMapper)this.colorMapper).setReplaceMissingValues(true, missing);
                        ((StringToColorMapper)this.colorMapper).setMissingReplacement(color, missing);
                    }
                }
            }
            this.colorVar.setUniqueValueSort(oldSort);
        } else {
            this.colorVar = null;
            this.colorMapper = null;
        }
    }

    private Object getColorVariableID(Variable colorVar) {
        Object varName = null;
        if (this.categoryVar == colorVar) {
            varName = this.roles.getVariable((Object)this.categoryRole, 0);
        } else if (this.responseVar == colorVar) {
            varName = this.roles.getVariable((Object)this.responseRole, 0);
        } else if (this.seriesVar == colorVar) {
            varName = this.roles.getVariable((Object)this.seriesRole, 0);
        }
        return varName;
    }

    protected LinkedHashMap buildColorMap(Variable colorVar) {
        if (this.dataFilter == null || !(this.dataFilter instanceof DataFilterInfoInterface)) {
            return null;
        }
        Object varName = this.getColorVariableID(colorVar);
        if (varName == null) {
            return null;
        }
        DataFilterInfoInterface infoFilter = (DataFilterInfoInterface)this.dataFilter;
        Object[] uniqueValues = infoFilter.getUniqueValues(varName, false);
        if (uniqueValues == null) {
            return null;
        }
        LinkedHashMap<Object, Integer> colorMap = new LinkedHashMap<Object, Integer>();
        for (int i = 0; i < uniqueValues.length; ++i) {
            colorMap.put(uniqueValues[i], new Integer(i));
        }
        return colorMap;
    }

    protected int getColorIndex(Object value, int defaultIndex, LinkedHashMap colorMap) {
        Integer index;
        int colorIndex = defaultIndex;
        if (value != null && colorMap != null && (index = (Integer)colorMap.get(value)) != null) {
            colorIndex = index;
        }
        return colorIndex;
    }

    @Override
    public boolean isLegendNeeded() {
        return this.colorByRole != null;
    }

    protected Object getLegendTitle(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.colorByRole != null && this.colorByRole.equals((Object)currentLegend)) {
            return this.dataFilter.getVariableDescription(this.roles.getVariable((Object)this.colorByRole, 0));
        }
        return null;
    }

    protected Object getLegendEntries(SILKNumber currentLegend) {
        if (currentLegend == null || this.colorByRole == null || !this.colorByRole.equals((Object)currentLegend) || this.colorVar == null || !this.colorVar.isConnected()) {
            return null;
        }
        Vector<LegendEntry> legendEntries = null;
        int oldSort = this.colorVar.getUniqueValueSort();
        this.colorVar.setUniqueValueSort(0);
        LinkedHashMap colorMap = this.buildColorMap(this.colorVar);
        if (this.colorVar instanceof GTKNumericDataFilterVariable) {
            int numValues = ((GTKNumericDataFilterVariable)this.colorVar).getUniqueValueCount();
            legendEntries = new Vector<LegendEntry>(numValues);
            this.colorVar.init();
            for (int i = 0; i < numValues; ++i) {
                String value;
                try {
                    value = ((GTKNumericDataFilterVariable)this.colorVar).formattedUniqueValue.getValue(i);
                }
                catch (MissingValueException e) {
                    value = this.getFormattedValue(this.getColorVariableID(this.colorVar), new Double(Double.NaN));
                }
                int index = this.getColorIndex(value, i, colorMap);
                DataStyleElement dse = SILKUtilities.getStyleElement((String)value, (int)index, (int)2, (Style)this.style, (String)this.fillAttrs.getReference(), (StyleElement)this.fillAttrs.getOverrides(false)).getAsDataStyle();
                Color color = dse.getFillColor();
                MarkerAttrib ms = new MarkerAttrib(true, color);
                legendEntries.add(new LegendEntry((Object)value, (MarkerStyleInterface)ms, null));
            }
        } else {
            int numValues = ((GTKStringDataFilterVariable)this.colorVar).getUniqueValueCount();
            legendEntries = new Vector(numValues);
            ((GTKStringDataFilterVariable)this.colorVar).setFormattedValueMissingValueExceptionsEnabled(false);
            for (int i = 0; i < numValues; ++i) {
                String value;
                try {
                    value = ((GTKStringDataFilterVariable)this.colorVar).formattedUniqueValue.getValue(i);
                }
                catch (MissingValueException e) {
                    MissingValues missing = e.getMissingValue();
                    value = this.colorMapper.getMissingValueLabel(missing);
                }
                int index = this.getColorIndex(value, i, colorMap);
                DataStyleElement dse = SILKUtilities.getStyleElement((String)value, (int)index, (int)2, (Style)this.style, (String)this.fillAttrs.getReference(), (StyleElement)this.fillAttrs.getOverrides(false)).getAsDataStyle();
                Color color = dse.getFillColor();
                MarkerAttrib ms = new MarkerAttrib(true, color);
                legendEntries.add(new LegendEntry((Object)value, (MarkerStyleInterface)ms, null));
            }
            ((GTKStringDataFilterVariable)this.colorVar).setFormattedValueMissingValueExceptionsEnabled(true);
        }
        this.colorVar.setUniqueValueSort(oldSort);
        return legendEntries;
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        boolean rc = super.setPropertyValue(id, value);
        switch (id) {
            case 23: {
                if (value == null) break;
                String leg = value.toString();
                if (this.colorByRole == null || !leg.equalsIgnoreCase(this.colorByRole.toString()) && !leg.equalsIgnoreCase(this.colorByRole.getEnglishName())) break;
                this.currentLegend = this.colorByRole;
                return true;
            }
        }
        return rc;
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        Object value = null;
        Object obj = null;
        switch (id) {
            case 10000: {
                value = new Double(this.categoryBarSpace);
                break;
            }
            case 10001: {
                value = new Double(this.seriesBarSpace);
                break;
            }
            case 10002: {
                value = new Double(this.baseline);
                break;
            }
            case 10003: {
                value = this.getStatistic();
                break;
            }
            case 10005: {
                value = new Boolean(this.fillConnect);
                break;
            }
            case 10101: {
                value = this.colorByRole;
                break;
            }
            case 10102: {
                value = Boolean.FALSE;
                break;
            }
            case 10006: {
                value = new Boolean(this.showGradient);
                break;
            }
            case 10004: {
                value = this.connectByRole;
                break;
            }
            case 23: {
                value = this.currentLegend;
                break;
            }
            case 434: {
                if (this.colorByRole == null || !this.colorByRole.equals((Object)this.currentLegend)) break;
                value = this.roles.getVariable((Object)this.colorByRole, 0);
                break;
            }
            case 24: 
            case 25: {
                if (this.colorByRole == null) break;
                value = this.colorByRole;
                break;
            }
            case 433: {
                value = this.getLegendEntries(this.currentLegend);
                break;
            }
            case 426: {
                value = this.getLegendTitle(this.currentLegend);
                break;
            }
            case 441: {
                value = Boolean.FALSE;
                break;
            }
            case 10103: {
                if (this.hasSeriesVariable()) {
                    value = this.getVarLabel(this.roles.getVariable((Object)RoleInterface.ROLE_SERIES, 0));
                    break;
                }
                value = "";
                break;
            }
            case 10105: {
                value = this.getVarLabel(this.roles.getVariable((Object)RoleInterface.ROLE_CATEGORY, 0));
                break;
            }
            case 10107: {
                obj = this.getVarLabel(this.roles.getVariable((Object)RoleInterface.ROLE_RESPONSE, 0));
                obj = obj == null ? (this.statType == 4 ? STAT_NAMES[4] : STAT_NAMES[3]) : obj + " " + STAT_SUFFIX_NAMES[this.statType];
                value = obj;
                break;
            }
            case 10104: {
                obj = this.roles.getVariable((Object)RoleInterface.ROLE_SERIES, 0);
                if (obj == null || this.dataFilter == null) break;
                value = this.dataFilter.getFormat(obj, SASFormat.class);
                break;
            }
            case 10106: {
                obj = this.roles.getVariable((Object)RoleInterface.ROLE_CATEGORY, 0);
                if (obj == null || this.dataFilter == null) break;
                value = this.dataFilter.getFormat(obj, SASFormat.class);
                break;
            }
            case 10108: {
                obj = this.roles.getVariable((Object)RoleInterface.ROLE_RESPONSE, 0);
                if (obj == null || this.dataFilter == null) break;
                value = this.dataFilter.getFormat(obj, SASFormat.class);
                break;
            }
            case 10109: {
                value = new Object[]{RoleInterface.ROLE_SERIES};
                break;
            }
            case 10110: {
                value = new Object[]{RoleInterface.ROLE_CATEGORY};
                break;
            }
            case 10111: {
                value = new Object[]{RoleInterface.ROLE_RESPONSE};
                break;
            }
            case 10115: {
                value = this.roles.getVariable((Object)this.responseRole, 0) == null && 3 == this.statType ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 10112: {
                value = "oblique";
                break;
            }
            default: {
                value = super.getPropertyValue(id);
            }
        }
        return value;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 10000: {
                if (!(value instanceof Number)) break;
                this.setBarSpace(((Number)value).doubleValue(), this.categoryRole);
                break;
            }
            case 10001: {
                if (!(value instanceof Number)) break;
                this.setBarSpace(((Number)value).doubleValue(), this.seriesRole);
                break;
            }
            case 10002: {
                if (!(value instanceof Number)) break;
                this.setBaseValue(((Number)value).doubleValue());
                break;
            }
            case 10003: {
                this.setStatistic(value);
                break;
            }
            case 10005: {
                if (!(value instanceof Boolean)) break;
                this.setFillConnect((Boolean)value);
                break;
            }
            case 10006: {
                if (!(value instanceof Boolean)) break;
                this.setShowGradient((Boolean)value);
                break;
            }
            case 10004: {
                this.setConnectBy(value);
                break;
            }
            case 10101: {
                this.setColorBy(value);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public boolean isWireframeSupported() {
        return false;
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        Bar3DObject pi = this;
        if (listener != null && listener instanceof PropertyInterface) {
            pi = (PropertyInterface)listener;
        }
        if (category == 1 && dialogIn instanceof TabbedPropertiesDialog) {
            TabbedPropertiesDialog tpd = (TabbedPropertiesDialog)dialogIn;
            TabPanelInterface tpi = null;
            tpi = tpd.getTab(Bar3DPanel.class);
            if (tpi != null) {
                tpi.addPropertyListener((PropertyInterface)pi);
            } else {
                tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DObject.BarPanelTitle.txt", (String)"Bar"), (TabPanelInterface)new Bar3DPanel(pi));
            }
        } else if (category == 1 && dialogIn instanceof GraphPropertiesDialog) {
            GraphPropertiesDialog gpd = (GraphPropertiesDialog)dialogIn;
            GraphPropertiesDialog.PropertiesTreeNode node = gpd.getRootNode((Object)"Chart", true);
            node.setDisplayName(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DObject.BarPanelTitle.txt", (String)"Bar"));
            if (node.getPanel() == null) {
                node.setPanel((Component)new Bar3DPanel(pi));
            } else if (node.getPanel() instanceof TabPanelInterface) {
                ((TabPanelInterface)node.getPanel()).addPropertyListener((PropertyInterface)pi);
            }
        }
        return true;
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                this.rebuildRequired = true;
                break;
            }
            case 3: {
                this.removeRole(e);
                this.rebuildRequired = true;
                break;
            }
            case 5: {
                this.setSortOrder(e);
            }
        }
        this.setSortMetadata();
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        if (this.dataFilter == null) {
            return null;
        }
        DataRange rc = null;
        Enumeration rolesEnum = Extract.elements((Object)which);
        while (rolesEnum.hasMoreElements()) {
            Object role = rolesEnum.nextElement();
            if (role instanceof Number && role == RoleInterface.ROLE_SERIES) {
                if (this.roles.getVariable((Object)this.seriesRole, 0) != null) continue;
                rc = new DiscreteRange();
                continue;
            }
            if (!(role instanceof Number) || role != RoleInterface.ROLE_RESPONSE) continue;
            if (this.vp.getVariableCount() == 0) {
                rc = null;
                continue;
            }
            double min = this.barHeightVar.getMin();
            double max = this.barHeightVar.getMax();
            min = Math.min(min, this.baseline);
            max = Math.max(max, this.baseline);
            rc = new ContinuousRange(min, max);
        }
        if (rc == null) {
            rc = super.getPreferredRange(which);
        }
        return rc;
    }

    @Override
    public boolean setDataSource(Object source, Object id) {
        boolean rc = super.setDataSource(source, id);
        this.selectionVar.connectFrom(this.dataFilter);
        return rc;
    }

    @Override
    public void setRange(byte dim, int index, DataRange range) {
        super.setRange(dim, index, range);
        this.updateBarSize();
    }

    private void updateBarSize() {
        if (this.xRange == null || this.yRange == null || this.zRange == null) {
            return;
        }
        if (!this.normalized) {
            double newCellWidth;
            int numX = 0;
            int numY = 0;
            if (this.xRange instanceof DiscreteRange) {
                numX = ((DiscreteRange)this.xRange).getValuesSize();
            }
            if (numX == 0) {
                numX = 1;
            }
            if (this.yRange instanceof DiscreteRange) {
                numY = ((DiscreteRange)this.yRange).getValuesSize();
            }
            if (numY == 0) {
                numY = 0;
            }
            if ((newCellWidth = numX >= numY ? (1.0 - 2.0 * this.seriesPadding) / (double)numX : (1.0 - 2.0 * this.categoryPadding) / (double)numY) != this.cellWidth) {
                this.cellWidth = newCellWidth;
                this.rebuildRequired = true;
            }
        }
    }

    @Override
    public void draw() {
        Channel ch = this.root.getChannel();
        if (ch == null || !this.networkBuilt) {
            return;
        }
        ch.glPushAttrib(0);
        ch.glEnable(4);
        ch.glEnable(1);
        ch.glDisable(12);
        this.root.draw();
        ch.glPopAttrib();
    }

    protected void setSortMetadata() {
        this.roles.setSupportedSortRoles(this.buildSupportedSortableRoles());
    }

    protected Object[][] buildSupportedSortableRoles() {
        if (this.dataFilter == null) {
            return null;
        }
        boolean cat = false;
        boolean series = false;
        Object catVar = this.roles.getVariable((Object)this.categoryRole, 0);
        Object seriesVar = this.roles.getVariable((Object)this.seriesRole, 0);
        if (catVar != null && !this.dataFilter.isNumericVariable(catVar)) {
            cat = true;
        }
        if (seriesVar != null && !this.dataFilter.isNumericVariable(seriesVar)) {
            series = true;
        }
        if (cat && series) {
            return new Object[][]{{this.categoryRole}, {this.seriesRole}};
        }
        if (cat) {
            return new Object[][]{{this.categoryRole}};
        }
        if (series) {
            return new Object[][]{{this.seriesRole}};
        }
        return null;
    }

    private class MultiplierFormat
    extends GTKFormat {
        private final int multiplier = 100;

        public MultiplierFormat() {
            super((Format)NumberFormat.getInstance(Locale.getDefault()));
            this.multiplier = 100;
        }

        public String format(Object argument) {
            Object newValue = argument;
            if (argument instanceof Double) {
                newValue = new Double((Double)argument * 100.0);
            }
            return super.format(newValue);
        }
    }
}

