/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.silk3d;

import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import java.awt.Color;

public class ColorModifier
implements ColorPipe {
    private ColorPipe inPipe;
    public static int COLOR_BRIGHTER = 0;
    public static int COLOR_DARKER = 1;
    private int colorMod = COLOR_BRIGHTER;
    private double modFactor = 0.2;

    public ColorModifier() {
    }

    public ColorModifier(ColorPipe in) {
        this.inPipe = in;
    }

    public ColorModifier(ColorPipe in, int modifier, double factor) {
        this.inPipe = in;
        if (modifier == COLOR_BRIGHTER || modifier == COLOR_DARKER) {
            this.colorMod = modifier;
        }
        this.modFactor = factor;
    }

    public Color getValue(int index) throws MissingValueException {
        if (this.inPipe == null) {
            throw new MissingValueException();
        }
        Color color = this.inPipe.getValue(index);
        if (color != null) {
            Color newColor = this.colorMod == COLOR_BRIGHTER ? ColorUtilities.brighter((Color)color, (double)this.modFactor) : ColorUtilities.darker((Color)color, (double)this.modFactor);
            return new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), color.getAlpha());
        }
        return null;
    }

    public void init(AInitAction initAction) {
        if (this.inPipe != null) {
            this.inPipe.init(initAction);
        }
    }

    public void reset(AResetAction resetAction) {
    }

    public Formatter getFormatter() {
        return null;
    }

    public void setColorModifier(int modifier) {
        if (modifier == COLOR_BRIGHTER || modifier == COLOR_DARKER) {
            this.colorMod = modifier;
        }
    }

    public void setFactor(double factor) {
        this.modFactor = factor;
    }
}

