/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.LayerChangedEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.info.SILKChartInfo;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.LayerListenerInterface;
import com.sas.graphics.silk.interfaces.LegendEntryInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.SILK3DComponentPropertyInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.silk3d.SILK3DChart;
import com.sas.graphics.silk.silk3d.util.ReferencePlane;
import com.sas.graphics.silk.silk3d.util.SILK3DAxis;
import com.sas.graphics.silk.silk3d.util.SILK3DAxisSet;
import com.sas.graphics.silk.ui.AxisPanel;
import com.sas.graphics.silk.ui.DataOptionsDialog;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.LegendPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.Brush;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.RoleManager;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class SILK3DComponent
extends SILKComponent
implements RedrawListener,
SILK3DComponentPropertyInterface,
RangeChangeListener,
LayerListenerInterface,
DataRangeInterface,
CellItemInterface,
MouseListener,
MouseMotionListener {
    protected Channel channel = null;
    boolean channelReady = false;
    private BufferedImage backBuffer = null;
    protected SILK3DAxisSet axes = null;
    protected Vector charts = new Vector();
    protected SILK3DChart primary = null;
    private int lastXInt = 0;
    private int lastYInt = 0;
    protected View3D view = null;
    protected final double defaultZoom = Double.NaN;
    protected final double defaultTilt = -30.0;
    protected final double defaultPerspectiveRotation = 35.0;
    protected final double defaultObliqueRotation = 150.0;
    protected final Vec3d defaultPerspectiveFocalPoint = new Vec3d(Double.NaN, Double.NaN, Double.NaN);
    protected final Vec3d defaultObliqueFocalPoint = new Vec3d(0.0, 0.0, 0.0);
    protected boolean userNavigating = false;
    private boolean forceRotate = false;
    private boolean forceZoom = false;
    private boolean forcePan = false;
    private boolean isSelecting = false;
    private boolean useDefaultActionMode = true;
    private Rectangle selectionRect = null;
    private Point selectionPoint = null;
    private boolean holdBuild = false;
    private boolean doPostBuild = false;
    protected boolean buildSuccess = false;
    protected String[] errorStrings;
    protected int errorType = 0;
    protected int projection = -1;
    public static final int OBLIQUE_PROJECTION = 0;
    public static final int PERSPECTIVE_PROJECTION = 1;
    protected String[] projectionList;
    protected String[] englishProjectionList;
    protected Vector rangeChangeListeners = null;
    protected int currentAxis = 0;
    protected Brush brush = null;
    public static int[] supportedProperties = new int[]{10200, 10205, 10202, 10203, 10204, 26, 10206, 10207};
    protected Insets prefOuterMargin = new Insets(0, 0, 0, 0);
    protected Insets prefInnerMargin = new Insets(0, 0, 0, 0);
    protected Insets outerMargin = new Insets(0, 0, 0, 0);
    protected Insets innerMargin = new Insets(0, 0, 0, 0);
    private boolean invertRotate = false;
    private boolean clickedOnLegend = false;

    public SILK3DComponent() {
        this.initializeChannel();
        this.setupLights();
        this.setStyle(SILKGlobal.getInstance().getPropertyValue(29));
        this.view = new View3D();
        this.axes = new SILK3DAxisSet(this.channel);
        this.axes.addRedrawListener(this);
        this.axes.applyStyle(this.style);
        this.actionMode = 6;
        this.projectionList = new String[2];
        this.projectionList[0] = ResourceLoader.getResourceString((Object)this.rb, (String)"SILK3DComponent.ObliqueProjection.txt", (String)"Oblique");
        this.projectionList[1] = ResourceLoader.getResourceString((Object)this.rb, (String)"SILK3DComponent.PerspectiveProjection.txt", (String)"Perspective");
        this.englishProjectionList = new String[2];
        this.englishProjectionList[0] = "Oblique";
        this.englishProjectionList[1] = "Perspective";
        this.errorStrings = new String[5];
        this.errorStrings[1] = ResourceLoader.getResourceString((Object)this.rb, (String)"SILK3DComponent.ChartError.txt", (String)"Chart has an error.");
        this.errorStrings[2] = ResourceLoader.getResourceString((Object)this.rb, (String)"SILK3DComponent.NoDataError.txt", (String)"Chart has no data.");
        this.errorStrings[3] = ResourceLoader.getResourceString((Object)this.rb, (String)"SILK3DComponent.InvalidDataError.txt", (String)"Chart has invalid data.");
        this.errorStrings[4] = ResourceLoader.getResourceString((Object)this.rb, (String)"SILK3DComponent.RoleAssignmentError.txt", (String)"Data is not assigned correctly.");
        this.errorStrings[0] = this.errorStrings[1];
        this.userSetProperties.appendProperties(supportedProperties);
        this.initializeMenu(null);
        if (this.silkAnno == null) {
            MenuUtilities.removeMenuItem((JPopupMenu)this.menu, (String)"ACTION_MODE_ANNOTATE");
        }
        this.brush = new Brush((Component)((Object)this));
        this.brush.setComponentIs3D(true);
        this.brush.setActionMode(6);
        this.brush.setSelectInChartSpace(false);
        this.brush.setSelectOnDrilldown(this.selectOnDrilldown);
        this.brush.setPolygonFillColor(this.style.getDataStyleElement("Selection").getLineColor());
    }

    private void initializeChannel() {
        this.channel = new Channel((Component)((Object)this));
        this.channel.glEnable(4);
        this.channel.glCullFace(1);
        this.channel.glEnable(1);
        this.channel.glEnable(8);
        this.channel.setDepthTestAlgorithm(4);
        this.channel.setBackbuffer(-1);
    }

    public SILK3DComponent(SILK3DChart newChart) {
        this();
        this.setChart(newChart);
    }

    public void dispose() {
        if (this.dataDlg != null) {
            this.dataDlg.removeAllCharts();
        }
        super.dispose();
        this.channel = null;
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.axes != null) {
            this.axes.dispose();
            this.axes = null;
        }
        if (this.charts != null) {
            for (int i = 0; i < this.charts.size(); ++i) {
                this.brush.removeFilter(((SILK3DChart)this.charts.elementAt(i)).getFilter());
                ((SILK3DChart)this.charts.elementAt(i)).dispose();
            }
            this.charts = null;
        }
        if (this.rangeChangeListeners != null) {
            this.rangeChangeListeners.removeAllElements();
        }
        this.rangeChangeListeners = null;
        this.view = null;
        this.selectionRect = null;
        this.selectionPoint = null;
        this.brush.dispose();
    }

    private String generateUniqueChartId(Object chart) {
        int num = 0;
        String id = "Chart";
        SILKChartInfo info = SILKChartInfo.getInstance((Object)chart);
        if (info != null) {
            id = info.getDisplayName();
        }
        String baseName = id;
        while (this.getChart(id) != null) {
            id = baseName + " " + ++num;
        }
        return id;
    }

    public Object getChart(Object id) {
        if (this.charts == null || this.charts.size() == 0) {
            return null;
        }
        if (id == null) {
            return this.charts.elementAt(0);
        }
        for (int i = 0; i < this.charts.size(); ++i) {
            if (!id.equals(((SILK3DChart)this.charts.elementAt(i)).getId())) continue;
            return this.charts.elementAt(i);
        }
        return null;
    }

    public SILK3DChart getChart() {
        return (SILK3DChart)this.getChart(null);
    }

    public void setChart(SILK3DChart chart) {
        if (chart == null) {
            return;
        }
        if (chart.getId() == null) {
            chart.setId(this.generateUniqueChartId(chart));
        }
        chart.setChannel(this.channel);
        chart.applyStyle(this.style);
        chart.addRangeChangeListener(this);
        chart.addRedrawListener(this);
        chart.addLayerListener(this);
        this.roles = chart.getRoleManager();
        if (this.roles != null) {
            this.roles.addRoleListener((RoleListenerInterface)this);
        }
        if (this.charts.size() == 0) {
            this.primary = chart;
            Object projection = this.primary.getPropertyValue(10112);
            if (projection != null) {
                this.setProjection(projection);
                this.userSetProperties.clear(10200);
            }
            this.axes.setNormalized(this.primary.isNormalized());
        }
        if (this.dataDlg != null) {
            this.dataDlg.addChart((RoleInterface)chart);
        }
        this.initAxesFromSource(chart);
        this.initializeMenu(null, this.isPopupRebuildRequired(this.primary));
        this.charts.addElement(chart);
        this.brush.addFilter(chart.getFilter());
    }

    private boolean isPopupRebuildRequired(SILK3DChart element) {
        if (element == null) {
            return false;
        }
        boolean rebuildPopup = false;
        Object cpm = element.getPropertyValue(19089);
        if (cpm instanceof Boolean) {
            rebuildPopup = (Boolean)cpm;
        }
        return rebuildPopup;
    }

    protected String getMenuXMLPath() {
        if (this.primary != null && this.primary.getMenuXMLPath() != null) {
            return this.primary.getMenuXMLPath();
        }
        return "/com/sas/graphics/silk/util/menus/Standard3DMenu.xml";
    }

    public String getToolTipText(MouseEvent me) {
        SILK3DChart chart;
        String rc = null;
        for (int i = this.charts.size() - 1; i >= 0 && ((rc = (chart = (SILK3DChart)this.charts.elementAt(i)).getTipText(me.getX(), me.getY())) == null || rc.length() <= 0); --i) {
        }
        return rc;
    }

    public void setBackground(Color bg) {
        this.background.setSolidBackground((Object)bg);
        if (this.channel != null) {
            this.channel.setBackgroundColor(bg);
        }
    }

    public boolean setStyle(Object newStyle) {
        boolean result = super.setStyle(newStyle);
        if (result) {
            if (this.brush != null) {
                this.brush.setPolygonFillColor(this.style.getDataStyleElement("Selection").getLineColor());
            }
            if (this.legends != null) {
                Enumeration legs = this.legends.elements();
                while (legs.hasMoreElements()) {
                    LegendObjectJ2D l = (LegendObjectJ2D)legs.nextElement();
                    l.applyStyle(this.style);
                }
            }
            if (this.axes != null) {
                result &= this.axes.applyStyle(this.style);
            }
            for (int i = 0; i < this.charts.size(); ++i) {
                result &= ((SILK3DChart)this.charts.elementAt(i)).applyStyle(this.style);
            }
            if (this.channel != null) {
                Color bg = this.style.getFillStyleElement("Backfill").getFillColor();
                this.channel.setBackgroundColor(bg);
            }
            if (this.silkAnno != null) {
                this.silkAnno.setStyle(this.style);
            }
        }
        return result;
    }

    public AxisInterface getAxis(Object which) {
        return this.axes.getAxis(which);
    }

    public boolean buildAndDraw() {
        return this.buildAndDraw(null, null, null);
    }

    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        if (this.holdBuild) {
            this.doPostBuild = true;
            return false;
        }
        this.doPostBuild = false;
        boolean buildNetwork = true;
        boolean drawNetwork = true;
        if (buildData != null && buildData instanceof Boolean && !((Boolean)buildData).booleanValue()) {
            buildNetwork = false;
        }
        if (drawData != null && drawData instanceof Boolean && !((Boolean)drawData).booleanValue()) {
            drawNetwork = false;
        }
        if (buildNetwork) {
            drawNetwork = this.build(buildData);
        }
        if (this.doPostBuild) {
            this.build(Boolean.TRUE);
        }
        this.draw(drawNetwork);
        return true;
    }

    public boolean build(Object buildData) {
        this.holdBuild = true;
        this.buildSuccess = true;
        this.errorType = 0;
        if (this.charts == null || this.charts.isEmpty()) {
            this.holdBuild = false;
            return true;
        }
        for (int i = 0; i < this.charts.size() && this.buildSuccess; ++i) {
            SILK3DChart chart = (SILK3DChart)this.charts.elementAt(i);
            this.buildSuccess &= chart.build(buildData);
            if (this.buildSuccess) continue;
            this.errorType = chart.getErrorCode();
        }
        this.buildLegends();
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        this.graphLayout.setDataRegion(this.graphLayout.getChartArea());
        this.brush.setChartArea(this.graphLayout.getChartArea());
        if (this.axes != null) {
            Rectangle r = this.graphLayout.getChartArea();
            this.axes.setChartAreaDimension(new Dimension(r.width, r.height));
            boolean bl = this.buildSuccess = this.axes.build(buildData) && this.buildSuccess;
            if (!this.buildSuccess) {
                this.errorType = 3;
            }
        } else {
            this.buildSuccess = false;
            this.errorType = 1;
        }
        this.holdBuild = false;
        if (this.propertiesDialog != null) {
            this.propertiesDialog.updateLegendPanels((PropertyInterface)this, (Object)this);
        }
        return this.buildSuccess;
    }

    protected boolean draw(boolean drawChannel) {
        boolean rc = true;
        if (drawChannel) {
            rc = this.drawChannel();
        }
        this.repaint();
        return rc;
    }

    protected boolean drawChannel() {
        Rectangle r = this.graphLayout.getChartArea();
        if (r.width >= 0 && r.height >= 0 && this.channel != null) {
            Rectangle viewport = new Rectangle(r);
            if (this.projection == 0) {
                int extraSpace = (int)((double)viewport.width * 0.05);
                viewport.x += extraSpace;
                viewport.width -= extraSpace * 2;
            }
            this.channel.glViewport(viewport.x, viewport.y, viewport.width, viewport.height);
            this.channelReady = true;
        }
        if (!this.channelReady) {
            return false;
        }
        this.channel.glClear(3);
        this.updateView();
        this.setStationaryLightPosition();
        if (this.axes != null) {
            this.axes.draw();
        }
        for (int i = 0; i < this.charts.size(); ++i) {
            ((SILK3DChart)this.charts.elementAt(i)).draw();
        }
        Enumeration planes = this.axes.getReferencePlanes();
        while (planes.hasMoreElements()) {
            ((ReferencePlane)planes.nextElement()).draw();
        }
        return true;
    }

    protected void drawErrorMessage(Graphics2D g) {
        if (g == null) {
            return;
        }
        Rectangle rectangle = new Rectangle(0, 0, this.compWidth, this.compHeight);
        this.background.drawBackground(g, (Component)((Object)this), rectangle);
        String errorMessage = this.errorStrings[this.errorType];
        Font f = g.getFont();
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout errorString = new TextLayout(errorMessage, f, frc);
        Rectangle2D bounds = errorString.getBounds();
        float x = (float)Math.max(0.0, (double)this.compWidth / 2.0 - bounds.getWidth() / 2.0);
        float y = (float)Math.max(bounds.getHeight(), (double)this.compHeight / 2.0 + bounds.getHeight() / 2.0);
        Color ctext = null;
        if (this.style != null) {
            ctext = this.style.getTextStyleElement("LabelText").getTextColor();
        }
        if (ctext == null) {
            ctext = Color.BLACK;
        }
        g.setColor(ctext);
        errorString.draw(g, x, y);
    }

    protected void setupLights() {
        this.channel.glEnable(3);
        this.channel.glLight(19, 0, new double[]{0.7, 0.7, 0.7});
        this.channel.glLight(19, 1, new double[]{0.3, 0.3, 0.3});
        this.channel.glLight(19, 2, new double[]{0.0, 0.0, 0.0});
        this.channel.glLight(19, 3, new double[]{0.0, 0.0, 1.0});
        this.channel.glLight(20, 0, new double[]{0.0, 0.0, 0.0});
        this.channel.glLight(20, 1, new double[]{1.0, 1.0, 1.0});
        this.channel.glLight(20, 2, new double[]{0.0, 0.0, 0.0});
        this.channel.glLight(21, 0, new double[]{0.0, 0.0, 0.0});
        this.channel.glLight(21, 1, new double[]{0.7, 0.7, 0.7});
        this.channel.glLight(21, 2, new double[]{0.0, 0.0, 0.0});
        this.channel.glLight(22, 0, new double[]{0.0, 0.0, 0.0});
        this.channel.glLight(22, 1, new double[]{0.7, 0.7, 0.7});
        this.channel.glLight(22, 2, new double[]{0.0, 0.0, 0.0});
        this.channel.glLight(23, 0, new double[]{0.0, 0.0, 0.0});
        this.channel.glLight(23, 1, new double[]{0.85, 0.85, 0.85});
        this.channel.glLight(23, 2, new double[]{0.0, 0.0, 0.0});
    }

    protected void enableLights(boolean perspective) {
        if (perspective) {
            this.channel.glEnable(19);
            this.channel.glDisable(20);
            this.channel.glDisable(21);
            this.channel.glDisable(22);
            this.channel.glDisable(23);
        } else {
            this.channel.glDisable(19);
            this.channel.glEnable(20);
            this.channel.glEnable(21);
            this.channel.glEnable(22);
            this.channel.glEnable(23);
        }
    }

    protected void setStationaryLightPosition() {
        this.channel.glLight(20, 3, new double[]{0.0, 0.0, 1.0});
        this.channel.glLight(21, 3, new double[]{1.0, 0.0, 0.0});
        this.channel.glLight(22, 3, new double[]{-1.0, 0.0, 0.0});
        this.channel.glLight(23, 3, new double[]{0.0, 1.0, 0.0});
    }

    protected void buildLegends() {
        if (!this.createLegends || this.charts == null || this.charts.size() == 0) {
            return;
        }
        Hashtable<Object, LegendObjectJ2D> newLegends = new Hashtable<Object, LegendObjectJ2D>();
        LegendInterface[] legs = this.graphLayout.getLegends();
        if (legs != null) {
            for (int i = 0; i < legs.length; ++i) {
                if (legs[i] instanceof LegendObjectJ2D) {
                    this.removeMouseListener((MouseListener)((LegendObjectJ2D)legs[i]));
                    this.removeMouseMotionListener((MouseMotionListener)((LegendObjectJ2D)legs[i]));
                }
                this.graphLayout.removeLegend(legs[i]);
            }
        }
        Vector<Object> overlayEntries = new Vector<Object>();
        for (int i = 0; i < this.charts.size(); ++i) {
            Object legendNames;
            SILK3DChart chart = (SILK3DChart)this.charts.elementAt(i);
            Object overlayEntry = chart.getPropertyValue(444);
            if (overlayEntry != null && overlayEntry instanceof LegendEntry) {
                overlayEntries.addElement(overlayEntry);
            }
            if ((legendNames = chart.getPropertyValue(24)) == null) {
                return;
            }
            Object oldCurrentLegend = chart.getPropertyValue(23);
            if (this.currentLegend == null && oldCurrentLegend instanceof SILKNumber) {
                this.currentLegend = (SILKNumber)oldCurrentLegend;
            }
            Enumeration e = Extract.elements((Object)legendNames);
            while (e.hasMoreElements()) {
                Object variable;
                Object name = e.nextElement();
                chart.setPropertyValue(23, name);
                Object entries = chart.getPropertyValue(433);
                if (entries == null) continue;
                Enumeration legendEntries = Extract.elements((Object)entries);
                int numEntries = Extract.getNumberItems((Object)entries, (int)Extract.getSourceType((Object)entries));
                boolean continuousLegend = false;
                Object o = chart.getPropertyValue(441);
                if (o instanceof Boolean) {
                    continuousLegend = (Boolean)o;
                }
                LegendEntryInterface[] arr = new LegendEntryInterface[numEntries];
                int num = 0;
                while (legendEntries.hasMoreElements()) {
                    Object le = legendEntries.nextElement();
                    if (!(le instanceof LegendEntryInterface)) continue;
                    arr[num++] = (LegendEntryInterface)le;
                }
                LegendObjectJ2D legend = null;
                if (this.legends != null && this.legends.containsKey(name)) {
                    legend = (LegendObjectJ2D)this.legends.get(name);
                } else {
                    legend = new LegendObjectJ2D();
                    legend.applyStyle(this.style);
                    Object vis = chart.getPropertyValue(420);
                    if (vis != null && vis instanceof Boolean) {
                        legend.setVisible(((Boolean)vis).booleanValue());
                    } else {
                        legend.setVisible(true);
                    }
                }
                Object title = chart.getPropertyValue(426);
                Text titleText = (Text)legend.getTitle();
                if (title != null && !titleText.hasUserSetValue(9015)) {
                    legend.setTitle((Object)title.toString());
                    titleText.setCurrentValueAsDefault(9015);
                }
                newLegends.put(name, legend);
                legend.setValues(arr, continuousLegend);
                if (this.getParent() != null) {
                    this.addMouseListener((MouseListener)legend);
                    this.addMouseMotionListener((MouseMotionListener)legend);
                }
                if ((variable = chart.getPropertyValue(434)) != null) {
                    legend.setData(chart.getFilter(), variable.toString());
                    legend.getLabel().setFormat(chart.getFilter().getFormat(variable, SASFormat.class));
                } else {
                    legend.setData(null, null);
                }
                this.graphLayout.addLegend((LegendInterface)legend);
            }
            this.legends = newLegends;
            chart.setPropertyValue(23, oldCurrentLegend);
        }
        if (overlayEntries.size() > 1) {
            LegendObjectJ2D legend = null;
            if (this.legends != null && this.legends.containsKey("Overlay Legend")) {
                legend = (LegendObjectJ2D)this.legends.get("Overlay Legend");
            } else {
                legend = new LegendObjectJ2D();
                legend.applyStyle(this.style);
                legend.setVisible(true);
            }
            newLegends.put("Overlay Legend", legend);
            Object[] arr = new LegendEntry[overlayEntries.size()];
            overlayEntries.copyInto(arr);
            legend.setValues((LegendEntryInterface[])arr, false);
            this.graphLayout.addLegend((LegendInterface)legend);
        }
    }

    private void initAxesFromSource(SILK3DChart source) {
        TextAttrib text;
        AxisInterface axis = null;
        String axisLabel = null;
        Object axisFormat = null;
        Object obj = null;
        Object integerAxis = null;
        if (this.primary == null) {
            return;
        }
        axis = this.axes.getAxis("X");
        obj = this.primary.getPropertyValue(10103);
        axisLabel = obj != null ? obj.toString() : null;
        axisFormat = this.primary.getPropertyValue(10104);
        integerAxis = this.primary.getPropertyValue(10113);
        if (axis != null) {
            ((SILK3DAxis)axis).setFireEvents(false);
            this.setRange((byte)1, 0, this.getRange(this.getXAxisRoles()));
            if (axisLabel != null && !(text = (TextAttrib)axis.getLabel()).hasUserSetValue(9015)) {
                axis.setLabel((Object)axisLabel);
                text.setCurrentValueAsDefault(9015);
            }
            if (axisFormat != null) {
                axis.setValues(axisFormat);
                ((TextAttrib)axis.getValues()).setCurrentValueAsDefault(9008);
            }
            if (integerAxis instanceof Boolean) {
                ((SILK3DAxis)axis).setForceIntegerValues((Boolean)integerAxis);
            } else {
                ((SILK3DAxis)axis).setForceIntegerValues(false);
            }
            ((SILK3DAxis)axis).setFireEvents(true);
        }
        axis = this.axes.getAxis("Y");
        obj = this.primary.getPropertyValue(10105);
        axisLabel = obj != null ? obj.toString() : null;
        axisFormat = this.primary.getPropertyValue(10106);
        integerAxis = this.primary.getPropertyValue(10114);
        if (axis != null) {
            ((SILK3DAxis)axis).setFireEvents(false);
            this.setRange((byte)2, 0, this.getRange(this.getYAxisRoles()));
            if (axisLabel != null && !(text = (TextAttrib)axis.getLabel()).hasUserSetValue(9015)) {
                axis.setLabel((Object)axisLabel);
                text.setCurrentValueAsDefault(9015);
            }
            if (axisFormat != null) {
                axis.setValues(axisFormat);
                ((TextAttrib)axis.getValues()).setCurrentValueAsDefault(9008);
            }
            if (integerAxis instanceof Boolean) {
                ((SILK3DAxis)axis).setForceIntegerValues((Boolean)integerAxis);
            } else {
                ((SILK3DAxis)axis).setForceIntegerValues(false);
            }
            ((SILK3DAxis)axis).setFireEvents(true);
        }
        axis = this.axes.getAxis("Z");
        obj = this.primary.getPropertyValue(10107);
        axisLabel = obj != null ? obj.toString() : null;
        axisFormat = this.primary.getPropertyValue(10108);
        integerAxis = this.primary.getPropertyValue(10115);
        if (axis != null) {
            ((SILK3DAxis)axis).setFireEvents(false);
            this.setRange((byte)3, 0, this.getRange(this.getZAxisRoles()));
            if (axisLabel != null && !(text = (TextAttrib)axis.getLabel()).hasUserSetValue(9015)) {
                axis.setLabel((Object)axisLabel);
                text.setCurrentValueAsDefault(9015);
            }
            if (axisFormat != null && !(text = (TextAttrib)axis.getLabel()).hasUserSetValue(9015)) {
                axis.setValues(axisFormat);
                text.setCurrentValueAsDefault(9008);
            }
            if (integerAxis instanceof Boolean) {
                ((SILK3DAxis)axis).setForceIntegerValues((Boolean)integerAxis);
            } else {
                ((SILK3DAxis)axis).setForceIntegerValues(false);
            }
            ((SILK3DAxis)axis).setFireEvents(true);
        }
    }

    public void paintComponent(Graphics g) {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.legendUpdateRequired() && this.buildSuccess) {
            this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
            this.drawChannel();
        }
        if (this.isUsingBackBuffer()) {
            if (this.backBuffer == null) {
                this.buildBackBuffer();
            }
            Graphics2D g3 = (Graphics2D)this.backBuffer.getGraphics();
            this.drawChart(g3);
            g.drawImage(this.backBuffer, 0, 0, null);
        } else {
            this.drawChart(g2);
        }
        this.graphLayout.drawHighlight((Graphics)g2);
        this.brush.draw((Graphics)g2);
        if (this.silkAnno != null) {
            this.silkAnno.draw(g2);
        }
    }

    private void buildBackBuffer() {
        if (this.compWidth <= 0 || this.compHeight <= 0 || !this.isUsingBackBuffer()) {
            return;
        }
        if (this.backBuffer == null) {
            this.backBuffer = new BufferedImage(this.compWidth, this.compHeight, 1);
        }
    }

    private void drawChart(Graphics2D g) {
        if (this.buildSuccess) {
            Rectangle rectangle = new Rectangle(0, 0, this.compWidth, this.compHeight);
            this.background.drawBackground(g, (Component)((Object)this), rectangle);
            this.channel.glRefresh((Graphics)g);
            this.graphLayout.draw((Graphics)g);
        } else {
            this.drawErrorMessage(g);
        }
    }

    private void drawSelectionRectangle(Graphics2D g) {
        if (this.selectionRect != null && !this.selectionRect.isEmpty()) {
            g.setColor(Color.black);
            g.draw(this.selectionRect);
        }
    }

    public void doResize(int compWidthIn, int compHeightIn) {
        super.doResize(compWidthIn, compHeightIn);
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        this.brush.invalidateBrush();
        this.buildAndDraw();
    }

    public void addNotify() {
        super.addNotify();
        this.initAxesFromSource(this.primary);
        this.buildAndDraw(Boolean.TRUE, null, null);
    }

    public void redraw(RedrawEvent e) {
        this.buildAndDraw();
    }

    public void boundingBoxChanged(RedrawEvent e) {
    }

    public void outerMarginChanged(RedrawEvent e) {
    }

    public Object getLegendPosition(Object which) {
        LegendInterface legend = this.getLegend(which);
        if (legend == null) {
            return null;
        }
        int pos = legend.getPosition();
        return legend.getLegendNumber(pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setLegendPosition(Object which, Object positionIn) {
        LegendInterface legend = this.getLegend(which);
        if (legend == null) {
            return false;
        }
        int pos = -1;
        if (positionIn instanceof String) {
            String s = (String)positionIn;
            if (s.equalsIgnoreCase("North")) {
                pos = 1;
            } else if (s.equalsIgnoreCase("South")) {
                pos = 2;
            } else if (s.equalsIgnoreCase("East")) {
                pos = 3;
            } else {
                if (!s.equalsIgnoreCase("West")) return false;
                pos = 4;
            }
        } else {
            if (!(positionIn instanceof Number)) return false;
            pos = ((Number)positionIn).intValue();
        }
        legend.setPosition(pos);
        this.buildAndDraw(null, null, null);
        return true;
    }

    protected LegendObjectJ2D getCurrentLegend() {
        if (this.charts == null || this.charts.size() == 0 || this.legends == null || this.legends.isEmpty()) {
            return null;
        }
        if (this.charts.size() == 1) {
            SILK3DChart chart = (SILK3DChart)this.charts.elementAt(0);
            Object name = chart.getPropertyValue(23);
            if (name == null || !this.legends.containsKey(name)) {
                return null;
            }
            return (LegendObjectJ2D)this.legends.get(name);
        }
        return null;
    }

    public Object[] getDataIds() {
        if (this.charts == null || this.charts.size() < 2) {
            return null;
        }
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < this.charts.size(); ++i) {
            Object id = ((SILK3DChart)this.charts.elementAt(i)).getId();
            if (id == null) {
                id = "Chart" + i;
            }
            v.addElement(id);
        }
        return v.toArray();
    }

    public Object getDataSource(Object id) {
        SILK3DChart chart = (SILK3DChart)this.getChart(id);
        if (chart == null || chart.getDataSource() == null) {
            return super.getDataSource(id);
        }
        return chart.getDataSource();
    }

    public boolean setDataSource(Object source, Object id) {
        SILK3DChart chart;
        boolean rc = super.setDataSource(source, id);
        for (DataFilterReadInterface f : this.brush.getFilters()) {
            this.brush.removeFilter(f);
        }
        this.brush.addFilter(this.dataFilter);
        if (rc) {
            this.axes.resetAxisSet();
        }
        for (int i = 0; i < this.charts.size() && rc; rc &= chart.setDataSource(source, id), ++i) {
            chart = (SILK3DChart)this.charts.elementAt(i);
            chart.resetDataRanges();
        }
        return rc;
    }

    public Object getRole(Object variableId) {
        SILK3DChart chart;
        if (variableId == null) {
            return null;
        }
        String var = variableId.toString();
        if (RoleManager.isTwoLevelName((String)var) && (chart = (SILK3DChart)this.getChart(RoleManager.getDataIdFromTwoLevelName((String)var))) != null) {
            return chart.getRole(RoleManager.getVariableIdFromTwoLevelName((String)var));
        }
        return super.getRole(variableId);
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        if (id != null && this.charts.size() > 1) {
            SILK3DChart chart = (SILK3DChart)this.getChart(id);
            if (chart == null) {
                return null;
            }
            return chart.getSupportedRoles(id, discrete);
        }
        if (this.primary != null) {
            return this.primary.getSupportedRoles(id, discrete);
        }
        if (this.roles != null) {
            return this.roles.getSupportedRoles(id, discrete);
        }
        return null;
    }

    public void roleChanged(RoleEvent e) {
        if (e.type != 4 && e.type != 5) {
            this.buildSuccess = false;
            TextStyleInterface text = null;
            if (this.isAxisRole(new Integer(e.role), "X") && this.getAxis("X") != null) {
                text = this.getAxis("X").getLabel();
            } else if (this.isAxisRole(new Integer(e.role), "Y") && this.getAxis("Y") != null) {
                text = this.getAxis("Y").getLabel();
            } else if (this.isAxisRole(new Integer(e.role), "Z") && this.getAxis("Z") != null) {
                text = this.getAxis("Z").getLabel();
            }
            if (text instanceof TextAttrib) {
                ((TextAttrib)text).setCurrentValueAsDefault(9015);
            }
            this.axes.resetAxisSet();
            this.initAxesFromSource(this.primary);
            this.resetComponent();
        }
        super.roleChanged(e);
        this.buildAndDraw();
    }

    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        boolean rc = super.applyWhereClause(clause, clearPrevious);
        this.holdBuild = true;
        for (int i = 0; i < this.charts.size(); ++i) {
            rc &= ((SILK3DChart)this.charts.elementAt(i)).applyWhereClause(clause, clearPrevious);
        }
        this.initAxesFromSource(this.primary);
        this.holdBuild = false;
        this.view.setZoom(Double.NaN);
        if (this.projection == 0) {
            this.view.setFocalPoint(this.defaultObliqueFocalPoint);
        } else {
            this.view.setFocalPoint(this.defaultPerspectiveFocalPoint);
        }
        this.buildAndDraw();
        return rc;
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 23: 
            case 27: 
            case 39: 
            case 44: 
            case 45: 
            case 46: {
                break;
            }
            case 26: {
                if (!(value instanceof Boolean) || this.axes == null) break;
                this.axes.setWallsVisible((Boolean)value);
                this.userSetProperties.set(26);
                break;
            }
            case 10200: {
                this.setProjection(value);
                break;
            }
            case 10202: {
                if (!(value instanceof Double)) break;
                this.setRotation((Double)value);
                break;
            }
            case 10203: {
                if (!(value instanceof Double)) break;
                this.setTilt((Double)value);
                break;
            }
            case 10204: {
                if (!(value instanceof Double)) break;
                this.setZoom((Double)value);
                break;
            }
            case 10205: {
                if (!(value instanceof Vec3d)) break;
                this.setFocalPoint((Vec3d)value);
                break;
            }
            case 10206: {
                if (!(value instanceof Boolean)) break;
                this.setCartesian((Boolean)value);
                break;
            }
            case 10207: {
                if (!(value instanceof Vec3d)) break;
                this.setCartesianOrigin((Vec3d)value);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    public boolean applyPropertyChanges(Object source) {
        boolean rc = false;
        this.holdBuild = true;
        if (this.charts != null) {
            for (int i = 0; i < this.charts.size(); ++i) {
                rc = ((SILK3DChart)this.charts.elementAt(i)).applyPropertyChanges(source) || rc;
            }
        }
        if (this.legends != null) {
            Enumeration e = this.legends.elements();
            while (e.hasMoreElements()) {
                LegendObjectJ2D legend = (LegendObjectJ2D)e.nextElement();
                rc = legend.applyPropertyChanges(source) || rc;
            }
        }
        SILK3DAxis axis = null;
        axis = this.getAxisObject("X");
        if (axis != null) {
            boolean bl = rc = axis.applyPropertyChanges(source) || rc;
        }
        if ((axis = this.getAxisObject("Y")) != null) {
            boolean bl = rc = axis.applyPropertyChanges(source) || rc;
        }
        if ((axis = this.getAxisObject("Z")) != null) {
            rc = axis.applyPropertyChanges(source) || rc;
        }
        rc = super.applyPropertyChanges(source) || rc;
        this.holdBuild = false;
        if (rc) {
            this.buildAndDraw();
        }
        return rc;
    }

    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        Object[] rc = null;
        LegendObjectJ2D legend = this.getCurrentLegend();
        if (legend != null && legend.isPropertySupported(id)) {
            rc = legend.getPropertyValue(id);
        } else if (this.charts != null) {
            boolean found = false;
            for (int i = 0; i < this.charts.size(); ++i) {
                SILK3DChart chart = (SILK3DChart)this.charts.elementAt(i);
                if (chart == null || !chart.isPropertySupported(id)) continue;
                rc = chart.getPropertyValue(id);
                found = true;
                break;
            }
            if (!found) {
                switch (id) {
                    case 46: {
                        rc = new Object[]{this.getAxis("X"), this.getAxis("Y"), this.getAxis("Z")};
                        break;
                    }
                    case 44: {
                        rc = new Object[]{"X", "Y", "Z"};
                        break;
                    }
                    case 238: {
                        rc = this.getCurrentAxisObject();
                        break;
                    }
                    case 45: {
                        rc = new Object[]{ResourceLoader.getResourceString((Object)this.rb, (String)"SILK3DComponent.AxisDisplayNameX.txt", (String)"X"), ResourceLoader.getResourceString((Object)this.rb, (String)"SILK3DComponent.AxisDisplayNameY.txt", (String)"Y"), ResourceLoader.getResourceString((Object)this.rb, (String)"SILK3DComponent.AxisDisplayNameZ.txt", (String)"Z")};
                        break;
                    }
                    case 39: {
                        rc = Boolean.TRUE;
                        break;
                    }
                    case 27: {
                        rc = Boolean.TRUE;
                        break;
                    }
                    case 26: {
                        if (this.axes != null) {
                            rc = new Boolean(this.axes.areWallsVisible());
                            break;
                        }
                        rc = Boolean.FALSE;
                        break;
                    }
                    case 10200: {
                        rc = this.getProjection();
                        break;
                    }
                    case 10201: {
                        rc = this.projectionList;
                        break;
                    }
                    case 439: {
                        rc = ResourceLoader.getResourceString((Object)this.rb, (String)"SILK3DComponent.Overlay.txt", (String)"Overlay");
                        break;
                    }
                    case 10202: {
                        if (this.view == null) break;
                        rc = new Double(this.view.getRotation());
                        break;
                    }
                    case 10203: {
                        if (this.view == null) break;
                        rc = new Double(this.view.getTilt());
                        break;
                    }
                    case 10204: {
                        if (this.view == null) break;
                        rc = new Double(this.view.getZoom());
                        break;
                    }
                    case 10205: {
                        if (this.view == null) break;
                        rc = this.view.getFocalPoint();
                        break;
                    }
                    case 10206: {
                        rc = new Boolean(this.getCartesian());
                        break;
                    }
                    case 10207: {
                        rc = this.getCartesianOrigin();
                        break;
                    }
                    default: {
                        SILK3DAxis axis;
                        if (id >= 200 && id <= 300 && (axis = this.getCurrentAxisObject()) != null) {
                            return axis.getPropertyValue(id);
                        }
                        rc = super.getPropertyValue(id);
                    }
                }
            }
        }
        return rc;
    }

    public boolean isPropertySupported(int id) {
        LegendObjectJ2D leg = this.getCurrentLegend();
        if (leg != null && leg.isPropertySupported(id)) {
            return true;
        }
        if (this.charts != null) {
            for (int i = 0; i < this.charts.size(); ++i) {
                SILK3DChart chart = (SILK3DChart)this.charts.elementAt(i);
                if (chart == null || !chart.isPropertySupported(id)) continue;
                return true;
            }
        }
        switch (id) {
            case 23: 
            case 26: 
            case 27: 
            case 39: 
            case 44: 
            case 45: 
            case 46: 
            case 10200: 
            case 10201: 
            case 10202: 
            case 10203: 
            case 10204: 
            case 10205: 
            case 10206: 
            case 10207: {
                return true;
            }
        }
        return super.isPropertySupported(id);
    }

    public boolean setPropertyValue(int id, Object value) {
        SILK3DAxis axis;
        boolean rc = false;
        if (id == 238) {
            Object v = value;
            if (value != null && value instanceof PropertyEvent) {
                v = ((PropertyEvent)value).value;
            }
            if (v != null && v instanceof Number) {
                int curAxis = ((Number)v).intValue();
                switch (curAxis) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.currentAxis = curAxis;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } else if (v instanceof String) {
                if ("X".equalsIgnoreCase(v.toString())) {
                    this.currentAxis = 0;
                } else if ("Y".equalsIgnoreCase(v.toString())) {
                    this.currentAxis = 1;
                } else if ("Z".equalsIgnoreCase(v.toString())) {
                    this.currentAxis = 2;
                }
            }
        }
        if (id >= 200 && id <= 300 && (axis = this.getCurrentAxisObject()) != null) {
            return axis.setPropertyValue(id, value);
        }
        LegendObjectJ2D legend = this.getCurrentLegend();
        if (legend != null && legend.isPropertySupported(id)) {
            legend.setPropertyValue(id, value);
        } else if (this.charts != null) {
            for (int i = 0; i < this.charts.size(); ++i) {
                SILK3DChart chart = (SILK3DChart)this.charts.elementAt(i);
                if (chart == null || !chart.isPropertySupported(id)) continue;
                chart.setPropertyValue(id, value);
            }
        }
        rc = super.setPropertyValue(id, value);
        return rc;
    }

    public void cancelPropertyChanges(Object source) {
        LegendObjectJ2D legend = this.getCurrentLegend();
        if (legend != null) {
            legend.cancelPropertyChanges(source);
        }
        if (this.charts != null) {
            for (int i = 0; i < this.charts.size(); ++i) {
                SILK3DChart chart = (SILK3DChart)this.charts.elementAt(i);
                if (chart == null) continue;
                chart.cancelPropertyChanges(source);
            }
        }
        super.cancelPropertyChanges(source);
    }

    public int[] getPendingChanges(Object source) {
        LegendObjectJ2D legend;
        int[] pendingList = super.getPendingChanges(source);
        Vector<Integer> v = new Vector<Integer>();
        if (pendingList != null && pendingList.length > 0) {
            for (int i = 0; i < pendingList.length; ++i) {
                v.add(new Integer(pendingList[i]));
            }
        }
        if ((legend = this.getCurrentLegend()) != null) {
            this.addPendingChanges((PropertyInterface)legend, source, v);
        }
        if (this.charts != null) {
            for (int i = 0; i < this.charts.size(); ++i) {
                this.addPendingChanges((SILK3DChart)this.charts.elementAt(i), source, v);
            }
        }
        this.addPendingChanges(this.getAxisObject("X"), source, v);
        this.addPendingChanges(this.getAxisObject("Y"), source, v);
        this.addPendingChanges(this.getAxisObject("Z"), source, v);
        int[] pending = null;
        if (v.size() > 0) {
            pending = new int[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                pending[i] = ((Number)v.elementAt(i)).intValue();
            }
        }
        return pending;
    }

    public boolean hasUserSetValue(int id) {
        for (int i = 0; i < this.charts.size(); ++i) {
            SILK3DChart chart = (SILK3DChart)this.charts.elementAt(i);
            if (!chart.isPropertySupported(id)) continue;
            return chart.hasUserSetValue(id);
        }
        return super.hasUserSetValue(id);
    }

    public void textUpdated(DvrTextEvent evt) {
        super.textUpdated(evt);
        this.buildAndDraw();
    }

    protected void buildDataDialog() {
        if (this.dataDlg != null) {
            return;
        }
        this.createDataDialog(this);
        for (int i = 0; i < this.charts.size(); ++i) {
            this.dataDlg.addChart((RoleInterface)this.charts.elementAt(i));
        }
    }

    protected void buildPropertiesDialog(Object listner) {
        if (this.propertiesDialog == null) {
            this.createPropertyDialog(listner);
            this.propertiesDialog.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"SILK3DComponent.Properties.txt", (String)"Properties"));
        }
        this.addTabs("Properties", (Dialog)this.propertiesDialog, 999, listner);
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        if (id == null || dialogIn == null) {
            return false;
        }
        SILK3DComponent pi = this;
        if (listener != null && listener instanceof PropertyInterface) {
            pi = (PropertyInterface)listener;
        }
        if (id.equals("Properties")) {
            if (dialogIn instanceof TabbedPropertiesDialog) {
                boolean graph = false;
                boolean titles = false;
                boolean axes = false;
                boolean legend = false;
                boolean chart = false;
                switch (category) {
                    case 0: {
                        graph = true;
                        break;
                    }
                    case 1: {
                        chart = true;
                        break;
                    }
                    case 2: {
                        axes = true;
                        break;
                    }
                    case 4: {
                        titles = true;
                        break;
                    }
                    case 3: {
                        legend = true;
                        break;
                    }
                    case 999: {
                        titles = true;
                        legend = true;
                        axes = true;
                        chart = true;
                        graph = true;
                    }
                }
                TabbedPropertiesDialog tpd = (TabbedPropertiesDialog)dialogIn;
                TabPanelInterface tpi = null;
                if (graph) {
                    super.addTabs(id, dialogIn, 0, listener);
                }
                if (chart) {
                    SILK3DChart cht = this.getChart();
                    cht.addTabs(id, dialogIn, 1, listener);
                }
                if (axes) {
                    tpi = tpd.getTab(AxisPanel.class);
                    if (tpi != null) {
                        tpi.addPropertyListener((PropertyInterface)pi);
                    } else {
                        AxisPanel ap = new AxisPanel();
                        ap.addPropertyListener((PropertyInterface)pi);
                        tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"SILK3DComponent.AxisPanelTitle.txt", (String)"Axis"), (TabPanelInterface)ap);
                    }
                }
                if (legend) {
                    tpi = tpd.getTab(LegendPanel.class);
                    if (tpi != null) {
                        tpi.addPropertyListener((PropertyInterface)pi);
                    } else {
                        tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"SILK3DComponent.LegendPanelTitle.txt", (String)"Legend"), (TabPanelInterface)new LegendPanel((PropertyInterface)pi));
                    }
                }
                if (titles) {
                    super.addTabs(id, dialogIn, 4, listener);
                }
            } else if (dialogIn instanceof GraphPropertiesDialog) {
                SILK3DChart cht;
                boolean graph = false;
                boolean titles = false;
                boolean axes = false;
                boolean legend = false;
                boolean chart = false;
                switch (category) {
                    case 0: {
                        graph = true;
                        break;
                    }
                    case 1: {
                        chart = true;
                        break;
                    }
                    case 2: {
                        axes = true;
                        break;
                    }
                    case 4: {
                        titles = true;
                        break;
                    }
                    case 3: {
                        legend = true;
                        break;
                    }
                    case 999: {
                        titles = true;
                        legend = true;
                        axes = true;
                        chart = true;
                        graph = true;
                    }
                }
                GraphPropertiesDialog gpd = (GraphPropertiesDialog)dialogIn;
                if (graph) {
                    super.addTabs(id, dialogIn, 0, listener);
                }
                if (chart && (cht = this.getChart()) != null) {
                    cht.addTabs(id, dialogIn, 1, listener);
                }
                if (axes) {
                    gpd.updateAxesPanels((PropertyInterface)this, listener == this ? null : listener);
                }
                if (legend) {
                    gpd.updateLegendPanels((PropertyInterface)this, listener == this ? null : listener);
                }
                if (titles) {
                    super.addTabs(id, dialogIn, 4, listener);
                }
            }
        }
        return false;
    }

    protected void updateView() {
        if (this.axes != null) {
            if (this.axes.isPerspective()) {
                boolean fpSet = this.isFocalPointSet();
                if (Double.isNaN(this.view.getZoom()) || !fpSet) {
                    double[] defView = this.axes.getView(this.view.getRotation(), this.view.getTilt());
                    if (Double.isNaN(this.view.getZoom())) {
                        this.view.setZoom(defView[2]);
                    }
                    if (!fpSet) {
                        this.view.setFocalPoint(this.axes.getAxisSet().getBoundingBox().getCenter());
                    }
                    this.axes.updateView(this.view.getRotation(), this.view.getTilt(), this.view.getZoom(), this.view.getFocalPoint());
                } else {
                    this.axes.updateView(this.view.getRotation(), this.view.getTilt(), this.view.getZoom(), this.view.getFocalPoint());
                }
            } else {
                this.axes.updateView(this.view.getRotation(), this.view.getFocalPoint());
            }
        }
    }

    private boolean isFocalPointSet() {
        if (this.view == null) {
            return false;
        }
        Vec3d fp = this.view.getFocalPoint();
        return fp != null && !Double.isNaN(fp.x) && !Double.isNaN(fp.y) && !Double.isNaN(fp.z);
    }

    public boolean resetComponent() {
        if (this.projection == 1) {
            this.view.setRotation(35.0);
            this.view.setFocalPoint(this.defaultPerspectiveFocalPoint);
        } else {
            this.view.setRotation(150.0);
            this.view.setFocalPoint(this.defaultObliqueFocalPoint);
        }
        this.view.setTilt(-30.0);
        this.view.setZoom(Double.NaN);
        this.userSetProperties.clear(10202);
        this.userSetProperties.clear(10203);
        this.userSetProperties.clear(10204);
        this.userSetProperties.clear(10205);
        this.draw(this.buildSuccess);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setProjection(Object projectionType) {
        JMenuItem zoomItem;
        boolean perspective;
        int oldProjection = this.projection;
        if (projectionType instanceof Number) {
            int i = ((Number)projectionType).intValue();
            if (i != 0 && i != 1) return false;
            this.projection = i;
        } else {
            if (!(projectionType instanceof String)) return false;
            String s = (String)projectionType;
            if (s.equalsIgnoreCase("oblique") || s.equalsIgnoreCase(this.projectionList[0])) {
                this.projection = 0;
            } else if (s.equalsIgnoreCase("perspective") || s.equalsIgnoreCase(this.projectionList[1])) {
                this.projection = 1;
            }
        }
        if (oldProjection == this.projection) {
            return true;
        }
        this.userSetProperties.set(10200);
        boolean bl = perspective = this.projection == 1;
        if (this.axes != null) {
            this.enableLights(perspective);
            this.axes.setPerspective(perspective);
        }
        if ((zoomItem = MenuUtilities.getMenuItem((JPopupMenu)this.menu, (String)"ACTION_MODE_GEOMETRIC_ZOOM")) != null) {
            if (perspective) {
                zoomItem.setEnabled(true);
            } else {
                if (zoomItem.isSelected()) {
                    MenuUtilities.setMenuItemSelected((JPopupMenu)this.menu, (String)"ACTION_MODE_SELECT", (boolean)true);
                    MenuUtilities.setMenuItemSelected((JPopupMenu)this.menu, (String)"ACTION_MODE_NONE", (boolean)true);
                }
                zoomItem.setEnabled(false);
            }
        }
        this.resetComponent();
        return true;
    }

    public Object getProjection() {
        return new SILKNumber(this.projection, this.projectionList[this.projection], this.englishProjectionList[this.projection]);
    }

    public void setView(double tilt, double rotation, double zoom) {
        if (this.view == null) {
            return;
        }
        this.view.setTilt(tilt);
        this.userSetProperties.set(10203);
        this.view.setRotation(rotation);
        this.userSetProperties.set(10202);
        this.view.setZoom(zoom);
        this.userSetProperties.set(10204);
        this.buildAndDraw();
        if (this.brush != null) {
            this.brush.invalidateBrush();
        }
    }

    public void setView(double tilt, double rotation) {
        if (this.view == null) {
            return;
        }
        this.view.setTilt(tilt);
        this.userSetProperties.set(10203);
        this.view.setRotation(rotation);
        this.userSetProperties.set(10202);
        this.buildAndDraw();
        if (this.brush != null) {
            this.brush.invalidateBrush();
        }
    }

    public void setTilt(double tilt) {
        if (this.view == null || tilt == this.view.getTilt()) {
            return;
        }
        this.view.setTilt(tilt);
        this.userSetProperties.set(10203);
        this.buildAndDraw();
    }

    public double getTilt() {
        if (this.view != null) {
            return this.view.getTilt();
        }
        return 0.0;
    }

    public void setRotation(double rotation) {
        if (this.view == null || rotation == this.view.getRotation()) {
            return;
        }
        this.view.setRotation(rotation);
        this.userSetProperties.set(10202);
        this.buildAndDraw();
    }

    public double getRotation() {
        if (this.view != null) {
            return this.view.getRotation();
        }
        return 0.0;
    }

    public void setZoom(double zoom) {
        if (this.view == null || zoom == this.view.getZoom()) {
            return;
        }
        this.view.setZoom(zoom);
        this.userSetProperties.set(10204);
        this.buildAndDraw();
    }

    public double getZoom() {
        if (this.view != null) {
            return this.view.getZoom();
        }
        return 0.0;
    }

    private void setFocalPoint(Vec3d vec) {
        if (this.view == null || vec == null || vec.equals((Object)this.view.getFocalPoint())) {
            return;
        }
        this.view.setFocalPoint(vec);
        this.userSetProperties.set(10205);
    }

    protected void startUserNavigate() {
        this.userNavigating = true;
        for (int i = 0; i < this.charts.size(); ++i) {
            SILK3DChart chart = (SILK3DChart)this.charts.elementAt(i);
            if (!chart.getWireframeRotate()) continue;
            chart.setWireframe(true);
        }
    }

    protected void endUserNavigate() {
        this.userNavigating = false;
        for (int i = 0; i < this.charts.size(); ++i) {
            SILK3DChart chart = (SILK3DChart)this.charts.elementAt(i);
            if (!chart.getWireframeRotate()) continue;
            chart.setWireframe(false);
        }
    }

    protected boolean mouseInLegend(Point p) {
        if (this.legends == null) {
            return false;
        }
        Enumeration e = this.legends.elements();
        while (e.hasMoreElements()) {
            if (!((LegendObjectJ2D)e.nextElement()).isPointInLegend(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (!this.buildSuccess) {
            return;
        }
        if (this.mouseInLegend(e.getPoint())) {
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (this.mouseInLegend(e.getPoint())) {
            this.clickedOnLegend = true;
            return;
        }
        this.lastXInt = e.getX();
        this.lastYInt = e.getY();
        this.invertRotate = this.view.getTilt() >= 90.0 && this.view.getTilt() < 270.0;
        int rotateMask = 18;
        int zoomMask = 17;
        int panMask = 19;
        int defaultMask = 16;
        JPopupMenu menu = this.getPopupMenu();
        if (menu != null && (e.getModifiers() & 4) != 0 && this.allowPopup) {
            this.useDefaultActionMode = false;
            menu.show((Component)((Object)((SILK3DComponent)e.getSource())), this.lastXInt, this.lastYInt);
            this.repaint();
        } else if ((e.getModifiers() & panMask) == panMask) {
            this.forcePan = true;
            this.useDefaultActionMode = false;
        } else if ((e.getModifiers() & rotateMask) == rotateMask) {
            this.forceRotate = true;
            this.useDefaultActionMode = false;
        } else if ((e.getModifiers() & zoomMask) == zoomMask) {
            this.forceZoom = true;
            this.useDefaultActionMode = false;
        } else if ((e.getModifiers() & defaultMask) == defaultMask) {
            this.useDefaultActionMode = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.clickedOnLegend) {
            this.clickedOnLegend = false;
            return;
        }
        if (!this.buildSuccess) {
            this.forceRotate = false;
            this.forceZoom = false;
            this.forcePan = false;
            this.isSelecting = false;
            this.useDefaultActionMode = true;
            return;
        }
        if (this.userNavigating) {
            this.endUserNavigate();
        }
        this.forceRotate = false;
        this.forceZoom = false;
        this.forcePan = false;
        this.useDefaultActionMode = true;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        if (this.clickedOnLegend) {
            return;
        }
        if (!this.buildSuccess) {
            return;
        }
        double az = 0.0;
        double incl = 0.0;
        double angleScaleFactor = 0.5;
        int dragMode = 0;
        if (this.forceRotate) {
            dragMode = 12;
        } else if (this.forcePan) {
            dragMode = 11;
        } else if (this.forceZoom) {
            dragMode = 10;
        } else if (this.useDefaultActionMode) {
            dragMode = this.actionMode;
        }
        switch (dragMode) {
            case 12: {
                this.tipText = null;
                int dx = e.getX() - this.lastXInt;
                int dy = e.getY() - this.lastYInt;
                if (this.projection == 1) {
                    az = this.invertRotate ? this.view.getRotation() + (double)dx * 0.5 : this.view.getRotation() - (double)dx * 0.5;
                    incl = this.view.getTilt() - (double)dy * 0.5;
                    this.view.setRotation(az);
                    this.userSetProperties.set(10202);
                    this.view.setTilt(incl);
                    this.userSetProperties.set(10203);
                } else {
                    az = this.view.getRotation() + (double)dx * 0.5;
                    this.view.setRotation(az);
                    this.userSetProperties.set(10202);
                }
                if (!this.userNavigating) {
                    this.startUserNavigate();
                }
                this.lastXInt = e.getX();
                this.lastYInt = e.getY();
                this.draw(true);
                break;
            }
            case 10: {
                if (this.projection == 0) {
                    return;
                }
                this.tipText = null;
                int dx = e.getX() - this.lastXInt;
                int dy = e.getY() - this.lastYInt;
                double dist = this.view.getZoom() + (double)dy / 100.0;
                this.view.setZoom(dist);
                this.userSetProperties.set(10204);
                if (!this.userNavigating) {
                    this.startUserNavigate();
                }
                this.lastXInt = e.getX();
                this.lastYInt = e.getY();
                this.draw(true);
                break;
            }
            case 11: {
                this.tipText = null;
                int dx = e.getX() - this.lastXInt;
                int dy = e.getY() - this.lastYInt;
                if (this.axes.isPerspective()) {
                    double azimuth = this.view.getRotation() * Math.PI / 180.0;
                    double inclination = this.view.getTilt() * Math.PI / 180.0;
                    Vec3d xVec = new Vec3d(Math.cos(azimuth), 0.0, -Math.sin(azimuth));
                    Vec3d yVec = new Vec3d(Math.sin(inclination) * Math.sin(azimuth), Math.cos(inclination), Math.sin(inclination) * Math.cos(azimuth));
                    xVec.scale((double)dx / 100.0);
                    yVec.scale((double)dy / 100.0);
                    Vec3d focal = this.view.getFocalPoint();
                    focal.subtract(xVec);
                    focal.add(yVec);
                    this.view.setFocalPoint(focal);
                } else {
                    Vec3d bboxSize = this.axes.getAxisSet().getBoundingBox().getSize();
                    Vec3d focal = this.view.getFocalPoint();
                    focal.x -= (double)dx * bboxSize.x / (double)this.getWidth();
                    focal.y += (double)dy * bboxSize.y / (double)this.getHeight();
                    this.view.setFocalPoint(focal);
                }
                this.userSetProperties.set(10205);
                if (!this.userNavigating) {
                    this.startUserNavigate();
                }
                this.lastXInt = e.getX();
                this.lastYInt = e.getY();
                this.draw(true);
                break;
            }
            case 6: 
            case 14: {
                this.repaint();
            }
        }
    }

    public void rangeChanged(RangeChangedEvent e) {
        if (e == null || e.getSource() == this) {
            return;
        }
        switch (e.getDimension()) {
            case 1: {
                this.setRange((byte)1, e.getType(), this.getRange(this.getXAxisRoles()));
                break;
            }
            case 2: {
                this.setRange((byte)2, e.getType(), this.getRange(this.getYAxisRoles()));
                break;
            }
            case 3: {
                this.setRange((byte)3, e.getType(), this.getRange(this.getZAxisRoles()));
            }
        }
    }

    public void layerChanged(LayerChangedEvent lce) {
        if (lce == null) {
            return;
        }
        if (lce.getAction() == 3) {
            this.build(Boolean.TRUE);
        } else if (lce.getAction() == 4) {
            this.buildLegends();
        } else if (lce.getAction() == 6 && this.legends != null) {
            Object legend = lce.getBuildData();
            LegendObjectJ2D leg = (LegendObjectJ2D)this.legends.get(legend);
            if (leg != null) {
                for (int i = 0; i < this.charts.size(); ++i) {
                    SILK3DChart chart = (SILK3DChart)this.charts.elementAt(i);
                    Object oldCurrentLegend = chart.getPropertyValue(23);
                    chart.setPropertyValue(23, legend);
                    Object title = chart.getPropertyValue(426);
                    if (title != null) {
                        leg.setTitle((Object)title.toString());
                    }
                    chart.setPropertyValue(23, oldCurrentLegend);
                }
            }
        } else if (lce.getAction() == 9 && lce.getSource() instanceof SILK3DChart) {
            this.brush.addFilter(((BaseElement)lce.getSource()).getFilter());
        }
    }

    protected boolean isAxisRole(Object role, String type) {
        Object[] zAxisRoles;
        Object[] yAxisRoles;
        int i;
        Object[] xAxisRoles;
        ArrayList<Object> arrays = new ArrayList<Object>();
        if ((type.equalsIgnoreCase("ANY") || type.equalsIgnoreCase("X")) && (xAxisRoles = this.getXAxisRoles()) != null) {
            for (i = 0; i < xAxisRoles.length; ++i) {
                arrays.add(xAxisRoles[i]);
            }
        }
        if ((type.equalsIgnoreCase("ANY") || type.equalsIgnoreCase("Y")) && (yAxisRoles = this.getYAxisRoles()) != null) {
            for (i = 0; i < yAxisRoles.length; ++i) {
                arrays.add(yAxisRoles[i]);
            }
        }
        if ((type.equalsIgnoreCase("ANY") || type.equalsIgnoreCase("Z")) && (zAxisRoles = this.getZAxisRoles()) != null) {
            for (i = 0; i < zAxisRoles.length; ++i) {
                arrays.add(zAxisRoles[i]);
            }
        }
        for (int i2 = 0; i2 < arrays.size(); ++i2) {
            Object r = arrays.get(i2);
            if (r == null || !r.equals(role)) continue;
            return true;
        }
        return false;
    }

    protected Object[] getXAxisRoles() {
        Vector rc = new Vector();
        for (int i = 0; i < this.charts.size(); ++i) {
            SILK3DChart chart = (SILK3DChart)this.charts.elementAt(i);
            Enumeration e = Extract.elements((Object)chart.getPropertyValue(10109));
            if (e == null) continue;
            while (e.hasMoreElements()) {
                rc.addElement(e.nextElement());
            }
        }
        return rc.toArray();
    }

    protected Object[] getYAxisRoles() {
        Vector rc = new Vector();
        for (int i = 0; i < this.charts.size(); ++i) {
            SILK3DChart chart = (SILK3DChart)this.charts.elementAt(i);
            Enumeration e = Extract.elements((Object)chart.getPropertyValue(10110));
            if (e == null) continue;
            while (e.hasMoreElements()) {
                rc.addElement(e.nextElement());
            }
        }
        return rc.toArray();
    }

    protected Object[] getZAxisRoles() {
        Vector rc = new Vector();
        for (int i = 0; i < this.charts.size(); ++i) {
            SILK3DChart chart = (SILK3DChart)this.charts.elementAt(i);
            Enumeration e = Extract.elements((Object)chart.getPropertyValue(10111));
            if (e == null) continue;
            while (e.hasMoreElements()) {
                rc.addElement(e.nextElement());
            }
        }
        return rc.toArray();
    }

    protected static DataRange mergeRange(DataRange range1, DataRange range2) {
        DiscreteRange mergedRange = null;
        if (range1 == null) {
            return range2;
        }
        if (range2 == null) {
            return range1;
        }
        if (range1 instanceof DiscreteRange && range2 instanceof DiscreteRange) {
            mergedRange = new DiscreteRange();
            mergedRange.union(range1);
            mergedRange.union(range2);
        } else if (range1 instanceof ContinuousRange && range2 instanceof ContinuousRange) {
            ContinuousRange r1 = (ContinuousRange)range1;
            ContinuousRange r2 = (ContinuousRange)range2;
            mergedRange = new ContinuousRange(Math.min(r1.getMin(), r2.getMin()), Math.max(r1.getMax(), r2.getMax()));
        }
        return mergedRange;
    }

    protected DataRange getRange(Object which) {
        if (which == null) {
            return null;
        }
        DataRange defaultRange = null;
        for (int i = 0; i < this.charts.size(); ++i) {
            SILK3DChart chart = (SILK3DChart)this.charts.elementAt(i);
            DataRange chartRange = chart.getPreferredRange(which);
            if (chartRange == null) continue;
            defaultRange = SILK3DComponent.mergeRange(defaultRange, chartRange);
        }
        return defaultRange;
    }

    public boolean getAxesVisible() {
        return true;
    }

    public int getNumRanges(byte dim) {
        return 1;
    }

    public DataRangeInterface getRangeSource(byte dim, int index) {
        return this;
    }

    public void setAxesVisible(boolean axesVisible) {
    }

    public void setRange(byte dim, int index, DataRange range) {
        if (range == null) {
            return;
        }
        this.axes.setRange(dim, index, range);
        DataRange newRange = this.getRangeSource(dim, index).getDataRange(dim);
        for (int i = 0; i < this.charts.size(); ++i) {
            ((SILK3DChart)this.charts.elementAt(i)).setRange(dim, index, newRange);
            ((SILK3DChart)this.charts.elementAt(i)).shareMap(this.axes, dim);
        }
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 3, newRange, dim));
    }

    public boolean getMarginsAligned() {
        return true;
    }

    public void disableMarginPrefCalc() {
    }

    public void enableMarginPrefCalc() {
    }

    public Insets getInnerMargin() {
        return this.innerMargin;
    }

    public Insets getOuterMargin() {
        return this.outerMargin;
    }

    public Insets getPreferredInnerMargin() {
        return this.prefInnerMargin;
    }

    public Insets getPreferredOuterMargin() {
        return this.prefOuterMargin;
    }

    public void setInnerMargin(Insets margin) {
    }

    public void setOuterMargin(Insets margin) {
    }

    public void addMarginListener(MarginListener listener) {
    }

    public void removeMarginListener(MarginListener listener) {
    }

    protected void fireMarginChanged(MarginChangeEvent event) {
    }

    public DataRange getDataRange(byte dimension) {
        DataRange rc = null;
        SILK3DAxis axis = null;
        switch (dimension) {
            case 1: {
                axis = (SILK3DAxis)this.getAxis("X");
                break;
            }
            case 2: {
                axis = (SILK3DAxis)this.getAxis("Y");
                break;
            }
            case 3: {
                axis = (SILK3DAxis)this.getAxis("Z");
            }
        }
        if (axis != null) {
            rc = axis.getOutputRange();
        }
        return rc;
    }

    public void addRangeChangeListener(RangeChangeListener l) {
        if (this.rangeChangeListeners == null) {
            this.rangeChangeListeners = new Vector();
        }
        if (l != null) {
            this.rangeChangeListeners.addElement(l);
        }
    }

    public void removeRangeChangeListener(RangeChangeListener l) {
        if (this.rangeChangeListeners != null) {
            this.rangeChangeListeners.removeElement(l);
        }
    }

    protected void fireRangeChangeEvent(RangeChangedEvent evt) {
        if (this.rangeChangeListeners == null) {
            return;
        }
        Enumeration e = this.rangeChangeListeners.elements();
        while (e.hasMoreElements()) {
            ((RangeChangeListener)e.nextElement()).rangeChanged(evt);
        }
    }

    public boolean setActionMode(int mode) {
        boolean rc = super.setActionMode(mode);
        if (this.silkAnno != null) {
            this.silkAnno.setActionMode(this.actionMode);
        }
        this.primary.setActionMode(mode);
        this.brush.setActionMode(mode);
        return rc;
    }

    public void setCartesian(boolean b) {
        boolean rc = this.axes.setCartesian(b);
        if (rc) {
            this.userSetProperties.set(10206);
            this.setRange((byte)1, 0, this.getRange(this.getXAxisRoles()));
            this.setRange((byte)2, 0, this.getRange(this.getYAxisRoles()));
            this.setRange((byte)3, 0, this.getRange(this.getZAxisRoles()));
            this.buildAndDraw();
        }
    }

    public boolean getCartesian() {
        return this.axes.getCartesian();
    }

    public void setCartesianOrigin(Vec3d origin) {
        boolean rc = this.axes.setCartesianOrigin(origin);
        if (rc) {
            this.userSetProperties.set(10207);
            this.setRange((byte)1, 0, this.getRange(this.getXAxisRoles()));
            this.setRange((byte)2, 0, this.getRange(this.getYAxisRoles()));
            this.setRange((byte)3, 0, this.getRange(this.getZAxisRoles()));
            this.buildAndDraw();
        }
    }

    public Vec3d getCartesianOrigin() {
        return this.axes.getCartesianOrigin();
    }

    public boolean createDataDialog(Object listener) {
        if (this.dataDlg != null) {
            return true;
        }
        Window parent = null;
        if (listener != null && listener instanceof Component) {
            parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        }
        if (parent == null || parent instanceof Frame) {
            this.dataDlg = new DataOptionsDialog((Frame)parent);
        } else if (parent instanceof Dialog) {
            this.dataDlg = new DataOptionsDialog((Dialog)parent);
        }
        return true;
    }

    private SILK3DAxis getCurrentAxisObject() {
        return this.getAxisObject(new Integer(this.currentAxis));
    }

    private SILK3DAxis getAxisObject(Object which) {
        if (this.axes == null) {
            return null;
        }
        return (SILK3DAxis)this.axes.getAxis(which);
    }

    protected String getMenuXML() {
        return "/com/sas/graphics/silk/util/menus/ScatterMenu.xml";
    }

    public boolean isActionEnabled(String action) {
        if (action.equalsIgnoreCase("EXCLUSIVE_SELECT")) {
            return false;
        }
        return super.isActionEnabled(action);
    }

    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        return this.primary.selectInLayer(select, selectRegion, event);
    }

    private class View3D {
        private double rotation = 0.0;
        private double tilt = 0.0;
        private double zoom = 0.0;
        private Vec3d focalPoint = new Vec3d();

        public double getRotation() {
            return this.rotation;
        }

        public double getTilt() {
            return this.tilt;
        }

        public double getZoom() {
            return this.zoom;
        }

        public void setRotation(double a) {
            if (SILK3DComponent.this.projection == 1) {
                while (a < 0.0) {
                    a += 360.0;
                }
                while (a >= 360.0) {
                    a -= 360.0;
                }
                this.rotation = a;
            } else {
                this.rotation = a < 30.0 ? 30.0 : (a > 150.0 ? 150.0 : a);
            }
        }

        public void setTilt(double i) {
            while (i < 0.0) {
                i += 360.0;
            }
            while (i >= 360.0) {
                i -= 360.0;
            }
            this.tilt = i;
        }

        public void setZoom(double d) {
            this.zoom = d < 0.1 ? 0.1 : d;
        }

        public Vec3d getFocalPoint() {
            return this.focalPoint;
        }

        public void setFocalPoint(Vec3d aPoint) {
            if (aPoint != null) {
                this.focalPoint.set(aPoint);
            } else {
                this.focalPoint.set(Double.NaN, Double.NaN, Double.NaN);
            }
        }
    }
}

