/*
 * Decompiled with CFR 0.152.
 */
package MITI.processor.diagram;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRGraphicsLib;
import MITI.messages.MIRModelProcessor.MPROC;
import MITI.processor.Processor;
import MITI.processor.diagram.ModelTraversal;
import MITI.processor.diagram.ObjectCache;
import MITI.sdk.MIRAssociation;
import MITI.sdk.MIRAssociationRole;
import MITI.sdk.MIRAssociationRoleNameMap;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRCandidateKey;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassDiagram;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRForeignKey;
import MITI.sdk.MIRJoin;
import MITI.sdk.MIRJoinRole;
import MITI.sdk.MIRKey;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRNamespace;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.diagrams.Diagram;
import MITI.sdk.diagrams.impl.DiagramSerialization;
import MITI.sdk.diagrams.impl.MIRClassDiagramBuilder;
import MITI.sdk.mix.MIRObjectCache;
import MITI.sdk.util.ObjectCollector;
import MITI.util.file.FileUtil;
import java.io.File;
import java.util.ArrayList;

public class DiagramProcessor
extends Processor {
    @Override
    protected void run() throws MIRException {
        File file = new File((String)this.options.get(MPROC.BP_DIAGRAMS_DIR.getParameterId()));
        MIRStoreModel mIRStoreModel = this.loadModel();
        if (mIRStoreModel != null && mIRStoreModel.getDesignPackageCount() > 0) {
            ObjectCache objectCache = new ObjectCache();
            mIRStoreModel.depthTraversal(new ModelTraversal(objectCache, this.cache));
            this.processRelationships(mIRStoreModel, objectCache);
            MIRClassDiagramBuilder mIRClassDiagramBuilder = new MIRClassDiagramBuilder((MIRObjectCache)objectCache);
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : file.listFiles()) {
                    this.processDiagram(mIRClassDiagramBuilder, file2);
                }
            }
            this.cache.writeFile(this.dstFile, mIRStoreModel);
        }
    }

    private MIRStoreModel loadModel() throws MIRException {
        MIRModel mIRModel = this.cache.readFile(this.srcFile);
        if (mIRModel != null && mIRModel.getElementType() == 2) {
            return (MIRStoreModel)mIRModel;
        }
        return null;
    }

    private void processDiagram(MIRClassDiagramBuilder mIRClassDiagramBuilder, File file) throws MIRException {
        String string = FileUtil.readContent(file, FileUtil.UTF8);
        Diagram diagram = DiagramSerialization.parse((int)0, (String)string);
        MIRClassDiagram mIRClassDiagram = mIRClassDiagramBuilder.build(diagram);
        if (mIRClassDiagram != null) {
            MIRGraphicsLib.processPresentationElements(mIRClassDiagram, false, false);
        }
    }

    private void processRelationships(MIRStoreModel mIRStoreModel, ObjectCache objectCache) {
        ObjectCollector objectCollector = new ObjectCollector(new short[]{22, 92});
        for (MIRObject mIRObject : objectCollector.collect(mIRStoreModel)) {
            if (mIRObject.getElementType() == 22) {
                MIRDesignPackage mIRDesignPackage = mIRStoreModel.getDesignPackage(null);
                this.processForeignKey((MIRForeignKey)mIRObject, mIRDesignPackage);
                continue;
            }
            if (mIRObject.getElementType() != 92) continue;
            this.processJoin((MIRJoin)mIRObject, objectCache);
        }
    }

    private void processForeignKey(MIRForeignKey mIRForeignKey, MIRDesignPackage mIRDesignPackage) {
        if (mIRForeignKey.getAssociationRole() == null && mIRForeignKey.getGeneralizationRole() == null && mIRDesignPackage != null) {
            MIRAssociation mIRAssociation = MIRBridgeLib.buildFKeyAssociation(mIRForeignKey);
            mIRAssociation.removeNamespace();
            mIRDesignPackage.addNamespaceElement(mIRAssociation);
        }
    }

    private void processJoin(MIRJoin mIRJoin, ObjectCache objectCache) {
        MIRJoinRole mIRJoinRole = null;
        MIRJoinRole mIRJoinRole2 = null;
        ArrayList<Object> arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList();
        for (MIRJoinRole mIRModelObject : mIRJoin.getJoinRoles()) {
            if (mIRModelObject.getClassifier() == null || mIRModelObject.getClassifier().getElementType() != 13) continue;
            if (mIRModelObject.getLeft()) {
                mIRJoinRole = mIRModelObject;
                arrayList = this.getListOfColumns(mIRModelObject);
                continue;
            }
            mIRJoinRole2 = mIRModelObject;
            arrayList2 = this.getListOfColumns(mIRModelObject);
        }
        if (mIRJoin.getJoinRoleCount() == 2 && mIRJoinRole != null && mIRJoinRole2 != null) {
            MIRAssociation mIRAssociation = new MIRAssociation();
            mIRAssociation.setFrom(mIRJoin);
            objectCache.put(this.cache.getObjectIdentifier(mIRJoin), mIRAssociation);
            MIRAssociationRole mIRAssociationRole = this.createRole(mIRAssociation, mIRJoinRole, objectCache);
            MIRAssociationRole mIRAssociationRole2 = this.createRole(mIRAssociation, mIRJoinRole2, objectCache);
            MIRNamespace mIRNamespace = mIRJoin.getNamespace();
            mIRJoin.delete();
            mIRNamespace.addNamespaceElement(mIRAssociation);
            if (!mIRJoinRole.getMultiplicity().endsWith("*") || !mIRJoinRole2.getMultiplicity().endsWith("*")) {
                MIRCandidateKey mIRCandidateKey = new MIRCandidateKey();
                mIRCandidateKey.setName(mIRAssociationRole.getName());
                mIRCandidateKey.setUniqueKey(true);
                mIRAssociationRole.getAssociatedClass().addKey(mIRCandidateKey);
                MIRForeignKey mIRForeignKey = new MIRForeignKey();
                mIRForeignKey.setName(mIRAssociationRole2.getName());
                mIRAssociationRole2.getAssociatedClass().addKey(mIRForeignKey);
                mIRAssociationRole2.addForeignKey(mIRForeignKey);
                int n = arrayList.size();
                if (n > 0 && n == arrayList2.size()) {
                    for (int i = 0; i < n; ++i) {
                        MIRAttribute mIRAttribute = (MIRAttribute)arrayList.get(i);
                        MIRAttribute mIRAttribute2 = (MIRAttribute)arrayList2.get(i);
                        if (mIRAttribute == null || mIRAttribute2 == null) continue;
                        if (!mIRCandidateKey.containsAttribute(mIRAttribute) && !mIRForeignKey.containsAttribute(mIRAttribute2)) {
                            mIRCandidateKey.addAttribute(mIRAttribute);
                            mIRForeignKey.addAttribute(mIRAttribute2);
                            MIRAssociationRoleNameMap mIRAssociationRoleNameMap = new MIRAssociationRoleNameMap();
                            mIRAssociationRoleNameMap.addSourceAttribute(mIRAttribute);
                            mIRAssociationRoleNameMap.addDestinationAttribute(mIRAttribute2);
                            mIRForeignKey.addAssociationRoleNameMap(mIRAssociationRoleNameMap);
                            continue;
                        }
                        mIRCandidateKey.removeAttributes();
                        mIRForeignKey.removeAttributes();
                        break;
                    }
                    mIRCandidateKey = this.getCandidateKey(mIRAssociationRole.getAssociatedClass(), mIRCandidateKey);
                    mIRForeignKey.addCandidateKey(mIRCandidateKey);
                }
                if (mIRForeignKey.getAttributeCount() == 0 || mIRCandidateKey.getAttributeCount() == 0) {
                    mIRCandidateKey.delete();
                    mIRForeignKey.delete();
                }
            }
        }
    }

    private MIRAssociationRole createRole(MIRAssociation mIRAssociation, MIRJoinRole mIRJoinRole, ObjectCache objectCache) {
        MIRAssociationRole mIRAssociationRole = new MIRAssociationRole();
        mIRAssociationRole.setFrom(mIRJoinRole);
        mIRAssociationRole.setSource(mIRJoinRole.getLeft());
        mIRAssociationRole.setMultiplicity(mIRJoinRole.getMultiplicity());
        mIRAssociationRole.addAssociatedClass((MIRClass)mIRJoinRole.getClassifier());
        mIRAssociation.addAssociationRole(mIRAssociationRole);
        objectCache.put(this.cache.getObjectIdentifier(mIRJoinRole), mIRAssociationRole);
        return mIRAssociationRole;
    }

    private ArrayList<MIRAttribute> getListOfColumns(MIRJoinRole mIRJoinRole) {
        ArrayList<MIRAttribute> arrayList = new ArrayList<MIRAttribute>();
        return arrayList;
    }

    private MIRCandidateKey getCandidateKey(MIRClass mIRClass, MIRCandidateKey mIRCandidateKey) {
        for (MIRKey mIRKey : mIRClass.getKeys()) {
            if (mIRKey == mIRCandidateKey || mIRKey.getElementType() != 21 || mIRKey.getAttributeCount() != mIRCandidateKey.getAttributeCount()) continue;
            boolean bl = true;
            for (MIRAttribute mIRAttribute : mIRCandidateKey.getAttributes()) {
                if (mIRKey.containsAttribute(mIRAttribute)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            mIRCandidateKey.delete();
            return (MIRCandidateKey)mIRKey;
        }
        return mIRCandidateKey;
    }
}

