/*
 * Decompiled with CFR 0.152.
 */
package MITI.processor.annotation;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.messages.MIRModelProcessor.MPROC;
import MITI.processor.Processor;
import MITI.sdk.MIRDate;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRNote;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.util.DateUtil;
import MITI.util.XmlUtil;
import MITI.util.file.FileUtil;
import java.io.File;
import java.util.Date;
import org.w3c.dom.Element;

public class AnnotationProcessor
extends Processor {
    public static final byte NONE = 0;
    public static final byte NOTE = 1;
    public static final byte UDP = 2;
    public static final String ID_LABEL = "ObjectId";
    public static final String TYPE_LABEL = "AnnotationType";
    public static final String MIR_LABEL = "MIRType";
    public static final String AUTHOR_LABEL = "Author";
    public static final String CREATION_DATE_LABEL = "CreationDate";
    public static final String MODIFICATION_DATE_LABEL = "ModificationDate";
    public static final String IMPORTANCE_LABEL = "Importance";
    public static final String STATUS_LABEL = "Status";
    public static final String TEXT_LABEL = "Text";
    public static final String COMMENT_TYPE = "UserDefinedComment";
    public static final String LABEL_TYPE = "UserDefinedLabel";
    public static final String NOTE_NAME = "MM_Comment_";
    private static final String EOL = "\r\n";
    private static final char[] STARS = new char[]{'*', '*', '*', '*', '*'};

    @Override
    protected void run() throws MIRException {
        MIRModel mIRModel = this.cache.readFile(this.srcFile);
        ObjectIdentifier objectIdentifier = this.cache.getObjectIdentifier(mIRModel);
        File file = new File((String)this.options.get(MPROC.BP_ANNOTATION_FILE.getParameterId()));
        Element element = XmlUtil.parseString(FileUtil.readContent(file, FileUtil.UTF8));
        for (Element element2 : XmlUtil.getChildElements(element)) {
            this.processElement(objectIdentifier.getModelId(), element2);
        }
        this.cache.writeFile(this.dstFile, mIRModel);
    }

    private void processElement(int n, Element element) {
        String string = element.getNodeName();
        String string2 = "";
        if (string.equals(COMMENT_TYPE)) {
            string2 = string2 + "Author: " + element.getAttribute(AUTHOR_LABEL) + EOL;
            string2 = string2 + "Creation Date: " + element.getAttribute(CREATION_DATE_LABEL) + EOL;
            string2 = string2 + "Modification Date: " + element.getAttribute(MODIFICATION_DATE_LABEL) + EOL;
            string2 = string2 + "Importance: " + String.valueOf(STARS, 0, Integer.parseInt(element.getAttribute(IMPORTANCE_LABEL))) + EOL;
            string2 = string2 + "Status: " + this.getStatusText(element.getAttribute(STATUS_LABEL)) + EOL;
            string2 = string2 + "Content: " + element.getAttribute(TEXT_LABEL) + EOL;
        } else {
            string2 = string2 + "Value: " + element.getAttribute(TEXT_LABEL);
        }
        int n2 = Integer.parseInt(element.getAttribute(ID_LABEL));
        byte by = Byte.parseByte(element.getAttribute(MIR_LABEL));
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(n, n2);
        MIRObject mIRObject = this.cache.getMirObject(objectIdentifier);
        if (mIRObject != null && mIRObject instanceof MIRElement) {
            if (by == 1) {
                int n3 = ((MIRElement)mIRObject).getNoteCount();
                MIRNote mIRNote = new MIRNote();
                mIRNote.setName(NOTE_NAME + String.valueOf(n3 + 1));
                mIRNote.setValue(element.getAttribute(TEXT_LABEL));
                mIRNote.setAuthor(element.getAttribute(AUTHOR_LABEL));
                mIRNote.setImportance(element.getAttribute(IMPORTANCE_LABEL));
                Date date = DateUtil.parseSimpleDate(element.getAttribute(MODIFICATION_DATE_LABEL), true);
                mIRNote.setModificationTime(new MIRDate(date));
                mIRNote.setStatus(this.getStatusText(element.getAttribute(STATUS_LABEL)));
                mIRNote.setPosition((short)(n3 + 1));
                ((MIRElement)mIRObject).addNote(mIRNote);
            } else if (by == 2) {
                MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRObject.getRootModel(), mIRObject.getElementType(), string, (byte)0, "", "", "SQL_VARCHAR", true, "");
                MIRPropertyValue mIRPropertyValue = MIRUdpLib.getPropertyValue(mIRPropertyType, (MIRElement)mIRObject);
                if (mIRPropertyValue == null) {
                    MIRUdpLib.setPropertyValue(mIRPropertyType, string2, (MIRElement)mIRObject);
                } else {
                    mIRPropertyValue.setValue(mIRPropertyValue.getValue() + EOL + string2);
                }
            }
        }
    }

    private String getStatusText(String string) {
        if (string != null) {
            if (string.equals("0")) {
                return "Candidate";
            }
            if (string.equals("1")) {
                return "Approved";
            }
            if (string.equals("2")) {
                return "Rejected";
            }
        }
        return "";
    }
}

