/*
 * Decompiled with CFR 0.152.
 */
package MITI.statistics;

import MITI.messages.MIRStatisticsUtil.STATISTICS;
import MITI.statistics.AtomicCounter;
import MITI.util.log.MIRLogger;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class SimpleStatistics {
    protected Map<String, AtomicCounter> counters = new TreeMap<String, AtomicCounter>();

    public void increaseCounter(String string, int n) {
        AtomicCounter atomicCounter = this.getCounter(string);
        atomicCounter.increment(n);
    }

    public void decreaseCounter(String string, int n) {
        AtomicCounter atomicCounter = this.getCounter(string);
        atomicCounter.decrement(n);
    }

    private AtomicCounter getCounter(String string) {
        AtomicCounter atomicCounter = this.counters.get(string);
        if (atomicCounter == null) {
            atomicCounter = new AtomicCounter();
            this.counters.put(string, atomicCounter);
        }
        return atomicCounter;
    }

    public Map<String, AtomicCounter> getCounters() {
        return this.counters;
    }

    public void print(MIRLogger mIRLogger) {
        this.print(mIRLogger, this.counters.keySet());
    }

    public void print(MIRLogger mIRLogger, Collection<String> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : collection) {
            AtomicCounter atomicCounter = this.counters.get(string);
            if (atomicCounter == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(atomicCounter.value());
        }
        STATISTICS.SIMPLE_STATISTICS.log(mIRLogger, stringBuffer.toString());
    }
}

