/*
 * Decompiled with CFR 0.152.
 */
package MITI.statistics;

import MITI.MIRException;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIR_Object;
import MITI.sdk.mix.MIRMixCache;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.impl.MIRProfiler;
import MITI.sdk.profiles.impl.memory.MemoryDataProvider;
import MITI.server.services.common.mir.ObjectDefinition;
import MITI.statistics.SimpleStatistics;

public class ProfileStatistics
extends SimpleStatistics {
    private MIRModel model;
    private MIRProfiler profiler;
    private MIRProfile profile;
    private MIRMixCache mixCache;

    public ProfileStatistics(MIRModel mIRModel, MIRMixCache mIRMixCache) {
        this.model = mIRModel;
        this.mixCache = mIRMixCache;
    }

    public void compute() throws MIRException {
        int n = this.model.getMetadataOrigin().getProfileId();
        MIRProfiler.loadProfile(n);
        this.profile = MIRProfiler.getProfile(n);
        if (this.profile != null) {
            MemoryDataProvider memoryDataProvider = new MemoryDataProvider(this.mixCache);
            this.profiler = new MIRProfiler(memoryDataProvider);
            ModelTraversal modelTraversal = new ModelTraversal();
            this.model.depthTraversal(modelTraversal);
        }
    }

    private class ModelTraversal
    implements MIR_Object.MIRTraversalOperation {
        private ModelTraversal() {
        }

        @Override
        public boolean traverse(MIRObject mIRObject) throws MIRException {
            return true;
        }

        @Override
        public void pre_process(MIRObject mIRObject, boolean bl) throws MIRException {
        }

        @Override
        public void post_process(MIRObject mIRObject) throws MIRException {
            ObjectDefinition objectDefinition = ProfileStatistics.this.mixCache.getObjectDefinition(mIRObject);
            ProfiledObject profiledObject = ProfileStatistics.this.profiler.getObject(objectDefinition, ProfileStatistics.this.profile.getName());
            if (profiledObject != null) {
                String string = profiledObject.getEntityName();
                ProfileStatistics.this.increaseCounter(string, 1);
            }
        }
    }
}

